/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.view;

/**
 * Use to Monitor the progress of time consuming operations. A progress 
 * bar can be shown to indicate the operation progress. Methods
 * in this interface can be called from the event or other threads.
 */
public interface ProgressMonitor 
{
  /**
   * Start monitoring a time consuming operation. 
   *
   * @param parent the parent component for the progress dialog.
   * @param msg a message to show the user describing the operation taking 
   * place.
   * @param minValue the lower bound of the range.
   * @param maxValue the upper bound of the range.
   * @param delay the amount of time to delay the popping up of the progress 
   * bar. If the <code>finish</code> method is called before the delay has 
   * elapsed, the progress bar is not shown.
   */
  void start( GUIPanel parent, 
              String msg, 
              int minValue, 
              int maxValue, 
              int delay );

  /**
   * Indicate that the operation has finished. If the progress bar is up it 
   * will hide it. The <code>finish</code> method will be called automatically
   * if the value set by <code>update</code> is greater or equal to the 
   * <code>maxValue</code> specified when the <code>start</code> method was 
   * called.
   */
  void finish();

  /**
   * Returns true if the user hit the Cancel button in the progress bar.
   */
  boolean isCancelled();

  /**
   * Indicate the progress of the operation taking place. If the specified 
   * <code>value</code> is greater or equal to the <code>maxValue</code> 
   * specified when the <code>start</code> method was called, the 
   * <code>finish</code> method will be automatically called.
   *
   * @param value the current progress value between the minimum and maximum
   * specified on start.
   * @param note an additional note to be displayed with the progress message. 
   * Its value can be <code>null</code> or an empty string.
   */
  void update( int value, String note );

}
