/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class EHAVT
extends ExportHandler {
    private List elements = new ArrayList();

    public EHAVT(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("DataElement_ID").append(",");
        sb.append("Num_DataElement_ID").append(",");
        sb.append("Type").append(",");
        sb.append("Sequence").append(",");
        sb.append("Value").append(",");
        sb.append("Short_Description").append(",");
        sb.append("Container_Name").append(",");
        sb.append("DataElement_Name");
        lines.add(sb.toString());
        LogicalDesign logDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logDesign)) {
            Iterator it = logDesign.getAttributeSet().iterator();
            while (it.hasNext()) {
                this.elements.add(it.next());
            }
        }
        for (RelationalDesign phDesign : this.getDesign().getRelationalDesigns()) {
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator cit = phDesign.getColumnSet().iterator();
            while (cit.hasNext()) {
                this.elements.add(cit.next());
            }
        }
        for (ContainedObjectWithDomain element : this.elements) {
            if (element.getValueList() == null) continue;
            Iterator vit = element.getValueIterator();
            int seq = 0;
            while (vit.hasNext()) {
                ++seq;
                Object key = vit.next();
                String value = (String)element.getValueList().getValuesDescriptionMap().get(key);
                sb = new StringBuffer();
                sb.append(element.getObjectID()).append(",");
                sb.append(element.getNumID()).append(",");
                if (element instanceof Attribute) {
                    sb.append("Attribute").append(",");
                } else {
                    sb.append("Column").append(",");
                }
                sb.append(seq).append(",");
                sb.append(key).append(",");
                sb.append(this.replaceAndQuoteString(value)).append(",");
                sb.append(this.replaceAndQuoteString(element.getContainer().getName())).append(",");
                sb.append(this.replaceAndQuoteString(element.getName())).append(",");
                lines.add(sb.toString());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_AVT.csv";
    }
}

