/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class EHTable
extends ExportHandler {
    public EHTable(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Table_Name").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("ModelID").append(",");
        sb.append("Num_ModelID").append(",");
        sb.append("Structured_Type_ID").append(",");
        sb.append("Num_Structured_Type_ID").append(",");
        sb.append("Structured_Type_Name").append(",");
        sb.append("Number_Data_Elements").append(",");
        sb.append("Classification_Type").append(",");
        sb.append("Allow_Type_Substitution").append(",");
        sb.append("Min_Volume").append(",");
        sb.append("Expected_Volume").append(",");
        sb.append("Max_Volume").append(",");
        sb.append("Growth_Rate_Percents").append(",");
        sb.append("Growth_Rate_Interval").append(",");
        sb.append("Normal_Form").append(",");
        sb.append("Temporary_Object_Scope").append(",");
        sb.append("Adequately_Normalized").append(",");
        sb.append("Substitution_Parent").append(",");
        sb.append("Num_Substitution_Parent").append(",");
        sb.append("Engineer").append(",");
        sb.append("Spatial_Table").append(",");
        sb.append("OID_is_PK").append(",");
        sb.append("OID_is_User_Defined").append(",");
        sb.append("Include_Scripts_Into_DDL");
        lines.add(sb.toString());
        for (RelationalDesign phDesign : this.getDesign().getRelationalDesigns()) {
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator tit = phDesign.getTableSet().iterator();
            while (tit.hasNext()) {
                Table table = (Table)tit.next();
                sb = new StringBuffer();
                sb.append(this.replaceAndQuoteString(table.getName())).append(",");
                sb.append(table.getObjectID()).append(",");
                sb.append(table.getNumID()).append(",");
                sb.append(table.getImportedId() != null ? table.getImportedId() : EMPTY_STR).append(",");
                sb.append(phDesign.getObjectID()).append(",");
                sb.append(phDesign.getNumID()).append(",");
                if (table.isBST()) {
                    sb.append(table.getBasedOnStructuredType().getObjectID()).append(",");
                    sb.append(table.getBasedOnStructuredType().getNumID()).append(",");
                    sb.append(this.replaceAndQuoteString(table.getBasedOnStructuredType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(table.getElements().length).append(",");
                sb.append(table.getTypeID()).append(",");
                sb.append(table.isAllowTypeSubstitution() ? YES : NO).append(",");
                sb.append(table.getMinVolumes()).append(",");
                sb.append(table.getExpectedVolumes()).append(",");
                sb.append(table.getMaxVolumes()).append(",");
                sb.append(table.getGrowthPercent()).append(",");
                sb.append(table.getGrowthType()).append(",");
                sb.append(table.getNormalForm()).append(",");
                sb.append(table.getScope()).append(",");
                sb.append(table.getAdequatelyNormalized().charAt(0)).append(",");
                if (table.getTypeSubstitution() != null) {
                    sb.append(table.getTypeSubstitution().getObjectID()).append(",");
                    sb.append(table.getTypeSubstitution().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(table.getShouldEngineer() ? YES : NO).append(",");
                sb.append(table.isSpatialTable() ? YES : NO).append(",");
                sb.append(table.isOidIsPK() ? YES : NO).append(",");
                sb.append(table.isUserDefinedOid() ? YES : NO).append(",");
                sb.append(table.getShouldGenerateScript() ? YES : NO).append(",");
                lines.add(sb.toString());
                this.getCsvExporter().addNote(table.getObjectID(), table.getNumID(), "Table", table.getNotes());
                this.getCsvExporter().addComment(table.getObjectID(), table.getNumID(), "Table", table.getComment());
                this.getCsvExporter().addCommentRDBMS(table.getObjectID(), table.getNumID(), "Table", table.getCommentInRDBMS());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Tables.csv";
    }
}

