/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl;

import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;

public class SSBDropTable
extends SQLStatementBuilder {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isDropEnabled()) {
            return true;
        }
        return object instanceof TableProxy && ((TableProxy)object).isDropEnabled() && !((TableProxy)object).shouldBeDroppedIndirectly();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object != null) {
            StorageDesign storageDesign;
            Table table = null;
            TableProxy tp = null;
            if (object instanceof TableProxy) {
                tp = (TableProxy)object;
                storageDesign = tp.getStorageDesign();
                table = (Table)tp.getObject();
            } else {
                table = (Table)object;
                storageDesign = this.getStorageDesign();
            }
            if (!(tp instanceof TableProxyOracle) || ((TableProxyOracle)tp).getSnapshot() == null) {
                this.appendBeforeDropScript(oldbuffer, prettyPrint, table);
                StringBuffer buffer = new StringBuffer();
                this.appendDrop(buffer);
                SSBDropTable.appendStringWithSpace(buffer, "TABLE");
                ModelIDObject tableObject = tp;
                if (tableObject == null) {
                    tableObject = table;
                }
                SSBDropTable.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(tableObject));
                if (tp instanceof TableProxyOracle) {
                    SSBDropTable.appendStringWithSpace(buffer, "CASCADE CONSTRAINTS");
                }
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                SSBDropTable.appendNewLine(buffer, prettyPrint, 0);
                if (tp instanceof TableProxyDB2 || tp instanceof TableProxyUDB) {
                    AbstractSSBDB2.appendLineFinisherUDB(buffer, prettyPrint);
                } else {
                    SSBDropTable.appendLineFinisher(buffer, prettyPrint);
                }
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
            }
        }
    }
}

