/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v12c;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBRedactionPolicyOracle
extends AbstractSSBOracle {
    StorageDesign storageDesign;

    public SSBRedactionPolicyOracle(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxy || object instanceof Table;
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (((ModelIDObject)object).isMarkedGenerate() && this.storageDesign.getAppView().getSettings().isIncludeRedactionInDDL()) {
            Table table = null;
            TableProxy tableProxy = null;
            if (object instanceof TableProxy) {
                tableProxy = (TableProxy)object;
                table = (Table)tableProxy.getObject();
                this.storageDesign = tableProxy.getStorageDesign();
            } else if (object instanceof Table) {
                table = (Table)object;
                Design design = table.getDesign();
                RDBMSSite site = table.getSelectedRDBMSSite();
                this.storageDesign = this.getStorageDesign();
            }
            if (table != null && !"".equalsIgnoreCase(table.getRedactionPolicyName()) && table.isRedactionPolicyGenerateInDDL()) {
                this.appendRedactionPolicies(buffer, table, tableProxy);
                SSBRedactionPolicyOracle.appendNewLine(buffer, prettyPrint, 0);
                SSBRedactionPolicyOracle.appendNewLine(buffer, prettyPrint, 0);
                DDLFileMaker.incrementRedactionPolicies();
            }
        }
    }

    private void appendRedactionPolicies(StringBuffer buffer, Table table, TableProxy tp) {
        ModelIDObject obj;
        String schema = table.getSchema();
        if (tp == null && this.storageDesign != null && this.storageDesign.isOpen()) {
            tp = (TableProxy)this.storageDesign.getStorageObject(table.getObjectID());
        }
        if (tp != null && (obj = tp.getSchemaImplementingObject()) != null) {
            schema = obj.getName();
        }
        String rpName = table.getRedactionPolicyName();
        boolean rpEnable = table.isRedactionPolicyEnabled();
        boolean isFirstColumn = true;
        Column[] columns = (Column[])table.getElements();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            String maskingType = column.getMaskingType();
            if ("".equalsIgnoreCase(maskingType) || "NO".equalsIgnoreCase(maskingType)) continue;
            MaskTemplate maskTemplate = column.getMaskTemplate();
            SSBRedactionPolicyOracle.appendString(buffer, "BEGIN");
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
            if (isFirstColumn) {
                SSBRedactionPolicyOracle.appendString(buffer, "DBMS_REDACT.ADD_POLICY");
            } else {
                SSBRedactionPolicyOracle.appendString(buffer, "DBMS_REDACT.ALTER_POLICY");
            }
            SSBRedactionPolicyOracle.appendString(buffer, '(');
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "object_schema", 10);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
            boolean incl_schema = this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL();
            if (!"".equalsIgnoreCase(schema) && incl_schema) {
                SSBRedactionPolicyOracle.appendString(buffer, '\'');
                SSBRedactionPolicyOracle.appendString(buffer, schema);
                SSBRedactionPolicyOracle.appendString(buffer, '\'');
            } else {
                SSBRedactionPolicyOracle.appendString(buffer, "NULL");
            }
            SSBRedactionPolicyOracle.appendString(buffer, ',');
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "object_name", 12);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
            SSBRedactionPolicyOracle.appendString(buffer, '\'');
            SSBRedactionPolicyOracle.appendString(buffer, table.getName());
            SSBRedactionPolicyOracle.appendString(buffer, '\'');
            SSBRedactionPolicyOracle.appendString(buffer, ',');
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "policy_name", 12);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
            SSBRedactionPolicyOracle.appendString(buffer, '\'');
            SSBRedactionPolicyOracle.appendString(buffer, rpName);
            SSBRedactionPolicyOracle.appendString(buffer, '\'');
            SSBRedactionPolicyOracle.appendString(buffer, ',');
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "column_name", 12);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
            SSBRedactionPolicyOracle.appendString(buffer, '\'');
            SSBRedactionPolicyOracle.appendString(buffer, column.getName());
            SSBRedactionPolicyOracle.appendString(buffer, '\'');
            SSBRedactionPolicyOracle.appendString(buffer, ',');
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "function_type", 10);
            SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
            SSBRedactionPolicyOracle.appendString(buffer, this.getFunctionTypeName(maskingType));
            if ("PARTIAL".equalsIgnoreCase(maskingType) && maskTemplate != null) {
                SSBRedactionPolicyOracle.appendString(buffer, ',');
                SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "function_parameters", 4);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
                SSBRedactionPolicyOracle.appendString(buffer, '\'');
                SSBRedactionPolicyOracle.appendString(buffer, maskTemplate.getFunctionParameters());
                SSBRedactionPolicyOracle.appendString(buffer, '\'');
            }
            if (isFirstColumn) {
                SSBRedactionPolicyOracle.appendString(buffer, ',');
                SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "expression", 13);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
                SSBRedactionPolicyOracle.appendString(buffer, '\'');
                String rpDefaultExpression = table.getRedactionPolicyDefaultExpression();
                if (rpDefaultExpression == null || rpDefaultExpression.length() == 0) {
                    rpDefaultExpression = "1=1";
                }
                rpDefaultExpression = rpDefaultExpression.replaceAll("'", "''");
                SSBRedactionPolicyOracle.appendString(buffer, rpDefaultExpression);
                SSBRedactionPolicyOracle.appendString(buffer, '\'');
            }
            if (isFirstColumn) {
                SSBRedactionPolicyOracle.appendString(buffer, ',');
                SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "enable", 17);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
                SSBRedactionPolicyOracle.appendString(buffer, rpEnable ? TRUE : FALSE);
            }
            if ("REGEXP".equalsIgnoreCase(maskingType) && maskTemplate != null) {
                String replaceString;
                String pattern = maskTemplate.getPattern();
                if (!"".equalsIgnoreCase(pattern)) {
                    SSBRedactionPolicyOracle.appendString(buffer, ',');
                    SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
                    SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "regexp_pattern", 9);
                    SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
                    SSBRedactionPolicyOracle.appendString(buffer, '\'');
                    SSBRedactionPolicyOracle.appendString(buffer, pattern);
                    SSBRedactionPolicyOracle.appendString(buffer, '\'');
                }
                if (!"".equalsIgnoreCase(replaceString = maskTemplate.getReplaceString())) {
                    SSBRedactionPolicyOracle.appendString(buffer, ',');
                    SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
                    SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "regexp_replace_string", 2);
                    SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
                    SSBRedactionPolicyOracle.appendString(buffer, '\'');
                    SSBRedactionPolicyOracle.appendString(buffer, replaceString);
                    SSBRedactionPolicyOracle.appendString(buffer, '\'');
                }
                SSBRedactionPolicyOracle.appendString(buffer, ',');
                SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "regexp_position", 8);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
                SSBRedactionPolicyOracle.appendString(buffer, maskTemplate.getPosition());
                SSBRedactionPolicyOracle.appendString(buffer, ',');
                SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "regexp_occurrence", 6);
                SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
                SSBRedactionPolicyOracle.appendString(buffer, maskTemplate.getOccurrence());
                String matchParameter = maskTemplate.getMatchParameter();
                if (!"".equalsIgnoreCase(matchParameter)) {
                    SSBRedactionPolicyOracle.appendString(buffer, ',');
                    SSBRedactionPolicyOracle.appendNewLine(buffer, true, 1);
                    SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "regexp_match_parameter");
                    SSBRedactionPolicyOracle.appendStringWithSpace(buffer, "=>");
                    SSBRedactionPolicyOracle.appendString(buffer, '\'');
                    SSBRedactionPolicyOracle.appendString(buffer, matchParameter);
                    SSBRedactionPolicyOracle.appendString(buffer, '\'');
                }
            }
            SSBRedactionPolicyOracle.appendString(buffer, ')');
            SSBRedactionPolicyOracle.appendString(buffer, ';');
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 0);
            SSBRedactionPolicyOracle.appendString(buffer, "END");
            SSBRedactionPolicyOracle.appendString(buffer, ';');
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 0);
            SSBRedactionPolicyOracle.appendString(buffer, '/');
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 0);
            SSBRedactionPolicyOracle.appendNewLine(buffer, true, 0);
            isFirstColumn = false;
        }
    }

    private String getFunctionTypeName(String maskingType) {
        if ("TEST".equalsIgnoreCase(maskingType)) {
            return "DBMS_REDACT.NONE";
        }
        if ("FULL".equalsIgnoreCase(maskingType)) {
            return "DBMS_REDACT.FULL";
        }
        if ("PARTIAL".equalsIgnoreCase(maskingType)) {
            return "DBMS_REDACT.PARTIAL";
        }
        if ("RANDOM".equalsIgnoreCase(maskingType)) {
            return "DBMS_REDACT.RANDOM";
        }
        if ("REGEXP".equalsIgnoreCase(maskingType)) {
            return "DBMS_REDACT.REGEXP";
        }
        return "DBMS_REDACT.FULL";
    }
}

