/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBTableOraclev9i;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBSnapshotOraclev9i
extends AbstractSSBOracle {
    SSBTableOraclev9i ssbTableOraclev9i;
    private StorageDesignOraclev9i storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        SnapshotOraclev9i snapshot = (SnapshotOraclev9i)object;
        TableProxyOracle tableProxy = snapshot.getImplementedTable();
        if (!snapshot.isMarkedGenerate()) {
            if (tableProxy != null && this.ssbTableOraclev9i != null) {
                this.ssbTableOraclev9i.appendIndexes(oldbuffer, tableProxy, prettyPrint);
            }
            return;
        }
        StringBuffer buffer = new StringBuffer();
        this.storageDesign = (StorageDesignOraclev9i)snapshot.getStorageDesign();
        this.appendComment(oldbuffer, snapshot);
        this.appendCreateSnapshot(buffer, snapshot);
        String advancedComment = buffer.toString();
        if (snapshot.getOnPrebuildTable() != null) {
            this.appendPrebuild(buffer, snapshot, prettyPrint);
        } else if (tableProxy != null) {
            Table table = (Table)tableProxy.getObject();
            StructuredType structType = table.getBasedOnStructuredType();
            if (structType != null) {
                StructuredTypeProxyOracle typeProxy = (StructuredTypeProxyOracle)this.storageDesign.getProxy(structType);
                if (typeProxy != null) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "OF");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(typeProxy));
                }
            } else {
                ColumnProxy[] columnProxies = tableProxy.getColumnProxies();
                boolean first = true;
                for (int i = 0; i < columnProxies.length; ++i) {
                    if (first) {
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                        first = false;
                    } else {
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ',');
                    }
                    ColumnProxy columnProxy = columnProxies[i];
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                }
                if (!first) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                }
            }
            if (snapshot.getCluster() != null) {
                this.appendCluster(buffer, snapshot, prettyPrint);
            } else {
                this.appendSegment(buffer, snapshot, prettyPrint);
            }
            if (tableProxy != null && this.ssbTableOraclev9i != null) {
                this.ssbTableOraclev9i.appendPartitionList(buffer, (TableProxyOraclev9i)tableProxy, prettyPrint);
            } else {
                this.appendPartitioning(buffer, snapshot, prettyPrint);
            }
            this.appendParallelClause(buffer, snapshot, prettyPrint);
            if (!snapshot.getBuild().equals("IMMEDIATE")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BUILD");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getBuild());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BUILD");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        }
        this.appendUsingIndex(buffer, snapshot, prettyPrint);
        this.appendRefreshClause(buffer, snapshot, prettyPrint);
        this.appendForUpdate(buffer, snapshot, prettyPrint);
        this.appendQueryRewrite(buffer, snapshot, prettyPrint);
        if (snapshot.getSubquery().equals("")) {
            SSBSnapshotOraclev9i.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid Materialized View " + snapshot.getName() + " with no subquery");
            SSBSnapshotOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            DDLFileMaker.incrementErrors();
        } else {
            this.appendSubquery(buffer, snapshot, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            SSBSnapshotOraclev9i.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            DDLFileMaker.incrementCreateSnapshot();
            SSBSnapshotOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            boolean generateCommentsInRDBMS = this.storageDesign.getAppView().getSettings().isGenerateCommentsInRDBMS();
            if (generateCommentsInRDBMS) {
                this.appendCommentOn(oldbuffer, snapshot, prettyPrint);
            }
            if (tableProxy != null && this.ssbTableOraclev9i != null) {
                if (generateCommentsInRDBMS && snapshot.getOnPrebuildTable() == null) {
                    this.ssbTableOraclev9i.appendTableCommentOn(oldbuffer, (Table)tableProxy.getObject(), (TableProxyOraclev9i)tableProxy, prettyPrint);
                }
                this.ssbTableOraclev9i.appendIndexes(oldbuffer, tableProxy, prettyPrint);
                String constraints = this.ssbTableOraclev9i.appendConstraints(tableProxy, snapshot);
                if (constraints != null && !constraints.isEmpty()) {
                    oldbuffer.append(constraints);
                    SSBSnapshotOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                }
            }
            this.appendPermissions(oldbuffer, snapshot, prettyPrint);
            SSBSnapshotOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
        }
    }

    private void appendCreateSnapshot(StringBuffer buffer, SnapshotOraclev9i snapshot) {
        this.appendCreate(buffer);
        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "MATERIALIZED");
        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "VIEW");
        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(snapshot));
    }

    private void appendSegment(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        this.appendPhysicalAttributes(buffer, snapshot.getSegment(), false, prettyPrint);
        this.appendTableSpace(buffer, snapshot, prettyPrint);
        for (LobStorageOracle lob : snapshot.getLobsCollection()) {
            this.appendLobStorage(buffer, lob, prettyPrint);
        }
        this.appendAttributes(buffer, snapshot, prettyPrint);
    }

    private void appendParallelClause(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(snapshot.getParalelClause())) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARALLEL");
            if (snapshot.getDegree() > 0) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getDegree());
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendPrebuild(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if (snapshot.getImplementedTable() != null || snapshot.getOnPrebuildTable() == null) {
            if (!snapshot.getBuild().equals("IMMEDIATE")) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BUILD");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getBuild());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BUILD");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "ON");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PREBUILT");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLE");
            if ("YES".equalsIgnoreCase(snapshot.getReducedPrecision())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "WITH REDUCED PRECISION");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "WITHOUT REDUCED PRECISION");
            }
        }
    }

    private void appendUsingIndex(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if (snapshot.getUseIndex().equals("YES")) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "USING");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "INDEX");
            if (snapshot.getIndexTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(snapshot.getIndexTablespace()));
            }
            if (snapshot.getIndexSegment() != null) {
                this.appendPhysicalAttributes(buffer, snapshot.getIndexSegment(), true, prettyPrint);
            }
        } else if (snapshot.getUseIndex().equals("NO")) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "USING");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NO");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "INDEX");
        }
    }

    private void appendRefreshClause(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if ("NEVER".equalsIgnoreCase(snapshot.getRefresh())) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NEVER");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "REFRESH");
        } else if ("YES".equals(snapshot.getRefresh())) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "REFRESH");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getRefreshType());
            if (!"".equalsIgnoreCase(snapshot.getAction())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getAction());
            } else if (!"".equalsIgnoreCase(snapshot.getStartDate()) || !"".equalsIgnoreCase(snapshot.getNextDate())) {
                if (!"".equalsIgnoreCase(snapshot.getStartDate())) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "START WITH");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getStartDate());
                }
                if (!"".equalsIgnoreCase(snapshot.getNextDate())) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NEXT");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getNextDate());
                }
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "ON DEMAND");
            }
            if (!snapshot.getWith().equalsIgnoreCase("")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "WITH");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getWith());
            }
            if ("YES".equalsIgnoreCase(snapshot.getDefaultSegment())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "USING");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
                if (!"LOCAL".equalsIgnoreCase(snapshot.getSegmentType())) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getSegmentType());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "LOCAL");
                }
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "ROLLBACK");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "SEGMENT");
            } else if (snapshot.getRollbackSegment() != null) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "USING");
                if (!"LOCAL".equalsIgnoreCase(snapshot.getSegmentType())) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getSegmentType());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "LOCAL");
                }
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "ROLLBACK");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "SEGMENT");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(snapshot.getRollbackSegment()));
            }
        }
    }

    private void appendForUpdate(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(snapshot.getForUpdate())) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "FOR");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "UPDATE");
        }
    }

    private void appendQueryRewrite(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if ("ENABLE".equalsIgnoreCase(snapshot.getQueryRewrite())) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "ENABLE");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "QUERY REWRITE");
        }
    }

    private void appendSubquery(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "AS");
        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, snapshot.getSubquery().trim());
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SnapshotOraclev9i;
    }

    private void appendLobStorage(StringBuffer buffer, LobStorageOracle lobStorage, boolean prettyPrint) {
        if (lobStorage != null) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "LOB");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getColumn()));
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "STORE AS");
            if (!lobStorage.getLobSegmentName().equalsIgnoreCase("")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getLobSegmentName()));
            }
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (lobStorage.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "STORAGE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                boolean props = false;
                if (lobStorage.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCInitialExtent());
                    props = true;
                }
                if (lobStorage.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NEXT");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCNextExtent());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCPctIncrease());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCMinExtents());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCMaxExtents());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCFreeLists());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && lobStorage.getSCFreelistGroups() > 1) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "FREELIST");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "GROUPS");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCFreelistGroups());
                    props = true;
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 3);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getSCBufferPool());
                    props = true;
                }
                if (props) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
            if (lobStorage.getChunk() > 0) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "CHUNK");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getChunk());
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getOldVersions().equalsIgnoreCase("RETENTION")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "RETENTION");
            } else {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PCTVERSION");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getPCTVersion());
            }
            if (lobStorage.getFreepools() > 0 && lobStorage.getSCFreelistGroups() <= 1) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "FREEPOOLS");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getFreepools());
            }
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorage.getStorageInRow())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "ENABLE");
            } else {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "DISABLE");
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "STORAGE IN ROW");
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, lobStorage.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorage.getCache()) && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(lobStorage.getLogging())) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorage.getLogging())) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTableSpace(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            TableSpaceOracle tableSpace = snapshot.getTablespace();
            if (tableSpace != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            } else if (snapshot.getSegment() != null && snapshot.getSegment().getTableSpace() != null) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(snapshot.getSegment().getTableSpace()));
            }
        }
    }

    private void appendAttributes(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
            if ("YES".equalsIgnoreCase(snapshot.getLogging())) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(snapshot.getLogging())) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
            }
        }
        if ("YES".equalsIgnoreCase(snapshot.getCache())) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "CACHE");
        } else if ("NO".equalsIgnoreCase(snapshot.getCache())) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NOCACHE");
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NOCACHE");
        }
    }

    private void appendCluster(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        ClusterOracle cluster = snapshot.getCluster();
        if (cluster != null) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "CLUSTER");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            if (!"".equalsIgnoreCase(snapshot.getClusterColumns())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getClusterColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendPhysicalAttributes(StringBuffer buffer, SegmentOracle segment, boolean usingIndex, boolean prettyPrint) {
        if (segment != null && segment.isMarkedGenerate() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (!usingIndex) {
                if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PCTFREE");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PCTUSED");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getPCTUsed());
                }
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 1) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "INITRANS");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "1");
                }
                if (segment.getMaxTrans() > 1) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getMaxTrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "MAXTRANS");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "255");
                }
            }
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "STORAGE");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
            boolean props = false;
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "INITIAL");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NEXT");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PCTINCREASE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "MINEXTENTS");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getSCMinExtents());
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "FREELISTS");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getSCFreeLists());
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "FREELIST");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "GROUPS");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BUFFER_POOL");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendPartitioning(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)snapshot.getPartitionList();
        if (partitionList != null) {
            String partitionType = partitionList.getPartitionType();
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITION BY RANGE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITION BY RANGE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "HASH");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                if ("NO".equals(partitionList.getUseSubpartStorageTemplate())) {
                    if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                        if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                        }
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "1");
                    }
                }
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITION BY RANGE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "LIST");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getSubPartColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "HASH");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITIONS");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                if (!"".equals(partitionList.getHashPTableSpaces())) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                }
                if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "OVERFLOW");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "HASH");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendHashPartitions(buffer, partitionList, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "BY");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "LIST");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormattedNameList(snapshot.getColumns()));
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendListPartitions(buffer, snapshot, prettyPrint);
            }
        }
    }

    private void appendPartStorage(StringBuffer buffer, AbstractStorageObjectOracle template, boolean prettyPrint) {
        TableSpaceOracle tableSpace = null;
        TableSpaceOracle overflowTableSpace = null;
        StorageObjectCollection lobs = null;
        if (template instanceof HashPartitionOraclev9i) {
            tableSpace = ((HashPartitionOraclev9i)template).getTableSpace();
            overflowTableSpace = ((HashPartitionOraclev9i)template).getIotOverflowTablespace();
            lobs = ((HashPartitionOraclev9i)template).getLobs();
        } else if (template instanceof ListStorageTemplatePartitionOraclev9i) {
            tableSpace = ((ListStorageTemplatePartitionOraclev9i)template).getTablespace();
            lobs = ((ListStorageTemplatePartitionOraclev9i)template).getLobs();
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            if (tableSpace != null) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (overflowTableSpace != null) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "OVERFLOW");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
            }
        }
        if (lobs != null) {
            for (Object storageObject : lobs) {
                HashPartitionLobItemOraclev9i lobItem;
                if (storageObject instanceof LobStorageOraclev9i) {
                    LobStorageOraclev9i lobStorage = (LobStorageOraclev9i)storageObject;
                    if (lobStorage.getTableSpace() == null && lobStorage.getLobSegmentName().trim().equals("")) continue;
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    this.appendLobPartitioningStorage(buffer, lobStorage, lobStorage.getColumn(), lobStorage.getLobSegmentName(), lobStorage.getTableSpace(), prettyPrint);
                    continue;
                }
                if (!(storageObject instanceof HashPartitionLobItemOraclev9i) || (lobItem = (HashPartitionLobItemOraclev9i)storageObject).getTableSpace() == null) continue;
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                this.appendLobPartitioningStorage(buffer, lobItem, lobItem.getLobColumn(), "", lobItem.getTableSpace(), prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        Iterator it = snapshot.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            ListPartitionOraclev9i partition = (ListPartitionOraclev9i)it.next();
            if (first) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ',');
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "VALUES");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
            if (!"".equalsIgnoreCase(partition.getColumns())) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, partition.getColumns());
            } else {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "DEFAULT");
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
            if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (partition.getSegment() == null) {
                if (partition.getTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTablespace()));
                }
                if (this.storageDesign.isOpen() && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if (partition.getLogging().equalsIgnoreCase("YES")) {
                        SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "LOGGING");
                    } else if (partition.getLogging().equalsIgnoreCase("NO")) {
                        SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            for (LobStorageOracle lob : partition.getLobStorages()) {
                this.appendLobStorage(buffer, lob, prettyPrint);
            }
        }
        if (!first) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitions(StringBuffer buffer, PartitionListOracle partitionList, boolean composite, boolean prettyPrint) {
        StorageObjectCollection partitions = partitionList.getSnapshot().getPartitionsCollection();
        if (partitions.size() > 0) {
            Object[] partitionsList = partitions.toArray();
            Arrays.sort(partitionsList, new PossitionComparator());
            ArrayList<Object> sortedList = new ArrayList<Object>();
            for (int i = 0; i < partitionsList.length; ++i) {
                sortedList.add(partitionsList[i]);
            }
            Iterator setIt = sortedList.iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                Object partitionObj = setIt.next();
                if (!(partitionObj instanceof PartitionOracle)) continue;
                PartitionOracle partition = (PartitionOracle)partitionObj;
                if (first) {
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "VALUES LESS THAN");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, partition.getValueList());
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                this.appendPhysicalAttributes(buffer, partition.getSegment(), false, prettyPrint);
                for (LobStorageOracle lob : partition.getLobs()) {
                    this.appendLobStorage(buffer, lob, prettyPrint);
                }
                if (!composite) continue;
                if (partitionList.getPartitionType().equalsIgnoreCase("COMPOSITE BY HASH")) {
                    if (this.appendHashSubPartitions(buffer, partition, prettyPrint) || partition.getSubPartitionsQuantity() <= 0) continue;
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "SUBPARTITIONS");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, partition.getSubPartitionsQuantity());
                    if ("".equalsIgnoreCase(partition.getSubPartitionsTableSpaces())) continue;
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "STORE IN");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partition.getSubPartitionsTableSpaces()));
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (partition.getListPartitions().size() <= 0) continue;
                boolean firstListPart = true;
                Iterator listPartitions = partition.getListPartitions().iterator();
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                while (listPartitions.hasNext()) {
                    ListStorageTemplatePartitionOraclev9i listPartition = (ListStorageTemplatePartitionOraclev9i)listPartitions.next();
                    if (!firstListPart) {
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ',');
                    } else {
                        firstListPart = false;
                    }
                    SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
                    if (!listPartition.getName().toUpperCase().startsWith("SYS_")) {
                        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listPartition));
                    }
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "VALUES");
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, listPartition.getValueList());
                    SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
                    this.appendPartStorage(buffer, listPartition, prettyPrint);
                }
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
            }
            if (!first) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, PartitionOracle partition, boolean prettyPrint) {
        boolean result = false;
        Iterator setIt = this.storageDesign.getHashPartitionSet().iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            HashPartitionOracle hashPartition = (HashPartitionOracle)setIt.next();
            if (hashPartition.getSubPartitionOf() != partition) continue;
            if (first) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                this.appendComma(buffer);
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "SUBPARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            this.appendPartStorage(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private boolean appendHashPartitions(StringBuffer buffer, PartitionListOracle partitionList, boolean prettyPrint) {
        boolean result = false;
        SnapshotOracle snapshot = partitionList.getSnapshot();
        Iterator it = snapshot.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            HashPartitionOracle hashPartition = (HashPartitionOracle)it.next();
            if (first) {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                this.appendComma(buffer);
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, HashPartitionOracle hashPartition, boolean prettyPrint) {
        for (HashPartitionLobItemOracle hashPLobItem : this.storageDesign.getHashPartitionLobItemSet()) {
            if (hashPLobItem.getHashPartition() == null || !hashPLobItem.getHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, Object column, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "LOB");
        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
        if (column instanceof ColumnProxy) {
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((ColumnProxy)column));
        } else {
            String columnName = "";
            if (column != null) {
                columnName = column.toString();
            }
            if (columnName.length() > 0) {
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnName));
            } else {
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("--  ERROR: Lob ");
                buffer.append(lobObject.getName());
                buffer.append(" has no Column specified");
                DDLFileMaker.incrementErrors();
            }
        }
        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
        SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "STORE AS");
        if (!lobSegName.equalsIgnoreCase("")) {
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, '(');
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "TABLESPACE");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOracle permissions, boolean prettyPrint) {
        if (permissions.getSnapshot() != null) {
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "ON");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getSnapshot()));
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, SnapshotOraclev9i snapshot, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        for (PermissionsOraclev9i permissions : this.storageDesign.getPermissionsSet()) {
            if (permissions.getSnapshot() != null && permissions.getSnapshot().equals(snapshot) && !permissions.getPrivileges().equalsIgnoreCase("")) {
                SSBSnapshotOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                SSBSnapshotOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "GRANT");
                SSBSnapshotOraclev9i.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions, prettyPrint);
                this.appendTo(buffer, permissions, this.storageDesign);
                advancedComment = buffer.toString();
                this.appendHierrarchyOption(buffer, permissions);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getSnapshot() == null || !permissions.getSnapshot().equals(snapshot) || permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            SSBSnapshotOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBSnapshotOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendComment(oldbuffer, permissions);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "GRANT");
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions, prettyPrint);
            this.appendTo(buffer, permissions, this.storageDesign);
            advancedComment = buffer.toString();
            this.appendHierrarchyOption(buffer, permissions);
            this.appendGrantOption(buffer, permissions);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            SSBSnapshotOraclev9i.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getRole() == null) {
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            buffer.append(NEWLINE);
            SSBSnapshotOraclev9i.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    public void setSSBTableOraclev9i(SSBTableOraclev9i ssbTableOraclev9i) {
        this.ssbTableOraclev9i = ssbTableOraclev9i;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOracle)one).getPosition() > ((PartitionOracle)two).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)one).getPosition() < ((PartitionOracle)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

