/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDiagramElements;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.PDFExporter;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.sql.BLOB;

public class RSDiagrams
extends RSGeneral {
    private static int openedDiagramscounter = 0;
    private static Map<DesignPartViewPlaceHolder, Boolean> diagramsToBeClosedList = new HashMap<DesignPartViewPlaceHolder, Boolean>();
    private static DesignPartViewPlaceHolder lastDiagram = null;
    private static String modelExtraFilesDirName = "";
    private static final Logger LOGGER = new Logger(RSDiagrams.class);

    /*
     * WARNING - void declaration
     */
    public static void export(Design design, Map map, Connection connection, boolean exportDiagramsAsPDF, String reportsPath, boolean clearDiagrams) throws Exception {
        File file;
        String query = "INSERT INTO DMRS_Diagrams (Diagram_Name, Object_ID, OVID, Diagram_Type, Is_Display, Visible, Master_Diagram_ID, Master_Diagram_OVID, Model_ID, Model_OVID, Model_Name, Notation, Show_All_Details, Show_Names_Only, Show_Elements, Show_Datatype, Show_Keys, Autoroute, Box_In_box, Master_Diagram_Name, Diagram_SVG, Diagram_PDF, Subview_ID, Subview_OVID, Subview_Name, Display_ID, Display_OVID, Display_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        ArrayList<DesignPartView> tempList = new ArrayList<DesignPartView>();
        HashMap<DesignPartView, DesignPart> list = new HashMap<DesignPartView, DesignPart>();
        boolean mainViewVisible = false;
        boolean displayViewVisible = false;
        LogicalDesign logicalModel = design.getLogicalDesign();
        mainViewVisible = RSDiagrams.ensureMainViewVisible(logicalModel);
        if (exportDiagramsAsPDF) {
            RSDiagrams.showDisplays(logicalModel.getMainView());
        }
        list.put(logicalModel.getMainView(), logicalModel);
        for (DesignPartView dpv : RSDiagrams.getDisplays(logicalModel.getMainView())) {
            list.put(dpv, logicalModel);
        }
        tempList.add(logicalModel.getMainView());
        tempList.addAll(RSDiagrams.getDisplays(logicalModel.getMainView()));
        Iterator<Object> it = logicalModel.getLogicalDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            if (exportDiagramsAsPDF) {
                RSDiagrams.showDisplays(ph.getDesignPartView());
            }
            list.put(ph.getDesignPartView(), logicalModel);
            for (DesignPartView dpv : RSDiagrams.getDisplays(ph.getDesignPartView())) {
                list.put(dpv, logicalModel);
            }
            tempList.add(ph.getDesignPartView());
            tempList.addAll(RSDiagrams.getDisplays(ph.getDesignPartView()));
        }
        modelExtraFilesDirName = logicalModel.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + logicalModel.getShortObjectID();
        lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
        File modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
        if (modelExtraFilesDir.exists() && clearDiagrams) {
            String[] filesList = modelExtraFilesDir.list();
            for (int i = 0; i < filesList.length; ++i) {
                File file2 = new File(modelExtraFilesDir, filesList[i]);
                file2.delete();
            }
        }
        for (DesignPartView dpv : tempList) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            if (ph == null) continue;
            RSDiagrams.generatePDF(dpv, ph, RSDiagrams.getDiagramName(dpv), modelExtraFilesDir, ph.getVisible());
        }
        tempList.clear();
        for (MultidimensionalDesign mud : design.getMultidimensionalDesigns()) {
            if (!mud.isLoaded()) continue;
            mainViewVisible = RSDiagrams.ensureMainViewVisible(mud);
            if (exportDiagramsAsPDF) {
                RSDiagrams.showDisplays(mud.getMainView());
            }
            list.put(mud.getMainView(), mud);
            tempList.add(mud.getMainView());
            modelExtraFilesDirName = mud.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + mud.getShortObjectID();
            lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
            modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
            if (modelExtraFilesDir.exists() && clearDiagrams) {
                void var18_30;
                String[] filesList = modelExtraFilesDir.list();
                boolean bl = false;
                while (var18_30 < filesList.length) {
                    File file3 = new File(modelExtraFilesDir, filesList[var18_30]);
                    file3.delete();
                    ++var18_30;
                }
            }
            for (DesignPartView designPartView : tempList) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)designPartView.getPlaceHolder();
                if (ph == null) continue;
                RSDiagrams.generatePDF(designPartView, ph, RSDiagrams.getDiagramName(designPartView), modelExtraFilesDir, ph.getVisible());
            }
            tempList.clear();
        }
        for (RelationalDesign rel : design.getRelationalDesigns()) {
            if (!rel.isLoaded()) continue;
            mainViewVisible = RSDiagrams.ensureMainViewVisible(rel);
            if (exportDiagramsAsPDF) {
                RSDiagrams.showDisplays(rel.getMainView());
            }
            list.put(rel.getMainView(), rel);
            for (DesignPartView dpv : RSDiagrams.getDisplays(rel.getMainView())) {
                list.put(dpv, rel);
            }
            tempList.add(rel.getMainView());
            tempList.addAll(RSDiagrams.getDisplays(rel.getMainView()));
            Iterator sbit = rel.getDesignSubviews().iterator();
            while (sbit.hasNext()) {
                DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)sbit.next();
                if (exportDiagramsAsPDF) {
                    RSDiagrams.showDisplays(designPartViewPlaceHolder.getDesignPartView());
                }
                list.put(designPartViewPlaceHolder.getDesignPartView(), rel);
                for (DesignPartView dpv : RSDiagrams.getDisplays(designPartViewPlaceHolder.getDesignPartView())) {
                    list.put(dpv, rel);
                }
                tempList.add(designPartViewPlaceHolder.getDesignPartView());
                tempList.addAll(RSDiagrams.getDisplays(designPartViewPlaceHolder.getDesignPartView()));
            }
            modelExtraFilesDirName = rel.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + rel.getShortObjectID();
            lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
            modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
            if (modelExtraFilesDir.exists() && clearDiagrams) {
                String[] stringArray = modelExtraFilesDir.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    file = new File(modelExtraFilesDir, stringArray[i]);
                    file.delete();
                }
            }
            for (DesignPartView dpv : tempList) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
                if (ph == null) continue;
                RSDiagrams.generatePDF(dpv, ph, RSDiagrams.getDiagramName(dpv), modelExtraFilesDir, ph.getVisible());
            }
            tempList.clear();
        }
        DataTypesDesign dataTypesDesign = design.getDataTypesDesign();
        mainViewVisible = RSDiagrams.ensureMainViewVisible(dataTypesDesign);
        if (exportDiagramsAsPDF) {
            RSDiagrams.showDisplays(design.getDataTypesDesign().getMainView());
        }
        list.put(dataTypesDesign.getMainView(), dataTypesDesign);
        for (DesignPartView dpv : RSDiagrams.getDisplays(dataTypesDesign.getMainView())) {
            list.put(dpv, logicalModel);
        }
        tempList.add(dataTypesDesign.getMainView());
        tempList.addAll(RSDiagrams.getDisplays(dataTypesDesign.getMainView()));
        it = dataTypesDesign.getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            if (exportDiagramsAsPDF) {
                RSDiagrams.showDisplays(ph.getDesignPartView());
            }
            list.put(ph.getDesignPartView(), dataTypesDesign);
            for (DesignPartView designPartView : RSDiagrams.getDisplays(ph.getDesignPartView())) {
                list.put(designPartView, dataTypesDesign);
            }
            tempList.add(ph.getDesignPartView());
            tempList.addAll(RSDiagrams.getDisplays(ph.getDesignPartView()));
        }
        modelExtraFilesDirName = dataTypesDesign.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + dataTypesDesign.getShortObjectID();
        lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
        modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
        if (modelExtraFilesDir.exists() && clearDiagrams) {
            void var18_37;
            String[] filesList = modelExtraFilesDir.list();
            boolean bl = false;
            while (var18_37 < filesList.length) {
                File file4 = new File(modelExtraFilesDir, filesList[var18_37]);
                file4.delete();
                ++var18_37;
            }
        }
        for (DesignPartView dpv : tempList) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)dpv.getPlaceHolder();
            if (designPartViewPlaceHolder == null) continue;
            RSDiagrams.generatePDF(dpv, designPartViewPlaceHolder, RSDiagrams.getDiagramName(dpv), modelExtraFilesDir, designPartViewPlaceHolder.getVisible());
        }
        tempList.clear();
        ProcessModel pm = design.getProcessModel();
        for (DataFlowDesign dataFlowDesign : pm.getDataFlowDesigns()) {
            if (dataFlowDesign.getTopLevelDataFlowDesign() == null) continue;
            mainViewVisible = RSDiagrams.ensureMainViewVisible(dataFlowDesign);
            list.put(dataFlowDesign.getMainView(), pm);
            tempList.add(dataFlowDesign.getMainView());
            RSObjectNotes.export(map, connection, dataFlowDesign);
            RSComments.export(map, connection, dataFlowDesign);
        }
        modelExtraFilesDirName = pm.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + pm.getShortObjectID();
        lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
        modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
        if (modelExtraFilesDir.exists() && clearDiagrams) {
            String[] stringArray = modelExtraFilesDir.list();
            for (int i = 0; i < stringArray.length; ++i) {
                file = new File(modelExtraFilesDir, stringArray[i]);
                file.delete();
            }
        }
        for (DesignPartView designPartView : tempList) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)designPartView.getPlaceHolder();
            if (ph == null) continue;
            RSDiagrams.generatePDF(designPartView, ph, RSDiagrams.getDiagramName(designPartView), modelExtraFilesDir, ph.getVisible());
        }
        tempList.clear();
        it = design.getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage transformationPackage = (TransformationPackage)it.next();
            for (TransformationTask tmt : transformationPackage.getTransformationTaskSet()) {
                mainViewVisible = RSDiagrams.ensureMainViewVisible(tmt);
                list.put(tmt.getMainView(), design.getProcessModel());
                tempList.add(tmt.getMainView());
            }
        }
        modelExtraFilesDirName = design.getProcessModel().getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + design.getProcessModel().getShortObjectID();
        lastDiagram = tempList.size() > 0 ? (DesignPartViewPlaceHolder)((DesignPartView)tempList.get(tempList.size() - 1)).getPlaceHolder() : null;
        modelExtraFilesDir = new File(reportsPath, modelExtraFilesDirName);
        if (modelExtraFilesDir.exists() && clearDiagrams) {
            String[] stringArray = modelExtraFilesDir.list();
            for (int i = 0; i < stringArray.length; ++i) {
                file = new File(modelExtraFilesDir, stringArray[i]);
                file.delete();
            }
        }
        for (DesignPartView designPartView : tempList) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)designPartView.getPlaceHolder();
            if (ph == null) continue;
            RSDiagrams.generatePDF(designPartView, ph, RSDiagrams.getDiagramName(designPartView), modelExtraFilesDir, ph.getVisible());
        }
        tempList.clear();
        for (Map.Entry entry : list.entrySet()) {
            DesignPartView dpv = (DesignPartView)entry.getKey();
            if (dpv.getDPVId() == null) continue;
            DesignPart dp = (DesignPart)entry.getValue();
            String shortObjID = dp.getShortObjectID();
            stmt.setString(1, RSDiagrams.getDiagramNameNoReplace(dpv));
            stmt.setString(2, dpv.getDPVId());
            stmt.setString(3, RSDiagrams.getOrCreateOVID(map, dpv.getDPVId()));
            stmt.setString(4, dpv.isMainDiagram() ? "MainView" : "Subview");
            stmt.setString(5, dpv.isDisplay() ? "Y" : "N");
            stmt.setString(6, dpv.isVisible() ? "Y" : "N");
            stmt.setString(7, dpv.isDisplay() ? dpv.getMasterDPV().getDPVId() : null);
            stmt.setString(8, dpv.isDisplay() ? RSDiagrams.getOrCreateOVID(map, dpv.getMasterDPV().getDPVId()) : null);
            stmt.setString(9, dpv.getDesignPart().getObjectID());
            stmt.setString(10, (String)map.get(dpv.getDesignPart().getObjectID()));
            stmt.setString(11, dpv.getDesignPart().getName());
            String not = "Barker";
            if (dpv.getNotation() == 0) {
                not = "Bachman";
            } else if (dpv.getNotation() == 2) {
                not = "IE";
            }
            stmt.setString(12, not);
            stmt.setString(13, dpv.showAllDetails() ? "Y" : "N");
            stmt.setString(14, dpv.isShowNamesOnly() ? "Y" : "N");
            stmt.setString(15, dpv.showElements() ? "Y" : "N");
            stmt.setString(16, dpv.showDatatype() ? "Y" : "N");
            stmt.setString(17, dpv.showKeys() ? "Y" : "N");
            stmt.setString(18, dpv.isAutoRoute() ? "Y" : "N");
            stmt.setString(19, dpv.isBoxInBox() ? "Y" : "N");
            stmt.setString(20, dpv.isDisplay() ? RSDiagrams.getDiagramNameNoReplace(dpv.getMasterDPV()) : null);
            stmt.setObject(21, null);
            BLOB blob = null;
            if (exportDiagramsAsPDF) {
                modelExtraFilesDirName = dp.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + shortObjID;
                File pdf = new File(reportsPath + "/" + modelExtraFilesDirName + "/" + RSDiagrams.getDiagramName(dpv) + ".pdf");
                if (pdf.exists()) {
                    int len;
                    FileInputStream is = new FileInputStream(pdf);
                    blob = BLOB.createTemporary((Connection)connection, (boolean)false, (int)10);
                    blob.open(1);
                    OutputStream out = blob.setBinaryStream(1L);
                    byte[] buf = new byte[1024];
                    while ((len = is.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    is.close();
                    out.flush();
                    out.close();
                    blob.close();
                    stmt.setBlob(22, (Blob)blob);
                } else {
                    stmt.setObject(22, null);
                }
            } else {
                stmt.setObject(22, null);
            }
            stmt.setString(23, dpv.isMainDiagram() ? null : dpv.getDPVId());
            stmt.setString(24, dpv.isMainDiagram() ? null : RSDiagrams.getOrCreateOVID(map, dpv.getDPVId()));
            stmt.setString(25, dpv.isMainDiagram() ? null : RSDiagrams.getDiagramNameNoReplace(dpv));
            stmt.setString(26, dpv.isDisplay() ? dpv.getDPVId() : null);
            stmt.setString(27, dpv.isDisplay() ? RSDiagrams.getOrCreateOVID(map, dpv.getDPVId()) : null);
            stmt.setString(28, dpv.isDisplay() ? RSDiagrams.getDiagramNameNoReplace(dpv) : null);
            stmt.setString(29, (String)map.get(design.getObjectID()));
            stmt.executeUpdate();
            if (blob != null) {
                blob.freeTemporary();
            }
            RSDiagramElements.export(map, connection, dpv);
        }
        stmt.close();
        stmt = null;
        if (exportDiagramsAsPDF) {
            RSDiagrams.clearPDF();
        }
    }

    public static String getDiagramName(DesignPartView dpv) {
        String name = "";
        if (dpv instanceof DPVProcess || dpv instanceof DPVTransformation) {
            name = dpv.getDesignPart().getName();
            if (name == null || "".equals(name)) {
                name = dpv.getDesignPart().getObjectTypeName();
            }
        } else {
            name = dpv.getName();
            if ((name == null || "".equals(name)) && ((name = dpv.getDesignPart().getName()) == null || "".equals(name))) {
                name = dpv.getDesignPart().getObjectTypeName();
            }
        }
        return name.replaceAll("[^a-zA-Z1-9_]", "_");
    }

    public static String getDiagramNameNoReplace(DesignPartView dpv) {
        String name = "";
        if (dpv instanceof DPVProcess || dpv instanceof DPVTransformation) {
            name = dpv.getDesignPart().getName();
            if (name == null || "".equals(name)) {
                name = dpv.getDesignPart().getObjectTypeName();
            }
        } else {
            name = dpv.getName();
            if ((name == null || "".equals(name)) && ((name = dpv.getDesignPart().getName()) == null || "".equals(name))) {
                name = dpv.getDesignPart().getObjectTypeName();
            }
        }
        return name;
    }

    private static boolean ensureMainViewVisible(DesignPart designPart) {
        boolean nowVisible = designPart.isMainViewVisible();
        if (designPart.isLoaded() && designPart.isVisible()) {
            designPart.setMainViewVisible(true);
        }
        return nowVisible;
    }

    private static boolean ensureDisplayViewVisible(DesignPartViewPlaceHolder placeHolder) {
        placeHolder.setVisibleNoLater(true);
        boolean nowVisible = placeHolder.getVisible();
        return nowVisible;
    }

    protected static List getDisplays(DesignPartView dpv) {
        ArrayList<DesignPartView> list = new ArrayList<DesignPartView>();
        Iterator it = dpv.getDisplays().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder phd = (DesignPartViewPlaceHolder)it.next();
            list.add(phd.getDesignPartView());
        }
        return list;
    }

    protected static void clearPDF() {
        File tempFile = new File(System.getProperty("java.io.tmpdir"), "diagram.pdf");
        if (tempFile.exists()) {
            boolean bl = tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generatePDF(DesignPartView dpv, DesignPartViewPlaceHolder ph, String diagramName, File modelExtraFilesDir, boolean isVisible) {
        AbstractDiagram diagram = null;
        RepaintManager currentManager = null;
        double scale = 0.0;
        boolean forceClose = false;
        OutputStream ostream = null;
        try {
            if (openedDiagramscounter == 3) {
                for (Map.Entry<DesignPartViewPlaceHolder, Boolean> pairs : diagramsToBeClosedList.entrySet()) {
                    DesignPartViewPlaceHolder ph0 = pairs.getKey();
                    Boolean wasVisible = pairs.getValue();
                    if (wasVisible.booleanValue()) continue;
                    ph0.setVisibleNoLater(false);
                }
                diagramsToBeClosedList.clear();
                diagramsToBeClosedList.put(ph, isVisible);
                openedDiagramscounter = 0;
            }
            ++openedDiagramscounter;
            diagramsToBeClosedList.put(ph, isVisible);
            if (lastDiagram != null && lastDiagram == ph) {
                forceClose = true;
            }
            boolean success = false;
            success = !modelExtraFilesDir.exists() ? modelExtraFilesDir.mkdir() : true;
            if (success) {
                File tempFile = new File(modelExtraFilesDir + "/" + diagramName + ".pdf");
                if (tempFile.exists()) {
                    return;
                }
                RSDiagrams.ensureDisplayViewVisible(ph);
                diagram = dpv.getWorkSpace();
                scale = diagram.getScale();
                ((Diagram)diagram).actualSize();
                currentManager = RepaintManager.currentManager(diagram);
                currentManager.setDoubleBufferingEnabled(false);
                PDFExporter.diagramToPDF((Diagram)diagram, tempFile.getAbsolutePath());
            }
        }
        catch (Throwable e) {
            LOGGER.error("Exception when export PDF to reporting repository (" + diagramName + ")" + e);
        }
        finally {
            if (forceClose) {
                for (Map.Entry<DesignPartViewPlaceHolder, Boolean> pairs : diagramsToBeClosedList.entrySet()) {
                    DesignPartViewPlaceHolder ph0 = pairs.getKey();
                    Boolean wasVisible = pairs.getValue();
                    if (wasVisible.booleanValue()) continue;
                    ph0.setVisibleNoLater(false);
                }
                diagramsToBeClosedList.clear();
                openedDiagramscounter = 0;
            }
            if (currentManager != null) {
                currentManager.setDoubleBufferingEnabled(true);
            }
            if (diagram != null) {
                diagram.setScale(scale);
            }
            try {
                if (ostream != null) {
                    ostream.flush();
                    ostream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("RSDiagrams.generatePDF() Can not close output stream when creating PDF diagram (" + diagramName + ")" + e);
            }
        }
    }

    private static void showDisplays(DesignPartView dpv) {
        if (dpv != null) {
            DesignPartView.NamedTabbedPane pane = dpv.getTabbedPane();
            TreeMap<String, DesignPartView> dpvMap = new TreeMap<String, DesignPartView>();
            Component[] dpvComps = pane.getComponents();
            for (int i = 0; i < dpvComps.length; ++i) {
                if (!(dpvComps[i] instanceof DesignPartView)) continue;
                DesignPartView dpvComp = (DesignPartView)dpvComps[i];
                dpvMap.put(dpvComp.getDPVId(), dpvComp);
            }
            if (dpvMap.containsKey(dpv.getDPVId())) {
                Component c = pane.getSelectedComponent();
                pane.setSelectedComponent(dpv);
                Iterator itd = dpv.getDisplays().iterator();
                while (itd.hasNext()) {
                    DesignPartViewPlaceHolder phd = (DesignPartViewPlaceHolder)itd.next();
                    String dpvKey = phd.getDesignPartView().getDPVId();
                    if (!dpvMap.containsKey(dpvKey)) continue;
                    pane.setSelectedComponent((DesignPartView)dpvMap.get(dpvKey));
                }
                pane.setSelectedComponent(c);
            }
        }
    }
}

