/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSViewDefinition;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.util.GUID;

public class RSEntityViews
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, LogicalDesign model, String modelOVID) throws Exception {
        ArrayList<EntityView> list = new ArrayList<EntityView>(1000);
        int count = 0;
        String query = "INSERT INTO DMRS_ENTITYVIEWS (EntityView_Name, Object_ID, OVID, Model_ID, Model_OVID, Import_ID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, User_Defined, View_Type, Model_Name, Design_OVID, RemoteDesign_ID, RemoteModel_ID, RemoteObject_ID, RemoteObjectRltvStorageName, UsedAsRemoteObject) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        Iterator it = model.getEntityViewSet().iterator();
        while (it.hasNext()) {
            EntityView view2 = (EntityView)it.next();
            String ovid = new GUID().toString();
            map.put(view2.getObjectID(), ovid);
            stmt.setString(1, view2.getName());
            stmt.setString(2, view2.getObjectID());
            stmt.setString(3, ovid);
            stmt.setString(4, model.getObjectID());
            stmt.setString(5, modelOVID);
            stmt.setString(6, view2.getImportedId());
            stmt.setString(7, view2.getBasedOnStructuredType() != null ? view2.getBasedOnStructuredType().getObjectID() : null);
            stmt.setString(8, view2.getBasedOnStructuredType() != null ? (String)map.get(view2.getBasedOnStructuredType().getObjectID()) : null);
            stmt.setString(9, view2.getBasedOnStructuredType() != null ? view2.getBasedOnStructuredType().getName() : null);
            stmt.setString(10, view2.getUserDefined() ? "Y" : "N");
            stmt.setString(11, view2.getViewType());
            stmt.setString(12, model.getName());
            stmt.setString(13, (String)map.get(design.getObjectID()));
            stmt.setString(14, view2.getRemoteDesignID());
            stmt.setString(15, view2.getRemoteModelID());
            stmt.setString(16, view2.getRemoteObjectID());
            stmt.setString(17, view2.getRemoteObjectRelativeStorageName());
            stmt.setString(18, view2.isUsedAsRemoteObject() ? "Y" : "N");
            stmt.addBatch();
            list.add(view2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (EntityView view2 : list) {
                RSObjectNotes.export(map, connection, view2);
                RSComments.export(map, connection, view2);
                RSCommentsInRDBMS.export(map, connection, view2);
                RSViewDefinition.export(map, connection, view2);
                RSDynamicProperties.export(design, map, connection, view2);
            }
            list.clear();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (EntityView view : list) {
                RSObjectNotes.export(map, connection, view);
                RSComments.export(map, connection, view);
                RSCommentsInRDBMS.export(map, connection, view);
                RSViewDefinition.export(map, connection, view);
                RSDynamicProperties.export(design, map, connection, view);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

