/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;

public class RSResponsibleParties
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<BIResponsibleParty> list = new ArrayList<BIResponsibleParty>(1000);
        int count = 0;
        ArrayList<BIResponsibleParty> partiesCollection = new ArrayList<BIResponsibleParty>();
        String query = "INSERT INTO DMRS_RESPONSIBLE_PARTIES (Responsible_Party_ID, Responsible_Party_OVID, Responsible_Party_Name, Business_Info_ID, Business_Info_OVID, Business_Info_Name, Parent_ID, Parent_OVID, Parent_Name, Responsibility, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        BusinessInfoDesign info = design.getBusinessInfoDesign();
        String designOVID = (String)map.get(design.getObjectID());
        String infoOVID = (String)map.get(design.getObjectID());
        Iterator it = info.getResPartySet().iterator();
        while (it.hasNext()) {
            BIResponsibleParty party2 = (BIResponsibleParty)it.next();
            String partyOVID = RSResponsibleParties.getOrCreateOVID(map, party2.getObjectID());
            partiesCollection.add(party2);
            BIResponsibleParty par = party2.getParentParty();
            stmt.setString(1, party2.getObjectID());
            stmt.setString(2, partyOVID);
            stmt.setString(3, party2.getName());
            stmt.setString(4, info.getObjectID());
            stmt.setString(5, infoOVID);
            stmt.setString(6, info.getName());
            if (par != null) {
                stmt.setString(7, par.getObjectID());
                stmt.setString(8, RSResponsibleParties.getOrCreateOVID(map, par.getObjectID()));
                stmt.setString(9, par.getName());
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
            }
            stmt.setString(10, party2.getResponsibility());
            stmt.setString(11, designOVID);
            stmt.addBatch();
            list.add(party2);
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
            for (BIResponsibleParty party2 : list) {
                RSComments.export(map, connection, party2);
                RSDynamicProperties.export(design, map, connection, party2);
            }
            list.clear();
        }
        RSResponsibleParties.exportElements(map, connection, partiesCollection, designOVID);
        RSResponsibleParties.exportContacts(map, connection, partiesCollection, designOVID);
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (BIResponsibleParty party : list) {
                RSComments.export(map, connection, party);
                RSDynamicProperties.export(design, map, connection, party);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportElements(Map map, Connection connection, List parties, String designOVID) throws Exception {
        int count = 0;
        String elemQuery = "INSERT INTO DMRS_RES_PARTY_ELEMENTS (Responsible_Party_ID, Responsible_Party_OVID, Responsible_Party_Name, Element_ID, Element_OVID, Element_Name, Element_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement elemStmt = connection.prepareStatement(elemQuery);
        for (BIResponsibleParty party : parties) {
            for (DesignObject elem : party.getElements()) {
                String elemOVID = RSResponsibleParties.getOrCreateOVID(map, elem.getObjectID());
                elemStmt.setString(1, party.getObjectID());
                elemStmt.setString(2, (String)map.get(party.getObjectID()));
                elemStmt.setString(3, party.getName());
                elemStmt.setString(4, elem.getObjectID());
                elemStmt.setString(5, elemOVID);
                elemStmt.setString(6, elem.getName());
                elemStmt.setString(7, elem.getObjectTypeName());
                elemStmt.setString(8, designOVID);
                elemStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                elemStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            elemStmt.executeBatch();
        }
        elemStmt.close();
        elemStmt = null;
    }

    private static void exportContacts(Map map, Connection connection, List parties, String designOVID) throws Exception {
        int count = 0;
        String contactQuery = "INSERT INTO DMRS_RES_PARTY_CONTACTS (Responsible_Party_ID, Responsible_Party_OVID, Responsible_Party_Name, Contact_ID, Contact_OVID, Contact_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement contactStmt = connection.prepareStatement(contactQuery);
        for (BIResponsibleParty party : parties) {
            for (BIContact contact : party.getContacts()) {
                String contactOVID = RSResponsibleParties.getOrCreateOVID(map, contact.getObjectID());
                contactStmt.setString(1, party.getObjectID());
                contactStmt.setString(2, (String)map.get(party.getObjectID()));
                contactStmt.setString(3, party.getName());
                contactStmt.setString(4, contact.getObjectID());
                contactStmt.setString(5, contactOVID);
                contactStmt.setString(6, contact.getName());
                contactStmt.setString(7, designOVID);
                contactStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                contactStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            contactStmt.executeBatch();
        }
        contactStmt.close();
        contactStmt = null;
    }
}

