/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.extension;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.fcp.extension.SubordinateTablesReader;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.util.logging.Logger;

public class SubordinateTablesJDBC
extends SubordinateTablesReader {
    private static final Logger LOGGER = new Logger(SubordinateTablesJDBC.class);
    static final String SCHEMA_PROPERTY = "schema";

    public SubordinateTablesJDBC(Connection connection, List selectedObjects) {
        super(connection, selectedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(boolean allSubordinateLevels, String dbType) {
        if (this.tableObjects.size() > 0) {
            try {
                DatabaseMetaData dbmd = this.connection.getMetaData();
                ArrayList<DBObject> tables = new ArrayList<DBObject>();
                tables.addAll(this.tableObjects);
                for (int step = 0; step < tables.size(); ++step) {
                    DBObject dbo = (DBObject)tables.get(step);
                    ResultSet rs = null;
                    try {
                        rs = this.getExportedKeys(dbmd, dbo.getSchema(), dbo.getName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (rs == null) continue;
                    while (rs.next()) {
                        DBObject dboTable;
                        String fkTable_Catalog = rs.getString(5);
                        String fkTable_Schema = rs.getString(6);
                        String fkTable_Name = rs.getString(7);
                        String owner = dbo.getSchema();
                        if (fkTable_Schema != null && !"".equals(fkTable_Schema)) {
                            owner = fkTable_Schema;
                        } else if (fkTable_Catalog != null && !"".equals(fkTable_Catalog)) {
                            owner = fkTable_Catalog;
                        }
                        if (this.hasDBObject(this.tableObjects, owner, fkTable_Name)) continue;
                        if ("MICROSOFT".equals(dbType)) {
                            dboTable = new DBObjectSqlServer(true, fkTable_Name, "TABLE", owner);
                            ((DBObjectSqlServer)dboTable).setDb(fkTable_Catalog);
                        } else {
                            dboTable = new DBObject(true, fkTable_Name, "TABLE", owner);
                        }
                        if (allSubordinateLevels) {
                            tables.add(dboTable);
                        }
                        this.tableObjects.add(dboTable);
                        this.selectedObjects.add(dboTable);
                    }
                    rs.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("SubordinateTablesJDBC.getAllObjects():", e);
            }
        }
        return this.selectedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFKs_fromChilds(Connection sqlConnection, List selectedObjects, Design design, RDBMSSite site) {
        ArrayList<DBObject> tableObjects = new ArrayList<DBObject>();
        for (DBObject dbo : selectedObjects) {
            if (!"TABLE".equalsIgnoreCase(dbo.getType())) continue;
            tableObjects.add(dbo);
        }
        if (tableObjects.size() > 0) {
            try {
                DatabaseMetaData dbmd = sqlConnection.getMetaData();
                for (int step = 0; step < tableObjects.size(); ++step) {
                    DBObject dbo = (DBObject)tableObjects.get(step);
                    ResultSet rs = null;
                    try {
                        rs = this.getExportedKeys(dbmd, dbo.getSchema(), dbo.getName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ArrayList<FKHelper> fkHelpers = new ArrayList<FKHelper>();
                    Table table = this.getTable(dbo.getSchema(), dbo.getName(), design, site);
                    if (table == null) continue;
                    if (rs != null) {
                        while (rs.next()) {
                            Table ch_table;
                            String pkCOLUMN_NAME = rs.getString(4);
                            String fkTable_Catalog = rs.getString(5);
                            String fkTable_Schema = rs.getString(6);
                            String fkTable_Name = rs.getString(7);
                            String fkCOLUMN_NAME = rs.getString(8);
                            String fkDELETE_RULE = rs.getString(11);
                            String fk_NAME = rs.getString(12);
                            String pk_NAME = rs.getString(13);
                            String owner = dbo.getSchema();
                            if (fkTable_Schema != null && !"".equals(fkTable_Schema)) {
                                owner = fkTable_Schema;
                            } else if (fkTable_Catalog != null && !"".equals(fkTable_Catalog)) {
                                owner = fkTable_Catalog;
                            }
                            if ((ch_table = this.getTable(owner, fkTable_Name, design, site)) == null) continue;
                            FKHelper fkHelper = this.getFKHelperForChildTable(ch_table, fkHelpers, fk_NAME);
                            fkHelper.fk_NAME = fk_NAME;
                            fkHelper.pk_NAME = pk_NAME;
                            fkHelper.pkTable = table;
                            fkHelper.fkDELETE_RULE = fkDELETE_RULE;
                            if (fkCOLUMN_NAME != null) {
                                fkHelper.fkColNames.add(fkCOLUMN_NAME);
                                fkHelper.pkColNames.add(pkCOLUMN_NAME);
                                continue;
                            }
                            System.out.println("Unable to find FK column!");
                        }
                        rs.close();
                    }
                    for (FKHelper next : fkHelpers) {
                        Table pkTable = next.pkTable;
                        Table chTable = next.chTable;
                        Index fkIndex = null;
                        if (chTable != null) {
                            fkIndex = chTable.getIndexByName(next.fk_NAME);
                        }
                        if (pkTable == null || chTable == null || fkIndex != null) continue;
                        Index index = null;
                        index = next.pk_NAME == null ? SHAlterTableOraclev10g.getUniqueIndexForColumnNames(pkTable, next.pkColNames) : pkTable.getIndexByName(next.pk_NAME);
                        FKIndexAssociation fkass = null;
                        Column column = null;
                        if (index != null) {
                            for (int f = 0; f < next.fkColNames.size(); ++f) {
                                String fkName;
                                String fkColumnName;
                                Column fkColumn;
                                String pkColumnName = (String)next.pkColNames.get(f);
                                if (pkColumnName != null && (column = (Column)pkTable.getElementByName(pkColumnName)) == null) {
                                    column = pkTable.createColumn();
                                    column.setName(pkColumnName);
                                    index.add(column);
                                }
                                if ((fkColumn = (Column)chTable.getElementByName(fkColumnName = (String)next.fkColNames.get(f))) == null) {
                                    fkColumn = chTable.createColumn();
                                    fkColumn.setName(fkColumnName);
                                }
                                if ((fkName = next.fk_NAME) != null) {
                                    FKIndexAssociation[] fkis = chTable.getFKAssociations();
                                    for (int j = 0; j < fkis.length; ++j) {
                                        FKIndexAssociation fkia = fkis[j];
                                        if (!fkia.getLocalFKIndex().getName().equalsIgnoreCase(fkName)) continue;
                                        fkass = fkia;
                                        break;
                                    }
                                }
                                if (fkass == null) {
                                    int deleteRule;
                                    fkass = chTable.addFK(index);
                                    if (fkName != null) {
                                        fkass.setName(fkName);
                                        fkass.getLocalFKIndex().setName(fkName);
                                    }
                                    try {
                                        deleteRule = Integer.valueOf(next.fkDELETE_RULE);
                                    }
                                    catch (Exception e) {
                                        deleteRule = 3;
                                    }
                                    switch (deleteRule) {
                                        case 3: {
                                            fkass.setDeleteRule("NO ACTION");
                                            break;
                                        }
                                        case 0: {
                                            fkass.setDeleteRule("CASCADE");
                                            break;
                                        }
                                        case 2: {
                                            fkass.setDeleteRule("SET NULL");
                                            break;
                                        }
                                        case 1: {
                                            fkass.setDeleteRule("RESTRICT");
                                        }
                                    }
                                }
                                fkColumn.addFKAssociation(column, fkass);
                                fkass.getLocalFKIndex().add(fkColumn);
                            }
                        }
                        if (fkass == null) continue;
                        fkass.resetMandatoryUsingColumns();
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.error("SubordinateTablesJDBC.generateFKs_fromChilds():", e);
            }
        }
    }

    private Table getTable(String schema, String name, Design design, RDBMSSite site) {
        RelationalDesign rd = design.getRelationalDesign();
        if (rd != null) {
            StorageDesign sd = rd.getStorageDesign(site);
            Iterator it = sd.getTableProxySet().iterator();
            while (it.hasNext()) {
                TableProxy tp = (TableProxy)it.next();
                StorageObject so = tp.getUserSchema();
                String sch = "";
                if (so != null) {
                    sch = so.getName();
                }
                Table table = (Table)tp.getObject();
                if (so == null) {
                    sch = table.getProperty("SCHEMA");
                }
                if ((sch == null || !sch.equalsIgnoreCase(schema) || !name.equalsIgnoreCase(tp.getName())) && (sch != null || !name.equalsIgnoreCase(tp.getName()))) continue;
                return table;
            }
        }
        return null;
    }

    protected ResultSet getExportedKeys(DatabaseMetaData dbmd, String schema, String tableName) throws Exception {
        return dbmd.getExportedKeys(null, schema, tableName);
    }

    private FKHelper getFKHelperForChildTable(Table chTable, List<FKHelper> list, String fkName) {
        for (FKHelper next : list) {
            if (next.chTable != chTable) continue;
            if (fkName != null && !"".equals(fkName)) {
                if (!fkName.equalsIgnoreCase(next.fk_NAME)) continue;
                return next;
            }
            return next;
        }
        FKHelper fkHelper = new FKHelper();
        fkHelper.chTable = chTable;
        list.add(fkHelper);
        return fkHelper;
    }

    private static class FKHelper {
        public List pkColNames = new ArrayList();
        public List fkColNames = new ArrayList();
        public String fkDELETE_RULE = "";
        public String fk_NAME = null;
        public String pk_NAME = null;
        public Table pkTable = null;
        public Table chTable = null;

        private FKHelper() {
        }
    }
}

