/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.ModelPhysicalSQLServerPreferences;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.panels.TraversableContext;

final class ModelPhysicalSQLServerPP
extends AbstractPP {
    private static final long serialVersionUID = 6356580008848944227L;
    private JTextField defaultSqlServerDatabase;
    private JPanel pn;
    private JTextField defaultSqlServerTriggerName;
    private JTextField defaultSqlServerSequenceName;
    private JComboBox defaultSqlServerAutoIncDDL;
    private JComboBox defaultSqlServerIdentityDDL;
    private static final String NONE = Messages.getString("OptionsDialog.NONE");
    private static final String TRIGGER = Messages.getString("OptionsDialog.TRIGGER");
    private static final String DEFAULTClause = Messages.getString("OptionsDialog.DEFAULTClause");
    private static final String IDENTITYClause = Messages.getString("OptionsDialog.IDENTITYClause");
    private static final String[] defaultAutoIncDDLChoices = new String[]{NONE, TRIGGER, DEFAULTClause};
    private static final String[] defaultIdentityDDLChoices = new String[]{NONE, TRIGGER, DEFAULTClause, IDENTITYClause};

    public ModelPhysicalSQLServerPP() {
        this.setHelpID("MODEL_PHYSICAL_SQLSERVER_PREFS_PANEL");
        this.pn = new JPanel(new GridBagLayout());
        this.pn.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.Defaults")));
        JLabel label = new JLabel(Messages.getString("OptionsDialog.DefaultDatabase"));
        this.addItem(this.pn, label, 0, 0, 1, 1, 17, 0, 100);
        this.defaultSqlServerDatabase = new JTextField();
        this.addItem(this.pn, this.defaultSqlServerDatabase, 1, 0, 1, 1, 17, 100, 100);
        JPanel pnAutoIncrementColumnTemplates = new JPanel(new GridBagLayout());
        pnAutoIncrementColumnTemplates.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.AutoIncrementColumnTemplates")));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.TriggerName")), 0, 0, 1, 1, 17, 0, 100);
        this.defaultSqlServerTriggerName = new JTextField();
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultSqlServerTriggerName, 1, 0, 1, 1, 17, 100, 100);
        JButton btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnAutoIncrementColumnTemplates, btnAddVariable, 2, 0, 1, 1, 17, 0, 100);
        btnAddVariable.addActionListener(new AddVariableActionListener(this.defaultSqlServerTriggerName));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.SequenceName")), 0, 1, 1, 1, 17, 0, 100);
        this.defaultSqlServerSequenceName = new JTextField();
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultSqlServerSequenceName, 1, 1, 1, 1, 17, 100, 100);
        btnAddVariable = new JButton(Messages.getString("OptionsDialog.AddVariable"));
        this.addItem(pnAutoIncrementColumnTemplates, btnAddVariable, 2, 1, 1, 1, 17, 0, 100);
        btnAddVariable.addActionListener(new AddVariableActionListener(this.defaultSqlServerSequenceName));
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.DefaultAutoIncrementDDL")), 0, 2, 1, 1, 17, 0, 100);
        this.defaultSqlServerAutoIncDDL = new JComboBox<String>(defaultAutoIncDDLChoices);
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultSqlServerAutoIncDDL, 1, 2, 1, 1, 17, 100, 100);
        this.addItem(pnAutoIncrementColumnTemplates, new JLabel(Messages.getString("OptionsDialog.DefaultIdentityDDL")), 0, 3, 1, 1, 17, 0, 100);
        this.defaultSqlServerIdentityDDL = new JComboBox<String>(defaultIdentityDDLChoices);
        this.addItem(pnAutoIncrementColumnTemplates, this.defaultSqlServerIdentityDDL, 1, 3, 1, 1, 17, 100, 100);
        this.add(this.pn, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
        this.add(pnAutoIncrementColumnTemplates, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, -1));
    }

    protected String translate(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return "";
    }

    public void onEntry(TraversableContext tc) {
        this.defaultSqlServerDatabase.setText(settings.getDefaultSqlServerDatabase());
        this.defaultSqlServerTriggerName.setText(settings.getDefaultSqlServerTriggerName());
        this.defaultSqlServerSequenceName.setText(settings.getDefaultSqlServerSequenceName());
        this.defaultSqlServerAutoIncDDL.setSelectedItem(this.translate(settings.getDefaultSqlServerAutoIncDDL(), Settings.AUTOINCREMENT_DDL_SQLSERVER, defaultAutoIncDDLChoices));
        this.defaultSqlServerIdentityDDL.setSelectedItem(this.translate(settings.getDefaultSqlServerIdentityDDL(), Settings.IDENTITY_DDL_SQLSERVER, defaultIdentityDDLChoices));
    }

    public void onExit(TraversableContext tc) {
        settings.setDefaultSqlServerDatabase(this.defaultSqlServerDatabase.getText());
        settings.setDefaultSqlServerTriggerName(this.defaultSqlServerTriggerName.getText());
        settings.setDefaultSqlServerSequenceName(this.defaultSqlServerSequenceName.getText());
        settings.setDefaultSqlServerAutoIncDDL(this.translate((String)this.defaultSqlServerAutoIncDDL.getSelectedItem(), defaultAutoIncDDLChoices, Settings.AUTOINCREMENT_DDL_SQLSERVER));
        settings.setDefaultSqlServerIdentityDDL(this.translate((String)this.defaultSqlServerIdentityDDL.getSelectedItem(), defaultIdentityDDLChoices, Settings.IDENTITY_DDL_SQLSERVER));
        ModelPhysicalSQLServerPreferences preferences = this.getModelPhysicalSQLServerPreferences(tc);
        preferences.setDefaultSqlServerDatabase(this.defaultSqlServerDatabase.getText());
        preferences.setDefaultSqlServerTriggerName(this.defaultSqlServerTriggerName.getText());
        preferences.setDefaultSqlServerSequenceName(this.defaultSqlServerSequenceName.getText());
        preferences.setDefaultSqlServerAutoIncDDL(settings.getDefaultSqlServerAutoIncDDL());
        preferences.setDefaultSqlServerIdentityDDL(settings.getDefaultSqlServerIdentityDDL());
    }

    private ModelPhysicalSQLServerPreferences getModelPhysicalSQLServerPreferences(TraversableContext tc) {
        return ModelPhysicalSQLServerPreferences.getInstance(tc.getPropertyStorage());
    }

    private class AddVariableActionListener
    implements ActionListener {
        private JTextField textField;

        private AddVariableActionListener(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[][] tablespaceName = new String[][]{{"{table}", Messages.getString("ModelPhysicalSqlServerPP.TableName")}, {"{table abbr}", Messages.getString("ModelPhysicalSqlServerPP.TableAbbreviation")}, {"{column}", Messages.getString("ModelPhysicalSqlServerPP.ColumnName")}, {"{column abbr}", Messages.getString("ModelPhysicalSqlServerPP.ColumnAbbreviation")}};
            ModelPhysicalSQLServerPP.this.createDialog(tablespaceName, this.textField);
        }
    }
}

