/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatusHelper;
import oracle.dbtools.crest.fcp.vcs.TreePathHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNObjectHelper;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ChangeRequestSet;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.businessinfo.BusinessInfoDesign;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesignSet;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesignSet;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.SVNDMPropertiesManager;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.RMDeletedMap;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.model.Displayable;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public abstract class StorableObjectStatus
implements Displayable {
    public static final String SHORT_STATUS_ADDED = "A";
    public static final String SHORT_STATUS_MODIFIED = "M";
    public static final String SHORT_STATUS_DELETED = "D";
    public static final String SHORT_STATUS_CONFLICTED = "C";
    public static final String SHORT_STATUS_MISSING = "MI";
    public static final String SHORT_STATUS_SVN_MISSING = "!";
    public static final String SHORT_STATUS_NOT_RECOGNISED = "?";
    public static final String SHORT_STATUS_NORMAL = "";
    protected String textStatus = "";
    protected String propertyStatus = "";
    protected Design design;
    protected File filePath;
    private String storableObjectName;
    private String storableObjectID;
    private String storableObjectParentID;
    private String repositoryUrl;
    private String pathUrl;
    private Long copyRevision;
    private String copyPath;
    private Class objectClass;
    private String objectType;
    private StorableObject storableObject;
    private boolean isFile;
    private DesignPart designPart;
    private RDBMSSite rdbmsSite;
    private Class<? extends DesignPart> designPartClass;
    private String shortObjectID;
    private ModelObject objectSet;
    private List<TreePathHelper> treePath = new ArrayList<TreePathHelper>();
    protected boolean remoteStatus;
    private static final Logger LOGGER = new Logger(StorableObjectStatus.class);
    public static final Comparator FILE_PATH_COMPARATOR = new FilePathComparator();
    protected boolean locked = false;
    private boolean inconflict;

    public StorableObjectStatus() {
    }

    public StorableObjectStatus(StorableObject storableObject) {
        this.storableObject = storableObject;
        this.filePath = new File(storableObject instanceof ModelIDObject ? ((ModelIDObject)storableObject).getSegmentedStorageName() : storableObject.getStorageName());
        this.design = storableObject.getDesign();
    }

    public abstract Long getRevision();

    public void setStorableObjectName(String storableObjectName) {
        this.storableObjectName = storableObjectName;
    }

    public void setStorableObjectID(String designObjectID) {
        this.storableObjectID = designObjectID;
    }

    public String getStorableObjectParentID() {
        if (this.storableObjectParentID == null) {
            return this.filePath.getParent();
        }
        return this.storableObjectParentID;
    }

    public void setStorableObjectParentID(String storableObjectParentID) {
        this.storableObjectParentID = storableObjectParentID;
    }

    public StorableObject getStorableObject() {
        if (this.storableObject == null && this.objectSet != null) {
            if (this.objectSet instanceof DesignObjectSet) {
                this.storableObject = ((DesignObjectSet)this.objectSet).getObjectByID(this.storableObjectID);
            } else if (this.objectSet instanceof ModelIDObjectSet) {
                this.storableObject = ((ModelIDObjectSet)this.objectSet).getObjectByID(this.storableObjectID);
            }
        }
        if (this.storableObject == null) {
            RelationalDesign reldes;
            StorageDesign sd;
            if (this.objectClass == Design.class) {
                this.storableObject = this.design;
            } else if (this.objectSet == null && this.designPart != null && this.designPart instanceof RelationalDesign && (sd = (reldes = (RelationalDesign)this.designPart).getStorageDesign(this.rdbmsSite)) != null) {
                this.storableObject = sd.getModelIDObject(this.storableObjectID);
            }
        }
        return this.storableObject;
    }

    public Class<? extends DesignPart> getDesignPartClass() {
        return this.designPart != null ? this.designPart.getClass() : this.designPartClass;
    }

    public String getShortObjectID() {
        return this.designPart != null ? this.designPart.getShortObjectID() : this.shortObjectID;
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public RDBMSSite getRdbmsSite() {
        return this.rdbmsSite;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public String getURL() {
        if (!StringUtilities.isEmpty(this.repositoryUrl) && !StringUtilities.isEmpty(this.pathUrl)) {
            return this.repositoryUrl + this.pathUrl;
        }
        return null;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public void setPathUrl(String pathUrl) {
        this.pathUrl = pathUrl;
    }

    public String getPathUrl() {
        return this.pathUrl;
    }

    public Long getCopyRevision() {
        return this.copyRevision;
    }

    public void setCopyRevision(Long copyRevision) {
        this.copyRevision = copyRevision;
    }

    public String getCopyPath() {
        return this.copyPath;
    }

    public void setCopyPath(String copyPath) {
        this.copyPath = copyPath;
    }

    public boolean isAdded() {
        return SHORT_STATUS_ADDED.equals(this.textStatus);
    }

    public boolean isModified() {
        return SHORT_STATUS_MODIFIED.equals(this.textStatus);
    }

    public boolean isDeleted() {
        return SHORT_STATUS_DELETED.equals(this.textStatus);
    }

    public boolean isMissing() {
        return SHORT_STATUS_SVN_MISSING.equals(this.textStatus) || SHORT_STATUS_MISSING.equals(this.textStatus);
    }

    public boolean isNotVersioned() {
        return SHORT_STATUS_NOT_RECOGNISED.equals(this.textStatus);
    }

    public String getTextStatus() {
        return this.textStatus;
    }

    public String getPropertyStatus() {
        return this.propertyStatus;
    }

    public void setTextStatus(String textStatus) {
        this.textStatus = textStatus;
    }

    public String getStorableObjectID() {
        StorableObject storableObject = this.getStorableObject();
        if (storableObject == null && File.class.equals((Object)this.objectClass) || this.objectClass == null) {
            return this.filePath.getPath();
        }
        return storableObject == null ? this.storableObjectID : (storableObject instanceof DesignPartView ? ((DesignPartView)storableObject).getDPVId() : ((ModelIDObject)storableObject).getObjectID());
    }

    public String getStorableObjectIDString() {
        return this.storableObjectID;
    }

    public String getStorableObjectName() {
        String name;
        StorableObject storableObject = this.getStorableObject();
        String objectName = this.storableObjectName;
        if (storableObject == null && !StringUtilities.isEmpty(objectName)) {
            return objectName;
        }
        if (storableObject == null && !StringUtilities.isEmpty(name = this.getStorableObjectNameForMissing())) {
            objectName = this.getTextStatus().equals(SHORT_STATUS_DELETED) ? "<html><font color = red>" + name + "</font></html>" : name;
            this.storableObjectName = name;
        }
        return storableObject == null ? objectName : storableObject.getName();
    }

    protected String getStorableObjectNameForMissing() {
        SVNClientHelper svnClientHelper;
        String objectID;
        String fileName;
        File file;
        block21: {
            block20: {
                file = this.getFilePath();
                fileName = file.getName();
                if (file.toString().contains(File.separator + "files" + File.separator) || file.toString().endsWith(File.separator + "files")) {
                    return fileName;
                }
                objectID = null;
                if (!fileName.endsWith(".xml")) {
                    return this.storableObjectName;
                }
                objectID = fileName.substring(0, fileName.indexOf(".xml"));
                svnClientHelper = SVNClientHelper.getInstance();
                File systemTypesFolder = null;
                String spath = this.design.getAppView().getSettings().getDefaultSystemTypesPath();
                if (!SHORT_STATUS_NORMAL.equals(spath) && !svnClientHelper.isVersioned(systemTypesFolder = new File(spath))) {
                    systemTypesFolder = null;
                }
                String lastAddedObjectsFileName = null;
                lastAddedObjectsFileName = this.design.isCompressedDesign() ? "LastAddedObjects.xmlz" : "LastAddedObjects.xml";
                if (lastAddedObjectsFileName.equalsIgnoreCase(file.getName())) break block20;
                if (!SVNClientHelper.isSystemFile(file, systemTypesFolder)) break block21;
            }
            return null;
        }
        String parentObjectShortID = svnClientHelper.getParentObjectShortID(file.getParentFile());
        String props = SVNDMPropertiesManager.extractObjectPropertiesFromAllAddedObjectsFile(this.design, parentObjectShortID, objectID);
        if (!StringUtilities.isEmpty(props)) {
            return svnClientHelper.getProperty(props, 5);
        }
        String DMTempFolder = System.getProperty("user.home") + File.separator + "DMTemp" + File.separator;
        File DMTempFilesFolder = new File(DMTempFolder);
        if (!DMTempFilesFolder.exists()) {
            DMTempFilesFolder.mkdir();
        }
        File fileToParse = new File(DMTempFolder + fileName);
        SVNURL url = null;
        Long revision = 0L;
        if (!StringUtilities.isEmpty(this.getURL())) {
            revision = this.getTextStatus().equals(SHORT_STATUS_DELETED) ? Long.valueOf(this.getRevision() - 1L) : this.getRevision();
            try {
                url = SVNUtil.toSVNURL((SVNUrl)new SVNUrl(this.getURL()));
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
            }
        } else {
            ISVNStatus isvnStatus = svnClientHelper.getSingleStatusLocal(file);
            if (isvnStatus != null && isvnStatus.getUrl() != null) {
                revision = this.getRevision();
                try {
                    url = SVNUtil.toSVNURL((SVNUrl)new SVNUrl(isvnStatus.getUrl().toString()));
                }
                catch (MalformedURLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        if (url != null && StringUtilities.isEmpty(props)) {
            File fileToRead = this.filePath;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            svnClientHelper.doGetContent(fileToRead, out);
            ByteArrayOutputStream buffer = out;
            byte[] bytes = buffer.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            props = svnClientHelper.extractObjectProperties(inputStream, this.design, parentObjectShortID);
            try {
                ((InputStream)inputStream).close();
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                LOGGER.error(e);
            }
            if (!StringUtilities.isEmpty(props)) {
                return svnClientHelper.getProperty(props, 5);
            }
            return props;
        }
        return SHORT_STATUS_NORMAL;
    }

    public String getShortLabel() {
        return null;
    }

    public String getLongLabel() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public Class getObjectClass() {
        if (this.objectClass == null && this.storableObject != null) {
            return this.storableObject.getClass();
        }
        return this.objectClass;
    }

    public ModelObject getParent() {
        return this.objectSet;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public Design getDesign() {
        return this.design;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public TreePathHelper[] getPath() {
        return this.treePath.toArray(new TreePathHelper[0]);
    }

    public String getPathString() {
        StringBuilder result = new StringBuilder();
        for (TreePathHelper treePathHelper : this.treePath) {
            result.append(treePathHelper.getPathName());
            result.append("/");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    protected void parse(File file, SVNUrl url, SVNStatus svnStatus) {
        try {
            String fileName = file.getName();
            String objName = FileUtils.removeExt(fileName);
            String path = FileUtils.fixPath(file.getCanonicalPath());
            String designPath = FileUtils.fixPath(this.design.getStoragePath());
            designPath = FileUtils.addLastSlash(designPath);
            if (this.parseDesignFilesDir(designPath, file, path)) {
                return;
            }
            if (this.parseDesignLevelDomainsDir(designPath, file, path)) {
                return;
            }
            if (this.parseDesignLevelRDBMSSitesDir(designPath, file, path)) {
                return;
            }
            this.storableObject = null;
            this.isFile = this.isFile(file);
            String syspath = this.design.getAppView().getSettings().getDefaultSystemTypesPath();
            if (!(this.isFile || !SHORT_STATUS_NORMAL.equals(syspath) && file.toString().startsWith(syspath) && file.toString().substring(syspath.length() + 1).indexOf(File.separator) < 0 || this.isStorageDes(file.getParentFile()))) {
                this.parseFolder(file);
                if (svnStatus != null) {
                    SVNStatusType stat = svnStatus.getPropertiesStatus();
                    if (svnStatus.getTreeConflict() != null || stat != SVNStatusType.STATUS_NONE && stat != SVNStatusType.STATUS_UNVERSIONED && stat != SVNStatusType.STATUS_NORMAL || svnStatus.getNodeStatus() == SVNStatusType.STATUS_DELETED && file.getPath().indexOf("note") > 0 || svnStatus.getNodeStatus() == SVNStatusType.STATUS_ADDED && !svnStatus.getCommittedRevision().equals((Object)SVNRevision.UNDEFINED) && !svnStatus.getCopyFromRevision().equals((Object)SVNRevision.UNDEFINED) || svnStatus.getNodeStatus() == SVNStatusType.STATUS_MISSING) {
                        this.parseObject(file, url, path, designPath, svnStatus);
                    }
                }
                return;
            }
            if (file.getName().endsWith(".local") || file.getName().endsWith(".localz")) {
                return;
            }
            if ("dl_settings.xml".equalsIgnoreCase(fileName)) {
                this.parseDLSettings(file);
                return;
            }
            if ("ExtendedMap".equalsIgnoreCase(objName) || objName.startsWith("ExtendedMap_RM") || objName.startsWith("DeletedMap_RM")) {
                this.parseMappings(file);
                return;
            }
            if ("defaultRDBMSSites.xml".equalsIgnoreCase(fileName) || "defaultdomains.xml".equalsIgnoreCase(fileName) || "types.xml".equalsIgnoreCase(fileName) || "dr_custom_scripts.xml".equalsIgnoreCase(fileName) || "report_templates.xml".equalsIgnoreCase(fileName) || !SHORT_STATUS_NORMAL.equals(syspath) && file.toString().startsWith(syspath) && file.toString().substring(syspath.length() + 1).indexOf(File.separator) < 0) {
                this.parseSystemTypes(file);
                return;
            }
            if (fileName.endsWith("_RDBMSSites.xml")) {
                this.parseDesignRDBMSSites(file);
                return;
            }
            this.storableObjectID = FileUtils.removeExt(fileName);
            boolean result = this.parseDesign(file) || this.parseBusinessInfoDesign(file) || this.parseDatatypeDesign(file) || this.parseLogicalDesign(file) || this.parseRelationalDesign(file) || this.parseMultidimensionalDesign(file) || this.parseProcessModel(file) || this.parseDataFlowDesign(file) || this.parseFKFolder(file) || this.parseChangeRequest(file) || this.parseObject(file, url, path, designPath, svnStatus);
        }
        catch (IOException e) {
            LOGGER.error(e);
        }
    }

    private boolean parseObject(File file, SVNUrl url, String path, String designPath, SVNStatus svnStatus) {
        if (path.length() <= designPath.length()) {
            return false;
        }
        try {
            String t2;
            path = path.substring(designPath.length());
            StringTokenizer st = new StringTokenizer(path, "/");
            String dpPath = st.nextToken();
            String string = t2 = st.hasMoreTokens() ? st.nextToken() : null;
            if ("domains".equalsIgnoreCase(dpPath)) {
                this.filePath = file;
                this.objectClass = DomainFileWrapper.class;
                this.storableObjectID = this.storableObjectName = FileUtils.removeExt(file.getName());
                this.treePath.add(new TreePathHelper("domains", file.getParentFile(), DomainFileWrapper.class));
                return true;
            }
            StorableObjectStatusHelper sosHelper = this.design.getDesignPart(dpPath, t2);
            if (sosHelper != null) {
                if (sosHelper.designPartClass == BusinessInfoDesign.class) {
                    BusinessInfoDesign.initObjectDetails(this.design, file, t2, sosHelper, this.storableObjectID);
                } else if (sosHelper.designPartClass == DataTypesDesign.class) {
                    DataTypesDesign.initObjectDetails(this.design, file, t2, sosHelper, this.storableObjectID);
                } else if (sosHelper.designPartClass == LogicalDesign.class) {
                    LogicalDesign.initObjectDetails(this.design, file, t2, sosHelper, this.storableObjectID);
                } else if (sosHelper.designPartClass == RelationalDesign.class) {
                    String objectPath = st.nextToken();
                    RelationalDesign.initObjectDetails(this.design, file, url, this.remoteStatus, objectPath, sosHelper, this.storableObjectID, path, svnStatus);
                } else if (sosHelper.designPartClass == MultidimensionalDesign.class) {
                    String objectPath = st.nextToken();
                    MultidimensionalDesign.initObjectDetails(this.design, file, objectPath, sosHelper, this.storableObjectID);
                } else if (sosHelper.designPartClass == ProcessModel.class) {
                    if (!this.isDataFlowDesign(file.getParentFile()) && "dflows".equalsIgnoreCase(t2)) {
                        String id = st.nextToken();
                        String objectPath = st.nextToken();
                        this.design.getProcessModel().initDesignPart(t2, id, sosHelper);
                        DataFlowDesign.initObjectDetails(this.design, file, objectPath, sosHelper, this.storableObjectID);
                    } else if (path.indexOf("/tt/") > 0) {
                        String parentID = null;
                        st.nextToken();
                        String type = st.nextToken();
                        String s3 = st.nextToken();
                        if (!s3.startsWith(this.storableObjectID)) {
                            type = st.nextToken();
                            parentID = s3;
                        }
                        TransformationTask.initObjectDetails(this.design, file, type, sosHelper, this.storableObjectID, parentID);
                        this.designPartClass = sosHelper.designPartClass;
                    } else {
                        ProcessModel.initObjectDetails(this.design, file, t2, sosHelper, this.storableObjectID);
                    }
                }
                this.objectClass = sosHelper.objectClass;
                this.objectType = sosHelper.objectType;
                this.designPart = sosHelper.designPart;
                this.rdbmsSite = sosHelper.rdbmsSite;
                this.objectSet = sosHelper.objectSet;
                this.storableObject = sosHelper.storableObject;
                this.treePath.addAll(sosHelper.treePath);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("StorableObjectStatus.parseObject(): " + file.getAbsolutePath(), e);
        }
        return false;
    }

    private DesignPart findMultidimensionalDesign(Design design, String objectID) {
        this.designPartClass = MultidimensionalDesign.class;
        this.objectSet = design.getMultidimensionalDesigns();
        for (MultidimensionalDesign model : design.getMultidimensionalDesigns()) {
            if (!model.getObjectID().equals(objectID)) continue;
            return model;
        }
        return null;
    }

    private DesignPart findDataFlowDesign(Design design, String objectID) {
        this.designPartClass = DataFlowDesign.class;
        this.objectSet = design.getProcessModel().getDataFlowDesigns();
        for (DataFlowDesign model : design.getProcessModel().getDataFlowDesigns()) {
            if (!model.getObjectID().equals(objectID)) continue;
            return model;
        }
        return null;
    }

    private DesignPart findRelationalDesignPart(Design design, String shortObjectID) {
        this.designPartClass = RelationalDesign.class;
        this.objectSet = design.getRelationalDesigns();
        this.shortObjectID = shortObjectID;
        for (RelationalDesign relationalDesign : design.getRelationalDesigns()) {
            if (!relationalDesign.getShortObjectID().equals(shortObjectID)) continue;
            return relationalDesign;
        }
        return null;
    }

    private DesignPart findStorageDesign(Design design, String shortObjectID, String rdbmsID) {
        this.designPartClass = RelationalDesign.class;
        this.objectSet = design.getRelationalDesigns();
        this.shortObjectID = shortObjectID;
        for (RelationalDesign relationalDesign : design.getRelationalDesigns()) {
            if (!relationalDesign.getShortObjectID().equals(shortObjectID)) continue;
            return relationalDesign;
        }
        return null;
    }

    private boolean parseFKFolder(File file) {
        if (file.isDirectory() && MDConfiguration.getDefaultInstance().get("fkeyPath").equals(file.getName())) {
            System.out.println("Parsing FK Folder: " + file.getAbsolutePath());
            this.objectClass = FKIndexAssociationSet.class;
            this.objectType = "FKIndexAssociation";
            this.designPart = this.findRelationalDesignPart(this.design, file.getParentFile().getName());
            if (this.designPart != null) {
                this.objectSet = ((RelationalDesign)this.designPart).getFKIndexAssociationSet();
            }
            this.treePath.add(new TreePathHelper(Design.getRelationalModelsSetName(), file.getParentFile(), RelationalDesignSet.class));
            return true;
        }
        return false;
    }

    private boolean parseRelationalDesign(File file) {
        if (this.isRelational(file.getParentFile())) {
            this.objectClass = RelationalDesign.class;
            this.designPart = this.findRelationalDesignPart(this.design, this.storableObjectID);
            this.treePath.add(new TreePathHelper(Design.getRelationalModelsSetName(), file.getParentFile(), RelationalDesignSet.class));
            return true;
        }
        return false;
    }

    private boolean parseStorageDesign(File file) {
        File par = file.getParentFile();
        if (this.isStorageDes(par)) {
            this.objectClass = StorageDesign.class;
            String reldID = par.getParentFile().getName();
            this.designPart = this.findRelationalDesignPart(this.design, reldID);
            this.treePath.add(new TreePathHelper(Design.getRelationalModelsSetName(), file.getParentFile(), RelationalDesignSet.class));
            return true;
        }
        return false;
    }

    private boolean parseLogicalDesign(File file) {
        if (this.isLogical(file.getParentFile())) {
            this.objectClass = LogicalDesign.class;
            this.designPart = this.design.getLogicalDesign();
            this.objectSet = null;
            this.storableObject = this.designPart;
            this.filePath = file;
            return true;
        }
        return false;
    }

    private boolean parseProcessModel(File file) {
        if (this.isProcessModel(file.getParentFile())) {
            this.objectClass = ProcessModel.class;
            this.designPart = this.design.getProcessModel();
            this.objectSet = null;
            this.storableObject = this.designPart;
            this.filePath = file;
            return true;
        }
        return false;
    }

    private boolean parseBusinessInfoDesign(File file) {
        if ("businessinfo".equals(file.getParentFile().getName())) {
            this.objectClass = BusinessInfoDesign.class;
            this.designPart = this.design.getBusinessInfoDesign();
            this.objectSet = null;
            this.storableObject = this.designPart;
            this.filePath = file;
            return true;
        }
        return false;
    }

    private boolean parseDatatypeDesign(File file) {
        if ("datatypes".equals(file.getParentFile().getName())) {
            this.objectClass = DataTypesDesign.class;
            this.designPart = this.design.getDataTypesDesign();
            this.storableObject = this.designPart;
            this.filePath = file;
            return true;
        }
        return false;
    }

    private boolean parseChangeRequest(File file) {
        if ("changerequest".equals(file.getParentFile().getName())) {
            this.parseFile(file);
            this.objectClass = ChangeRequest.class;
            this.objectSet = this.design.getChangeRequestSet();
            this.treePath.add(new TreePathHelper("changerequest", file.getParentFile(), ChangeRequestSet.class));
            return true;
        }
        return false;
    }

    private boolean parseMultidimensionalDesign(File file) {
        if (this.isMultidimensional(file.getParentFile())) {
            this.objectClass = MultidimensionalDesign.class;
            this.designPart = this.findMultidimensionalDesign(this.design, this.storableObjectID);
            this.treePath.add(new TreePathHelper(Design.getMultidimensionalDesignSetName(), file.getParentFile(), MultidimensionalDesignSet.class));
            return true;
        }
        return false;
    }

    private boolean parseDataFlowDesign(File file) {
        if ("dflows".equals(file.getParentFile().getName())) {
            this.objectClass = DataFlowDesign.class;
            this.designPart = this.findDataFlowDesign(this.design, this.storableObjectID);
            try {
                SVNObjectHelper parentSVNOH;
                SVNObjectHelper svnOH = SVNObjectHelper.getSVNObjectHelperFor(this.design, this.storableObjectID);
                if (svnOH != null && (parentSVNOH = SVNObjectHelper.getSVNObjectHelperFor(this.design, svnOH.parentID)) != null) {
                    Class<ModelIDObject> parentClass = Class.forName(parentSVNOH.className);
                    if (parentClass.isAssignableFrom(ProcessModel.class)) {
                        this.treePath.add(new TreePathHelper("Process Model", new File(this.design.getProcessModel().getStorageName()), parentClass));
                        this.treePath.add(new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), file.getParentFile(), DataFlowDesignSet.class));
                    } else {
                        while (parentSVNOH != null) {
                            parentClass = Class.forName(parentSVNOH.className);
                            if (parentClass.isAssignableFrom(DataFlowDesign.class)) {
                                this.treePath.add(0, new TreePathHelper(parentSVNOH.propName, new File(parentSVNOH.fileName), parentClass));
                                this.treePath.add(0, new TreePathHelper(ProcessModel.getDataFlowDesignSetName(), new File(parentSVNOH.fileName).getParentFile(), parentClass));
                            } else if (parentClass.isAssignableFrom(Process.class)) {
                                this.treePath.add(0, new TreePathHelper(parentSVNOH.propName, new File(parentSVNOH.fileName), parentClass));
                                this.treePath.add(0, new TreePathHelper(DataFlowDesign.getProcessSetName(), new File(parentSVNOH.fileName).getParentFile(), parentClass));
                            } else if (parentClass.isAssignableFrom(ProcessModel.class)) {
                                this.treePath.add(0, new TreePathHelper("Process Model", new File(this.design.getProcessModel().getStorageName()), parentClass));
                            }
                            if ((parentSVNOH = SVNObjectHelper.getSVNObjectHelperFor(this.design, parentSVNOH.parentID)) == null || !parentSVNOH.className.endsWith("Process")) continue;
                            this.treePath.remove(0);
                        }
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean parseDesign(File file) {
        String fileName = file.getName();
        if (fileName.endsWith(".dmd") || fileName.endsWith(".dmdz")) {
            this.storableObjectName = FileUtils.removeExt(fileName);
            this.objectClass = Design.class;
            return true;
        }
        return false;
    }

    private void parseFile(File file) {
        String fileName = file.getName();
        this.filePath = file;
        this.storableObjectName = fileName;
        this.storableObjectID = fileName;
    }

    private void parseFolder(File file) {
        this.parseFile(file);
        this.objectClass = File.class;
    }

    private void parseDLSettings(File file) {
        this.parseFile(file);
        this.objectClass = DesignLevelSettings.class;
    }

    private void parseMappings(File file) {
        this.parseFile(file);
        if (file.getName().indexOf("ExtendedMap_RM") > -1) {
            this.objectClass = RMExtendedMap.class;
            this.treePath.add(new TreePathHelper("mapping", file.getParentFile(), RMExtendedMap.class));
            return;
        }
        if (file.getName().indexOf("DeletedMap_RM") > -1) {
            this.objectClass = RMDeletedMap.class;
            this.treePath.add(new TreePathHelper("mapping", file.getParentFile(), RMDeletedMap.class));
            return;
        }
        this.objectClass = ExtendedMap.class;
        this.treePath.add(new TreePathHelper("mapping", file.getParentFile(), ExtendedMap.class));
    }

    private void parseSystemTypes(File file) {
        this.parseFile(file);
        this.treePath.add(new TreePathHelper("System Types", file.getParentFile(), null));
    }

    private void parseDesignRDBMSSites(File file) {
        this.parseFile(file);
        this.objectClass = RDBMSSite.class;
    }

    private boolean parseDesignFilesDir(String designPath, File file, String filePath) {
        String filesP = designPath + "files";
        File filesDir = new File(filesP);
        if (filePath.indexOf(filesP = FileUtils.addLastSlash(filesP)) == 0) {
            this.parseFile(file);
            File parent = file.getParentFile();
            while (!parent.equals(filesDir)) {
                this.treePath.add(0, new TreePathHelper(parent.getName(), parent, null));
                parent = parent.getParentFile();
            }
            this.treePath.add(0, new TreePathHelper("files", filesDir, null));
            return true;
        }
        return false;
    }

    private boolean parseDesignLevelDomainsDir(String designPath, File file, String filePath) {
        String filesP = designPath + "domains";
        if (filePath.indexOf(filesP = FileUtils.addLastSlash(filesP)) == 0) {
            this.parseFile(file);
            this.treePath.add(0, new TreePathHelper("domains", file.getParentFile(), null));
            return true;
        }
        return false;
    }

    private boolean parseDesignLevelRDBMSSitesDir(String designPath, File file, String filePath) {
        String filesP = designPath + "rdbms";
        if (filePath.indexOf(filesP = FileUtils.addLastSlash(filesP)) == 0) {
            this.parseFile(file);
            this.treePath.add(0, new TreePathHelper("rdbms", file.getParentFile(), null));
            return true;
        }
        return false;
    }

    private boolean isRelational(File file) {
        return "rel".equals(file.getName());
    }

    private boolean isStorageDes(File file) {
        return "phys".equals(file.getName());
    }

    private boolean isLogical(File file) {
        return "logical".equals(file.getName());
    }

    private boolean isProcessModel(File file) {
        return "pm".equals(file.getName());
    }

    private boolean isDataFlowDesign(File file) {
        return "dflows".equals(file.getName());
    }

    private boolean isMultidimensional(File file) {
        return "multidimensional".equals(file.getName());
    }

    public void setStorableObject(StorableObject storableObject) {
        this.storableObject = storableObject;
    }

    private boolean isFile(File file) {
        return file.exists() && file.isFile() || !file.exists() && (file.getName().endsWith(".xml") || file.getName().endsWith(".dmd") || file.getName().endsWith(".dmdz"));
    }

    public boolean equals(Object obj) {
        return obj instanceof StorableObjectStatus && this.design.equals(((StorableObjectStatus)obj).getDesign()) && this.filePath.equals(((StorableObjectStatus)obj).getFilePath());
    }

    public void setLockedFlag(boolean locked) {
        this.locked = locked;
    }

    public boolean getLockedFlag() {
        return this.locked;
    }

    public boolean isInconflict() {
        return this.inconflict;
    }

    public void setInconflict(boolean inconflict) {
        this.inconflict = inconflict;
    }

    static class FilePathComparator
    implements Comparator {
        FilePathComparator() {
        }

        public int compare(Object one, Object two) {
            return ((StorableObjectStatus)one).getFilePath().getPath().compareTo(((StorableObjectStatus)two).getFilePath().getPath());
        }
    }
}

