/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.fcp.BrowserDockable;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.fcp.vcs.svn.commands.DesignEstimatesCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNCommitCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNCommitDesignCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNImportCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateWorkingCopyCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNVersionHistoryCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNVersionTreeCommand;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.log.MessagePage;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSController;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;

public class DMSVNOSGiController
extends VCSController {
    private static DMSVNOSGiController instance = null;
    private static Map<String, Command> commandsMap = new HashMap<String, Command>();
    private static Map<Integer, Command> commandsIDMap = new HashMap<Integer, Command>();
    private Command command = null;
    private static final int SVN_STORABLE_OBJECT_PROPERTIES = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand");
    private static final int SVN_VERSION_HISTORY = Ide.findOrCreateCmdID((String)"DataModelingAddin.VersionHistory");
    private static final int SVN_VERSION_HISTORY_TEAM_MENU = Ide.findOrCreateCmdID((String)SVNVersionHistoryCommand.COMMAND_ID);
    private static final int SVN_COMPARE_LAST_LOCAL = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareLastLocalCommand");
    private static final int SVN_TEXT_COMPARE_LAST_LOCAL = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareLastLocalCommand");
    private static final int SVN_COMPARE_LATEST = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.compare-latest");
    private static final int SVN_TEXT_COMPARE_LATEST = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareLatestCommand");
    private static final int SVN_UPDATE = Ide.findOrCreateCmdID((String)SVNUpdateCommand.COMMAND_ID);
    private static final int SVN_UPDATE_ALL = Ide.findOrCreateCmdID((String)"DataModelingAddin.UpdateAll");
    private static final int SVN_COMPARE_CURRENT = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareCurrentCommand");
    private static final int SVN_TEXT_COMPARE_CURRENT = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareCurrentCommand");
    private static final int SVN_VERSION_TREE = Ide.findOrCreateCmdID((String)"DataModelingAddin.VersionTree");
    private static final int SVN_VERSION_TREE_TEAM_MENU = Ide.findOrCreateCmdID((String)SVNVersionTreeCommand.COMMAND_ID);
    private static final int SVN_IMPORT = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.import");
    private static final int DESIGN_ESTIMATES = Ide.findOrCreateCmdID((String)DesignEstimatesCommand.COMMAND_ID);

    private DMSVNOSGiController() {
        super(AbstractSVNOperation.class.getPackage());
        if (commandsMap == null) {
            commandsMap = new HashMap<String, Command>();
        }
    }

    public static DMSVNOSGiController getInstance() {
        if (instance == null) {
            instance = new DMSVNOSGiController();
        }
        return instance;
    }

    public void register(IdeAction action, Command command) {
        commandsMap.put(action.getCommand(), command);
        commandsIDMap.put(action.getCommandId(), command);
        action.addController((Controller)this);
    }

    protected boolean isHandledAction(IdeAction action) {
        return commandsMap.keySet().contains(action.getCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction action, Context context) {
        Design design;
        if (context.getView().getId().equals("FileNavigatorWindow.Files")) {
            return false;
        }
        int commandId = action.getCommandId();
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        if (this.isHandledAction(action)) {
            this.command = commandsMap.get(action.getCommand());
        }
        if (context.getView() instanceof MessagePage) {
            for (View view : Ide.getMainWindow().getVisibleViews()) {
                if (!(view instanceof DMDiagramEditor)) continue;
                context.setView(view);
            }
        }
        if ((design = VCSClientHelper.getSelectionDesign(context.getView())) == null) {
            design = ApplicationView.getInstance().getCurrentDesign();
        }
        if (design != null) {
            if (!(design.isVersioned() || SVNClientHelper.getInstance().isVersioned(design.getAppView().getSettings().getDefaultSystemTypesPath()) || commandId == SVN_IMPORT || commandId == DESIGN_ESTIMATES || this.command instanceof SVNUpdateWorkingCopyCommand)) {
                return this.command instanceof SVNCommitDesignCommand;
            }
            if (this.command != null) {
                try {
                    waitCursor.show();
                    this.command.setContext(context);
                    try {
                        this.command.doit();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        waitCursor.hide();
                    }
                    return true;
                }
                catch (Exception e) {
                    waitCursor.hide();
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == null) {
            return false;
        }
        if (!Extension.isSVNExtensionLoaded()) {
            ideAction.setEnabled(false);
            return true;
        }
        Command command = commandsMap.get(ideAction.getCommand());
        if (!VCSClientHelper.isDataModelerContextView(context)) {
            if (command instanceof SVNCommitDesignCommand) {
                ideAction.setName(DataModelerAddin.COMMIT_WORKING_COPY_NAME);
            }
            return false;
        }
        Design design = VCSClientHelper.getSelectionDesign(context.getView());
        if (command instanceof SVNCommitDesignCommand) {
            ideAction.setName(DataModelerAddin.COMMIT_DESIGN_NAME);
        }
        if (command instanceof SVNImportCommand) {
            ideAction.setEnabled(true);
            return true;
        }
        if (design == null) {
            if (ideAction.getCommand() != null && command != null) {
                ideAction.setEnabled(false);
                return true;
            }
            return false;
        }
        if (!(design.isVersioned() || context.getView() != null && context.getView() instanceof SVNChangeListWindow)) {
            if (ideAction.getCommandId() == DESIGN_ESTIMATES && !design.isNewDesign()) {
                ideAction.setEnabled(true);
                return true;
            }
            if (command == null) {
                return false;
            }
            if (context.getView() != null) {
                if (context.getView() instanceof BrowserDockable) {
                    BrowserDockable browserDockable = (BrowserDockable)context.getView();
                    BrowserPanel browserPanel = (BrowserPanel)browserDockable.getBrowser();
                    if (browserPanel != null) {
                        TreePath selectionPath = browserPanel.getJTree().getSelectionPath();
                        if (SVNClientHelper.getInstance().isVersioned(design.getAppView().getSettings().getDefaultSystemTypesPath())) {
                            if (selectionPath != null && selectionPath.getParentPath() != null) {
                                if (selectionPath.getParentPath().getLastPathComponent().toString().compareTo(Design.DOMAINS) == 0) {
                                    ideAction.setEnabled(true);
                                } else {
                                    ideAction.setEnabled(false);
                                }
                            } else {
                                ideAction.setEnabled(false);
                            }
                        } else {
                            ideAction.setEnabled(false);
                        }
                    } else {
                        ideAction.setEnabled(false);
                    }
                } else {
                    ideAction.setEnabled(false);
                }
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (ideAction.getCommand().equalsIgnoreCase("oracle.jdevimpl.vcs.svn.op.SVNOperationUpdateWC")) {
            ideAction.setEnabled(true);
            return true;
        }
        boolean vcsCommandIsAvailable = false;
        if (command != null) {
            if (command instanceof VCSCommand) {
                VCSCommand vcsCommand = (VCSCommand)command;
                vcsCommand.setContext(context);
                vcsCommandIsAvailable = vcsCommand.isAvailable();
            }
        } else {
            return true;
        }
        SVNChangeListWindow svnChangeListWindow = null;
        if (context.getView() != null && context.getView() instanceof SVNChangeListWindow) {
            DataModelerChangeList changeList = (DataModelerChangeList)((SVNChangeListWindow)context.getView()).getContextChangeList();
            VersioningTreeNode selectedNode = changeList.getPanel().getSelectedNode();
            int commandID = ideAction.getCommandId();
            svnChangeListWindow = (SVNChangeListWindow)context.getView();
            svnChangeListWindow.getContextChangeList().firePropertyChange("changeListCount", changeList.getCount() == 0 ? 1 : 0, changeList.getCount());
            svnChangeListWindow.getContextChangeList().setToolTipText("");
            if (selectedNode != null) {
                File currentFile = selectedNode.getFilePath();
                StorableObjectStatus storableObjectStatus = selectedNode.getStorableObjectStatus();
                commandID = ideAction.getCommandId();
                if (currentFile.isDirectory() || storableObjectStatus == null) {
                    if (commandID == SVN_COMPARE_LAST_LOCAL || commandID == SVN_TEXT_COMPARE_LAST_LOCAL || commandID == SVN_COMPARE_LATEST || commandID == SVN_TEXT_COMPARE_LATEST || commandID == SVN_COMPARE_CURRENT || commandID == SVN_TEXT_COMPARE_CURRENT || commandID == SVN_VERSION_HISTORY || commandID == SVN_STORABLE_OBJECT_PROPERTIES || commandID == SVN_VERSION_HISTORY_TEAM_MENU || commandID == SVN_VERSION_TREE || commandID == SVN_VERSION_TREE_TEAM_MENU || commandID == SVN_UPDATE || commandID == SVN_UPDATE_ALL) {
                        ideAction.setEnabled(false);
                    } else {
                        ideAction.setEnabled(vcsCommandIsAvailable);
                        if (changeList instanceof SVNOutgoingChangesChangeList && ideAction.getCommand().compareTo(SVNCommitCommand.COMMAND_ID) == 0) {
                            ((SVNOutgoingChangesChangeList)changeList).updateToolbarActionsAvailability(vcsCommandIsAvailable);
                        }
                    }
                } else if (commandID == SVN_COMPARE_LAST_LOCAL || commandID == SVN_TEXT_COMPARE_LAST_LOCAL || commandID == SVN_COMPARE_LATEST || commandID == SVN_TEXT_COMPARE_LATEST || commandID == SVN_COMPARE_CURRENT || commandID == SVN_TEXT_COMPARE_CURRENT || commandID == SVN_VERSION_HISTORY || commandID == SVN_STORABLE_OBJECT_PROPERTIES || commandID == SVN_VERSION_HISTORY_TEAM_MENU || commandID == SVN_VERSION_TREE || commandID == SVN_VERSION_TREE_TEAM_MENU || commandID == SVN_UPDATE || commandID == SVN_UPDATE_ALL) {
                    ideAction.setEnabled(true);
                } else {
                    ideAction.setEnabled(vcsCommandIsAvailable);
                    if (changeList instanceof SVNOutgoingChangesChangeList && ideAction.getCommand().compareTo(SVNCommitCommand.COMMAND_ID) == 0) {
                        ((SVNOutgoingChangesChangeList)changeList).updateToolbarActionsAvailability(vcsCommandIsAvailable);
                    }
                }
                return true;
            }
            if (commandID == SVN_IMPORT) {
                return true;
            }
            if (design.isVersioned() || SVNClientHelper.getInstance().isVersioned(design.getAppView().getSettings().getDefaultSystemTypesPath())) {
                ideAction.setEnabled(vcsCommandIsAvailable);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        ideAction.setEnabled(vcsCommandIsAvailable);
        return vcsCommandIsAvailable;
    }
}

