/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports;

import java.awt.Frame;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.SyncConnectionDialog;
import oracle.dbtools.crest.imports.SyncObject;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.jdeveloper.db.DatabaseConnections;

public class SyncUtils {
    private static final Logger LOGGER = new Logger(SyncUtils.class);
    private static boolean syncMode;
    private static List<DBObject> sqlServerSchemas;
    private static List<String> sqlServerSchemaNames;

    public static void syncDataDictionary(RelationalDesign relModel, boolean syncMode, Map selectedIDs) {
        block24: {
            try {
                SyncUtils.syncMode = syncMode;
                relModel.getDesign().setRelationalDesign(relModel);
                relModel.getAppView().setCurrentDesign(relModel.getDesign());
                Object[] sourceStamps = relModel.getImportConnectionStamps().toArray();
                DBConnectionStamp redirectStamp = relModel.getRedirectConnectionStamp();
                List<String> selectedObjStamps = SyncUtils.getSelectedObjStamps(relModel, selectedIDs);
                DBConnectionStamp[] syncStamps = (DBConnectionStamp[])SyncConnectionDialog.showDialog((Frame)Ide.getMainWindow(), relModel, Messages.getString("ControllerRelational.DataDictionaryConnections"), Messages.getString("ControllerRelational.SelectConnection"), sourceStamps, redirectStamp, selectedObjStamps, syncMode);
                if (syncStamps.length == 0) {
                    return;
                }
                DBConnectionStamp redirectSyncStamp = syncStamps[0];
                if (!"".equals(redirectSyncStamp.getConnName()) && redirectSyncStamp.getConnType() != 1 && redirectSyncStamp.getConnType() != 2 && redirectSyncStamp.getConnType() != 3 && redirectSyncStamp.getConnType() != 4) {
                    return;
                }
                ArrayList<Integer> selectedStampIndexes = new ArrayList<Integer>();
                for (int i = 1; i < syncStamps.length; ++i) {
                    DBConnectionStamp syncStamp = syncStamps[i];
                    int index = relModel.findImportConnectionStamp(syncStamp.getConnName());
                    if (!relModel.getImportConnectionStamp(index).isSameAs(syncStamp)) {
                        relModel.setImportConnectionStamp(syncStamp, index);
                        relModel.setDirty(true);
                    }
                    if (syncStamp.getSyncSelected() != 1 && !syncStamp.isSimilarAs(redirectSyncStamp)) continue;
                    selectedStampIndexes.add(index);
                    syncStamp.setSyncSelected(1);
                }
                int checkType = -1;
                if (!"".equals(redirectSyncStamp.getConnName())) {
                    checkType = redirectSyncStamp.getConnType();
                }
                for (int i = 0; i < selectedStampIndexes.size(); ++i) {
                    DBConnectionStamp checkStamp = relModel.getImportConnectionStamp((Integer)selectedStampIndexes.get(i));
                    if (checkType == -1) {
                        checkType = checkStamp.getConnType();
                        continue;
                    }
                    if (checkType == checkStamp.getConnType()) continue;
                    return;
                }
                if (!"".equals(redirectSyncStamp.getConnName())) {
                    if (!redirectSyncStamp.isSameAs(redirectStamp)) {
                        relModel.setRedirectConnectionStamp(redirectSyncStamp);
                        relModel.setDirty(true);
                    }
                } else if (redirectStamp != null) {
                    relModel.setRedirectConnectionStamp(null);
                    relModel.setDirty(true);
                }
                if ("".equals(redirectSyncStamp.getConnName()) && selectedStampIndexes.size() == 1) {
                    redirectSyncStamp = relModel.getImportConnectionStamp((Integer)selectedStampIndexes.get(0));
                }
                if (selectedStampIndexes.size() == 1) {
                    relModel.setImportConnectionStampIndex((Integer)selectedStampIndexes.get(0));
                } else {
                    relModel.setImportConnectionStampIndex(-1);
                }
                String connName = redirectSyncStamp.getConnName();
                int connType = redirectSyncStamp.getConnType();
                if ("".equals(connName)) break block24;
                try {
                    Connection conn = DatabaseConnections.getInstance().getUniqueConnection(connName);
                    if (conn != null) {
                        Properties connProp = new Properties();
                        DBMExtractionController controller = new DBMExtractionController(relModel.getAppView());
                        AbstractDBMExtractionHandler handler = controller.getDBMExtractionHandler(connType);
                        handler.init(conn);
                        if (handler instanceof DBMExtractionHandlerOracle) {
                            ((DBMExtractionHandlerOracle)handler).setDBAUser(conn);
                        }
                        RDBMSSite site = handler.getRDBMSSite();
                        relModel.setSelectedRDBMSSite(site);
                        ArrayList syncObjects = new ArrayList();
                        ArrayList<String> conn_Names = new ArrayList<String>();
                        for (int i = 0; i < selectedStampIndexes.size(); ++i) {
                            DBConnectionStamp selStamp = relModel.getImportConnectionStamp((Integer)selectedStampIndexes.get(i));
                            conn_Names.add(selStamp.getConnName());
                        }
                        List objects = SyncUtils.getSelectedObjects(relModel, selectedIDs, conn_Names, connType, conn, handler, syncMode);
                        syncObjects.addAll(objects);
                        try {
                            if (syncMode) {
                                FKIndexAssociation.RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = false;
                            }
                            controller.generateDesign(conn, connProp, syncObjects, relModel, syncMode, site, true, selectedIDs, connName, connType);
                        }
                        catch (Throwable x) {
                            MessageDialogs.showErrorMessage(x.getMessage());
                            LOGGER.error(x);
                        }
                        break block24;
                    }
                    connName = "";
                }
                catch (SQLException se) {
                    connName = "";
                    MessageDialogs.showErrorMessage(se.getMessage());
                    LOGGER.error(se);
                }
            }
            catch (Throwable ex) {
                MessageDialogs.showErrorMessage(ex.getMessage());
                LOGGER.error(ex);
            }
        }
    }

    private static List<String> getSelectedObjStamps(RelationalDesign relModel, Map selectedIDs) {
        ArrayList<String> stamps = new ArrayList<String>();
        if (selectedIDs != null && !selectedIDs.isEmpty()) {
            TableSet tableSet = relModel.getTableSet();
            TableViewSet viewSet = relModel.getTableViewSet();
            Iterator selIDIter = selectedIDs.entrySet().iterator();
            while (selIDIter.hasNext()) {
                String selID = (String)selIDIter.next().getKey();
                DesignObject selObj = tableSet.getObjectByID(selID);
                if (selObj != null) {
                    if ("".equals(selObj.getSourceConnName()) || stamps.contains(selObj.getSourceConnName())) continue;
                    stamps.add(selObj.getSourceConnName());
                    continue;
                }
                selObj = viewSet.getObjectByID(selID);
                if (selObj == null || "".equals(selObj.getSourceConnName()) || stamps.contains(selObj.getSourceConnName())) continue;
                stamps.add(selObj.getSourceConnName());
            }
        }
        return stamps;
    }

    public static List getSelectedObjects(RelationalDesign relModel, Map selectedIDs, List<String> conn_Names, int connType, Connection conn, AbstractDBMExtractionHandler handler, boolean syncMode) throws Exception {
        Settings settings = relModel.getDesign().getAppView().getSettings();
        String dbname = conn.getMetaData().getDatabaseProductName();
        Iterator syncObjectsIt = settings.getSyncObjects().iterator();
        ArrayList list = new ArrayList();
        StorageDesign storage = relModel.getStorageDesign();
        sqlServerSchemas = new ArrayList<DBObject>();
        sqlServerSchemaNames = new ArrayList<String>();
        if (selectedIDs != null) {
            StorageDesignOracle storageOracle;
            ArrayList<ModelIDObject> objects = new ArrayList<ModelIDObject>();
            ArrayList extTables = new ArrayList();
            Iterator iter = relModel.getTableSet().iterator();
            while (iter.hasNext()) {
                ModelIDObject obj = (ModelIDObject)iter.next();
                if (!syncMode && obj.isRemoteObject() || !selectedIDs.containsKey(obj.getObjectID())) continue;
                if (storage != null && storage instanceof StorageDesignOracle) {
                    storageOracle = (StorageDesignOracle)storage;
                    if (!(obj instanceof Table)) continue;
                    TableProxyOracle tp = (TableProxyOracle)storageOracle.getStorageObject(obj.getObjectID());
                    if (tp != null && "EXTERNAL".equalsIgnoreCase(tp.getOrganization())) {
                        objects.add(obj);
                        continue;
                    }
                    objects.add(obj);
                    if (!"6".equals(((Table)obj).getTypeID())) continue;
                }
                objects.add(obj);
            }
            List dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, objects.iterator(), "TABLE", selectedIDs.size() > 0);
            list.addAll(dboList);
            if (extTables.size() > 0) {
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, extTables.iterator(), "TABLE", selectedIDs.size() > 0);
                list.addAll(dboList);
            }
            objects.clear();
            iter = relModel.getTableViewSet().iterator();
            while (iter.hasNext()) {
                ModelIDObject obj = (ModelIDObject)iter.next();
                if (!syncMode && obj.isRemoteObject() || !selectedIDs.containsKey(obj.getObjectID())) continue;
                objects.add(obj);
            }
            dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, objects.iterator(), "VIEW", selectedIDs.size() > 0);
            list.addAll(dboList);
            if (storage != null && storage instanceof StorageDesignOracle) {
                storageOracle = (StorageDesignOracle)storage;
                iter = storageOracle.getTableSpaceSet().iterator();
                dboList = SyncUtils.getSelectedObjectsNoSchema(conn_Names, connType, conn, handler, iter, "TABLESPACE");
                list.addAll(dboList);
            }
        } else {
            StorageDesignOracle storageOracle;
            ArrayList extTables = new ArrayList();
            ArrayList<ModelIDObject> objects = new ArrayList<ModelIDObject>();
            Iterator iter = relModel.getTableSet().iterator();
            while (iter.hasNext()) {
                ModelIDObject obj = (ModelIDObject)iter.next();
                if (storage != null && storage instanceof StorageDesignOracle) {
                    storageOracle = (StorageDesignOracle)storage;
                    if (!(obj instanceof Table)) continue;
                    TableProxyOracle tp = (TableProxyOracle)storageOracle.getStorageObject(obj.getObjectID());
                    if (tp != null && "EXTERNAL".equalsIgnoreCase(tp.getOrganization())) {
                        objects.add(obj);
                        continue;
                    }
                    objects.add(obj);
                    if (!"6".equals(((Table)obj).getTypeID())) continue;
                }
                objects.add(obj);
            }
            List dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, objects.iterator(), "TABLE");
            list.addAll(dboList);
            if (extTables.size() > 0) {
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, extTables.iterator(), "TABLE");
                list.addAll(dboList);
                extTables.clear();
            }
            objects.clear();
            iter = relModel.getTableViewSet().iterator();
            dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "VIEW");
            list.addAll(dboList);
            if (connType == 4) {
                iter = relModel.getTableSet().iterator();
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "SUMMARY TABLE");
                list.addAll(dboList);
                iter = relModel.getTableSet().iterator();
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "TYPED TABLE");
                list.addAll(dboList);
            }
            if (storage != null && storage instanceof StorageDesignOracle) {
                storageOracle = (StorageDesignOracle)storage;
                boolean usersExtracted = false;
                while (syncObjectsIt.hasNext()) {
                    SyncObject so = (SyncObject)syncObjectsIt.next();
                    if (!so.getDatabase().equals("Oracle") || !so.isUsed()) continue;
                    if (so.getType().equals("TABLESPACE")) {
                        iter = storageOracle.getTableSpaceSet().iterator();
                        dboList = SyncUtils.getSelectedObjectsNoSchema(conn_Names, connType, conn, handler, iter, "TABLESPACE");
                        list.addAll(dboList);
                    } else if (so.getType().equals("TEMP TABLESPACE")) {
                        iter = storageOracle.getTemporaryTablespaceSet().iterator();
                        dboList = SyncUtils.getSelectedObjectsNoSchema(conn_Names, connType, conn, handler, iter, "TEMP TABLESPACE");
                        list.addAll(dboList);
                    } else if (so.getType().equals("UNDO TABLESPACE")) {
                        iter = storageOracle.getUndoTablespaceSet().iterator();
                        dboList = SyncUtils.getSelectedObjectsNoSchema(conn_Names, connType, conn, handler, iter, "UNDO TABLESPACE");
                        list.addAll(dboList);
                    } else if (so.getType().equals("ROLE")) {
                        iter = storageOracle.getRoleSet().iterator();
                        dboList = SyncUtils.getSelectedObjectsNoSchema(conn_Names, connType, conn, handler, iter, "ROLE");
                        list.addAll(dboList);
                    } else if (so.getType().equals("USER")) {
                        iter = storageOracle.getUserSet().iterator();
                        dboList = SyncUtils.getSelectedObjectsNoSchema(conn_Names, connType, conn, handler, iter, "USER");
                        list.addAll(dboList);
                        usersExtracted = true;
                    } else if (so.getType().equals("DIRECTORY")) {
                        iter = storageOracle.getDirectorySet().iterator();
                        dboList = SyncUtils.getSelectedObjectsNoSchema(conn_Names, connType, conn, handler, iter, "DIRECTORY");
                        list.addAll(dboList);
                    } else if (so.getType().equals("EXTERNAL TABLE")) {
                        iter = storageOracle.getExternalTableSet().iterator();
                        dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "TABLE");
                        list.addAll(dboList);
                    } else if (so.getType().equals("CONTEXT")) {
                        iter = storageOracle.getContextSet().iterator();
                        dboList = SyncUtils.getSelectedObjectsNoSchema(conn_Names, connType, conn, handler, iter, "CONTEXT");
                        list.addAll(dboList);
                    } else if (so.getType().equals("CLUSTER")) {
                        iter = storageOracle.getClusterSet().iterator();
                        dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "CLUSTER");
                        list.addAll(dboList);
                    } else if (so.getType().equals("SEQUENCE")) {
                        iter = storageOracle.getSequenceSet().iterator();
                        dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "SEQUENCE");
                        list.addAll(dboList);
                    } else if (so.getType().equals("SYNONYM")) {
                        iter = storageOracle.getSynonymSet().iterator();
                        dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "SYNONYM");
                        list.addAll(dboList);
                    } else if (so.getType().equals("DIMENSION")) {
                        iter = storageOracle.getDimensionSet().iterator();
                        dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "DIMENSION");
                        list.addAll(dboList);
                    } else if (so.getType().equals("PACKAGE")) {
                        iter = storageOracle.getPackageSet().iterator();
                        dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "PACKAGE");
                        list.addAll(dboList);
                    } else if (so.getType().equals("PROCEDURE")) {
                        iter = storageOracle.getStoredProcedureSet().iterator();
                        dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "PROCEDURE");
                        list.addAll(dboList);
                    } else if (so.getType().equals("FUNCTION")) {
                        iter = storageOracle.getFunctionSet().iterator();
                        dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "FUNCTION");
                        list.addAll(dboList);
                    }
                    if (usersExtracted) continue;
                    iter = storageOracle.getUserSet().iterator();
                    SyncUtils.getSelectedObjectsNoSchema(conn_Names, connType, conn, handler, iter, "USER");
                }
                ArrayList struct_and_collect = new ArrayList();
                storageOracle.getCollectionTypeProxySet().addAllElementsTo(struct_and_collect);
                storageOracle.getStructuredTypeProxySet().addAllElementsTo(struct_and_collect);
                iter = struct_and_collect.iterator();
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "OBJECT");
                list.addAll(dboList);
            }
            if (connType == 2) {
                iter = relModel.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "DATATYPE");
                list.addAll(dboList);
                if (storage instanceof StorageDesignSqlServerv2k12) {
                    StorageDesignSqlServerv2k12 storageSqlServer = (StorageDesignSqlServerv2k12)storage;
                    iter = storageSqlServer.getSequenceSet().iterator();
                    dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "SEQUENCE");
                    list.addAll(dboList);
                }
            } else if (connType == 3) {
                iter = relModel.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "DATATYPE");
                list.addAll(dboList);
            } else if (connType == 4) {
                iter = relModel.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "DATATYPE");
                list.addAll(dboList);
                iter = relModel.getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "TYPE");
                list.addAll(dboList);
                iter = relModel.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                dboList = SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, "TYPE");
                list.addAll(dboList);
            }
        }
        if (!sqlServerSchemas.isEmpty()) {
            sqlServerSchemas.addAll(list);
            return sqlServerSchemas;
        }
        return list;
    }

    public static List getSelectedObjects(RelationalDesign relModel, List<String> conn_Names, int connType, Connection conn, AbstractDBMExtractionHandler handler, Iterator iter, String type) throws Exception {
        return SyncUtils.getSelectedObjects(relModel, conn_Names, connType, conn, handler, iter, type, false);
    }

    public static List getSelectedObjects(RelationalDesign rel, List<String> conn_Names, int connType, Connection conn, AbstractDBMExtractionHandler handler, Iterator iter, String type, boolean selectedObjectsOnly) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        TreeMap<String, DBObject> schemaMap = new TreeMap<String, DBObject>();
        ArrayList<String> objLongNames = new ArrayList<String>();
        List dboList = new ArrayList();
        Settings settings = ApplicationView.getInstance().getSettings();
        boolean syncWholeSchema = settings.isSyncWholeSchema();
        boolean syncExcludeRemoteObjects = settings.isExcludeRemoteObjectsFromSync();
        while (iter.hasNext()) {
            ModelIDObject obj = (ModelIDObject)iter.next();
            if ((!syncMode || syncExcludeRemoteObjects) && obj.isRemoteObject()) continue;
            rel = obj.getDesign().getRelationalDesign();
            StorageDesign sd = rel.getStorageDesign();
            boolean use = settings.isUseDBSyncSourceConnection();
            boolean useSchema = settings.isUseDBSyncSourceSchema();
            boolean useName = settings.isUseDBSyncSourceObject();
            syncWholeSchema = settings.isSyncWholeSchema();
            String connName = obj.getSourceConnName();
            boolean isUseConnectionUser = rel.isUseConnectionUser();
            if (use && !"".equals(obj.getSourceConnName()) && !conn_Names.contains(connName)) continue;
            String objName = "";
            String schemaName = "";
            objName = useName && !"".equals(obj.getSourceObjName()) ? obj.getSourceObjName() : (obj.getNameHasQuotes() ? obj.getName() : obj.getName().toUpperCase());
            if (useSchema && !"".equals(obj.getSourceObjSchema())) {
                schemaName = obj.getSourceObjSchema();
            } else if (obj instanceof DesignObject) {
                schemaName = ((DesignObject)obj).getSchema();
            } else {
                StorageObject user = null;
                if (obj instanceof StructuredTypeProxy) {
                    user = ((StructuredTypeProxy)obj).getSchemaOrUser();
                } else if (obj instanceof CollectionTypeProxy) {
                    user = ((CollectionTypeProxy)obj).getSchemaOrOwner();
                } else if (obj instanceof OwnedObjectOracle) {
                    user = ((OwnedObjectOracle)((Object)obj)).getUser();
                }
                if (user != null) {
                    schemaName = user.getName();
                }
            }
            if (sd.isOpen() && obj instanceof DesignObject) {
                String sch;
                ModelIDObject imp;
                RelationalObjectProxy tp;
                if (!useSchema) {
                    schemaName = ((DesignObject)obj).getSchema();
                }
                if (obj instanceof Table) {
                    tp = (TableProxy)sd.getTableProxySet().getObjectByID(obj.getObjectID());
                    if (tp != null) {
                        if (!useSchema && (imp = ((TableProxy)tp).getSchemaImplementingObject()) != null && imp.getName().toUpperCase().indexOf("IMPLICIT") <= -1) {
                            schemaName = imp.getNameHasQuotes() ? imp.getName() : imp.getName().toUpperCase();
                        }
                        if (!useName) {
                            objName = tp.getNameHasQuotes() ? tp.getName() : tp.getName().toUpperCase();
                        }
                    }
                } else if (obj instanceof TableView) {
                    tp = (TableViewProxy)sd.getTableViewProxySet().getObjectByID(obj.getObjectID());
                    if (tp != null && (imp = ((TableViewProxy)tp).getSchemaImplementingObject()) != null) {
                        schemaName = imp.getName();
                    }
                } else if (!useSchema && obj instanceof ContainerObject && !"".equals(sch = sd.getSchemaImplementationNane(((ContainerObject)obj).getSchemaObject()))) {
                    schemaName = sch;
                }
            }
            if (isUseConnectionUser || "".equals(schemaName) && !syncWholeSchema) {
                try {
                    schemaName = conn.getMetaData().getUserName();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (connType != 2) {
                if (!("".equals(schemaName) || schemaMap.containsKey(schemaName) || "MDSYS".equals(schemaName) && "SDO_GEOMETRY".equals(objName) || "SYS".equals(schemaName) && (objName.equals("XMLTYPE") || objName.startsWith("ANY")) || "ORDSYS".equals(schemaName) && objName.startsWith("ORD"))) {
                    schemaMap.put(schemaName, new DBObject(true, schemaName));
                }
            } else if (connType == 2 && !"".equals(schemaName)) {
                SchemaObject so;
                StorageDesign storageDesign = rel.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServerv2k5) {
                    String dbName;
                    String mapName;
                    String dbSourceName;
                    RelationalObjectProxy proxy;
                    StorageDesignSqlServerv2k5 storage = (StorageDesignSqlServerv2k5)storageDesign;
                    ModelObject schema = null;
                    if (type == "TABLE") {
                        proxy = (TableProxySqlServer)storage.getTableProxySet().getByName(obj.getName());
                        dbSourceName = ((TableProxySqlServer)proxy).getDatabase().getSourceObjName();
                        schema = storage.getSchemaSet().getBySourceNameAndDB(schemaName, dbSourceName);
                    } else if (type == "VIEW") {
                        proxy = (TableViewProxySqlServer)storage.getTableViewProxySet().getByName(obj.getName());
                        dbSourceName = ((TableViewProxySqlServer)proxy).getDataBase().getSourceObjName();
                        schema = storage.getSchemaSet().getBySourceNameAndDB(schemaName, dbSourceName);
                    } else if (type == "SEQUENCE" && storage instanceof StorageDesignSqlServerv2k12) {
                        SequenceSqlServerv2k12 seq = (SequenceSqlServerv2k12)((StorageDesignSqlServerv2k12)storage).getSequenceSet().getByName(obj.getName());
                        dbSourceName = seq.getDatabase().getSourceObjName();
                        schema = storage.getSchemaSet().getBySourceNameAndDB(schemaName, dbSourceName);
                    }
                    if (schema != null && !schemaMap.containsKey(mapName = (dbName = schema.getSourceObjSchema()) + "_" + schemaName)) {
                        String id = ((ModelIDObject)schema).getObjectID();
                        String uid = ((SchemaSqlServer)schema).getUid();
                        DBUserSqlServer dbSchema = new DBUserSqlServer(true, schemaName, "SCHEMA");
                        dbSchema.setDb(dbName);
                        dbSchema.setId(id);
                        dbSchema.setUid(uid);
                        schemaMap.put(mapName, dbSchema);
                    }
                } else if (storageDesign != null && storageDesign instanceof StorageDesignSqlServerv2k && !"".equals(schemaName) && !schemaMap.containsKey(schemaName) && (so = (SchemaObject)rel.getSchemaObjectSet().getByName(schemaName)) != null) {
                    String db = so.getSourceObjSchema();
                    String id = so.getObjectID();
                    DBUserSqlServer dbSchema = new DBUserSqlServer(true, schemaName, "SCHEMA");
                    dbSchema.setDb(db);
                    dbSchema.setId(id);
                    dbSchema.setUid(id);
                    schemaMap.put(schemaName, dbSchema);
                }
            }
            String objLongName = (!"".equals(schemaName) ? schemaName + "." : "") + objName;
            objLongNames.add(objLongName.toUpperCase());
        }
        if (!schemaMap.isEmpty()) {
            for (DBObject sch : schemaMap.values()) {
                String dbSchName;
                if (!(sch instanceof DBUserSqlServer) || sqlServerSchemaNames.contains(dbSchName = ((DBUserSqlServer)sch).getDb() + "_" + sch.getName())) continue;
                sqlServerSchemaNames.add(dbSchName);
                sqlServerSchemas.add(sch);
            }
            dboList = handler.getDBObjects(conn, new ArrayList(schemaMap.values()), type);
            for (DBObject dbo : dboList) {
                String dboSchema = dbo.getSchema();
                String dboLongName = (!"".equals(dboSchema) ? dboSchema + "." : "") + dbo.getName();
                if ((!syncWholeSchema || selectedObjectsOnly) && !objLongNames.contains(dboLongName.toUpperCase())) continue;
                list.add(dbo);
            }
        }
        return list;
    }

    public static List getSelectedObjectsNoSchema(List<String> conn_Names, int connType, Connection conn, AbstractDBMExtractionHandler handler, Iterator iter, String type) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        TreeMap schemaMap = new TreeMap();
        ArrayList<String> objLongNames = new ArrayList<String>();
        List dboList = new ArrayList();
        while (iter.hasNext()) {
            ModelIDObject obj = (ModelIDObject)iter.next();
            boolean use = obj.getAppView().getSettings().isUseDBSyncSourceConnection();
            boolean useName = obj.getAppView().getSettings().isUseDBSyncSourceObject();
            String objName = "";
            String connName = obj.getSourceConnName();
            if (use && !"".equals(obj.getSourceConnName()) && !conn_Names.contains(connName)) continue;
            if (useName && !"".equals(obj.getSourceObjName())) {
                objName = obj.getSourceObjName();
            } else {
                objName = obj.getName().toUpperCase();
                if (obj.getNameHasQuotes()) {
                    objName = obj.getName();
                }
            }
            objLongNames.add(objName);
        }
        dboList = handler.getDBObjects(conn, new ArrayList(schemaMap.values()), type);
        for (DBObject dbo : dboList) {
            String dboLongName = dbo.getName();
            if (!objLongNames.contains(dboLongName)) continue;
            list.add(dbo);
        }
        return list;
    }

    static {
        sqlServerSchemas = new ArrayList<DBObject>();
        sqlServerSchemaNames = new ArrayList<String>();
    }
}

