/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.ddl.oracle.SHCreatePackageOracle;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public class SHCreatePackageBodyOracle
extends SHCreatePackageOracle {
    public SHCreatePackageBodyOracle(Design design) {
        super(design);
    }

    @Override
    protected String getTypeName() {
        return "Package Body";
    }

    @Override
    protected void parse(String statement, String line) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (storageDesignOracle != null) {
            String ownerName = null;
            String packageName = this.extractOwnerAndName(statement);
            int dotIndex = packageName.indexOf(46);
            if (dotIndex > -1) {
                ownerName = packageName.substring(0, dotIndex);
                packageName = packageName.substring(dotIndex + 1);
            }
            PackageOracle packageOracle = null;
            packageOracle = ownerName != null ? storageDesignOracle.getPackageSet().getByOwnerAndName(ownerName, packageName) : (PackageOracle)storageDesignOracle.getPackageSet().getByName(packageName);
            if (packageOracle == null) {
                packageOracle = (PackageOracle)storageDesignOracle.getPackageSet().createElement(null);
                if (ownerName != null) {
                    UserOracle owner = (UserOracle)storageDesignOracle.getUserSet().getByName(ownerName);
                    if (owner == null && ownerName.trim().length() > 0) {
                        owner = storageDesignOracle.getUserSet().createUser();
                        owner.setName(ownerName);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    packageOracle.setOwner(owner);
                }
                packageOracle.setName(packageName);
                this.design.getRelationalDesign().stampModelObjectDDL(packageOracle);
            }
            packageOracle.setBodySource(this.extractSource(line));
        }
    }
}

