/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreatePartitionSchemeSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreatePartitionSchemeSqlServerv2k5.class);
    private StorageDesignSqlServerv2k5 storageDesign;

    public SHCreatePartitionSchemeSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreatePartitionSchemeSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create partition scheme")) {
            try {
                this.parseScheme(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreatePartitionSchemeSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseScheme(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            String name = Token.getTokenAfter(statement, "SCHEME");
            statement = Token.cutTokenFromFront(this.statement, name);
            String partFuncionName = Token.getTokenAfter(statement, "PARTITION");
            PartitionFunctionSqlServerv2k5 partfunc = (PartitionFunctionSqlServerv2k5)((DataBaseSqlServerv2k5)this.getCurrentDB()).getPartitionFunction().getByName(partFuncionName);
            if (partfunc != null) {
                PartitionSchemeSqlServerv2k5 partScheme = (PartitionSchemeSqlServerv2k5)this.storageDesign.getPartitionSchemeSet().createPartitionScheme();
                partScheme.setName(name);
                this.design.getRelationalDesign().stampModelObjectDDL(partScheme);
                partScheme.setPartitionFunction(partfunc);
                this.initFileGroup(partScheme, Token.getStringAfter(statement, partFuncionName));
            }
        }
    }

    private void initFileGroup(PartitionSchemeSqlServerv2k5 partScheme, String statement) {
        if (Token.hasToken(statement, "ALL")) {
            partScheme.setMappingType(PartitionSchemeSqlServer.getMapTypeChoices()[1]);
        }
        String fileGroups = Token.getValBetweenBrackets(statement);
        String[] st = fileGroups.split(",");
        PartitionFunctionSqlServerv2k5 partFunc = (PartitionFunctionSqlServerv2k5)partScheme.getPartitionFunction();
        for (int i = 0; i < st.length; ++i) {
            String name = st[i];
            FileGroupSqlServerv2k5 fileGroup = (FileGroupSqlServerv2k5)this.getCurrentDB().getFilegroups().getByName(name);
            if (2 * i <= partFunc.getBValuesSet().size() - 2) {
                String boundaryValue = (String)partFunc.getBValuesSet().get(2 * i);
                partScheme.setMappingTable(boundaryValue);
            } else {
                partScheme.setMappingTable("MAXVALUE");
            }
            if (fileGroup != null) {
                partScheme.setMappingTable(fileGroup.getName());
                partScheme.setSingleFileGroup(fileGroup);
                continue;
            }
            partScheme.setMappingTable("");
        }
    }
}

