/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateBufferPoolUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateBufferPoolUDB.class);

    public SHCreateBufferPoolUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateBufferPoolUDB.clearCR(line);
        if (Token.startsWithString(statement, "create bufferpool")) {
            try {
                this.parseBufferPool(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateBufferPoolUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseBufferPool(String statement) {
        this.statement = statement;
        String bpName = Token.getQuotedNameAfterToken(this.statement, "BUFFERPOOL").trim();
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        BufferPoolUDB bp = storageDesign.getBufferPoolSet().createBufferPool();
        if (bp != null) {
            bp.setName(bpName);
            this.design.getRelationalDesign().stampModelObjectDDL(bp);
            String scope = Token.getTokenAfter(this.statement, bpName).trim();
            if (scope.equalsIgnoreCase("NODEGROUP")) {
                String part = this.statement;
                while (!Token.getFirstToken(part).equalsIgnoreCase("NODEGROUP")) {
                    part = Token.cutFirstToken(part);
                }
                part = Token.cutFirstToken(part);
                StringBuffer nodeGroup = new StringBuffer();
                while (!Token.getFirstToken(part).equalsIgnoreCase("SIZE")) {
                    nodeGroup.append(Token.getFirstToken(part));
                    part = Token.cutFirstToken(part);
                }
                String nodes = nodeGroup.toString().trim();
                bp.setScope(nodes);
            }
            this.initSize(bp);
            this.initPageSize(bp);
            this.initExtendedStorage(bp);
        }
    }

    private void initSize(BufferPoolUDB bp) {
        if (Token.hasToken(this.statement, "SIZE")) {
            try {
                int size = Integer.parseInt(Token.getTokenAfter(this.statement, "SIZE"));
                bp.setSize(size);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateBufferPoolUDB.initSize: " + e.getMessage());
            }
            if (Token.hasToken(this.statement, "EXCEPT") && Token.hasCloseAndOpenBrackets(this.statement)) {
                String nodes = Token.getValBetweenBrackets(this.statement).trim();
                bp.setNodesWithDiffSize(nodes);
            }
        }
    }

    private void initPageSize(BufferPoolUDB bp) {
        if (Token.hasToken(this.statement, "PAGESIZE")) {
            try {
                int pageSize = Integer.parseInt(Token.getTokenAfter(this.statement, "PAGESIZE"));
                if (!Token.getTokenAfter(this.statement, "" + pageSize).equalsIgnoreCase("K")) {
                    pageSize /= 1024;
                }
                bp.setPageSize(pageSize);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PAGESIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateBufferPoolUDB.initPageSize : " + e.getMessage());
            }
        }
    }

    private void initExtendedStorage(BufferPoolUDB bp) {
        if (this.statement.toUpperCase().indexOf("EXTENDED STORAGE") > -1 && this.statement.toUpperCase().indexOf("NOT EXTENDED STORAGE") == -1) {
            bp.setExtendedStorage(true);
        }
    }
}

