/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateMethodUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateMethodUDB.class);

    public SHCreateMethodUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateMethodUDB.clearCR(line);
        if (Token.startsWithString(statement, "create method") || Token.startsWithString(statement, "create specific method")) {
            try {
                this.parseCreateMethod(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateMethodUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseCreateMethod(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB stoDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            String name = Token.getNameAfterToken(this.statement, "METHOD", '\"', '\"').trim();
            if (!"SPECIFIC".equalsIgnoreCase(Token.getTokenAfter(statement, "CREATE").trim())) {
                StructuredType structuredType;
                String stName = Token.getNameAfterToken(this.statement, "FOR", '\"', '\"').trim();
                int posPoint = stName.indexOf(46);
                if (posPoint > 0) {
                    stName = Token.getValAfterCharacter(stName, '.');
                }
                if ((structuredType = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(stName)) != null) {
                    Method method = structuredType.getMethodByName(name);
                    if (method != null) {
                        MethodProxyUDB methodProxy = (MethodProxyUDB)stoDesign.getMethodProxySet().getByName(name);
                        this.initExternalName(methodProxy);
                        this.initTransformGroup(methodProxy);
                        this.initReturn(methodProxy);
                    } else {
                        LOGGER.error("Unable to find required Method: " + name);
                    }
                } else {
                    LOGGER.error("Unable to find required Structured Type: " + stName);
                }
            }
        }
    }

    private void initExternalName(MethodProxyUDB methodProxy) {
        String temp;
        if (Token.hasToken(this.statement, "EXTERNAL") && "NAME".equalsIgnoreCase(Token.getFirstToken(temp = Token.getStringAfterToken(this.statement, "EXTERNAL").trim()).trim())) {
            String extName = Token.getToken(temp, 2).trim();
            methodProxy.setExt_R_Name(extName);
        }
    }

    private void initTransformGroup(MethodProxyUDB methodProxy) {
        if (Token.hasString(this.statement, "TRANSFORM GROUP")) {
            String temp = Token.getStringAfter(this.statement, "TRANSFORM GROUP").trim();
            String transformGroup = Token.getFirstToken(temp).trim();
            methodProxy.setExt_R_TransformGroup(transformGroup);
        }
    }

    private void initReturn(MethodProxyUDB methodProxy) {
        if (Token.hasToken(this.statement, "RETURN")) {
            String body = Token.getStringAfterToken(this.statement, "RETURN").trim();
            methodProxy.setSqlMethodBody(body);
        }
    }
}

