/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;

public class SHGrantUDB
extends DDLStatementHandler {
    private PermissionsUDB permissions;
    private StorageDesignUDB storageDesign;
    private TableProxyUDB table = null;
    private TableViewProxyUDB view = null;

    public SHGrantUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHGrantUDB.clearCR(line);
        if (Token.startsWithString(statement, "grant use of tablespace")) {
            try {
                this.parseGrantUseOf(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHGrantUDB.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "grant control on index")) {
            try {
                this.parseGrantControl(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHGrantUDB.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "grant") && (Token.hasToken(statement, "ALTERIN") || Token.hasToken(statement, "CREATEIN") || Token.hasToken(statement, "DROPIN"))) {
            try {
                this.parseSchemaPrivileges(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHGrantUDB.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "grant") && Token.hasToken(statement, "ON") && Token.hasToken(statement, "TO")) {
            try {
                this.grantPermissions(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHGrantUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseGrantUseOf(String statement) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        String ts = Token.getStringAfterToken(statement, "TABLESPACE");
        ts = Token.getStringBeforeToken(ts, "TO");
        String users = Token.getStringAfterToken(statement, "TO");
        boolean grantOption = false;
        if (Token.hasToken(users, "GRANT")) {
            users = Token.getStringBeforeToken(users, "WITH");
            grantOption = true;
        }
        TableSpaceUDB tablespace = (TableSpaceUDB)storageDesign.getTableSpaceSet().getByName(ts);
        StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
        while (usersTokenizer.hasMoreTokens()) {
            OwnerUDB owner;
            String user = usersTokenizer.nextToken().trim();
            if (user.toUpperCase().startsWith("USER")) {
                user = Token.cutFirstToken(user).trim();
                if (storageDesign.getOwnerSet().getByName(user) == null) {
                    owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                    owner.setName(user);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                tablespace.setUsers(user);
                continue;
            }
            if (user.toUpperCase().startsWith("PUBLIC")) {
                if (storageDesign.getOwnerSet().getByName(user) == null) {
                    owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                    owner.setName(user);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                tablespace.setUsers(user);
                continue;
            }
            if (user.toUpperCase().startsWith("GROUP")) {
                user = Token.cutFirstToken(user).trim();
                if (storageDesign.getUserGroupSet().getByName(user) == null) {
                    UserGroupUDB group = storageDesign.getUserGroupSet().createUserGroup();
                    group.setName(user);
                }
                tablespace.setGroups(user);
                continue;
            }
            if (storageDesign.getOwnerSet().getByName(user) == null) {
                owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                owner.setName(user);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            tablespace.setUsers(user);
        }
        if (grantOption) {
            tablespace.setGrantOption("YES");
        }
    }

    private void parseGrantControl(String statement) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        String ind = Token.getStringAfterToken(statement, "INDEX");
        ind = Token.getStringBeforeToken(ind, "TO");
        String users = Token.getStringAfter(statement, "TO");
        IndexProxyUDB index = (IndexProxyUDB)storageDesign.getIndexProxySet().getByName(ind);
        StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
        while (usersTokenizer.hasMoreTokens()) {
            OwnerUDB owner;
            String user = usersTokenizer.nextToken().trim();
            if (user.toUpperCase().startsWith("USER")) {
                user = Token.cutFirstToken(user).trim();
                if (storageDesign.getOwnerSet().getByName(user) == null) {
                    owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                    owner.setName(user);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                index.setUsers(user);
                continue;
            }
            if (user.toUpperCase().startsWith("PUBLIC")) {
                if (storageDesign.getOwnerSet().getByName(user) == null) {
                    owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                    owner.setName(user);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                index.setUsers(user);
                continue;
            }
            if (user.toUpperCase().startsWith("GROUP")) {
                user = Token.cutFirstToken(user).trim();
                if (storageDesign.getUserGroupSet().getByName(user) == null) {
                    UserGroupUDB group = storageDesign.getUserGroupSet().createUserGroup();
                    group.setName(user);
                }
                index.setGroups(user);
                continue;
            }
            if (storageDesign.getOwnerSet().getByName(user) == null) {
                owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                owner.setName(user);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            index.setUsers(user);
        }
    }

    private void parseSchemaPrivileges(String statement) {
        String privileges = Token.getStringAfterToken(statement, "GRANT");
        privileges = Token.getStringBeforeToken(privileges, "ON");
        String schema = Token.getStringAfterToken(statement, "SCHEMA");
        schema = Token.getStringBeforeToken(schema, "TO");
        String users = Token.getStringAfterToken(statement, "TO");
        boolean grantOption = false;
        if (Token.hasToken(users, "GRANT")) {
            users = Token.getStringBeforeToken(users, "WITH");
            grantOption = true;
        }
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        StringTokenizer tokenizer = new StringTokenizer(schema, ",");
        while (tokenizer.hasMoreTokens()) {
            String schemaName = tokenizer.nextToken();
            SchemaUDB s = (SchemaUDB)storageDesign.getSchemaSet().getByName(schemaName);
            StringTokenizer usersTokenizer = new StringTokenizer(users, ",");
            while (usersTokenizer.hasMoreTokens()) {
                StringTokenizer privTokenizer;
                PrivilegesUDB priv;
                OwnerUDB owner;
                String user = usersTokenizer.nextToken().trim();
                if (user.toUpperCase().startsWith("USER")) {
                    user = Token.cutFirstToken(user).trim();
                    if (storageDesign.getOwnerSet().getByName(user) == null) {
                        owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                        owner.setName(user);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    } else {
                        owner = (OwnerUDB)storageDesign.getOwnerSet().getByName(user);
                    }
                    priv = this.getPrivileges(s, user);
                    priv.setUser(owner);
                    privTokenizer = new StringTokenizer(privileges, ",");
                    while (privTokenizer.hasMoreTokens()) {
                        priv.setSystemPrivileges(privTokenizer.nextToken().trim());
                    }
                    if (!grantOption) continue;
                    priv.setGrantOption("YES");
                    continue;
                }
                if (user.toUpperCase().startsWith("PUBLIC")) {
                    if (storageDesign.getOwnerSet().getByName(user) == null) {
                        owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                        owner.setName(user);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    } else {
                        owner = (OwnerUDB)storageDesign.getOwnerSet().getByName(user);
                    }
                    priv = this.getPrivileges(s, user);
                    priv.setUser(owner);
                    privTokenizer = new StringTokenizer(privileges, ",");
                    while (privTokenizer.hasMoreTokens()) {
                        priv.setSystemPrivileges(privTokenizer.nextToken().trim());
                    }
                    if (!grantOption) continue;
                    priv.setGrantOption("YES");
                    continue;
                }
                if (user.toUpperCase().startsWith("GROUP")) {
                    UserGroupUDB group;
                    user = Token.cutFirstToken(user).trim();
                    if (storageDesign.getUserGroupSet().getByName(user) == null) {
                        group = storageDesign.getUserGroupSet().createUserGroup();
                        group.setName(user);
                    } else {
                        group = (UserGroupUDB)storageDesign.getUserGroupSet().getByName(user);
                    }
                    priv = this.getPrivileges(s, user);
                    priv.setGroup(group);
                    privTokenizer = new StringTokenizer(privileges, ",");
                    while (privTokenizer.hasMoreTokens()) {
                        priv.setSystemPrivileges(privTokenizer.nextToken().trim());
                    }
                    if (!grantOption) continue;
                    priv.setGrantOption("YES");
                    continue;
                }
                if (storageDesign.getOwnerSet().getByName(user) == null) {
                    owner = (OwnerUDB)storageDesign.getOwnerSet().createElement(null);
                    owner.setName(user);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                } else {
                    owner = (OwnerUDB)storageDesign.getOwnerSet().getByName(user);
                }
                priv = this.getPrivileges(s, user);
                priv.setUser(owner);
                privTokenizer = new StringTokenizer(privileges, ",");
                while (privTokenizer.hasMoreTokens()) {
                    priv.setSystemPrivileges(privTokenizer.nextToken().trim());
                }
                if (!grantOption) continue;
                priv.setGrantOption("YES");
            }
        }
    }

    private PrivilegesUDB getPrivileges(SchemaUDB schema, Object user) {
        PrivilegesUDB priv2;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        for (PrivilegesUDB priv2 : storageDesign.getPrivilegesSet()) {
            if (priv2.getSchema() != schema || priv2.getUser() != user && priv2.getGroup() != user) continue;
            return priv2;
        }
        priv2 = storageDesign.getPrivilegesSet().createPriv();
        priv2.setSchema(schema);
        return priv2;
    }

    private void grantPermissions(String statement) {
        this.statement = statement.replaceAll("\"", "");
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            ArrayList users = this.initUsersAndRoles();
            RelationalObjectProxy proxy = this.initOn();
            if (proxy != null) {
                for (int i = 0; i < users.size(); ++i) {
                    this.permissions = this.getPermissionForUser((StorageObject)users.get(i), proxy) != null ? this.getPermissionForUser((StorageObject)users.get(i), proxy) : this.storageDesign.getPermissionsSet().createPermissions();
                    if (this.permissions == null) continue;
                    this.initPrivileges();
                    this.initOnObject(proxy);
                    this.initTo(users.get(i));
                }
            }
        }
    }

    private PermissionsUDB getPermissionForUser(StorageObject user, RelationalObjectProxy proxy) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        PermissionsUDB perm = null;
        while (it.hasNext()) {
            perm = (PermissionsUDB)it.next();
            if (perm.getUser() != user && perm.getGroup() != user || perm.getTable() != proxy && perm.getView() != proxy) continue;
            return perm;
        }
        return null;
    }

    private ArrayList initUsersAndRoles() {
        ArrayList<StorageObject> list = new ArrayList<StorageObject>();
        String to = Token.getStringAfter(this.statement, "TO").trim();
        if (Token.hasToken(to, "WITH")) {
            to = Token.getStringBeforeToken(to, "WITH");
        }
        if (!to.equalsIgnoreCase("")) {
            StringTokenizer tokenizer = new StringTokenizer(to, ",");
            String userOrGroup = null;
            while (tokenizer.hasMoreTokens()) {
                OwnerUDB owner;
                userOrGroup = tokenizer.nextToken().trim();
                if (userOrGroup.toUpperCase().startsWith("USER")) {
                    userOrGroup = Token.cutFirstToken(userOrGroup).trim();
                    if (this.storageDesign.getOwnerSet().getByName(userOrGroup) == null) {
                        owner = (OwnerUDB)this.storageDesign.getOwnerSet().createElement(null);
                        owner.setName(userOrGroup);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    } else {
                        owner = (OwnerUDB)this.storageDesign.getOwnerSet().getByName(userOrGroup);
                    }
                    list.add(owner);
                    continue;
                }
                if (userOrGroup.toUpperCase().startsWith("GROUP")) {
                    UserGroupUDB group;
                    userOrGroup = Token.cutFirstToken(userOrGroup).trim();
                    if (this.storageDesign.getUserGroupSet().getByName(userOrGroup) == null) {
                        group = (UserGroupUDB)this.storageDesign.getUserGroupSet().createElement(null);
                        group.setName(userOrGroup);
                        this.design.getRelationalDesign().stampModelObjectDDL(group);
                    } else {
                        group = (UserGroupUDB)this.storageDesign.getUserGroupSet().getByName(userOrGroup);
                    }
                    list.add(group);
                    continue;
                }
                if (userOrGroup.toUpperCase().startsWith("PUBLIC")) {
                    if (this.storageDesign.getOwnerSet().getByName(userOrGroup) == null) {
                        owner = (OwnerUDB)this.storageDesign.getOwnerSet().createElement(null);
                        owner.setName(userOrGroup);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    } else {
                        owner = (OwnerUDB)this.storageDesign.getOwnerSet().getByName(userOrGroup);
                    }
                    list.add(owner);
                    continue;
                }
                if (this.storageDesign.getOwnerSet().getByName(userOrGroup) == null) {
                    owner = (OwnerUDB)this.storageDesign.getOwnerSet().createElement(null);
                    owner.setName(userOrGroup);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                } else {
                    owner = (OwnerUDB)this.storageDesign.getOwnerSet().getByName(userOrGroup);
                }
                list.add(owner);
            }
        }
        return list;
    }

    private void initPrivileges() {
        StringTokenizer tokenizer;
        String priv = Token.getStringAfter(this.statement.toUpperCase(), "GRANT").trim();
        if (Token.hasCloseAndOpenBrackets(priv = Token.getStringBeforeToken(priv, "ON"))) {
            String columns = Token.getValBetweenBrackets(priv).trim();
            priv = Token.getStringBefore(priv, "(").trim();
            this.initColumns(columns, priv);
        }
        if (this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1) {
            tokenizer = new StringTokenizer(priv, ",");
            String pr = null;
            while (tokenizer.hasMoreTokens()) {
                pr = tokenizer.nextToken().trim();
                this.permissions.setPrivilegesWithGrantOption(pr);
            }
        } else {
            tokenizer = new StringTokenizer(priv, ",");
            String pr = null;
            while (tokenizer.hasMoreTokens()) {
                pr = tokenizer.nextToken().trim();
                this.permissions.setPrivileges(pr);
            }
        }
    }

    private void initColumns(String columns, String priv) {
        StringTokenizer tokenizer = new StringTokenizer(columns, ",");
        String column = null;
        while (tokenizer.hasMoreTokens()) {
            column = tokenizer.nextToken().trim();
            if (column.equalsIgnoreCase("") || this.table == null || this.table.getColumn(column) == null) continue;
            column = column + ", " + priv;
            this.permissions.setColumnList(column);
        }
    }

    private RelationalObjectProxy initOn() {
        String on = Token.getStringAfterToken(this.statement, "ON").trim();
        if (!(on = Token.getStringBeforeToken(on, "TO")).equalsIgnoreCase("")) {
            this.table = ((TableProxySetUDB)this.storageDesign.getTableProxySet()).getByName(on);
            if (this.table != null) {
                return this.table;
            }
            this.view = ((TableViewProxySetUDB)this.storageDesign.getTableViewProxySet()).getByName(on);
            if (this.view != null) {
                return this.view;
            }
        }
        this.importLog.addError("Error in setting object of permission " + this.statement);
        return null;
    }

    private void initOnObject(RelationalObjectProxy proxy) {
        if (proxy instanceof TableProxyUDB) {
            this.permissions.setTable((TableProxyUDB)proxy);
        } else if (proxy instanceof TableViewProxyUDB) {
            this.permissions.setView((TableViewProxyUDB)proxy);
        }
    }

    private void initTo(Object object) {
        String to = Token.getStringAfter(this.statement.toUpperCase(), "TO").trim();
        if (Token.hasToken(to, "WITH")) {
            to = Token.getStringBeforeToken(to, "WITH");
        }
        if (!to.equalsIgnoreCase("")) {
            if (object instanceof OwnerUDB) {
                this.permissions.setUser((OwnerUDB)object);
            } else if (object instanceof UserGroupUDB) {
                this.permissions.setGroup((UserGroupUDB)object);
            }
        } else {
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }
}

