/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.ODConstants;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractObjectHandler
implements ODConstants {
    private static final Logger LOGGER = new Logger(AbstractObjectHandler.class);
    protected ODExtractionHandler odExtractionHandler;
    protected ApplicationView view;
    private Design design;
    private List<UserDefinedProperty> udpList;
    PreparedStatement udp_statement = null;
    static PreparedStatement do_statement;
    static PreparedStatement sto_statement;
    static PreparedStatement dbsyn_statement;
    static PreparedStatement txt_statement;
    static PreparedStatement txtnv_statement;

    public AbstractObjectHandler(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        this.odExtractionHandler = odExtractionHandler;
        this.view = view;
        this.design = view.getCurrentDesign();
    }

    public abstract String getType();

    public abstract void generate(Connection var1, List var2, ImportLogger var3) throws Exception;

    public List extract(Connection sqlConnection, List appSystems) throws Exception {
        return new ArrayList();
    }

    public Design getDesign() {
        return this.design;
    }

    public StorageDesign getStorageDesign() {
        return this.getDesign().getRelationalDesign().getStorageDesign();
    }

    public ApplicationView getView() {
        return this.view;
    }

    public String getSQLDataType(short type) {
        switch (type) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case -8: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "IMAGE";
            }
            case -1: {
                return "LONG alphabetic";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case -9: {
                return "VARCHAR";
            }
        }
        return null;
    }

    public String getColumn(ResultSet resultSet, String column) {
        String result = null;
        if (resultSet != null) {
            try {
                result = resultSet.getString(column);
            }
            catch (Exception e) {
                System.out.println("Column does not exist: " + column);
            }
        }
        return result;
    }

    public boolean getColumn(ResultSet resultSet, String column, boolean defaultValue) {
        boolean result = defaultValue;
        if (resultSet != null) {
            try {
                result = resultSet.getBoolean(column);
            }
            catch (Exception e) {
                System.out.println("Column does not exist: " + column);
            }
        }
        return result;
    }

    public int getColumn(ResultSet resultSet, String column, int defaultValue) {
        int result = defaultValue;
        if (resultSet != null) {
            try {
                result = resultSet.getInt(column);
            }
            catch (Exception e) {
                System.out.println("Column does not exist: " + column);
            }
        }
        return result;
    }

    protected void dumpResultSet(ResultSet rs) {
        try {
            while (rs.next()) {
                System.out.println("-----------------------------------------------");
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    System.out.println(rsmd.getColumnName(i) + " : " + rsmd.getColumnTypeName(i) + " = " + rs.getString(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void dumpBuffer(StringBuffer buffer) {
        System.out.println(buffer.toString());
    }

    public ODExtractionHandler getExtractionHandler() {
        return this.odExtractionHandler;
    }

    protected void setNotesAndComments(Connection sqlConnection, StorageObject storageObject, String id) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_type").append(',');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TXT_REF").append('=').append(id).append(' ');
            buffer.append(" order by txt_type, txt_seq");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String text;
                String txtType = rs.getString("txt_type");
                String txtText = rs.getString("txt_text");
                if ("CDINOT".equalsIgnoreCase(txtType)) {
                    text = storageObject.getNotes();
                    if (text == null || "".equalsIgnoreCase(text)) {
                        storageObject.setNotes(txtText);
                        continue;
                    }
                    storageObject.setNotes(text + txtText);
                    continue;
                }
                if (!"CDIDSC".equalsIgnoreCase(txtType)) continue;
                text = storageObject.getComment();
                if (text == null || "".equalsIgnoreCase(text)) {
                    storageObject.setComment(txtText);
                    continue;
                }
                storageObject.setComment(text + txtText);
            }
            rs.close();
        }
        statement.close();
    }

    protected void setNotesAndComments(Connection sqlConnection, StorageObject storageObject, String id, String ivid) throws Exception {
        if (sto_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_type").append(',');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TXT_REF").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append(" and txt_type in ('CDIDSC','CDINOT')");
            buffer.append(" order by txt_type, txt_seq");
            sto_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            sto_statement.setString(1, id);
            sto_statement.setString(2, ivid);
            rs = sto_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String text;
                String txtType = rs.getString("txt_type");
                String txtText = rs.getString("txt_text");
                if ("CDINOT".equalsIgnoreCase(txtType)) {
                    text = storageObject.getNotes();
                    if (text == null || "".equalsIgnoreCase(text)) {
                        storageObject.setNotes(txtText);
                        continue;
                    }
                    storageObject.setNotes(text + txtText);
                    continue;
                }
                if (!"CDIDSC".equalsIgnoreCase(txtType)) continue;
                text = storageObject.getComment();
                if (text == null || "".equalsIgnoreCase(text)) {
                    storageObject.setComment(txtText);
                    continue;
                }
                storageObject.setComment(text + txtText);
            }
            rs.close();
        }
    }

    protected void setNotesAndComments(Connection sqlConnection, DesignObject designObject, String id) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_type").append(',');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TXT_REF").append('=').append(id).append(' ');
            buffer.append(" order by txt_type, txt_seq");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String text;
                String txtType = rs.getString("txt_type");
                String txtText = rs.getString("txt_text");
                if ("CDIDSC".equalsIgnoreCase(txtType)) {
                    text = designObject.getComment();
                    if (text == null || "".equals(text)) {
                        designObject.setComment(txtText);
                        continue;
                    }
                    designObject.setComment(text + txtText);
                    continue;
                }
                if (!"CDINOT".equalsIgnoreCase(txtType)) continue;
                text = designObject.getNotes();
                if (text == null || "".equals(text)) {
                    designObject.setNotes(txtText);
                    continue;
                }
                designObject.setNotes(text + txtText);
            }
            rs.close();
        }
        statement.close();
    }

    protected void setNotesAndComments(Connection sqlConnection, DesignObject designObject, String id, String ivid) throws Exception {
        this.setNotesAndComments(sqlConnection, designObject, id, ivid, false);
    }

    protected void setNotesAndComments(Connection sqlConnection, DesignObject designObject, String id, String ivid, boolean constraint) throws Exception {
        if (constraint && !(designObject instanceof ContainedObject)) {
            return;
        }
        if (do_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_type").append(',');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TXT_REF").append('=').append(" ? ");
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append(" and txt_type in ('CDIDSC','CDINOT')");
            buffer.append(" order by txt_type, txt_seq");
            String sql = buffer.toString();
            do_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            do_statement.setString(1, id);
            do_statement.setString(2, ivid);
            rs = do_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", e);
        }
        if (rs != null) {
            String notes = "";
            String comments = "";
            while (rs.next()) {
                String txtType = rs.getString("txt_type");
                String txtText = rs.getString("txt_text");
                if ("CDIDSC".equalsIgnoreCase(txtType)) {
                    if ("".equalsIgnoreCase(comments)) {
                        comments = txtText;
                        continue;
                    }
                    comments = comments + txtText;
                    continue;
                }
                if (!"CDINOT".equalsIgnoreCase(txtType)) continue;
                if ("".equalsIgnoreCase(notes)) {
                    designObject.setNotes(txtText);
                    notes = txtText;
                    continue;
                }
                notes = notes + txtText;
            }
            if (constraint) {
                String conComments = ((ContainedObject)designObject).getConstraintComment();
                String conNotes = ((ContainedObject)designObject).getConstraintNotes();
                String sepComments = !"".equals(conComments) ? "\n" : "";
                String sepNotes = !"".equals(conNotes) ? "\n" : "";
                ((ContainedObject)designObject).setConstraintComment(conComments + sepComments + comments);
                ((ContainedObject)designObject).setConstraintNotes(conNotes + sepNotes + notes);
            } else {
                designObject.setComment(comments);
                designObject.setNotes(notes);
            }
            rs.close();
        }
    }

    protected String getFromTextLines(Connection sqlConnection, String txt_type, String id) throws Exception {
        if (txtnv_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_type").append(',');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TXT_REF").append('=').append(" ? ");
            buffer.append(" and txt_type = ? ");
            buffer.append(" order by txt_type, txt_seq");
            txtnv_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        String result = "";
        ResultSet rs = null;
        try {
            txtnv_statement.setString(1, id);
            txtnv_statement.setString(2, txt_type);
            rs = txtnv_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String txtText = rs.getString("txt_text");
                result = result + txtText;
            }
            rs.close();
        }
        return result;
    }

    protected String getFromTextLines(Connection sqlConnection, String txt_type, String id, String ivid) throws Exception {
        if (txt_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_type").append(',');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TXT_REF").append('=').append(" ? ");
            buffer.append("and parent_ivid").append('=').append(" ? ");
            buffer.append(" and txt_type = ? ");
            buffer.append(" order by txt_type, txt_seq");
            txt_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        String result = "";
        ResultSet rs = null;
        try {
            txt_statement.setString(1, id);
            txt_statement.setString(2, ivid);
            txt_statement.setString(3, txt_type);
            rs = txt_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("AbstractObjectHandler.setNotesAndComments():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String txtText = rs.getString("txt_text");
                result = result + txtText;
            }
            rs.close();
        }
        return result;
    }

    public void createDBSynonyms(Connection sqlConnection, String object_name, String parent_ivid) throws Exception {
        if (dbsyn_statement == null) {
            String query = "select name,id,ivid,scope from ci_database_synonyms where parent_ivid = ?";
            dbsyn_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            dbsyn_statement.setString(1, parent_ivid);
            rs = dbsyn_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("AbstractObjectHandler.createSynonyms():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String sid = rs.getString("ID");
                String scope = rs.getString(4);
                if (name == null || "".equals(name)) continue;
                SynonymOracle synonym = ((StorageDesignOracle)this.getStorageDesign()).getSynonymSet().createSynonym();
                synonym.setName(name);
                synonym.setObject(object_name);
                if ("PUBLIC".equalsIgnoreCase(scope)) {
                    synonym.setPublic("YES");
                }
                this.setNotesAndComments(sqlConnection, synonym, sid, parent_ivid);
            }
            rs.close();
        }
    }

    public static void clearStatements() {
        do_statement = null;
        sto_statement = null;
        dbsyn_statement = null;
        txt_statement = null;
        txtnv_statement = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeStatements() {
        if (do_statement != null) {
            try {
                do_statement.close();
            }
            catch (SQLException e) {
            }
            finally {
                do_statement = null;
            }
        }
        if (sto_statement != null) {
            try {
                sto_statement.close();
            }
            catch (SQLException e) {
            }
            finally {
                sto_statement = null;
            }
        }
        if (dbsyn_statement != null) {
            try {
                dbsyn_statement.close();
            }
            catch (SQLException e) {
            }
            finally {
                dbsyn_statement = null;
            }
        }
        if (txt_statement != null) {
            try {
                txt_statement.close();
            }
            catch (SQLException e) {
            }
            finally {
                txt_statement = null;
            }
        }
        if (txtnv_statement != null) {
            try {
                txtnv_statement.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                txtnv_statement = null;
            }
        }
    }

    public List<Des_UDP_Descriptor> getUDP_Descriptors(Connection sqlConnection, String objectType) {
        ArrayList<Des_UDP_Descriptor> list = new ArrayList<Des_UDP_Descriptor>();
        try {
            if (this.udp_statement == null || this.udp_statement.isClosed()) {
                String sql = "select ELEMENT_TYPE_NAME,   NAME as COLUMN_NAME,   DISPLAY_NAME,   DISPLAY_DATATYPE,   DISPLAY_LENGTH,   DISPLAY_PRECISION,   DISPLAY_SCALE from ciue_properties where ELEMENT_TYPE_NAME = ?   and is_extended='Y'   and is_published = 'Y'";
                this.udp_statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                this.udp_statement.setString(1, objectType);
                rs = this.udp_statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOTable.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    Des_UDP_Descriptor des = new Des_UDP_Descriptor();
                    des.columnName = rs.getString(2);
                    des.udpName = rs.getString(3);
                    des.dataType = rs.getString(4);
                    des.size = rs.getString(5);
                    des.precision = rs.getString(6);
                    des.scale = rs.getString(7);
                    list.add(des);
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public String getUDP_SQL_columns(List<Des_UDP_Descriptor> list, String prefix) {
        String res = "";
        for (Des_UDP_Descriptor d : list) {
            if ("".equals(prefix)) {
                res = res + ", " + d.columnName + " ";
                continue;
            }
            res = res + ", " + prefix + "." + d.columnName + " ";
        }
        return res;
    }

    public void createDynamicProperties(ModelIDObject obj, List<Des_UDP_Descriptor> list, ResultSet rs) {
        for (Des_UDP_Descriptor d : list) {
            try {
                String value = rs.getString(d.columnName);
                if (value == null) continue;
                if (d.dataType.equals("DATE")) {
                    try {
                        String v;
                        value = v = value.substring(0, 4) + "-" + value.substring(4, 6) + "-" + value.substring(6, 8);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                obj.setProperty(d.udpName, value);
            }
            catch (SQLException e) {
                e.printStackTrace();
                LOGGER.error("Error in getting UDP for " + obj.getName() + "\n", e);
            }
        }
    }

    public void clearUDP_Statement() {
        try {
            if (this.udp_statement != null) {
                this.udp_statement.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List getUdpList() {
        if (this.udpList == null) {
            this.udpList = new ArrayList<UserDefinedProperty>();
        }
        return this.udpList;
    }

    public static class Des_UDP_Descriptor {
        public String columnName;
        public String udpName;
        public String dataType;
        public String size;
        public String precision;
        public String scale;
    }
}

