/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.Logger;

public class RHForeignKey
extends RowHandler {
    public static final String OBJECT_TYPE = "FOREIGN_KEY";
    public static final String OBJECT_TYPE_COOL = "FOREIGN_KEYS";
    public List lines = new ArrayList();
    private static final Logger LOGGER = new Logger(RHForeignKey.class);

    public RHForeignKey(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(line);
            this.addForeignKeyLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        list.add(OBJECT_TYPE_COOL);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.collectLines(line);
            this.createForeignKey(line, hasMapping);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void collectLines(VarFileLine line) {
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool != 1000 && !this.lines.contains(line)) {
            this.lines.add(line);
        }
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    private void createForeignKey(VarFileLine line, boolean hasMapping) {
        Table table = (Table)this.getCreatedObject(this.getField(line, "foreignkey_table_id"));
        Index index = (Index)this.getCreatedObject(this.getField(line, "foreignkey_primarykey_id"));
        if (!hasMapping) {
            String columnSetKey = null;
            int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
            columnSetKey = testCool == 1000 ? this.getField(line, "FOREIGNKEY_COLUMNSET") : this.getField(line, "FOREIGNKEY_COLJCT5");
            if (table != null && index != null) {
                FKIndexAssociation fkass = table.addFK(index, null, null);
                fkass.setName(this.getField(line, "foreignkey_NAME"));
                this.fillElements(line, fkass, table);
                this.processFKColumns(fkass, columnSetKey);
                if (fkass.getTopView() == null) {
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fkass);
                }
                if (fkass.getRemoteTable().getTopView() == null) {
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fkass.getRemoteTable());
                }
                if (fkass.getContainerWithKeyObject().getTopView() == null) {
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fkass.getContainerWithKeyObject());
                }
                fkass.setSourceTVTable((TVTable)fkass.getRemoteTable().getTopView());
                fkass.setTargetTVTable((TVTable)fkass.getContainerWithKeyObject().getTopView());
                this.addCreatedObject(this.getField(line, "general_id"), fkass);
                this.removeSelectedLine(line);
            }
        } else {
            String idFK = this.getField(line, "general_id");
            FKIndexAssociation fkass = (FKIndexAssociation)this.getAllCreatedObjects().get(idFK);
            if (fkass != null) {
                this.fillElements(line, fkass, table);
                this.getDesign().getRelationalDesign().getMainView().createViewFor(fkass);
                this.getDesign().getRelationalDesign().getMainView().createViewFor(fkass.getRemoteTable());
                this.getDesign().getRelationalDesign().getMainView().createViewFor(fkass.getContainerWithKeyObject());
                fkass.setSourceTVTable((TVTable)fkass.getRemoteTable().getTopView());
                fkass.setTargetTVTable((TVTable)fkass.getContainerWithKeyObject().getTopView());
                this.removeSelectedLine(line);
            } else {
                String columnSetKey = null;
                int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
                columnSetKey = testCool == 1000 ? this.getField(line, "FOREIGNKEY_COLUMNSET") : this.getField(line, "FOREIGNKEY_COLJCT5");
                FKIndexAssociationReference reference = (FKIndexAssociationReference)this.getAllReferences().get(columnSetKey);
                if (table != null && index != null && reference != null) {
                    fkass = table.addFK(index, null, reference);
                    fkass.setName(this.getField(line, "foreignkey_NAME"));
                    this.fillElements(line, fkass, table);
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fkass);
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fkass.getRemoteTable());
                    this.getDesign().getRelationalDesign().getMainView().createViewFor(fkass.getContainerWithKeyObject());
                    fkass.setSourceTVTable((TVTable)fkass.getRemoteTable().getTopView());
                    fkass.setTargetTVTable((TVTable)fkass.getContainerWithKeyObject().getTopView());
                    this.addCreatedObject(this.getField(line, "general_id"), fkass);
                    this.removeSelectedLine(line);
                } else {
                    LOGGER.error("FKIndexAssociation is not found in getAllCreatedObjects() for RHForeignKey.createForeignKey()");
                    this.importLog.addError("Foreign key reference i snot found near " + line);
                }
            }
        }
    }

    private void fillCommontOn(VarFileLine line, FKIndexAssociation fkass) {
        String commentKey = this.getField(line, "FOREIGNKEY_text");
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("TEXT") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(commentKey)) continue;
            String comment = this.getField(selectedLine, "text_comment");
            fkass.setComment(comment);
        }
    }

    private void fillDeleteRule(VarFileLine line, FKIndexAssociation fkass) {
        try {
            int deleteRule = Integer.parseInt(this.getField(line, "FOREIGNKEY_DELETE"));
            String[] choises = fkass.getDeleteRuleChoices();
            switch (deleteRule) {
                case 0: {
                    fkass.setDeleteRule(choises[3]);
                    break;
                }
                case 1: {
                    fkass.setDeleteRule(choises[2]);
                    break;
                }
                case 2: {
                    fkass.setDeleteRule(choises[1]);
                    break;
                }
                default: {
                    fkass.setDeleteRule(choises[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in RHForeignKey.fillDeleteRule :");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL DELETE RULE format near " + line);
        }
    }

    protected void fillElements(VarFileLine line, FKIndexAssociation fkass, Table table) {
        KeyObject indexFK = fkass.getLocalFKIndex();
        indexFK.setName(this.getField(line, "foreignkey_NAME"));
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        String objectID = indexFK.getObjectID();
        IndexProxyDB2 indexProxyFK = (IndexProxyDB2)this.getDesign().getStorageDesign(site).getIndexProxySet().getProxy(objectID);
        if (indexProxyFK != null) {
            indexProxyFK.setMarkedGenerate(false);
            this.fillOwner(line, indexProxyFK, table);
        }
        this.fillCommontOn(line, fkass);
        this.fillDeleteRule(line, fkass);
    }

    private void fillOwner(VarFileLine line, IndexProxyDB2 indexProxy, Table table) {
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool == 1000) {
            String ownerName = this.getField(line, "CREATE_BY");
            Owner owner = (Owner)this.getAllCreatedObjects().get(ownerName);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)indexProxy.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(ownerName);
                this.addCreatedObject(ownerName, owner);
            }
            indexProxy.setOwner(owner);
        } else {
            TableProxyDB2 tableProxy = (TableProxyDB2)indexProxy.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            indexProxy.setOwner(tableProxy.getOwner());
        }
    }

    private List getFkColumns(String columnSetKey) {
        TreeMap<Integer, Column> map = new TreeMap<Integer, Column>();
        Integer col_pos = new Integer(3);
        ArrayList<ContainedObject> columns = new ArrayList<ContainedObject>();
        for (VarFileLine line : this.getAllSelectedLines()) {
            String fifth = this.getField(line, "COLJCT_5_KEY").trim();
            if (!line.getType().equalsIgnoreCase("COLJCT") || !fifth.equalsIgnoreCase(columnSetKey)) continue;
            String colId = this.getField(line, "COLJCT_COLUMN_KEY");
            String pos = this.getField(line.getLine(), col_pos);
            int position = Integer.parseInt(pos);
            if (colId == null) continue;
            Column col = (Column)this.getAllCreatedObjects().get(colId);
            map.put(new Integer(position), col);
        }
        for (Integer key : map.keySet()) {
            ContainedObject col = (ContainedObject)map.get(key);
            if (col == null) continue;
            columns.add(col);
        }
        return columns;
    }

    private void processFKColumns(FKIndexAssociation fkass, String columnSetKey) {
        List columns = this.getFkColumns(columnSetKey);
        Column[] pkCols = (Column[])fkass.getKeyObject().getElements();
        if (pkCols.length != columns.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("RHForeignKey different number of columns in PK and FK local table = ").append(fkass.getContainerWithKeyObject().getName()).append(" remote table - > ").append(fkass.getRemoteTable().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        } else {
            Iterator it = columns.iterator();
            KeyObject ind = fkass.getLocalFKIndex();
            for (int k = 0; k < pkCols.length; ++k) {
                Column col = (Column)it.next();
                col.addFKAssociation(pkCols[k], fkass);
                ind.add(col);
            }
        }
    }
}

