/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHFlowDestination;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;
import oracle.dbtools.crest.util.logging.Logger;

public class RHFlowSource
extends RowHandler {
    public static final String OBJECT_TYPE_1 = "PROCESSINFO_FLOW";
    public static final String OBJECT_TYPE_2 = "EXTERNAL_AGENTINFO";
    public static final String OBJECT_TYPE_3 = "INFO_STOREINFO_FLO";
    private static final Logger LOGGER = new Logger(RHFlowSource.class);

    public RHFlowSource(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE_1) || line.getType().equalsIgnoreCase(OBJECT_TYPE_2) || line.getType().equalsIgnoreCase(OBJECT_TYPE_3)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE_1);
        list.add(OBJECT_TYPE_2);
        list.add(OBJECT_TYPE_3);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE_1) || line.getType().equalsIgnoreCase(OBJECT_TYPE_2) || line.getType().equalsIgnoreCase(OBJECT_TYPE_3)) {
            this.setSource(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void setSource(VarFileLine line) {
        try {
            List targets = this.getSpecificRowHandler(RHFlowDestination.class).getOwnLines();
            String objectID = this.getField(line, "SOURCE_OBJECT_ID");
            String flowID = this.getField(line, "SOURCE_FLOW_ID");
            String targetID = "";
            for (int i = 0; i < targets.size(); ++i) {
                VarFileLine selectedLine = (VarFileLine)targets.get(i);
                String id = this.getField(selectedLine, "DESTINATION_FLOW_ID");
                if (!flowID.equalsIgnoreCase(id)) continue;
                targetID = this.getField(selectedLine, "DESTINATION_OBJECT_ID");
                break;
            }
            AbstractProcessObject source = (AbstractProcessObject)this.getAllCreatedObjects().get(objectID);
            AbstractProcessObject target = (AbstractProcessObject)this.getAllCreatedObjects().get(targetID);
            if (source != null && target != null) {
                Flow flow;
                DataFlowDesign dfd = null;
                if (source instanceof Process) {
                    dfd = (DataFlowDesign)source.getDesignPart();
                } else if (target instanceof Process) {
                    dfd = (DataFlowDesign)target.getDesignPart();
                }
                if (dfd != null && (flow = dfd.createFlowsBetween((AbstractDataFlowTV)source.getTopView(), (AbstractDataFlowTV)target.getTopView())) != null) {
                    this.addCreatedObject(flowID, flow);
                }
            }
            this.removeSelectedLine(line);
        }
        catch (Exception e) {
            LOGGER.error("Error in RHFlowSource.setSource()", e);
        }
    }
}

