/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Process;

public class RHProcessEvents
extends RowHandler {
    public static final String OBJECT_TYPE_1 = "PROCESSCLOCK_EVENT";
    public static final String OBJECT_TYPE_2 = "PROCESSPERSON_EVEN";
    public static final String OBJECT_TYPE_3 = "PROCESSSTORAGE_EVE";

    public RHProcessEvents(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE_1) || line.getType().equalsIgnoreCase(OBJECT_TYPE_2) || line.getType().equalsIgnoreCase(OBJECT_TYPE_3)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE_1);
        list.add(OBJECT_TYPE_2);
        list.add(OBJECT_TYPE_3);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE_1) || line.getType().equalsIgnoreCase(OBJECT_TYPE_2) || line.getType().equalsIgnoreCase(OBJECT_TYPE_3)) {
            this.mapEvents(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void mapEvents(VarFileLine line) {
        String processID = this.getField(line, "general_id");
        String eventID = this.getField(line, "DESTINATION_OBJECT_ID");
        Process process = (Process)this.getAllCreatedObjects().get(processID);
        Event event = (Event)this.getAllCreatedObjects().get(eventID);
        if (process != null && event != null) {
            process.addEvent(event);
            event.addProcess(process);
        }
        this.removeSelectedLine(line);
    }
}

