/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import oracle.dbtools.crest.util.GUID;

public class IDGenerator {
    private long counter = 0L;
    private long startCounter = 10000L;
    private long range = 3000000L;
    private StringBuffer buffer = new StringBuffer();

    public void initializeWith(long startCounter, long range) {
        this.startCounter = startCounter;
        this.range = range;
        this.counter = 0L;
    }

    public String createNewID() {
        return new GUID().toString();
    }

    public boolean canCreateNext() {
        return this.counter < this.range;
    }

    public long getStartCounter() {
        return this.startCounter;
    }

    public void setStartCounter(long startCounter) {
        this.startCounter = startCounter;
    }

    public long getCounter() {
        return this.counter;
    }

    public void setCounter(long counter) {
        this.counter = counter;
    }

    public long getLastIDIndex() {
        return this.startCounter + this.counter;
    }

    public String createNewID(String prefix) {
        return this.createNewID(new String[]{prefix});
    }

    public String createNewID(String prefix1, String prefix2, String prefix3) {
        return this.createNewID(new String[]{prefix1, prefix2, prefix3});
    }

    public String createNewID(String[] prefixes) {
        this.buffer.setLength(0);
        for (int i = 0; i < prefixes.length; ++i) {
            this.buffer.append(prefixes[i]);
        }
        this.buffer.append(this.nextNumber());
        String result = this.buffer.toString();
        return result;
    }

    private long nextNumber() {
        if (this.canCreateNext()) {
            ++this.counter;
            return this.startCounter + this.counter;
        }
        throw new RuntimeException("IDGenerator exceeded limit.");
    }
}

