/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class SubsetCO
extends ContainerObject
implements ContainerObjectListener,
LongNameObject {
    private ContainerObject container;
    protected StringBuffer nameBuffer = new StringBuffer();
    private static final Logger LOGGER = new Logger(SubsetCO.class);

    public SubsetCO(DesignPart designPart) {
        super(designPart);
    }

    public void setContainerObject(ContainerObject newContainer) {
        if (this.container != null) {
            this.container.removeContainerListener(this);
            this.container.removeObjectListener(this);
        }
        if (newContainer != null) {
            newContainer.addContainerListener(this);
            newContainer.addObjectListener(this);
        }
        this.container = newContainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(ContainedObject object) {
        if (this.shouldCheckContainer()) {
            if (this.container == null) {
                throw new IllegalStateException(Messages.getString("SubsetCO.0"));
            }
            if (!object.belongsTo(this.container)) throw new IllegalArgumentException(MessageFormat.format(Messages.getString("SubsetCO.TryingToAddElement"), this.getClass(), this.container.getLongName(), object.getLongName()));
            super.add(object);
            return;
        } else {
            super.add(object);
        }
    }

    protected boolean shouldCheckContainer() {
        return true;
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
        if (event.isType(1)) {
            this.remove((ContainedObject)event.getElement());
        }
    }

    @Override
    public Class getContainedClass() {
        if (this.getContainerObject() == null) {
            LOGGER.error("SubsetCO container null in: " + this.getClass());
            LOGGER.error("\tdo not use container.remove(subset) but subset.remove()");
            return ContainedObject.class;
        }
        return this.getContainerObject().getContainedClass();
    }

    @Override
    public String getLongName() {
        this.nameBuffer.setLength(0);
        if (this.container != null) {
            this.nameBuffer.append(this.container.getName());
            this.nameBuffer.append('.');
        }
        this.nameBuffer.append(this.getName());
        return this.nameBuffer.toString();
    }

    @Override
    public ContainerObject getTopLevelContainer() {
        return this.container;
    }

    public ContainerObject getContainerObject() {
        return this.container;
    }

    @Override
    public ContainedObject createContainedObject(String id) {
        return null;
    }

    @Override
    public void remove() {
        if (!this.getIsBeingRemoved()) {
            this.clearElements();
            super.remove();
        }
    }

    public void clearElements() {
        this.getElementsCollection().clear();
        this.fireChange(this.sharedEvent);
    }

    @Override
    public void remove(ContainedObject object) {
        if (object != null && this.isWriteable() && this.getElementsCollection().contains(object)) {
            this.getElementsCollection().remove(object);
            this.removeLocalId(object.getObjectID());
            object.removeObjectListener(this);
            this.sharedEvent.setElement(object);
            this.sharedEvent.setType(1);
            this.fireChange(this.sharedEvent);
        }
    }
}

