/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBListPartitionOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.AbstractCSSBOraclev10g;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.SupplementalLogGroup;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;

public class CSSBAlterTableOraclev10g
extends AbstractCSSBOraclev10g {
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection listPartitionsNode;
        int listPartitionsIndex;
        CompareObjectSelection sourceObj = (CompareObjectSelection)object;
        Table table = (Table)sourceObj.getObject();
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        boolean createProp = false;
        if (sourceObj.isModified()) {
            for (EngPropertyHolder ph : sourceObj.getPropertiesComparator().getPropertiesList()) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(PropertiesComparator.COMMENT_IN_RDBMS) && table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendCommentOn(oldbuffer, tableProxy, prettyPrint);
                    continue;
                }
                if (!ph.getName().equals(PropertiesComparator.SPATIAL_TABLE) || !Boolean.parseBoolean(ph.getLeftValue())) continue;
                for (SpatialColumnDefObject spObjects : table.getSpatialDefinitions()) {
                    if (spObjects.getSpatialColumn() == null && !spObjects.isFunction()) continue;
                    this.appendRegisterSpatialTable(oldbuffer, table, spObjects, prettyPrint);
                }
            }
            ArrayList<String> propList = new ArrayList<String>();
            boolean alterProp = false;
            Settings settings = sourceObj.getObject().getAppView().getSettings();
            for (EngPropertyHolder ph : sourceObj.getPropertiesComparator().getStoragePropertiesList()) {
                if (!ph.isSelected()) continue;
                String propName = ph.getName();
                if (settings.isIncludeStorageInDDL()) {
                    if (propName.equalsIgnoreCase(PropertyNames.PCT_FREE) && settings.isIncludePctFreeInDDL()) {
                        propList.add("PCTFREE");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.PCT_USED) && settings.isIncludePctUsedInDDL()) {
                        propList.add("PCTUSED");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.INIT_TRANS) && settings.isIncludeInitransInDDL()) {
                        propList.add("INITRANS");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.SC_BUFFER_POOL) && settings.isIncludeBufferPoolInDDL()) {
                        propList.add("BUFFER_POOL");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.SC_INITIAL_EXTENT) && settings.isIncludeInitialExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_NEXT_EXTENT) && settings.isIncludeNextExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_MIN_EXTENTS) && settings.isIncludeMinExtentsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_MAX_EXTENTS) && settings.isIncludeMaxExtentsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_PCT_INCREASE) && settings.isIncludePctIncreaseInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS) && settings.isIncludeFreeListsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS_GRPS) && settings.isIncludeFreeListGroupsInDDL()) {
                        createProp = true;
                    }
                }
                if (!propName.equalsIgnoreCase(PropertyNames.TABLESPACE) || !settings.isIncludeTablespaceInDDL()) continue;
                createProp = true;
            }
            if (alterProp) {
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLE");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, this.storageDesign));
                this.appendSegment(oldbuffer, tableProxy.getSegment(), prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging(), propList);
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
                this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                CDDLFileMaker.incrementAlterTable();
            }
            if (createProp) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "-- Table " + table.getName() + " some storage properties are not modified");
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            }
        }
        if ((listPartitionsIndex = sourceObj.getChildIndex(CompareModelToModel.LIST_PARTITIONS)) > -1 && !createProp && (listPartitionsNode = (CompareObjectSelection)sourceObj.getChild(listPartitionsIndex)).hasChildsWithChangeStatus()) {
            CSSBListPartitionOracle cssbListPartitionOracle = new CSSBListPartitionOracle();
            cssbListPartitionOracle.updateListPartitions(oldbuffer, sourceObj, listPartitionsNode, this.storageDesign, prettyPrint);
        }
        this.processPhysicalproperties(oldbuffer, object, prettyPrint);
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Table;
    }

    void processPhysicalproperties(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection sourceObj = (CompareObjectSelection)object;
        if (sourceObj.isModified()) {
            Table table = (Table)sourceObj.getObject();
            Design design = table.getDesign();
            RDBMSSite site = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
            TableProxyOraclev10g stp = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            StoragePropertiesComparator pc = sourceObj.getPropertiesComparator().getPhysicalPropertiesComparator();
            PropertyHolder ph = (PropertyHolder)pc.getPropertyHolderByName(TableComparatorOracle.SUPPLEMENTAL_GROUPS);
            TableProxyOraclev10g ttp = null;
            if (pc instanceof TableComparatorOracle) {
                ttp = (TableProxyOraclev10g)((TableComparatorOracle)pc).getTargetTableProxy();
            }
            if (ph.isSelected() && ttp != null) {
                CSSBAlterTableOraclev10g.processLogGroups(oldbuffer, sourceObj, stp, ttp, prettyPrint);
            }
            if ((ph = (PropertyHolder)pc.getPropertyHolderByName(TableComparatorOracle.SUPPLEMENTAL_ID_KEYS)).isSelected() && ttp != null) {
                CSSBAlterTableOraclev10g.processLogIdKeys(oldbuffer, sourceObj, stp, ttp, prettyPrint);
            }
        }
    }

    public static void processLogIdKeys(StringBuffer oldbuffer, CompareObjectSelection sourceObj, TableProxyOraclev10g stp, TableProxyOraclev10g ttp, boolean prettyPrint) {
        CSSBAlterTableOraclev10g.processLogIdKeys(oldbuffer, sourceObj, stp, ttp, prettyPrint, true);
    }

    public static void processLogIdKeys(StringBuffer oldbuffer, CompareObjectSelection sourceObj, TableProxyOraclev10g stp, TableProxyOraclev10g ttp, boolean prettyPrint, boolean includDrop) {
        boolean tf;
        String keys = "";
        String dkeys = "";
        boolean sf = stp.getSupplementalLogPK();
        if (sf != (tf = ttp.getSupplementalLogPK())) {
            if (tf) {
                dkeys = "PRIMARY KEY";
            }
            if (sf) {
                keys = "PRIMARY KEY";
            }
        }
        if ((sf = stp.getSupplementalLogUK()) != (tf = ttp.getSupplementalLogUK())) {
            if (tf) {
                dkeys = dkeys.isEmpty() ? "UNIQUE" : dkeys + ',' + "UNIQUE";
            }
            if (sf) {
                keys = keys.isEmpty() ? "UNIQUE" : keys + ',' + "UNIQUE";
            }
        }
        if ((sf = stp.getSupplementalLogFK()) != (tf = ttp.getSupplementalLogFK())) {
            if (tf) {
                dkeys = dkeys.isEmpty() ? "FOREIGN KEY" : dkeys + ',' + "FOREIGN KEY";
            }
            if (sf) {
                keys = keys.isEmpty() ? "FOREIGN KEY" : keys + ',' + "FOREIGN KEY";
            }
        }
        if ((sf = stp.getSupplementalLogALL()) != (tf = ttp.getSupplementalLogALL())) {
            if (tf) {
                dkeys = dkeys.isEmpty() ? "ALL" : dkeys + ',' + "ALL";
            }
            if (sf) {
                keys = keys.isEmpty() ? "ALL" : keys + ',' + "ALL";
            }
        }
        if (!dkeys.isEmpty() && includDrop) {
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER TABLE " + CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, stp.getStorageDesign()) + " DROP SUPPLEMENTAL LOG DATA (");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, dkeys);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, ") COLUMNS");
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
        }
        if (!keys.isEmpty()) {
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER TABLE " + CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, stp.getStorageDesign()) + " ADD SUPPLEMENTAL LOG DATA (");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, keys);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, ") COLUMNS");
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
        }
    }

    public static void processLogGroups(StringBuffer oldbuffer, CompareObjectSelection sourceObj, TableProxyOraclev10g stp, TableProxyOraclev10g ttp, boolean prettyPrint) {
        CSSBAlterTableOraclev10g.processLogGroups(oldbuffer, sourceObj, stp, ttp, prettyPrint, true);
    }

    public static void processLogGroups(StringBuffer oldbuffer, CompareObjectSelection sourceObj, TableProxyOraclev10g stp, TableProxyOraclev10g ttp, boolean prettyPrint, boolean includDrop) {
        ArrayList<SupplementalLogGroup> drop = new ArrayList<SupplementalLogGroup>();
        ArrayList<SupplementalLogGroup> create = new ArrayList<SupplementalLogGroup>();
        List<SupplementalLogGroup> slogs = stp.getLoggingGroups();
        List<SupplementalLogGroup> tlogs = ttp.getLoggingGroups();
        ArrayList<SupplementalLogGroup> tcopy = new ArrayList<SupplementalLogGroup>(tlogs);
        for (SupplementalLogGroup sg : slogs) {
            SupplementalLogGroup gr = SupplementalLogGroup.getByName(tlogs, sg.getName());
            if (gr == null) {
                create.add(sg);
                continue;
            }
            if (gr.equivelentTo(sg)) {
                tcopy.remove(gr);
                continue;
            }
            create.add(sg);
            drop.add(sg);
            tcopy.remove(gr);
        }
        if (includDrop) {
            drop.addAll(tcopy);
            for (SupplementalLogGroup sg : drop) {
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLE");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, stp.getStorageDesign()));
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "DROP SUPPLEMENTAL LOG GROUP");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, stp.getStorageDesign().getFormatedName(sg.getName()));
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
            }
        }
        for (SupplementalLogGroup sg : create) {
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLE");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, stp.getStorageDesign()));
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ADD SUPPLEMENTAL LOG GROUP");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, stp.getStorageDesign().getFormatedName(sg.getName()));
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, sg.getColumnsDDLPresentation());
            if (TableProxyOraclev10g.ALWAYS.equals(sg.getCondition())) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, TableProxyOraclev10g.ALWAYS);
            }
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
        }
    }
}

