/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.TableView;

public class TableViewEntityViewComparator
extends EngPropertiesComparator {
    private TableView tableView;
    private EntityView entityView;

    TableViewEntityViewComparator(TableView tableView, EntityView entityView) {
        super(tableView, entityView);
        this.tableView = tableView;
        this.entityView = entityView;
        this.initPropertiesList();
    }

    TableViewEntityViewComparator(TableView tableView, EntityView entityView, List filters) {
        this(tableView, entityView);
        this.applyCompareFilter(filters, tableView.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromTableViewToEntityView();
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initDeprecated();
        this.initCommentsAndNotes();
        EngPropertyHolder ph = new EngPropertyHolder(STRUCTURED_TYPE);
        if (this.tableView != null && this.tableView.getBasedOnStructuredType() != null) {
            ph.setLeftValue(this.tableView.getBasedOnStructuredType().getName());
        } else {
            ph.setLeftValue("");
        }
        if (this.entityView != null && this.entityView.getBasedOnStructuredType() != null) {
            ph.setRightValue(this.entityView.getBasedOnStructuredType().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.tableView != null && this.entityView != null && this.tableView.getBasedOnStructuredType() != this.entityView.getBasedOnStructuredType()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ENT_TABLE_TYPE_SUBSTITUTION);
        ph.setLeftValue(this.tableView != null && this.tableView.getTypeSubstitution() != null ? String.valueOf(this.tableView.getTypeSubstitution().getParentContainerObject().getName()) : "");
        ph.setRightValue(this.entityView != null && this.entityView.getTypeSubstitution() != null ? String.valueOf(this.entityView.getTypeSubstitution().getParentContainerObject().getName()) : "");
        if (this.tableView != null && this.entityView != null) {
            if (this.tableView.getTypeSubstitution() != null) {
                TableView parentTV = (TableView)this.tableView.getTypeSubstitution().getParentContainerObject();
                EntityView parentEV = null;
                if (this.entityView.getTypeSubstitution() != null) {
                    parentEV = (EntityView)this.entityView.getTypeSubstitution().getParentContainerObject();
                }
                if (parentTV.getEngEntityView() != parentEV) {
                    ph.setModified(true);
                    ph.setSelected(true);
                }
            } else if (this.entityView.getTypeSubstitution() != null) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        } else if (this.tableView != null && this.tableView.getTypeSubstitution() != null) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(WHERE_PROPERTY);
        ph.setLeftValue(this.tableView != null ? this.tableView.getWhere() : "");
        ph.setRightValue(this.entityView != null ? this.entityView.getWhere() : "");
        if (this.tableView != null && this.entityView != null && !this.tableView.getWhere().equals(this.entityView.getWhere())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(HAVING_PROPERTY);
        ph.setLeftValue(this.tableView != null ? this.tableView.getHaving() : "");
        ph.setRightValue(this.entityView != null ? this.entityView.getHaving() : "");
        if (this.tableView != null && this.entityView != null && !this.tableView.getHaving().equals(this.entityView.getHaving())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(USER_DEFINED_DQL);
        ph.setLeftValue(this.tableView != null ? this.tableView.getUserDefinedSQL() : "");
        ph.setRightValue(this.entityView != null ? this.entityView.getUserDefinedSQL() : "");
        if (this.tableView != null && this.entityView != null && this.entityView.getUserDefined() && this.tableView.getUserDefined()) {
            String leftDef = this.tableView.getUserDefinedSQL();
            String rightDef = this.entityView.getUserDefinedSQL();
            leftDef = leftDef.replaceAll("\"", "").trim();
            rightDef = rightDef.replaceAll("\"", "").trim();
            leftDef = leftDef.replaceAll("\\(", "").trim();
            rightDef = rightDef.replaceAll("\\(", "").trim();
            if (!(leftDef = leftDef.replaceAll("\\)", "").trim()).equalsIgnoreCase(rightDef = rightDef.replaceAll("\\)", "").trim())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
    }

    private void copyPropertiesFromTableViewToEntityView() {
        if (this.tableView != null && this.entityView != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(STRUCTURED_TYPE)) {
                    this.entityView.setBasedOnStructuredType(this.tableView.getBasedOnStructuredType());
                    continue;
                }
                if (ph.getName().equals(WHERE_PROPERTY)) {
                    this.entityView.setWhere(this.tableView.getWhere());
                    continue;
                }
                if (ph.getName().equals(HAVING_PROPERTY)) {
                    this.entityView.setHaving(this.tableView.getHaving());
                    continue;
                }
                if (!ph.getName().equals(USER_DEFINED_DQL)) continue;
                this.entityView.setUserDefinedSQL(this.tableView.getUserDefinedSQL());
                this.entityView.setLayoutSQL(this.tableView.getLayoutSQL());
                this.entityView.setParsed(this.tableView.isParsed());
                this.entityView.setIncorrectSQL(this.tableView.isIncorrectSQL());
                this.entityView.setValidSQL(this.tableView.isValidSQL());
            }
        }
    }

    @Override
    protected boolean shouldApplyNametranslation() {
        return false;
    }
}

