/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.AbstractDenormalizer;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class DenormalizerMergeTable
extends AbstractDenormalizer {
    private FKIndexAssociation mergeThisAssociation = null;

    public Collection getTargetableTables() {
        Table table = this.getSource();
        FKIndexAssociationSet fkset = ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet();
        return fkset.getChildTables(table);
    }

    public void setTarget(Table table) {
        this.setBaseTable(table);
    }

    public void setSource(Table table) {
        this.setDerivedTable(table);
    }

    public Table getTarget() {
        return this.getBaseTable();
    }

    public Table getSource() {
        return this.getDerivedTable();
    }

    public Table[] getAllTablesWithSourceAssociation() {
        Collection coll = this.getTargetableTables();
        return coll.toArray(new Table[coll.size()]);
    }

    public FKIndexAssociation[] getSourceAssociationsIn(Table target) {
        FKIndexAssociation[] fkAssociations = target.getFKAssociations();
        ArrayList<FKIndexAssociation> sourceTargetAssociations = new ArrayList<FKIndexAssociation>();
        for (int i = 0; i < fkAssociations.length; ++i) {
            FKIndexAssociation assoc = fkAssociations[i];
            if (!this.getSource().equals(assoc.getRemoteTable())) continue;
            sourceTargetAssociations.add(assoc);
        }
        return sourceTargetAssociations.toArray(new FKIndexAssociation[sourceTargetAssociations.size()]);
    }

    public void merge() {
        boolean propagate = this.getTarget().getDesign().isPropagatePKChahges();
        try {
            this.getTarget().getDesign().setPropagatePKChahges(false);
            if (this.mergeThisAssociation != null) {
                this.merge(this.mergeThisAssociation);
                this.mergeThisAssociation = null;
            } else if (this.getTarget() != null) {
                this.merge(this.getTarget());
            } else {
                this.mergeAll();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.getTarget().getDesign().setPropagatePKChahges(propagate);
        }
    }

    public void merge(Table target) {
        FKIndexAssociation fk;
        KeyObject sourcePK;
        int i;
        Table source = this.getSource();
        List newmappings = target.getMappingsToEntities();
        ArrayList<XtdMapping> oldmappings = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : source.getMappingsToEntities()) {
            DesignObject obj;
            oldmappings.add(mapping);
            if (!mapping.isDeleted() && (obj = mapping.getLogicalObject()) instanceof Entity) {
                XtdMapping m = source.getRelationalModel().getRMExtendedMap().createMapping(obj, target);
                newmappings.add(m);
            }
            source.getRelationalModel().getRMExtendedMap().removeMapping(mapping);
        }
        boolean idfkremoved = false;
        FKIndexAssociation[] associations = this.getSourceAssociationsIn(target);
        for (i = 0; i < associations.length; ++i) {
            if (!associations[i].isIdentifyingForPK()) continue;
            associations[i].remove();
        }
        associations = source.getFKAssociations();
        for (i = 0; i < associations.length; ++i) {
            if (target.equals(associations[i].getRemoteTable())) {
                if (!associations[i].isIdentifyingForPK()) continue;
                sourcePK = source.getPK();
                if (sourcePK != null) {
                    sourcePK.remove();
                    idfkremoved = true;
                }
                associations[i].remove();
                continue;
            }
            if (!this.getSource().equals(associations[i].getRemoteTable())) continue;
        }
        Index tpk = (Index)target.getPK();
        if (tpk != null && !idfkremoved && (fk = source.getFKIndexAssociationFor(tpk)) != null) {
            FKElement[] cols = fk.getColumns();
            for (int k = 0; k < cols.length; ++k) {
                cols[k].remove();
            }
            fk.remove();
        }
        if ((sourcePK = source.getPK()) != null) {
            sourcePK.setUnique(true);
        }
        this.mergeTables();
        this.getSource().remove();
        for (XtdMapping mapping : oldmappings) {
            target.getRelationalModel().getRMExtendedMap().removeMapping(mapping);
        }
        this.processMappings(target, newmappings);
    }

    private void processMappings(Table target, List newMappings) {
        boolean dirty = false;
        ArrayList list = new ArrayList(newMappings);
        for (XtdMapping mapping : list) {
            CandidateKey pkey;
            if (mapping.isDeleted()) continue;
            Entity ent = (Entity)mapping.getLogicalObject();
            Table table = target;
            if (mapping.getRelationalObject() != target) continue;
            table = target;
            Index pk = (Index)target.getPK();
            if (pk != null && pk.getEngCandidateKey(ent) == null && !mapping.getIndexes().contains(pk.getObjectID())) {
                mapping.getIndexes().add(pk.getObjectID());
                dirty = true;
            }
            if ((pkey = (CandidateKey)ent.getPK()) != null && pkey.getEngIndex(table.getRelationalModel(), table) == null && !mapping.getKeys().contains(pkey.getObjectID())) {
                mapping.getKeys().add(pkey.getObjectID());
                dirty = true;
            }
            if (table == null) continue;
            for (Column col : table.getElementsCollection()) {
                if (col.getEngAttribute(ent) != null || mapping.getColumns().contains(col.getObjectID())) continue;
                mapping.getColumns().add(col.getObjectID());
                dirty = true;
            }
            Iterator itc = table.getKeySet().iterator();
            while (itc.hasNext()) {
                Index ind = (Index)itc.next();
                if (!ind.isPK() && !ind.isUnique() || ind.getEngCandidateKey(ent) != null || mapping.getIndexes().contains(ind.getObjectID())) continue;
                mapping.getIndexes().add(ind.getObjectID());
                dirty = true;
            }
            for (Attribute attr : ent.getElementsCollection()) {
                if (attr.getEngColumn(target.getRelationalModel(), table) != null || mapping.getAttributes().contains(attr.getObjectID())) continue;
                dirty = true;
                mapping.getAttributes().add(attr.getObjectID());
            }
            Iterator ite = ent.getKeySet().iterator();
            while (ite.hasNext()) {
                CandidateKey key = (CandidateKey)ite.next();
                if (key.getEngIndex(target.getRelationalModel(), table) != null || mapping.getKeys().contains(key.getObjectID())) continue;
                dirty = true;
                mapping.getKeys().add(key.getObjectID());
            }
        }
        if (dirty) {
            target.getRelationalModel().getRMExtendedMap().setDirty(true);
        }
    }

    public void mergeAll() {
        Table[] targetTables = this.getAllTablesWithSourceAssociation();
        for (int i = 0; i < targetTables.length; ++i) {
            this.merge(targetTables[i]);
        }
    }

    public void merge(FKIndexAssociation association) {
        Table oldTarget = this.getTarget();
        Table newTarget = (Table)association.getContainerWithKeyObject();
        this.setTarget(newTarget);
        association.remove();
        this.changeColumns((Column[])this.getSource().getElements(), this.getTarget(), false);
        this.setTarget(oldTarget);
    }

    public void mergeTables() {
        HashMap indexColumns = new HashMap();
        Table target = this.getTarget();
        Table source = this.getSource();
        Iterator it = this.getSource().getKeySet().iterator();
        while (it.hasNext()) {
            Index ind = (Index)it.next();
            ArrayList<String> colsIDs = new ArrayList<String>();
            for (Column col : ind.getElementsCollection()) {
                colsIDs.add(col.getObjectID());
            }
            if (!ind.isFK()) {
                indexColumns.put(ind.getObjectID(), colsIDs);
                continue;
            }
            if (ind.getFKAssociation() == null) continue;
            indexColumns.put(ind.getFKAssociation().getObjectID(), colsIDs);
        }
        this.moveColumns((Column[])this.getSource().getElements(), this.getSource(), this.getTarget());
        Object[] indexes = this.getSource().getKeySet().toArray();
        for (int i = 0; i < indexes.length; ++i) {
            Index ind = (Index)indexes[i];
            if (ind.isFK()) continue;
            ArrayList<Column> cols = new ArrayList<Column>();
            List ids = (List)indexColumns.get(ind.getObjectID());
            if (ids == null) continue;
            for (String old : ids) {
                Column col = (Column)target.getElementByID(old);
                if (col == null) continue;
                cols.add(col);
            }
            if (cols.size() != ids.size()) continue;
            Index nind = ind;
            source.moveIndexToTable(ind, target);
            nind.getElementsCollection().clear();
            for (Column col : cols) {
                nind.add(col);
            }
        }
        this.processForeignKeys(source, target, indexColumns);
    }

    public void processForeignKeys(Table source, Table target, Map indexcols) {
        FKIndexAssociation[] foreignKeys = source.getFKAssociations();
        for (int i = 0; i < foreignKeys.length; ++i) {
            FKIndexAssociation fk = foreignKeys[i];
            List idlist = (List)indexcols.get(fk.getObjectID());
            ArrayList<Column> list = new ArrayList<Column>();
            if (idlist != null) {
                for (String id : idlist) {
                    Column col = (Column)target.getElementByID(id);
                    if (col == null) continue;
                    list.add(col);
                }
            }
            if (list.size() <= 0 || list.size() != idlist.size()) continue;
            FKIndexAssociation newAssociation = null;
            newAssociation = target.addForeignKey((Index)fk.getKeyObject(), list);
            newAssociation.getLocalFKIndex().setGeneratorID(fk.getGeneratorID());
            fk.copy(newAssociation);
            for (XtdMapping mapping : fk.getMappingsToRelations()) {
                DesignObject obj;
                if (mapping.isDeleted() || !((obj = mapping.getLogicalObject()) instanceof Relation)) continue;
                source.getRelationalModel().getRMExtendedMap().createMapping(obj, newAssociation);
            }
            newAssociation.resetEdgeParams();
            fk.remove();
        }
    }

    public boolean canMerge() {
        return this.getSource() != null && (this.getTarget() == null || this.isTargetable(this.getTarget()));
    }

    public boolean isTargetable(Table target) {
        return true;
    }

    public Table findMainTarget(Table[] tables) {
        ArrayList<Table> list = new ArrayList<Table>();
        list.addAll(Arrays.asList(tables));
        return this.findMainTarget(list);
    }

    protected Table findMainTarget(List list) {
        int size = list.size();
        if (size > 1) {
            Table candidate1 = (Table)list.get(0);
            Table candidate2 = (Table)list.get(1);
            this.setSource(candidate1);
            if (this.isTargetable(candidate2)) {
                list.remove(candidate1);
            } else {
                this.setSource(candidate2);
                if (this.isTargetable(candidate1)) {
                    list.remove(candidate2);
                } else {
                    list.remove(candidate1);
                    list.remove(candidate2);
                }
            }
            return this.findMainTarget(list);
        }
        if (size == 1) {
            return (Table)list.get(0);
        }
        return null;
    }

    @Override
    public TableSet getTableSet() {
        return ((RelationalDesign)this.getSource().getDesignPart()).getTableSet();
    }
}

