/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ErrorDescriptor;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.relational.memento.Memento;
import oracle.dbtools.crest.model.design.undo.relational.memento.ViewIndexMemento;

public class ViewIndex
extends KeyObject {
    public static final String TYPE_NAME = "ViewIndex";
    public static final String VALUE_ASCENDING = "ASC";
    public static final String VALUE_DESCENDING = "DESC";
    private static String SORT_ORDER = "sortOrder";
    private static String COLUMN_ID = "columnID";
    private Map sortMap = new TreeMap();
    private ViewIndexMemento memento;
    private String indexExpression = "";
    private String idOfRecoveredIntegrityIndex;
    private String indexState = "Plain Index";
    private static Set indexStateSet = null;
    private String relationGeneratorID = "";

    public ViewIndex(DesignPart designPart) {
        super(designPart);
    }

    public ViewIndex(DesignPart designPart, FKIndexAssociation fk) {
        this(designPart);
        this.indexState = "Foreign Key";
        this.name = fk.getName();
        this.setFKAssociation(fk);
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnViewSet();
    }

    @Override
    protected void clearStructure() {
    }

    @Override
    protected void updateStructure() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void setColumnSortOrder(Object column, String sortOrder) {
        if (((ContainedObject)column).getObjectID() != null) {
            this.sortMap.put(((ContainedObject)column).getObjectID(), sortOrder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getColumnSortOrder(Object column) {
        String sortOrder = null;
        if (!(column instanceof AbstractViewElement)) return " ";
        if (((ContainedObject)column).getObjectID() == null) return VALUE_ASCENDING;
        sortOrder = (String)this.sortMap.get(((ContainedObject)column).getObjectID());
        if (sortOrder == null) {
            return " ";
        }
        if (!"".equals(sortOrder.trim())) return sortOrder;
        return VALUE_ASCENDING;
    }

    public String getIndexExpression() {
        return this.indexExpression;
    }

    public void setIndexExpression(String indexExpression) {
        this.indexExpression = indexExpression;
    }

    public String getRelationGeneratorID() {
        return this.relationGeneratorID;
    }

    public void setRelationGeneratorID(String relationGeneratorID) {
        this.relationGeneratorID = relationGeneratorID;
    }

    @Override
    public Memento getIndexMemento() {
        return this.getIndexMemento(false);
    }

    public Memento getIndexMemento(boolean recreate) {
        if (recreate || this.memento == null) {
            this.memento = new ViewIndexMemento(this);
        }
        return this.memento;
    }

    public TableView getView() {
        return (TableView)this.getContainerWithKeyObject();
    }

    public void restoreFromMemento(ViewIndexMemento mem) {
        this.setSchemaObject(mem.schemaObject);
        this.setName(mem.name);
        this.setObjectID(mem.id);
        this.setComment(mem.comments);
        this.setCommentInRDBMS(mem.comments_in_rdbms);
        this.setNotes(mem.notes);
        this.setMarkedGenerate(mem.generate_in_DDL);
        this.setShouldEngineer(mem.engineer);
        this.setDeprecated(mem.deprecated);
        this.setIndexExpression(mem.expression);
        this.setOidKey(mem.isOidKey);
        ContainedObject[] cos = this.getElements();
        ArrayList<AbstractViewElement> list = new ArrayList<AbstractViewElement>();
        TableView view = (TableView)this.getContainerWithKeyObject();
        for (ViewIndexMemento.ColWr wr : mem.columns) {
            AbstractViewElement column = (AbstractViewElement)view.getElementByID(wr.col_id);
            if (column == null) continue;
            list.add(column);
        }
        for (int i = 0; i < cos.length; ++i) {
            AbstractViewElement col = (AbstractViewElement)cos[i];
            if (list.contains(col)) continue;
            this.remove(col);
        }
        List elems = (List)this.getElementsCollection();
        int k = 0;
        for (AbstractViewElement col : list) {
            int ind = elems.indexOf(col);
            if (ind < 0) {
                this.add(col);
                this.moveToIndex(col, k);
            } else {
                this.moveToIndex(col, k);
            }
            ++k;
        }
        for (ViewIndexMemento.ColWr wr : mem.columns) {
            AbstractViewElement column = (AbstractViewElement)view.getElementByID(wr.col_id);
            if (column == null) continue;
            this.setColumnSortOrder(column, wr.sort_order);
        }
        this.setIndexState(mem.index_state);
    }

    public String getIdOfRecoveredIntegrityIndex() {
        return this.idOfRecoveredIntegrityIndex;
    }

    public void setIdOfRecoveredIntegrityIndex(String idOfRecoveredIntegrityIndex) {
        this.idOfRecoveredIntegrityIndex = idOfRecoveredIntegrityIndex;
    }

    @Override
    public String getIndexState() {
        if (this.isPK()) {
            return "Primary Constraint";
        }
        if (this.isUnique()) {
            return "Unique Constraint";
        }
        if (this.isFK()) {
            return "Foreign Key";
        }
        if (!this.isPK() && "Primary Constraint".equalsIgnoreCase(this.indexState)) {
            return "Plain Index";
        }
        return this.indexState;
    }

    @Override
    public void setIndexState(String indexState) {
        if (this.checkIndexStateValue(indexState)) {
            String oldState = this.getIndexState();
            this.indexState = indexState;
            if ("Primary Constraint".equalsIgnoreCase(indexState)) {
                KeyObject oldPK;
                if (!this.isPK() && (oldPK = this.getContainerWithKeyObject().getPK()) != null) {
                    oldPK.setIndexState("Unique Constraint");
                }
                this.setPK(true);
                this.makeValidPKIfNotEmpty();
            } else if ("Unique Constraint".equalsIgnoreCase(indexState)) {
                if (this.isPK()) {
                    this.setPK(false);
                }
                if (!this.isUnique()) {
                    this.setUnique(true);
                }
            } else if ((this.isPK() || this.isUnique()) && this.hasFKAssociations()) {
                this.indexState = oldState;
            } else {
                if (this.isPK()) {
                    this.setPK(false);
                }
                if (this.isUnique()) {
                    this.setUnique(false);
                }
            }
        }
    }

    private boolean checkIndexStateValue(String value) {
        if (indexStateSet == null) {
            indexStateSet = new HashSet();
            indexStateSet.addAll(Arrays.asList(INDEX_STATES));
        }
        return indexStateSet.contains(value);
    }

    public boolean hasFKAssociations() {
        Iterator it = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (!fk.getRemoteIndex().getObjectID().equals(this.getObjectID())) continue;
            return true;
        }
        return false;
    }

    public List getUsedColumns() {
        if (this.getElementsCollection().size() > 0) {
            return new ArrayList(this.getElementsCollection());
        }
        return Collections.EMPTY_LIST;
    }

    public List getIndexColumnUsageList() {
        ArrayList list = new ArrayList();
        for (AbstractViewElement col : this.getElementsCollection()) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put(COLUMN_ID, col.getObjectID());
            String sort = this.getColumnSortOrder(col);
            if (VALUE_DESCENDING.equals(sort)) {
                map.put(SORT_ORDER, sort);
            }
            list.add(map);
        }
        return list;
    }

    public void applyIndexColumnUsageList(List list) {
        int i;
        ArrayList<AbstractViewElement> tempCols = new ArrayList<AbstractViewElement>();
        ArrayList<String> tempSorts = new ArrayList<String>();
        for (Object obj : list) {
            AbstractViewElement col;
            Map map;
            String colID;
            if (!(obj instanceof Map) || (colID = (String)(map = (Map)obj).get(COLUMN_ID)) == null || (col = (AbstractViewElement)this.getView().getElementByID(colID)) == null) continue;
            tempCols.add(col);
            String sort = (String)map.get(SORT_ORDER);
            if (sort != null && VALUE_DESCENDING.equals(sort)) {
                tempSorts.add(VALUE_DESCENDING);
                continue;
            }
            tempSorts.add(VALUE_ASCENDING);
        }
        ContainedObject[] cols = this.getElements();
        for (i = 0; i < cols.length; ++i) {
            if (tempCols.contains(cols[i])) continue;
            this.remove(cols[i]);
        }
        for (i = 0; i < tempCols.size(); ++i) {
            AbstractViewElement col = (AbstractViewElement)tempCols.get(i);
            if (!this.contains(col)) {
                this.add(col);
            }
            this.moveToIndex(col, i);
            this.setColumnSortOrder(col, (String)tempSorts.get(i));
        }
    }

    @Override
    public boolean isSurrogateKey() {
        return false;
    }

    @Override
    public ContainedObject[] getColumns() {
        return this.getElementsCollection().toArray(new FKElement[0]);
    }

    @Override
    public void synchronizeMarkedGenerate(boolean markedGenerate) {
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        ViewIndex index = (ViewIndex)desObject;
        index.setIndexState(this.getIndexState());
        index.setIndexExpression(this.getIndexExpression());
        TableView table = (TableView)index.getContainerWithKeyObject();
        for (ColumnView column : this.getElementsCollection()) {
            String sorder = this.getColumnSortOrder(column);
            ColumnView newColumn = (ColumnView)table.getElementByID(column.getObjectID());
            if (newColumn == null) {
                newColumn = (ColumnView)table.getElementByName(column.getName());
            }
            if (newColumn == null) continue;
            index.setColumnSortOrder(newColumn, sorder);
        }
        index.setName(this.getName());
    }

    @Override
    public String getLongName() {
        if (this.isPK() || this.isUnique()) {
            SchemaObject so;
            if (this.getContainerObject() != null && (so = this.getContainerObject().getSchemaObject()) != null) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
            return this.getName();
        }
        SchemaObject so = this.getSchemaObject();
        if (so != null && !"".equals(so.getLongName())) {
            return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
        }
        return this.getName();
    }

    @Override
    public String toString() {
        this.nameBuffer.setLength(0);
        if (this.getContainerObject() != null) {
            this.nameBuffer.append(this.getContainerObject().getName());
            this.nameBuffer.append('.');
        }
        this.nameBuffer.append(this.getName());
        return this.nameBuffer.toString();
    }

    @Override
    public boolean setName(String name) {
        boolean res = super.setName(name);
        if (this.name != null && !this.name.equals(name) && this.getDesign().isLoading()) {
            ErrorDescriptor err = new ErrorDescriptor();
            err.error = Index.INDEX_IS_RENAMED_IN_LOADING;
            err.object = this;
            err.newName = name;
            this.getDesignPart().getErrorDescriptionList().add(err);
        }
        return res;
    }

    @Override
    public void setPK(boolean value) {
        if (this.getDesignObjectSet() != null && this.getDesignObjectSet().getNameSpaceController() != null) {
            NameSpaceController nsc = this.getDesignObjectSet().getNameSpaceController();
            HashMap<String, Boolean> status = new HashMap<String, Boolean>();
            status.put("Primary Constraint", this.isPK());
            status.put("Unique Constraint", this.isUnique());
            super.setPK(value);
            nsc.objectStatusChanged(status, this);
        } else {
            super.setPK(value);
        }
    }

    @Override
    public void setUnique(boolean value) {
        if (this.getDesignObjectSet() != null && this.getDesignObjectSet().getNameSpaceController() != null) {
            NameSpaceController nsc = this.getDesignObjectSet().getNameSpaceController();
            HashMap<String, Boolean> status = new HashMap<String, Boolean>();
            status.put("Primary Constraint", this.isPK());
            status.put("Unique Constraint", this.isUnique());
            super.setUnique(value);
            nsc.objectStatusChanged(status, this);
        } else {
            super.setUnique(value);
        }
    }
}

