/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AbstractPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPartitionPropertyDialogDB2;

public class IndexPartitionDB2
extends AbstractPartitionDB2 {
    private IndexProxyDB2 index = null;
    private int partNumber = 1;
    private String partConstants = "";
    private StorageTemplateDB2 storageTemplate = null;
    public static final String TYPE_NAME = "IndexPartition";

    @Override
    public String getIDPrefix() {
        return "IP";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public IndexProxyDB2 getIndex() {
        return this.index;
    }

    public void setIndex(IndexProxyDB2 index) {
        this.index = index;
        index.setClusterType(IndexProxyDB2.CLUSTER_TYPES[2]);
        this.fireDataFieldChange();
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
        this.fireDataFieldChange();
    }

    public String getPartConstants() {
        return this.partConstants;
    }

    public void setPartConstants(String partConstants) {
        this.partConstants = partConstants;
        this.fireDataFieldChange();
    }

    public StorageTemplateDB2 getStorageTemplate() {
        return this.storageTemplate;
    }

    public void setStorageTemplate(StorageTemplateDB2 storageTemplate) {
        this.storageTemplate = storageTemplate;
        this.fireDataFieldChange();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPartitionPropertyDialogDB2 dialog = new IndexPartitionPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        IndexPartitionDB2 indexPart = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getIndexPartitionSet().getByName(this.getName());
        if (storageObject != null) {
            if (!this.isRawObject()) {
                indexPart = (IndexPartitionDB2)storageObject;
            }
        } else {
            indexPart = ((AbstractStorageDesignDB2)targetDesign).getIndexPartitionSet().createIndexPartition();
        }
        if (indexPart != null) {
            indexPart.setName(this.getName());
            indexPart.setPartConstants(this.getPartConstants());
            if (this.getStorageTemplate() != null) {
                StorageTemplateDB2 templ = (StorageTemplateDB2)((AbstractStorageDesignDB2)targetDesign).getStorageTemplateSet().getByName(this.getStorageTemplate().getName());
                if (templ == null) {
                    StorageTemplateDB2 newTempl = ((AbstractStorageDesignDB2)targetDesign).getStorageTemplateSet().createStorageTemplate();
                    newTempl.setName(this.getStorageTemplate().getName());
                    newTempl.setRawObject(true);
                    indexPart.setStorageTemplate(newTempl);
                } else {
                    indexPart.setStorageTemplate(templ);
                }
            }
            indexPart.setComment(this.getComment());
            indexPart.setRawObject(false);
        }
    }
}

