/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;

public class PKProxySetSqlServer
extends IndexProxySet {
    public PKProxySetSqlServer(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected RelationalObjectProxy createProxy(DesignObject object) {
        return new PKProxySqlServer((Index)object, this.getStorageDesign());
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        return new PKProxySqlServer(design, id, longName, this.getStorageDesign());
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        Index ind;
        if (event.isAdded()) {
            Index ind2 = (Index)event.getAffected();
            if (ind2.isPK()) {
                this.add(ind2);
                this.fireUpdate();
            }
        } else if (event.isRemoved() && this.containsId((ind = (Index)event.getAffected()).getObjectID())) {
            this.remove((Index)event.getAffected());
            this.fireUpdate();
        }
    }

    @Override
    protected void add(Index[] array) {
        for (int i = 0; i < array.length; ++i) {
            Index ind = array[i];
            if (!ind.isPK()) continue;
            this.add(ind);
        }
    }

    @Override
    public void add(DesignObject object) {
        String id = object.getObjectID();
        RelationalObjectProxy proxy = this.getProxy(id);
        if (proxy == null && (proxy = this.restoreProxyFromRecycleMap(object)) != null) {
            this.add(proxy);
            this.fireUpdate();
            return;
        }
        if (proxy != null) {
            if (!this.getProxy(id).isLoaded()) {
                this.getProxy(id).loadDesignObject();
            }
        } else if (object instanceof KeyObject && ((KeyObject)object).isPK()) {
            proxy = this.createProxy(object);
            Iterator it = this.iterator();
            IndexProxy pk = null;
            while (it.hasNext() && ((pk = (IndexProxy)it.next()).equals(proxy) || !pk.getTable().equals(((IndexProxy)proxy).getTable()))) {
                pk = null;
            }
            try {
                if (pk != null) {
                    this.remove(pk);
                }
                this.add(proxy);
            }
            catch (IllegalStateException e) {
                System.out.println("Error in PKProxySetSqlServer.add");
            }
        }
    }

    public boolean hasDublicateNames() {
        for (int i = 0; i < this.elements.size(); ++i) {
            PKProxySqlServer current = (PKProxySqlServer)this.elements.get(i);
            for (int j = i + 1; j < this.elements.size(); ++j) {
                PKProxySqlServer another = (PKProxySqlServer)this.elements.get(j);
                if (!current.getName().equalsIgnoreCase(another.getName()) || ((TableProxySqlServer)current.getTableProxy()).getDatabase() != ((TableProxySqlServer)another.getTableProxy()).getDatabase()) continue;
                return true;
            }
        }
        return false;
    }
}

