/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableSpacePropertyDialogUDB;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableSpaceUDB
extends AbstractStorageObjectDB2
implements StorageObjectListener,
ModelObjectSetListener,
PropertiesPropagator {
    public static final String SYSTEM = "SYSTEM";
    public static final String DATABASE = "DATABASE";
    public static final String DATATYPE_REGULAR = "REGULAR";
    public static final String DATATYPE_LONG = "LONG";
    public static final String DATATYPE_SYSTEM_TEMP = "SYSTEM TEMPORARY";
    public static final String DATATYPE_USER_TEMP = "USER TEMPORARY";
    private static String[] availableManagedByTypes = new String[]{"SYSTEM", "DATABASE"};
    protected static String[] availableDataTypes = new String[]{"REGULAR", "LONG", "SYSTEM TEMPORARY", "USER TEMPORARY"};
    private static Object[] availablePageSizes = new Object[]{new Integer(4), new Integer(8), new Integer(16), new Integer(32)};
    private boolean dbDefOnly = false;
    private String managedBy = "SYSTEM";
    private String autoResize = "";
    private String initialSize = "";
    private String increaseSize = "";
    private String maxSize = "";
    private String dataType = "REGULAR";
    private NodeGroupUDB nodegroup = null;
    private int pageSize = 4;
    private String extentSize = "";
    protected String prefetchSize = "";
    private BufferPoolUDB bufferPool = null;
    private float overhead = 0.0f;
    private float tranferRate = 0.0f;
    private boolean droppedTableRecovery = false;
    private boolean fileSystemCaching = true;
    private String users = "";
    private UserSet userSet = null;
    private String userGroups = "";
    private UserSet userGroupSet = null;
    private String grantOption = "NO";
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private StorageObjectCollection containers;
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "TableSpace";

    public TableSpaceUDB(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.containers = new StorageObjectCollection(((StorageDesignUDB)storageDesign).getContainerSet());
        this.containers.setParent(this);
        this.containers.setName(Messages.getString("TableSpaceUDB.Containers"));
        this.containers.setSetMethod("setTableSpace");
        this.containers.setClassForParent(TableSpaceUDB.class);
        this.containers.setIcon(GUIConfiguration.getInstance().getIcon("CONTAINER_ICON", 16));
        ((StorageDesignUDB)storageDesign).getContainerSet().addSetListener(this);
        this.addContainersFromDesign(((StorageDesignUDB)storageDesign).getContainerSet());
    }

    public void addContainersFromDesign(StorageObjectSet set) {
        for (ContainerUDB cont : set) {
            if (cont.getTableSpace() != null && cont.getTableSpace() == this) {
                cont.setParent(this.containers);
                if (this.containers.contains(cont)) continue;
                this.containers.add(cont);
                continue;
            }
            this.containers.remove(cont);
        }
    }

    @Override
    public String getIDPrefix() {
        return "TS";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setDBDefOnly(boolean value) {
        this.dbDefOnly = value;
    }

    public boolean getDBDefOnly() {
        return this.dbDefOnly;
    }

    public static String[] getAvailableDataTypes() {
        return availableDataTypes;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setNodeGroup(NodeGroupUDB nodegroup) {
        this.nodegroup = nodegroup;
        this.fireDataFieldChange();
    }

    public NodeGroupUDB getNodeGroup() {
        return this.nodegroup;
    }

    public static Object[] getAvailablePageSizes() {
        return availablePageSizes;
    }

    public void setPageSize(int size) {
        this.pageSize = size;
    }

    public void setPageSize(Integer size) {
        this.setPageSize((int)size);
    }

    public Integer getPageSize() {
        return new Integer(this.pageSize);
    }

    public void setExtentSize(String numberOfPages) {
        if (this.checkExtentSize(numberOfPages)) {
            this.extentSize = numberOfPages;
        }
    }

    public String getExtentSize() {
        return this.extentSize;
    }

    protected boolean checkExtentSize(String extent) {
        if ("".equalsIgnoreCase(extent)) {
            return true;
        }
        try {
            if (Integer.parseInt(extent) > 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            String unit = extent.substring(extent.length() - 1);
            String value = extent.substring(0, extent.length() - 1).trim();
            if (Integer.parseInt(value) > 0 && (unit.equalsIgnoreCase("K") || unit.equalsIgnoreCase("M"))) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void setPrefetchSize(String numberOfPages) {
        if (this.checkPrefetchSize(numberOfPages)) {
            this.prefetchSize = numberOfPages;
        }
    }

    public String getPrefetchSize() {
        return this.prefetchSize;
    }

    protected boolean checkPrefetchSize(String prefetch) {
        if ("".equalsIgnoreCase(prefetch)) {
            return true;
        }
        try {
            if (Integer.parseInt(prefetch) > 0) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            String unit = prefetch.substring(prefetch.length() - 1);
            String value = prefetch.substring(0, prefetch.length() - 1).trim();
            if (Integer.parseInt(value) > 0 && (unit.equalsIgnoreCase("K") || unit.equalsIgnoreCase("M") || unit.equalsIgnoreCase("G"))) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void setBufferPool(BufferPoolUDB bufferPool) {
        this.bufferPool = bufferPool;
        this.fireDataFieldChange();
    }

    public BufferPoolUDB getBufferPool() {
        return this.bufferPool;
    }

    public void setOverhead(float numberOfMilliseconds) {
        this.overhead = numberOfMilliseconds;
    }

    public float getOverhead() {
        return this.overhead;
    }

    public void setTransferRate(float numberOfMilliseconds) {
        this.tranferRate = numberOfMilliseconds;
    }

    public float getTransferRate() {
        return this.tranferRate;
    }

    public void setDroppedTableRecovery(boolean droppedTableRecovery) {
        this.droppedTableRecovery = droppedTableRecovery;
    }

    public boolean getDroppedTableRecovery() {
        return this.droppedTableRecovery;
    }

    public void setFileSystemCaching(boolean fileSystemCaching) {
        this.fileSystemCaching = fileSystemCaching;
    }

    public boolean getFileSystemCaching() {
        return this.fileSystemCaching;
    }

    public ContainerUDB[] getContainers() {
        ContainerSetUDB containerSet = ((StorageDesignUDB)this.getStorageDesign()).getContainerSet();
        return containerSet.getContainersFor(this);
    }

    public ContainerUDB[] getContainersForNode(String node) {
        ContainerUDB[] allContainers = this.getContainers();
        ArrayList<ContainerUDB> containersForNode = new ArrayList<ContainerUDB>();
        for (int i = 0; i < allContainers.length; ++i) {
            if (!allContainers[i].getOnNodes().equalsIgnoreCase(node)) continue;
            containersForNode.add(allContainers[i]);
        }
        return containersForNode.toArray(new ContainerUDB[0]);
    }

    public List getAllNodes() {
        ContainerUDB[] allContainers = this.getContainers();
        ArrayList<String> allNodes = new ArrayList<String>();
        for (int i = 0; i < allContainers.length; ++i) {
            if (allNodes.contains(allContainers[i].getOnNodes())) continue;
            allNodes.add(allContainers[i].getOnNodes());
        }
        return allNodes;
    }

    public TableProxyUDB[] getTableProxies() {
        ArrayList<TableProxyUDB> tableProxiesForTableSpace = new ArrayList<TableProxyUDB>();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign();
        RelationalObjectProxy[] tableProxies = (RelationalObjectProxy[])storageDesign.getTableProxySet().toArray();
        for (int i = 0; i < tableProxies.length; ++i) {
            TableProxyUDB tableProxy = (TableProxyUDB)tableProxies[i];
            if (tableProxy.getTableSpace() == null || !tableProxy.getTableSpace().equals(this)) continue;
            tableProxiesForTableSpace.add(tableProxy);
        }
        return tableProxiesForTableSpace.toArray(new TableProxyUDB[0]);
    }

    public boolean usedForDataBaseCreation() {
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign();
        DataBaseUDB[] databases = (DataBaseUDB[])storageDesign.getDataBaseSet().toArray();
        for (int i = 0; i < databases.length; ++i) {
            if (databases[i].getCatalogTableSpace() != null && databases[i].getCatalogTableSpace().equals(this)) {
                return true;
            }
            if (databases[i].getTemporaryTableSpace() != null && databases[i].getTemporaryTableSpace().equals(this)) {
                return true;
            }
            if (databases[i].getUserTableSpace() == null || !databases[i].getUserTableSpace().equals(this)) continue;
            return true;
        }
        return false;
    }

    public void setManagedBy(String managedBy) {
        this.managedBy = managedBy;
    }

    public String getManagedBy() {
        return this.managedBy;
    }

    public static Object[] getAvailableManagedByTypes() {
        return availableManagedByTypes;
    }

    public void setAutoResize(String autoResize) {
        this.autoResize = autoResize;
    }

    public String getAutoResize() {
        return this.autoResize;
    }

    public void setInitialSize(String initialSize) {
        if (this.checkInitialSize(initialSize)) {
            this.initialSize = initialSize;
        }
    }

    public String getInitialSize() {
        return this.initialSize;
    }

    protected boolean checkInitialSize(String size) {
        if ("".equalsIgnoreCase(size)) {
            return true;
        }
        try {
            String unit = size.substring(size.length() - 1);
            String value = size.substring(0, size.length() - 1).trim();
            if (Integer.parseInt(value) > 0 && (unit.equalsIgnoreCase("K") || unit.equalsIgnoreCase("M") || unit.equalsIgnoreCase("G"))) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void setIncreaseSize(String increaseSize) {
        String size = increaseSize.replaceAll("%", "PERCENT");
        if (this.checkIncreaseSize(size)) {
            this.increaseSize = size;
        }
    }

    public String getIncreaseSize() {
        return this.increaseSize;
    }

    protected boolean checkIncreaseSize(String size) {
        String value;
        String unit;
        if ("".equalsIgnoreCase(size)) {
            return true;
        }
        if (size.toUpperCase().endsWith("PERCENT")) {
            try {
                unit = size.substring(size.length() - 7);
                value = size.substring(0, size.length() - 7).trim();
                if (Integer.parseInt(value) > 0 && Integer.parseInt(value) <= 100) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            unit = size.substring(size.length() - 1);
            value = size.substring(0, size.length() - 1).trim();
            if (Integer.parseInt(value) > 0 && (unit.equalsIgnoreCase("K") || unit.equalsIgnoreCase("M") || unit.equalsIgnoreCase("G"))) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void setMaxSize(String maxSize) {
        if (this.checkMaxSize(maxSize)) {
            this.maxSize = maxSize;
        }
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    protected boolean checkMaxSize(String size) {
        if ("".equalsIgnoreCase(size)) {
            return true;
        }
        if (size.equalsIgnoreCase("NONE")) {
            return true;
        }
        try {
            String unit = size.substring(size.length() - 1);
            String value = size.substring(0, size.length() - 1).trim();
            if (Integer.parseInt(value) > 0 && (unit.equalsIgnoreCase("K") || unit.equalsIgnoreCase("M") || unit.equalsIgnoreCase("G"))) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableSpacePropertyDialogUDB dialog = new TableSpacePropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.containers;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.containers) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.containers) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof ContainerUDB) {
            ContainerUDB cont = (ContainerUDB)event.getAffected();
            if (cont.getTableSpace() != null && cont.getTableSpace() == this) {
                cont.setParent(this.containers);
                this.containers.add(cont);
            } else {
                this.containers.remove(cont);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ContainerUDB) {
                ContainerUDB cont = (ContainerUDB)event.getAffected();
                cont.addObjectListener(this);
                if (cont.getTableSpace() != null && cont.getTableSpace() == this) {
                    cont.setParent(this.containers);
                    this.containers.add(cont);
                } else {
                    this.containers.remove(cont);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof ContainerUDB) {
            ContainerUDB cont = (ContainerUDB)event.getAffected();
            this.containers.remove(cont);
            cont.removeObjectListener(this);
        }
    }

    private void addUser(String user) {
        if (!this.getUserSet().contains(user)) {
            this.getUserSet().add(user);
        }
    }

    public void recreateUserSet(String users) {
        this.getUserSet().clear();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            this.getUserSet().add(st.nextToken().trim());
        }
    }

    public void setUsers(String users) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(users);
        } else {
            this.addUser(users);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    private void addUserGroup(String group) {
        if (!this.getUserGroupSet().contains(group)) {
            this.getUserGroupSet().add(group);
        }
    }

    public void recreateUserGroupSet(String groups) {
        this.getUserGroupSet().clear();
        StringTokenizer st = new StringTokenizer(groups, ",");
        while (st.hasMoreTokens()) {
            this.getUserGroupSet().add(st.nextToken().trim());
        }
    }

    public void setGroups(String groups) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserGroupSet(groups);
        } else {
            this.addUserGroup(groups);
        }
        this.userGroups = this.getUserGroupSet().toString();
        this.fireDataFieldChange();
    }

    public String getGroups() {
        return this.userGroups;
    }

    public UserSet getUserGroupSet() {
        if (this.userGroupSet == null) {
            this.userGroupSet = new UserSet();
        }
        return this.userGroupSet;
    }

    public void clear() {
        this.getUserSet().removeAllElements();
        this.users = "";
        this.getUserGroupSet().removeAllElements();
        this.userGroups = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(TableSpaceUDB.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    public String getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(String grantOption) {
        if (grantOption != null && grantOption.equals(this.grantOption)) {
            return;
        }
        if (this.checkYesNo(grantOption)) {
            this.grantOption = grantOption;
            this.fireDataFieldChange();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("DB Definition Only", this, "getDBDefOnly", "setDBDefOnly", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("DataType", this, "getDataType", "setDataType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Managed by", this, "getManagedBy", "setManagedBy", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Auto Resize", this, "getAutoResize", "setAutoResize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Initial Size", this, "getInitialSize", "setInitialSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Increase Size", this, "getIncreaseSize", "setIncreaseSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Max Size", this, "getMaxSize", "setMaxSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Nodegroup", this, "getNodeGroup", "setNodeGroup", NodeGroupUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Page Size", this, "getPageSize", "setPageSize", Integer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Extent Size", this, "getExtentSize", "setExtentSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Prefetch Size", this, "getPrefetchSize", "setPrefetchSize", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("BufferPool", this, "getBufferPool", "setBufferPool", BufferPoolUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Overhead", this, "getOverhead", "setOverhead", Float.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Transfer Rate", this, "getTransferRate", "setTransferRate", Float.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Dropped Table Rec", this, "getDroppedTableRecovery", "setDroppedTableRecovery", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("File System Caching", this, "getFileSystemCaching", "setFileSystemCaching", Boolean.TYPE));
        }
        return this.propertyWrapperList;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TABLESPACE_ICON", 16);
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

