/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v71;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.SchemaUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;

public class IndexProxyUDBv71
extends IndexProxyUDB {
    public IndexProxyUDBv71(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyUDBv71(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)((StorageDesignUDBv71)targetDesign).getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getName());
        IndexProxyUDBv71 indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignUDBv71)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxyUDBv71)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv71 scheme = (SchemaUDBv71)((StorageDesignUDBv71)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (scheme == null) {
                    SchemaUDBv71 newScheme = (SchemaUDBv71)((StorageDesignUDBv71)targetDesign).getSchemaSet().createSchema();
                    newScheme.setName(this.getSchema().getName());
                    newScheme.setRawObject(true);
                    indexProxy.setSchema(newScheme);
                } else {
                    indexProxy.setSchema(scheme);
                }
            }
            indexProxy.setCluster(this.getCluster());
            indexProxy.setPercentageFree(this.getPercentageFree());
            indexProxy.setMinimumPercentageUsed(this.getMinimumPercentageUsed());
            indexProxy.setReverseScanSupport(this.getReverseScanSupport());
            indexProxy.recreateColumnListSet(this.getColumnSet().toString());
            indexProxy.recreateUserGroupSet(this.getUserGroupSet().toString());
            indexProxy.recreateUserSet(this.getUserSet().toString());
            indexProxy.setComment(this.getComment());
            indexProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxy.setRawObject(false);
        }
    }
}

