/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.StringTokenizer;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRGlobalPartitionListMaxColumnsOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "2EDD220F-DCA4-6102-2690-44BA9F1FABA1";

    public DRGlobalPartitionListMaxColumnsOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRGlobalPartitionListMaxColumnsOracle.SetGlobalPartitionListColumns"));
        this.setDescription(Messages.getString("DRGlobalPartitionListMaxColumnsOracle.NumberColumnsEqualOrLessThan32"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexGlobalPartitionsListOracle partitionList = (IndexGlobalPartitionsListOracle)object;
        StringTokenizer st = new StringTokenizer(partitionList.getGlobalPartColumns(), ",");
        int columnsNbr = st.countTokens();
        if (columnsNbr > 32) {
            return CheckResult.createFailed(object, this, Messages.getString("DRGlobalPartitionListMaxColumnsOracle.PartitionListContainsMoreThan32ColumnsColumnList"));
        }
        return CheckResult.createOk(object, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "2EDD220F-DCA4-6102-2690-44BA9F1FABA1";
    }
}

