/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RXMLChangeRequest
extends AbstractRXMLDesignObject {
    public RXMLChangeRequest(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        ChangeRequest request = new ChangeRequest(design.getLogicalDesign());
        request.setObjectID(StringUtilities.decodeAttributeValue(objectID));
        request.setDesign(design);
        design.getChangeRequestSet().add(request);
        design.addDesignObject(request);
        return request;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof ChangeRequest) {
            String value;
            Node textNode;
            ChangeRequest request = (ChangeRequest)desObject;
            Element valueElm = RXMLChangeRequest.getFirstChildByTagName(objInfo, "reason");
            if (valueElm != null && (textNode = valueElm.getFirstChild()) != null && (value = textNode.getNodeValue()) != null) {
                request.setReason(StringUtilities.decodeAttributeValue(value));
            }
            if ((valueElm = RXMLChangeRequest.getFirstChildByTagName(objInfo, "status")) != null && (textNode = valueElm.getFirstChild()) != null && (value = textNode.getNodeValue()) != null) {
                request.setStatus(value);
            }
            if ((valueElm = RXMLChangeRequest.getFirstChildByTagName(objInfo, "completed")) != null && (textNode = valueElm.getFirstChild()) != null && (value = textNode.getNodeValue()) != null) {
                request.setCompleted(Boolean.valueOf(value));
            }
            if ((valueElm = RXMLChangeRequest.getFirstChildByTagName(objInfo, "requestDate")) != null && (textNode = valueElm.getFirstChild()) != null && (value = textNode.getNodeValue()) != null) {
                request.setRequestDate(value);
            }
            if ((valueElm = RXMLChangeRequest.getFirstChildByTagName(objInfo, "completionDate")) != null && (textNode = valueElm.getFirstChild()) != null && (value = textNode.getNodeValue()) != null) {
                request.setCompletionDate(value);
            }
            if ((valueElm = RXMLChangeRequest.getFirstChildByTagName(objInfo, "implNote")) != null && (textNode = valueElm.getFirstChild()) != null && (value = textNode.getNodeValue()) != null) {
                request.setImplDescription(value);
            }
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/').append("changerequest");
            return buffer.toString();
        }
        return "changerequest";
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == ChangeRequest.class;
    }
}

