/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLCollectionType
extends AbstractWXMLDesignObject
implements DTConstants {
    private CollectionType collectionType = null;

    public WXMLCollectionType(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof CollectionType;
        if (result) {
            this.collectionType = (CollectionType)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.collectionType != null) {
            String designName = this.collectionType.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("datatypes").append('/');
        }
        buffer.append(this.getConfiguration().get("collectiontypePath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("collection_type", String.valueOf(collectionType.getType() != null ? collectionType.getType() : NULL_STR));
            map.put("max_element", String.valueOf(collectionType.getMaxElement()));
            map.put("datatype", StringUtilities.encodeAttributeValue(String.valueOf(collectionType.getElementType().getType().getObjectID())));
            map.put("reference", String.valueOf(collectionType.getElementType().isReference()));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

