/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.logical.TVEntityView;

public class EntityViewDiagramCell
extends ContainerDiagramCell {
    private JMenuItem miDeleteView;

    public EntityViewDiagramCell(ContainerObject container) {
        super(container);
    }

    public EntityViewDiagramCell(ContainerObject container, Map attributeMap) {
        super(container, attributeMap);
    }

    private void showProperty() {
        this.getContainer().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        if (this.isEditable() && this.selectedObjects.length == 1) {
            if (this.getTopView().canRemove()) {
                this.miDeleteView.setEnabled(true);
            } else {
                this.miDeleteView.setEnabled(false);
            }
        }
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu.removeAll();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(CREATE_SYNONYM){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewDiagramCell.this.getTopView().createViewSynonim(EntityViewDiagramCell.this.getDiagram().getAppView().getCurrentDPV());
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(CREATE_SUBVIEW_FROM_SELECTED){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewDiagramCell.this.getTopView().getDesignPartView().createSubViewFromSelected();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(CREATE_SUBVIEW_WITH_RELATED_OBJECTS){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewDiagramCell.this.getTopView().getDesignPartView().createSubViewWithRelatedObjects();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(COPY){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewDiagramCell.this.getContainer().getAppView().clearCopiedObjects();
                    EntityViewDiagramCell.this.getTopView().getDesignPartView().addSelectedToCopied();
                }
            });
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultDiagramCell.deleteObjects(EntityViewDiagramCell.this.selectedObjects, EntityViewDiagramCell.this.getDiagram().getAppView());
                    }
                });
                if (!this.getDiagram().getDesignPartView().isMainDiagram()) {
                    this.menu.add(new AbstractAction(DELETE_VIEWS){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EntityViewDiagramCell.this.getDiagram().getDesignPartView().removeTopViewsWithUndo(EntityViewDiagramCell.this.getDiagram().getSelectionCells());
                        }
                    });
                }
            } else {
                this.menu.add(new AbstractAction(DELETE_OBJECT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EntityViewDiagramCell.this.deleteView();
                    }
                });
                this.miDeleteView = this.menu.add(new AbstractAction(DELETE_VIEW){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EntityViewDiagramCell.this.getTopView().getDesignPartView().postTopViewRemove(EntityViewDiagramCell.this.getTopView());
                        ((ContainerView)EntityViewDiagramCell.this.getTopView()).remove(false);
                    }
                });
            }
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewDiagramCell.this.format();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(SEND_TO_BACK){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewDiagramCell.this.getTopView().sendToBack();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(RESIZE_TO_VISIBLE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityViewDiagramCell.this.getTopView().getDesignPartView().resizeSelectedObjects();
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(new AbstractAction(VALIDATE_SELECTED_VIEWS){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityViewDiagramCell.this.getTopView().getDesignPartView().validateViews(false);
            }
        });
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(DesignPartView.MI_PARSE_SQL){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityViewDiagramCell.this.getTopView().getDesignPartView().parseOlderStyleViews(false);
            }
        });
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(DESIGN_RULES){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityViewDiagramCell.this.showDesignRulesDialog();
            }
        });
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityViewDiagramCell.this.showProperty();
            }
        });
        return this.menu;
    }

    public void deleteView() {
        TVEntityView tvt = (TVEntityView)this.getTopView();
        ApplicationView.log(MessageFormat.format(Messages.getString("EntityViewDiagramCell.DeleteView"), tvt.getModel().getName()));
        tvt.remove();
    }

    @Override
    public void deleteSelected() {
        ((ContainerView)this.getTopView()).remove();
    }
}

