/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class CubeRenderer
extends MDDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 226, 198);
    private int MORE_ARROW_PADDING = 4;
    private int MORE_ARROW_WIDTH = 8;
    private int MORE_ARROW_HEIGHT = 8;

    public CubeRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.getMdObject().getDesign().getDesignLevelSettings().getDefaultFCObject("Cube");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.getMdObject().getDesign().getDesignLevelSettings().getDefaultFCObject("Cube");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics g) {
        Cube cube = (Cube)this.getMdObject();
        TopView efo = this.getTopView();
        if (this.detailedView) {
            int b = this.borderWidth;
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            int width = d.width - b;
            int height = d.height - b;
            int[] xps = new int[]{6, width, width, 6};
            int[] yps = new int[]{0, 0, height - 6, height - 6};
            Polygon diamond = new Polygon(xps, yps, 4);
            g2.setPaint(this.getBackgroundColor());
            g.fillPolygon(diamond);
            g.setColor(this.getBorderColor());
            g2.setStroke(new BasicStroke(b));
            g.drawPolygon(diamond);
            int[] xps2 = new int[]{0, width - 3, width - 3, 0};
            int[] yps2 = new int[]{3, 3, height - 3, height - 3};
            diamond = new Polygon(xps2, yps2, 4);
            g2.setPaint(this.getBackgroundColor());
            g.fillPolygon(diamond);
            g.setColor(this.getBorderColor());
            g.drawPolygon(diamond);
            Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
            float fontSize = titleFont.getSize2D();
            g.setFont(titleFont);
            FontMetrics fm = g.getFontMetrics();
            int colTextHeight = fm.getHeight();
            int yCursor = Math.max(colTextHeight, titleFont.getSize());
            int xCursor = (width - fm.stringWidth(this.title)) / 2;
            if (xCursor < 20) {
                xCursor = 20;
            }
            BasicStroke textStroke = new BasicStroke(1.0f);
            BasicStroke lineStroke = new BasicStroke(this.borderWidth);
            g2.setStroke(textStroke);
            g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
            g.setFont(titleFont);
            g.drawString(this.title, xCursor, yCursor);
            DesignPartView dpv = this.getDesignPartView();
            if (dpv != null && !dpv.clearDetails() && !dpv.isShowNamesOnly()) {
                if (dpv.showAllDetails() || dpv.showKeys()) {
                    g2.setStroke(lineStroke);
                    g.setColor(this.getBorderColor());
                    yCursor = (int)((double)yCursor + ((double)yCursor - (double)colTextHeight / 1.5));
                    g.drawLine(0, yCursor, width - 3, yCursor);
                    g2.setStroke(textStroke);
                    String entname = "";
                    if (cube != null) {
                        Iterator itn = cube.getFactEntities().iterator();
                        StringBuffer sb = new StringBuffer();
                        boolean firstn = true;
                        while (itn.hasNext()) {
                            ContainerObject ent = (ContainerObject)itn.next();
                            if (firstn) {
                                sb.append(ent.getName());
                                firstn = false;
                                continue;
                            }
                            sb.append(", ").append(ent.getName());
                        }
                        entname = sb.toString();
                    }
                    g.setColor(efo.getFontObject(EditableFonts.FO_FACT_ENTITIES).getColor());
                    g.setFont(efo.getFontObject(EditableFonts.FO_FACT_ENTITIES).getFont());
                    fm = g.getFontMetrics();
                    colTextHeight = fm.getHeight();
                    g.drawString(entname, 5, yCursor += fm.getMaxAscent() - fm.getMaxDescent() + 3);
                }
                if (dpv.showAllDetails() || dpv.showElements()) {
                    Object[] links;
                    int i;
                    g.setColor(this.getBorderColor());
                    g2.setStroke(lineStroke);
                    g.drawLine(0, yCursor += fm.getMaxDescent(), width - 3, yCursor);
                    Object[] elements = cube.getMeasures().toArray();
                    String longestName = "";
                    for (i = 0; i < elements.length; ++i) {
                        String n = ((Measure)elements[i]).getName();
                        if (n.length() <= longestName.length()) continue;
                        longestName = n;
                    }
                    fontSize = efo.getFontObject(EditableFonts.FO_MEASURE).getFont().getSize2D();
                    g.setFont(efo.getFontObject(EditableFonts.FO_MEASURE).getFont().deriveFont(fontSize));
                    fm = g.getFontMetrics();
                    colTextHeight = fm.getHeight();
                    for (i = 0; i < elements.length; ++i) {
                        if ((yCursor += fm.getHeight()) > height - 3) {
                            g.setColor(this.getBorderColor());
                            int right = width - this.MORE_ARROW_PADDING;
                            int left = right - this.MORE_ARROW_WIDTH;
                            int center = right - this.MORE_ARROW_WIDTH / 2;
                            int bottom = height - this.MORE_ARROW_PADDING;
                            int top = bottom - this.MORE_ARROW_HEIGHT;
                            int[] xPts = new int[]{center, left, right};
                            int[] yPts = new int[]{bottom, top, top};
                            g.fillPolygon(xPts, yPts, 3);
                            break;
                        }
                        Measure measure = (Measure)elements[i];
                        g2.setStroke(textStroke);
                        g.setColor(efo.getFontObject(EditableFonts.FO_MEASURE_TYPE).getColor());
                        g.setFont(efo.getFontObject(EditableFonts.FO_MEASURE_TYPE).getFont().deriveFont(fontSize));
                        String type = measure.isFormula() ? "FX" : "A ";
                        g.drawString(type, 5, yCursor);
                        fm = g.getFontMetrics();
                        int anLeft = fm.stringWidth("FX") + 10;
                        g.setColor(efo.getFontObject(EditableFonts.FO_MEASURE).getColor());
                        g.setFont(efo.getFontObject(EditableFonts.FO_MEASURE).getFont().deriveFont(fontSize));
                        g.drawString(measure.getName(), anLeft, yCursor);
                        fm = g.getFontMetrics();
                        anLeft += fm.stringWidth(longestName) + 20;
                        if (measure.getDefaultAggregationFunction() != null) {
                            g.setColor(efo.getFontObject(EditableFonts.FO_FUNCTION).getColor());
                            g.setFont(efo.getFontObject(EditableFonts.FO_FUNCTION).getFont().deriveFont(fontSize));
                            int l = measure.getDefaultAggregationFunction().name.length();
                            l = Math.min(l, 5);
                            String function = measure.getDefaultAggregationFunction().name.substring(0, l);
                            if (measure.getDefaultAggregationFunction().name.length() > 0) {
                                g.drawString(function, anLeft, yCursor);
                            }
                        }
                        fm = g.getFontMetrics();
                        anLeft += fm.stringWidth("MMMMM");
                        if (!measure.isFormula() || measure.getFormula() == null) continue;
                        g.setColor(efo.getFontObject(EditableFonts.FO_FORMULA).getColor());
                        g.setFont(efo.getFontObject(EditableFonts.FO_FORMULA).getFont().deriveFont(fontSize));
                        g.drawString(measure.getFormula(), anLeft, yCursor);
                    }
                    if ((links = cube.getOutgoingLinks().toArray()).length > 0) {
                        int i2;
                        boolean hasAttributes = false;
                        for (i2 = 0; i2 < links.length; ++i2) {
                            Link link = (Link)links[i2];
                            if (link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                            hasAttributes = true;
                            break;
                        }
                        if (hasAttributes) {
                            elements = cube.getAllJoinAttributes().toArray();
                            for (i2 = 0; i2 < elements.length; ++i2) {
                                String n = ((DesignObject)elements[i2]).getName();
                                if (n.length() <= longestName.length()) continue;
                                longestName = n;
                            }
                            g.setColor(this.getBorderColor());
                            g2.setStroke(lineStroke);
                            yCursor += yCursor / 16;
                            g.drawLine(0, yCursor, width - 2, yCursor);
                            block5: for (i2 = 0; i2 < links.length; ++i2) {
                                int j;
                                RollupLink rlink = ((Link)links[i2]).getRollupLink();
                                oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)((Link)links[i2]).getTargetMDObject();
                                Object[] attributes = rlink.getChildToParentAttributes().toArray();
                                longestName = "";
                                for (j = 0; j < attributes.length; ++j) {
                                    String n = ((ContainedObject)attributes[j]).getName();
                                    if (n.length() <= longestName.length()) continue;
                                    longestName = n;
                                }
                                for (j = 0; j < attributes.length; ++j) {
                                    fontSize = efo.getFontObject(EditableFonts.FO_CHILD_TO_PARENT).getFont().getSize2D();
                                    g.setColor(efo.getFontObject(EditableFonts.FO_MEASURE_TYPE).getColor());
                                    g.setFont(efo.getFontObject(EditableFonts.FO_MEASURE_TYPE).getFont().deriveFont(fontSize));
                                    fm = g.getFontMetrics();
                                    if ((yCursor += fm.getMaxDescent() + fm.getMaxAscent()) > height - 3) {
                                        g.setColor(this.getBorderColor());
                                        int right = width - this.MORE_ARROW_PADDING;
                                        int left = right - this.MORE_ARROW_WIDTH;
                                        int center = right - this.MORE_ARROW_WIDTH / 2;
                                        int bottom = height - this.MORE_ARROW_PADDING;
                                        int top = bottom - this.MORE_ARROW_HEIGHT;
                                        int[] xPts = new int[]{center, left, right};
                                        int[] yPts = new int[]{bottom, top, top};
                                        g.fillPolygon(xPts, yPts, 3);
                                        continue block5;
                                    }
                                    ContainedObject attr = (ContainedObject)attributes[j];
                                    g2.setStroke(textStroke);
                                    g.drawString("R", 5, yCursor);
                                    g.setColor(efo.getFontObject(EditableFonts.FO_CHILD_TO_PARENT).getColor());
                                    g.setFont(efo.getFontObject(EditableFonts.FO_CHILD_TO_PARENT).getFont());
                                    fm = g.getFontMetrics();
                                    int anLeft = fm.stringWidth("FX") + 10;
                                    g.drawString(attr.getName(), anLeft, yCursor);
                                    anLeft += fm.stringWidth(longestName) + 10;
                                    g.setColor(efo.getFontObject(EditableFonts.FO_FUNCTION).getColor());
                                    g.setFont(efo.getFontObject(EditableFonts.FO_FUNCTION).getFont().deriveFont(fontSize));
                                    fm = g.getFontMetrics();
                                    if (rlink.isRolePlaying()) {
                                        g.drawString(rlink.getName(), anLeft, yCursor);
                                        continue;
                                    }
                                    g.drawString(dim.getName(), anLeft, yCursor);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            int b = this.borderWidth;
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            int width = d.width - b;
            int height = d.height - b;
            int[] xps = new int[]{6, width, width, 6};
            int[] yps = new int[]{0, 0, height - 6, height - 6};
            Polygon diamond = new Polygon(xps, yps, 4);
            g.setColor(this.getBackgroundColor());
            g.fillPolygon(diamond);
            g.setColor(this.getBorderColor());
            g2.setStroke(new BasicStroke(b));
            g.drawPolygon(diamond);
            int[] xps2 = new int[]{0, width - 3, width - 3, 0};
            int[] yps2 = new int[]{3, 3, height - 3, height - 3};
            diamond = new Polygon(xps2, yps2, 4);
            g2.setPaint(this.getBackgroundColor());
            g.fillPolygon(diamond);
            g.setColor(this.getBorderColor());
            g.drawPolygon(diamond);
            Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
            g.setFont(titleFont);
            FontMetrics fm = g.getFontMetrics();
            int yCursor = width / 2 + 8;
            int xCursor = (width - fm.stringWidth(this.title)) / 2;
            if (xCursor < 20) {
                xCursor = 20;
            }
            BasicStroke textStroke = new BasicStroke(1.0f);
            g2.setStroke(textStroke);
            g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
            g.drawString(this.title, xCursor, yCursor);
        }
    }
}

