/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectDesignsDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private Design result = null;
    private JButton bnOK;
    private ApplicationView appView;
    private JComboBox cbDesigns;
    private JLabel jlabel;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectDesignsDialog.this.dispose();
        }
    };

    public SelectDesignsDialog(ApplicationView appView) {
        super(appView.getFrame(), Messages.getString("SelectDesignsDialog.SelectDesign"), true);
        this.appView = appView;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setResizable(false);
        this.updateLabel();
        CommonUtil.centerOnScreen(this);
    }

    private JPanel init() {
        JPanel jpanel = new JPanel();
        JPanel jpMain = new JPanel(new BorderLayout());
        jpMain.setPreferredSize(new Dimension(280, 70));
        jpMain.add((Component)this.initDesignList(), "North");
        jpanel.add(jpMain);
        return jpanel;
    }

    private JPanel initDesignList() {
        JPanel jpanel = new JPanel(new BorderLayout(5, 5));
        JLabel label = new JLabel(Messages.getString("SelectDesignsDialog.SelectDesign"));
        jpanel.add((Component)label, "North");
        this.cbDesigns = new JComboBox<Object>(this.appView.getDesigns().toArray());
        jpanel.add((Component)this.cbDesigns, "Center");
        this.jlabel = new JLabel();
        jpanel.add((Component)this.jlabel, "South");
        this.cbDesigns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDesignsDialog.this.updateLabel();
            }
        });
        return jpanel;
    }

    private void updateLabel() {
        Design design = (Design)this.cbDesigns.getSelectedItem();
        if (design != null) {
            this.jlabel.setText(FileUtils.longToShortPath(design.getStoragePath(), 50));
        } else {
            this.jlabel.setText("");
        }
    }

    public JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(Messages.getString("AbstractEditorConstants.OK"));
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDesignsDialog.this.result = (Design)SelectDesignsDialog.this.cbDesigns.getSelectedItem();
                if (SelectDesignsDialog.this.result != null) {
                    SelectDesignsDialog.this.appView.setCurrentDesign(SelectDesignsDialog.this.result);
                }
                SelectDesignsDialog.this.dispose();
            }
        });
        this.bnOK.setEnabled(this.cbDesigns.getSelectedItem() != null);
        this.getRootPane().setDefaultButton(this.bnOK);
        bottomPanel.add(this.bnOK);
        JButton bnCancel = new JButton(Messages.getString("AbstractEditor.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectDesignsDialog.this.result = null;
                SelectDesignsDialog.this.dispose();
            }
        });
        bottomPanel.add(bnCancel);
        return bottomPanel;
    }

    public Design getResult() {
        return this.result;
    }

    public static Design showDialog(ApplicationView appView) {
        SelectDesignsDialog dialog = new SelectDesignsDialog(appView);
        dialog.setVisible(true);
        return dialog.getResult();
    }
}

