/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StructuredTypeProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StructuredTypePropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private StructuredTypeProxyOraclev9i type;
    private JComboBox cbOwner;
    private JComboBox cbInvokerRights;
    private JComboBox cbMapOrderFunction;
    private JComboBox cbMapOrderType;
    private JTextField tfSuperType;
    private JComboBox cbFinal;
    private JComboBox cbInstantiable;
    private JComboBox cbMapToJavaClass;
    private JTextField tfJavaClass;
    private JComboBox cbJavaInstance;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public StructuredTypePropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.type = (StructuredTypeProxyOraclev9i)object;
        this.setHeight(410);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StructuredTypePropertyDialogOracle.StructuredTypeProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initInvokerRights();
        this.initMapOrderFunction();
        this.initMapOrderType();
        this.initSuperType();
        this.initFinal();
        this.initInstantiable();
        this.initMapToJavaClass();
        this.initJavaClass();
        this.initJavaInstance();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox<Object>(this.getStorageDesign().getUserSet().toArray());
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initInvokerRights() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.InvokerRights"));
        this.general.add(label);
        this.cbInvokerRights = new JComboBox<String>(StructuredTypeProxyOracle.getInvokerRightChoices());
        this.setBG(this.cbInvokerRights);
        this.cbInvokerRights.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInvokerRights);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbInvokerRights, 80);
    }

    private void initMapOrderFunction() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.MapOrderFunction"));
        this.general.add(label);
        this.cbMapOrderFunction = new JComboBox();
        this.setBG(this.cbMapOrderFunction);
        this.cbMapOrderFunction.setPreferredSize(this.tfName.getPreferredSize());
        this.cbMapOrderFunction.addActionListener(new MapOrderListener());
        this.general.add(this.cbMapOrderFunction);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbMapOrderFunction, 110);
    }

    private void initMapOrderType() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.MapOrderType"));
        this.general.add(label);
        this.cbMapOrderType = new JComboBox<String>(StructuredTypeProxyOracle.getMapOrderChoices());
        this.setBG(this.cbMapOrderType);
        this.cbMapOrderType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbMapOrderType);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbMapOrderType, 140);
    }

    private void initSuperType() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.SuperType"));
        this.general.add(label);
        this.tfSuperType = new JTextField("", 26);
        this.tfSuperType.setEnabled(false);
        this.general.add(this.tfSuperType);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfSuperType, 170);
    }

    private void initFinal() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.Final"));
        this.general.add(label);
        this.cbFinal = new JComboBox<String>(YES_NO);
        this.setBG(this.cbFinal);
        this.cbFinal.setPreferredSize(this.tfName.getPreferredSize());
        this.cbFinal.setEnabled(false);
        this.general.add(this.cbFinal);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbFinal, 200);
    }

    private void initInstantiable() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.Instantiable"));
        this.general.add(label);
        this.cbInstantiable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbInstantiable);
        this.cbInstantiable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbInstantiable.setEnabled(false);
        this.general.add(this.cbInstantiable);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbInstantiable, 230);
    }

    private void initMapToJavaClass() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.MapToJavaClass"));
        this.general.add(label);
        this.cbMapToJavaClass = new JComboBox<String>(YES_NO);
        this.setBG(this.cbMapToJavaClass);
        this.cbMapToJavaClass.setPreferredSize(this.tfName.getPreferredSize());
        this.cbMapToJavaClass.addActionListener(new MapToJavaListener());
        this.general.add(this.cbMapToJavaClass);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbMapToJavaClass, 260);
    }

    private void initJavaClass() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.JavaClass"));
        this.general.add(label);
        this.tfJavaClass = new JTextField("", 26);
        this.general.add(this.tfJavaClass);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.tfJavaClass, 290);
    }

    private void initJavaInstance() {
        JLabel label = new JLabel(Messages.getString("StructuredTypePropertyDialogOracle.JavaInstance"));
        this.general.add(label);
        this.cbJavaInstance = new JComboBox<String>(StructuredTypeProxyOraclev9i.JAVA_INSTANCES);
        this.setBG(this.cbJavaInstance);
        this.cbJavaInstance.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbJavaInstance);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbJavaInstance, 320);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.type.getName());
        this.tfName.setText(this.type.getName());
        this.cbOwner.setSelectedItem(this.type.getOwner());
        this.cbOwner.setEnabled(!this.type.getStructuredType().isNullInstance());
        this.cbInvokerRights.setSelectedItem(this.type.getInvokerRights());
        MethodProxyOracle currentMapOrderFunction = this.type.getMapOrderFunction();
        this.cbMapOrderFunction.addItem(null);
        for (MethodProxyOracle methodProxy : this.type.getMethods()) {
            if (methodProxy.getMethod().getReturnValue() == null && methodProxy != currentMapOrderFunction) continue;
            this.cbMapOrderFunction.addItem(methodProxy);
        }
        this.cbMapOrderFunction.setSelectedItem(currentMapOrderFunction);
        this.cbMapOrderType.setSelectedItem(this.type.getMapOrderType());
        this.tfSuperType.setText(this.type.getSuperType());
        this.cbFinal.setSelectedItem(StructuredTypePropertyDialogOraclev9i.translateYesNoForDisplay(this.type.getFinal()));
        this.cbInstantiable.setSelectedItem(StructuredTypePropertyDialogOraclev9i.translateYesNoForDisplay(this.type.getInstantiable()));
        this.cbMapToJavaClass.setSelectedItem(StructuredTypePropertyDialogOraclev9i.translateYesNoForDisplay(this.type.getMapToJavaClass()));
        this.tfJavaClass.setText(this.type.getJavaClass());
        this.cbJavaInstance.setSelectedItem(this.type.getJavaInstanceUsing());
        if (((StructuredType)this.type.getObject()).getParentType() != null) {
            this.cbMapOrderFunction.setEnabled(false);
        } else {
            this.cbMapOrderFunction.setEnabled(true);
        }
        if (this.type.getMapOrderFunction() != null) {
            this.cbMapOrderType.setEnabled(true);
        } else {
            this.cbMapOrderType.setEnabled(false);
        }
        String selected = this.type.getMapToJavaClass();
        if ("YES".equalsIgnoreCase(selected)) {
            this.tfJavaClass.setEnabled(true);
            this.cbJavaInstance.setEnabled(true);
        } else {
            this.tfJavaClass.setEnabled(false);
            this.cbJavaInstance.setEnabled(false);
        }
        this.getCommentsList().insert(this.type.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.type != null) {
            this.type.setName(this.tfName.getText());
            this.type.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            this.type.setInvokerRights((String)this.cbInvokerRights.getSelectedItem());
            this.type.setMapOrderFunction((MethodProxyOracle)this.cbMapOrderFunction.getSelectedItem());
            this.type.setMapOrderType((String)this.cbMapOrderType.getSelectedItem());
            this.type.setMapToJavaClass(StructuredTypePropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbMapToJavaClass.getSelectedItem()));
            this.type.setJavaClass(this.tfJavaClass.getText());
            this.type.setJavaInstanceUsing((String)this.cbJavaInstance.getSelectedItem());
            this.type.setComment(this.getCommentsList().getText());
        }
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("StructuredTypePropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 350);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StructuredTypePropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(StructuredTypePropertyDialogOraclev9i.this.getAppView(), StructuredTypePropertyDialogOraclev9i.this.getStorageDesign(), StructuredTypePropertyDialogOraclev9i.this.type);
            StructuredTypePropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }

    class MapToJavaListener
    implements ActionListener {
        MapToJavaListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selected = (String)StructuredTypePropertyDialogOraclev9i.this.cbMapToJavaClass.getSelectedItem();
            if (AbstractPropertyDialog.YES.equalsIgnoreCase(selected)) {
                StructuredTypePropertyDialogOraclev9i.this.tfJavaClass.setEnabled(true);
                StructuredTypePropertyDialogOraclev9i.this.cbJavaInstance.setEnabled(true);
            } else {
                StructuredTypePropertyDialogOraclev9i.this.tfJavaClass.setEnabled(false);
                StructuredTypePropertyDialogOraclev9i.this.cbJavaInstance.setEnabled(false);
            }
        }
    }

    class MapOrderListener
    implements ActionListener {
        MapOrderListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StructuredTypePropertyDialogOraclev9i.this.cbMapOrderFunction.getSelectedItem() != null) {
                StructuredTypePropertyDialogOraclev9i.this.cbMapOrderType.setEnabled(true);
            } else {
                StructuredTypePropertyDialogOraclev9i.this.cbMapOrderType.setEnabled(false);
            }
        }
    }
}

