/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class DatabasePropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private DataBaseUDB database;
    private JComboBox cbAutomaticStorage;
    private JTextField tfOnPath;
    private JTextField tfDBPathOn;
    private JTextField tfAlias;
    private JTextField tfCodeSet;
    private JTextField tfTerritory;
    private JComboBox cbCollatingSeq;
    private JIntegerField ifNumSegs;
    private JIntegerField ifDefExtentSize;
    private JComboBox cbCatalogTS;
    private JComboBox cbUserTS;
    private JComboBox cbTempTS;

    public DatabasePropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.database = (DataBaseUDB)object;
        this.setHeight(440);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DatabasePropertyDialogUDB.DatabaseProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAutomaticStorage();
        this.initOnPath();
        this.initAlias();
        this.initCodeSet();
        this.initTerritory();
        this.initCollatingSeq();
        this.initNumSegs();
        this.initDiffExtentSize();
        this.initCatalogTableSpace();
        this.initUserTableSpace();
        this.initTempTableSpace();
    }

    private void initAutomaticStorage() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDB.AutomaticStorage"));
        this.general.add(label);
        this.cbAutomaticStorage = new JComboBox<String>(DataBaseUDB.getAutomaticStorageChoices());
        this.setBG(this.cbAutomaticStorage);
        this.cbAutomaticStorage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutomaticStorage);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbAutomaticStorage, 50);
    }

    private void initOnPath() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDB.OnPath"));
        this.general.add(label);
        this.tfOnPath = new JTextField("", 26);
        this.general.add(this.tfOnPath);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfOnPath, 80);
        label = new JLabel(Messages.getString("DatabasePropertyDialogUDB.DBPathOn"));
        this.general.add(label);
        this.tfDBPathOn = new JTextField("", 26);
        this.general.add(this.tfDBPathOn);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfDBPathOn, 110);
    }

    private void initAlias() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDB.Alias"));
        this.general.add(label);
        this.tfAlias = new JTextField("", 26);
        this.general.add(this.tfAlias);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.tfAlias, 140);
    }

    private void initCodeSet() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDB.CodeSet"));
        this.general.add(label);
        this.tfCodeSet = new JTextField("", 26);
        this.general.add(this.tfCodeSet);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfCodeSet, 170);
    }

    private void initTerritory() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDB.Territory"));
        this.general.add(label);
        this.tfTerritory = new JTextField("", 26);
        this.general.add(this.tfTerritory);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfTerritory, 200);
    }

    private void initCollatingSeq() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDB.CollatingSequence"));
        this.general.add(label);
        this.cbCollatingSeq = new JComboBox<String>(DataBaseUDB.getAvailableCollatingSequences());
        this.setBG(this.cbCollatingSeq);
        this.cbCollatingSeq.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCollatingSeq);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbCollatingSeq, 230);
    }

    private void initNumSegs() {
        JLabel label = new JLabel("NUMSEGS:");
        this.general.add(label);
        this.ifNumSegs = new JIntegerField(0, 26);
        this.general.add(this.ifNumSegs);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.ifNumSegs, 260);
    }

    private void initDiffExtentSize() {
        JLabel label = new JLabel(Messages.getString("DatabasePropertyDialogUDB.DftExtentSize"));
        this.general.add(label);
        this.ifDefExtentSize = new JIntegerField(0, 26);
        this.general.add(this.ifDefExtentSize);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.ifDefExtentSize, 290);
    }

    private void initCatalogTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("DatabasePropertyDialogUDB.CtlgTableSpace"));
        this.general.add(lbTableSpace);
        this.cbCatalogTS = new JComboBox();
        this.setBG(this.cbCatalogTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbCatalogTS);
        }
        this.cbCatalogTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCatalogTS);
        this.setLabelConstraints(lbTableSpace, 320);
        this.setObjectConstraints(this.cbCatalogTS, 320);
    }

    private void initUserTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("DatabasePropertyDialogUDB.UserTableSpace"));
        this.general.add(lbTableSpace);
        this.cbUserTS = new JComboBox();
        this.setBG(this.cbUserTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbUserTS);
        }
        this.cbUserTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUserTS);
        this.setLabelConstraints(lbTableSpace, 350);
        this.setObjectConstraints(this.cbUserTS, 350);
    }

    private void initTempTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("DatabasePropertyDialogUDB.TempTableSpace"));
        this.general.add(lbTableSpace);
        this.cbTempTS = new JComboBox();
        this.setBG(this.cbTempTS);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTempTS);
        }
        this.cbTempTS.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTempTS);
        this.setLabelConstraints(lbTableSpace, 380);
        this.setObjectConstraints(this.cbTempTS, 380);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.database.getName());
        this.tfName.setText(this.database.getName());
        this.cbAutomaticStorage.setSelectedItem(this.database.getAutomaticStorage());
        this.tfOnPath.setText(this.database.getOnPath());
        this.tfDBPathOn.setText(this.database.getDBPathOn());
        this.tfAlias.setText(this.database.getAlias());
        this.tfCodeSet.setText(this.database.getCodeSet());
        this.tfTerritory.setText(this.database.getTerritory());
        this.cbCollatingSeq.setSelectedItem(this.database.getCollatingSequence());
        this.ifNumSegs.setValue((long)this.database.getSegmentNumber());
        this.ifDefExtentSize.setValue((long)this.database.getDefaultExtentSize());
        this.cbCatalogTS.setSelectedItem(this.database.getCatalogTableSpace());
        this.cbUserTS.setSelectedItem(this.database.getUserTableSpace());
        this.cbTempTS.setSelectedItem(this.database.getTemporaryTableSpace());
        this.getCommentsList().insert(this.database.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.database != null) {
            this.database.setName(this.tfName.getText());
            this.database.setAutomaticStorage((String)this.cbAutomaticStorage.getSelectedItem());
            this.database.setOnPath(this.tfOnPath.getText());
            this.database.setDBPathOn(this.tfDBPathOn.getText());
            this.database.setAlias(this.tfAlias.getText());
            this.database.setCodeSet(this.tfCodeSet.getText());
            this.database.setTerritory(this.tfTerritory.getText());
            this.database.setCollatingSequence((String)this.cbCollatingSeq.getSelectedItem());
            this.database.setSegmentNumber(this.ifNumSegs.getIntValue());
            this.database.setDefaultExtentSize(this.ifDefExtentSize.getIntValue());
            Object selected = this.cbCatalogTS.getSelectedItem();
            if (selected instanceof TableSpaceUDB) {
                this.database.setCatalogTableSpace((TableSpaceUDB)selected);
            } else {
                this.database.setCatalogTableSpace(null);
            }
            selected = this.cbUserTS.getSelectedItem();
            if (selected instanceof TableSpaceUDB) {
                this.database.setUserTableSpace((TableSpaceUDB)selected);
            } else {
                this.database.setUserTableSpace(null);
            }
            selected = this.cbTempTS.getSelectedItem();
            if (selected instanceof TableSpaceUDB) {
                this.database.setTemporaryTableSpace((TableSpaceUDB)selected);
            } else {
                this.database.setTemporaryTableSpace(null);
            }
            this.database.setComment(this.getCommentsList().getText());
        }
    }
}

