/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.SequenceUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.udb.ColumnsPermissionsDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PermissionsPropertyDialogUDB
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("PermissionsPropertyDialogUDB.Edit");
    private static String COLUMN_CHECKED = "c";
    private StorageObject storageObject;
    private JPanel objectsPanel;
    private OwnerSetUDB usersSet;
    private UserGroupSetUDB groupsSet;
    private ApplicationView appView;
    private StorageDesignUDB storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private ColumnsPermissionsDialogUDB dialog;
    private UsersTable usersTable;
    private GroupsTable groupsTable;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertyDialogUDB.this.bnCancel.doClick();
        }
    };

    public PermissionsPropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view.getFrame());
        this.appView = view;
        this.storageDesign = (StorageDesignUDB)storageDesign;
        this.storageObject = object;
        this.setResizable(false);
        this.storageObject.setDialogVisible(true, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PermissionsPropertyDialogUDB.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel bottomPanel = new JPanel();
        if (this.isEditable()) {
            if (this.storageObject instanceof TableProxyUDB) {
                JButton bnColumns = new JButton(Messages.getString("PermissionsPropertyDialogUDB.Columns"));
                bnColumns.addActionListener(new ColumnsPermissionsListener(this));
                bnColumns.setCursor(Cursor.getPredefinedCursor(12));
                bnColumns.setMnemonic(79);
                bottomPanel.add((Component)bnColumns, "Before");
            }
            JButton bnOK = new JButton(Messages.getString("PermissionsPropertyDialogUDB.OK"));
            bnOK.addActionListener(new OKAction());
            bnOK.setMnemonic(79);
            bottomPanel.add(bnOK);
            this.getRootPane().setDefaultButton(bnOK);
            JButton bnApply = new JButton(Messages.getString("PermissionsPropertyDialogUDB.Apply"));
            bnApply.addActionListener(new ApplyAction());
            bnApply.setMnemonic(65);
            bottomPanel.add(bnApply);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("PermissionsPropertyDialogUDB.Cancel") : Messages.getString("PermissionsPropertyDialogUDB.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escape);
        bottomPanel.add(this.bnCancel);
        this.jpanel.add((Component)bottomPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.addTabs();
        this.initProperties();
        this.setModal(true);
    }

    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    public void initProperties() {
        PermissionsUDB perm;
        int k;
        int i;
        for (i = 0; i < this.usersTable.getRowCount(); ++i) {
            OwnerUDB user = (OwnerUDB)this.usersTable.getValueAt(i, 0);
            for (k = 0; k < this.usersTable.getColumnCount(); ++k) {
                if (!(this.usersTable.getValueAt(i, k) instanceof JButton)) continue;
                JButton button = (JButton)this.usersTable.getValueAt(i, k);
                perm = this.getPermission(user, this.storageObject);
                if (perm != null) {
                    if (perm.getPrivileges().indexOf(this.usersTable.getColumnName(k)) > -1) {
                        button.setText(CHECKED);
                        button.updateUI();
                        continue;
                    }
                    if (perm.getPrivilegesWithGrantOption().indexOf(this.usersTable.getColumnName(k)) > -1) {
                        button.setText(CHECKED_WITH_GRANT_OPTION);
                        button.updateUI();
                        continue;
                    }
                    if (perm.hasColPrivilege(this.usersTable.getColumnName(k))) {
                        button.setText(COLUMN_CHECKED);
                        button.updateUI();
                        continue;
                    }
                    button.setText(EMPTY_VALUE);
                    button.updateUI();
                    continue;
                }
                button.setText(EMPTY_VALUE);
                button.updateUI();
            }
        }
        for (i = 0; i < this.groupsTable.getRowCount(); ++i) {
            UserGroupUDB group = (UserGroupUDB)this.groupsTable.getValueAt(i, 0);
            for (k = 0; k < this.groupsTable.getColumnCount(); ++k) {
                if (!(this.groupsTable.getValueAt(i, k) instanceof JButton)) continue;
                JButton btn = (JButton)this.groupsTable.getValueAt(i, k);
                perm = this.getPermission(group, this.storageObject);
                if (perm != null) {
                    if (perm.getPrivileges().indexOf(this.groupsTable.getColumnName(k)) > -1) {
                        btn.setText(CHECKED);
                        btn.updateUI();
                        continue;
                    }
                    if (perm.getPrivilegesWithGrantOption().indexOf(this.groupsTable.getColumnName(k)) > -1) {
                        btn.setText(CHECKED_WITH_GRANT_OPTION);
                        btn.updateUI();
                        continue;
                    }
                    if (perm.hasColPrivilege(this.groupsTable.getColumnName(k))) {
                        btn.setText(COLUMN_CHECKED);
                        btn.updateUI();
                        continue;
                    }
                    btn.setText(EMPTY_VALUE);
                    btn.updateUI();
                    continue;
                }
                btn.setText(EMPTY_VALUE);
                btn.updateUI();
            }
        }
    }

    protected void addTabs() {
        this.initUsersTable();
        this.initGroupsTable();
    }

    private void initGroupsTable() {
        this.groupsSet = this.storageDesign.getUserGroupSet();
        this.groupsTable = new GroupsTable();
        this.groupsTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.groupsTable);
        scrollpane.setPreferredSize(new Dimension(800, 280));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertyDialogUDB.UserGroups"), this.objectsPanel);
        this.groupsTable.updateUI();
        GroupsModel tableModel = (GroupsModel)this.groupsTable.getModel();
        for (int i = 0; i < this.groupsSet.size(); ++i) {
            UserGroupUDB group = (UserGroupUDB)this.groupsSet.getElement(i);
            String[] list = new String[]{EMPTY_VALUE};
            if (this.storageObject instanceof TableProxyUDB) {
                list = (String[])PermissionsUDB.getTablePermissionsValues().toArray();
            } else if (this.storageObject instanceof TableViewProxyUDB) {
                list = (String[])PermissionsUDB.getViewPermissionsValues().toArray();
            } else if (this.storageObject instanceof SequenceUDB) {
                list = (String[])PermissionsUDB.getSequencePermissionsValues().toArray();
            }
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(group);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initUsersTable() {
        this.usersTable = new UsersTable();
        this.usersTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.usersTable);
        scrollpane.setPreferredSize(new Dimension(800, 280));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(scrollpane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertyDialogUDB.Users"), this.objectsPanel);
        this.usersTable.updateUI();
        UsersModel tableModel = (UsersModel)this.usersTable.getModel();
        for (int i = 0; i < this.storageDesign.getOwnerSet().size(); ++i) {
            OwnerUDB user = (OwnerUDB)this.storageDesign.getOwnerSet().getElement(i);
            String[] list = new String[]{EMPTY_VALUE};
            if (this.storageObject instanceof TableProxyUDB) {
                list = (String[])PermissionsUDB.getTablePermissionsValues().toArray();
            } else if (this.storageObject instanceof TableViewProxyUDB) {
                list = (String[])PermissionsUDB.getViewPermissionsValues().toArray();
            } else if (this.storageObject instanceof SequenceUDB) {
                list = (String[])PermissionsUDB.getSequencePermissionsValues().toArray();
            }
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(user);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    protected void setProperties() {
        JButton button;
        int k;
        PermissionsUDB perm;
        int i;
        for (i = 0; i < this.usersTable.getRowCount(); ++i) {
            OwnerUDB user = (OwnerUDB)this.usersTable.getValueAt(i, 0);
            perm = this.getPermission(user, this.storageObject);
            if (this.hasSelectedUserPrivileges(i)) {
                if (user.getObjectID().equals("OWNER_IMPLICIT") || user.getObjectID().equals("PUBLIC")) {
                    user.setIsNullInstance(false);
                }
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setUser(user);
                    if (this.storageObject instanceof TableProxyUDB) {
                        perm.setTable((TableProxyUDB)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxyUDB) {
                        perm.setView((TableViewProxyUDB)this.storageObject);
                    } else if (this.storageObject instanceof SequenceUDB) {
                        perm.setSequence((SequenceUDB)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.usersTable.getColumnCount(); ++k) {
                    if (!(this.usersTable.getValueAt(i, k) instanceof JButton)) continue;
                    button = (JButton)this.usersTable.getValueAt(i, k);
                    if (button.getText().equals(CHECKED)) {
                        perm.setPrivileges(this.usersTable.getColumnName(k));
                        continue;
                    }
                    if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    perm.setPrivilegesWithGrantOption(this.usersTable.getColumnName(k));
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
        for (i = 0; i < this.groupsTable.getRowCount(); ++i) {
            UserGroupUDB group = (UserGroupUDB)this.groupsTable.getValueAt(i, 0);
            perm = this.getPermission(group, this.storageObject);
            if (this.hasSelectedGroupPrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setGroup(group);
                    if (this.storageObject instanceof TableProxyUDB) {
                        perm.setTable((TableProxyUDB)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxyUDB) {
                        perm.setView((TableViewProxyUDB)this.storageObject);
                    } else if (this.storageObject instanceof SequenceUDB) {
                        perm.setSequence((SequenceUDB)this.storageObject);
                    }
                }
                perm.clear();
                for (k = 0; k < this.groupsTable.getColumnCount(); ++k) {
                    if (!(this.groupsTable.getValueAt(i, k) instanceof JButton)) continue;
                    button = (JButton)this.groupsTable.getValueAt(i, k);
                    if (button.getText().equals(CHECKED)) {
                        perm.setPrivileges(this.groupsTable.getColumnName(k));
                        continue;
                    }
                    if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    perm.setPrivilegesWithGrantOption(this.groupsTable.getColumnName(k));
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
    }

    public String getCaption() {
        return Messages.getString("PermissionsPropertyDialogUDB.Permissions");
    }

    public OwnerSetUDB getUsersSet() {
        return this.usersSet;
    }

    private PermissionsUDB getPermission(StorageObject user, StorageObject proxy) {
        for (PermissionsUDB perm : this.storageDesign.getPermissionsSet()) {
            if (perm.getUser() != user && perm.getGroup() != user || perm.getTable() != proxy && perm.getView() != proxy && perm.getSequence() != proxy) continue;
            return perm;
        }
        return null;
    }

    private boolean hasSelectedUserPrivileges(int row) {
        for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
            if (!(this.usersTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.usersTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (button.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!button.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedGroupPrivileges(int row) {
        for (int k = 1; k < this.groupsTable.getColumnCount(); ++k) {
            if (!(this.groupsTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.groupsTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (button.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!button.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    public void setColumnPermissions(StorageObject user, String priv) {
        block5: {
            int row;
            block4: {
                row = 0;
                if (!(user instanceof OwnerUDB)) break block4;
                for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
                    if (this.usersTable.getValueAt(i, 0) != user) continue;
                    row = i;
                    break;
                }
                for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(k).equalsIgnoreCase(priv)) continue;
                    JButton button = (JButton)this.usersTable.getValueAt(row, k);
                    button.setText(COLUMN_CHECKED);
                    this.usersTable.updateUI();
                }
                break block5;
            }
            if (!(user instanceof UserGroupUDB)) break block5;
            for (int i = 0; i < this.groupsTable.getRowCount(); ++i) {
                if (this.groupsTable.getValueAt(i, 0) != user) continue;
                row = i;
                break;
            }
            for (int k = 1; k < this.groupsTable.getColumnCount(); ++k) {
                if (!((GroupsModel)this.groupsTable.getModel()).getColumnName(k).equalsIgnoreCase(priv)) continue;
                JButton button = (JButton)this.groupsTable.getValueAt(row, k);
                button.setText(COLUMN_CHECKED);
                this.groupsTable.updateUI();
            }
        }
    }

    public void clearColumnPermissions(StorageObject user, String priv) {
        block5: {
            int row;
            block4: {
                row = 0;
                if (!(user instanceof OwnerUDB)) break block4;
                for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
                    if (this.usersTable.getValueAt(i, 0) != user) continue;
                    row = i;
                    break;
                }
                for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
                    JButton button;
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(k).equalsIgnoreCase(priv) || !(button = (JButton)this.usersTable.getValueAt(row, k)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                    button.setText(EMPTY_VALUE);
                }
                break block5;
            }
            if (!(user instanceof UserGroupUDB)) break block5;
            for (int i = 0; i < this.groupsTable.getRowCount(); ++i) {
                if (this.groupsTable.getValueAt(i, 0) != user) continue;
                row = i;
                break;
            }
            for (int k = 1; k < this.groupsTable.getColumnCount(); ++k) {
                JButton button;
                if (!((GroupsModel)this.groupsTable.getModel()).getColumnName(k).equalsIgnoreCase(priv) || !(button = (JButton)this.groupsTable.getValueAt(row, k)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                button.setText(EMPTY_VALUE);
            }
        }
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (currentButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(table.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setText(value == null ? "" : "  " + ((JButton)value).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertyDialogUDB.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertyDialogUDB.this.setProperties();
            PermissionsPropertyDialogUDB.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertyDialogUDB.this.setProperties();
            PermissionsPropertyDialogUDB.this.storageObject.setDirty(true);
            PermissionsPropertyDialogUDB.this.dispose();
        }
    }

    private class ColumnsPermissionsListener
    implements ActionListener {
        PermissionsPropertyDialogUDB permDialog;

        public ColumnsPermissionsListener(PermissionsPropertyDialogUDB permDialog) {
            this.permDialog = permDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StorageObject selectedUser = null;
            if (PermissionsPropertyDialogUDB.this.tpane.getSelectedIndex() == 0) {
                if (PermissionsPropertyDialogUDB.this.usersTable.getSelectedRow() > -1) {
                    selectedUser = (StorageObject)PermissionsPropertyDialogUDB.this.usersTable.getValueAt(PermissionsPropertyDialogUDB.this.usersTable.getSelectedRow(), 0);
                }
            } else if (PermissionsPropertyDialogUDB.this.groupsTable.getSelectedRow() > -1) {
                selectedUser = (StorageObject)PermissionsPropertyDialogUDB.this.groupsTable.getValueAt(PermissionsPropertyDialogUDB.this.groupsTable.getSelectedRow(), 0);
            }
            if (selectedUser != null && (PermissionsPropertyDialogUDB.this.dialog == null || PermissionsPropertyDialogUDB.this.dialog.getUser() != selectedUser)) {
                PermissionsPropertyDialogUDB.this.dialog = new ColumnsPermissionsDialogUDB(PermissionsPropertyDialogUDB.this.appView, PermissionsPropertyDialogUDB.this.storageDesign, PermissionsPropertyDialogUDB.this.storageObject, selectedUser, this.permDialog);
            }
            if (PermissionsPropertyDialogUDB.this.dialog != null) {
                PermissionsPropertyDialogUDB.this.dialog.show();
            }
        }
    }

    public class GroupsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] perms = new Object[]{};
            if (PermissionsPropertyDialogUDB.this.storageObject instanceof TableProxyUDB) {
                perms = PermissionsUDB.getTablePrivilegesValues();
            } else if (PermissionsPropertyDialogUDB.this.storageObject instanceof TableViewProxyUDB) {
                perms = PermissionsUDB.getViewPrivilegesValues();
            } else if (PermissionsPropertyDialogUDB.this.storageObject instanceof SequenceUDB) {
                perms = PermissionsUDB.getSequencePrivilegesValues();
            }
            return perms.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            Object[] perms = new Object[]{};
            if (PermissionsPropertyDialogUDB.this.storageObject instanceof TableProxyUDB) {
                perms = PermissionsUDB.getTablePermissionsValues().toArray();
            } else if (PermissionsPropertyDialogUDB.this.storageObject instanceof TableViewProxyUDB) {
                perms = PermissionsUDB.getViewPermissionsValues().toArray();
            } else if (PermissionsPropertyDialogUDB.this.storageObject instanceof SequenceUDB) {
                perms = PermissionsUDB.getSequencePermissionsValues().toArray();
            }
            if (column == 0) {
                return Messages.getString("PermissionsPropertyDialogUDB.Group");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!PermissionsPropertyDialogUDB.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class GroupsTable
    extends JTable {
        GroupsModel dataModel;

        public GroupsTable() {
            this.dataModel = new GroupsModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    class UsersTable
    extends JTable {
        UsersModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class UsersModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] perms = new Object[]{};
            if (PermissionsPropertyDialogUDB.this.storageObject instanceof TableProxyUDB) {
                perms = PermissionsUDB.getTablePermissionsValues().toArray();
            } else if (PermissionsPropertyDialogUDB.this.storageObject instanceof TableViewProxyUDB) {
                perms = PermissionsUDB.getViewPermissionsValues().toArray();
            } else if (PermissionsPropertyDialogUDB.this.storageObject instanceof SequenceUDB) {
                perms = PermissionsUDB.getSequencePermissionsValues().toArray();
            }
            return perms.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            Object[] perms = new Object[]{};
            if (PermissionsPropertyDialogUDB.this.storageObject instanceof TableProxyUDB) {
                perms = PermissionsUDB.getTablePermissionsValues().toArray();
            } else if (PermissionsPropertyDialogUDB.this.storageObject instanceof TableViewProxyUDB) {
                perms = PermissionsUDB.getViewPermissionsValues().toArray();
            } else if (PermissionsPropertyDialogUDB.this.storageObject instanceof SequenceUDB) {
                perms = PermissionsUDB.getSequencePermissionsValues().toArray();
            }
            if (column == 0) {
                return Messages.getString("PermissionsPropertyDialogUDB.User");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!PermissionsPropertyDialogUDB.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

