/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import com.adbs.querybuilder.QueryBuilder;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.imports.SyncUtils;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.DP_UndoManager;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.IdeDMUtils;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.SelectNeighborsDialog;
import oracle.dbtools.crest.swingui.ShowHideConnectors;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVImage;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.admin.objects.SubViewObjectsAdmin;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.relational.FKDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableViewDiagramCell;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.relational.ControllerRelational;
import oracle.dbtools.crest.swingui.relational.Messages;
import oracle.dbtools.crest.swingui.relational.TVFKArc;
import oracle.dbtools.crest.swingui.relational.TVFKContainer;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class DPVRelational
extends DesignPartView {
    public static final String MI_COLUMNS = Messages.getString("DPVRelational.Columns");
    public static final String MI_KEY_ELEMENTS = Messages.getString("DPVRelational.KeyElements");
    public static final String SHOW_HIDE_LINES = Messages.getString("DPVRelational.ShowHideLines");
    public static final String SHOW_HIDE_SOURCE_NAME = Messages.getString("DPVRelational.Source");
    public static final String SHOW_HIDE_TARGET_NAME = Messages.getString("DPVRelational.Target");
    public static final String MI_CLEAR_SOURCE_STAMP = Messages.getString("DPVRelational.ClearSourceStamp");
    public static final String MI_VALIDATE_ALL_TABLE_QUERIES = Messages.getString("DPVRelational.ValidateAllTableQueries");
    public static final Dimension TOPVIEW_SIZE = new Dimension(280, 320);
    private AbstractController controller;
    private JPopupMenu menu;
    private JMenuItem miPaste;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miGridEnabled;
    private JCheckBoxMenuItem miShowGrid;
    private JCheckBoxMenuItem miShowPageGrid;
    private JMenu miAutoLayout;
    private JMenuItem miUseSynonyms;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miHideDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miElements;
    private JCheckBoxMenuItem miKeyElements;
    private JCheckBoxMenuItem miDatatype;
    private JCheckBoxMenuItem miFKeys;
    private JCheckBoxMenuItem miKeys;
    private JCheckBoxMenuItem miIndexes;
    private JCheckBoxMenuItem miKeyAndIndexColumns;
    private JCheckBoxMenuItem miShowLegend;
    private JCheckBoxMenuItem miShowLabels;
    private JCheckBoxMenuItem miSchemaName;
    private JCheckBoxMenuItem miClassificationTypes;
    private JCheckBoxMenuItem miComments;
    private JCheckBoxMenuItem miExpandComplexTypes;
    private JCheckBoxMenuItem miDynamicProperties;
    private int left = 20;
    private int top = 20;
    private int initialLeft = 20;
    private int initialTop = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private int autoLayout = 0;
    private List createdTV = new ArrayList();
    public static String LAYOUT_1 = Messages.getString("DPVRelational.Layout1");
    public static String LAYOUT_2 = Messages.getString("DPVRelational.Layout2");
    public static String LAYOUT_3 = Messages.getString("DPVRelational.Layout3");
    public static String LAYOUT_4 = Messages.getString("DPVRelational.Layout4");
    public static String USE_SYNONYMS = Messages.getString("DPVRelational.UseSynonyms");
    private JMenu miLayout;
    private JMenu miSync;
    private JMenu miViews;
    private static final Logger LOGGER = new Logger(DPVRelational.class);
    int lvers = 1;
    private Map thMap = new TreeMap();
    private int maxWidth = 12000;
    private int refCount = 13;
    private boolean useSynonyms = false;
    private int gcount = 0;
    private List roots;
    private List fkList = new ArrayList();
    private int startx = 2000;
    private int starty = 20;
    private int dx = 80;
    private int dy = 80;
    private int maxLevel = 999999;
    private boolean mixLeftRight = true;
    private int levelled = 0;
    private int arranged = 0;
    THReferredByComparatorAsc1 referredByComparatorAsc1 = new THReferredByComparatorAsc1();
    THReferredByComparatorAsc2 referredByComparatorAsc2 = new THReferredByComparatorAsc2();
    THReferredByComparatorDesc referredByComparatorDesc = new THReferredByComparatorDesc();
    THReferComparatorDesc referComparatorDesc = new THReferComparatorDesc();
    THHeightComparatorAsc heightComparatorAsc = new THHeightComparatorAsc();
    THHeightComparatorDesc heightComparatorDesc = new THHeightComparatorDesc();
    boolean layOutchanging = false;
    public static final String TOOLBAR_NAME = "Relational Model";

    public DPVRelational(ApplicationView appView, DesignPart desPart) {
        super(appView, desPart);
        this.controller = new ControllerRelational(appView);
        this.controller.setName("Relational");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        return this.createTopViewFor(object);
    }

    public Collection getTVTypeSubstitutions() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator fit = ((RelationalDesign)this.getDesignPart()).getTypeSubstitutionSet().iterator();
        while (fit.hasNext()) {
            TypeSubstitution fk = (TypeSubstitution)fit.next();
            TopView tv = fk.getViewFor(this);
            if (tv == null) continue;
            col.add(tv);
        }
        return col;
    }

    public Collection getTVFKRelations() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator fit = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (fit.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)fit.next();
            TopView tv = fk.getViewFor(this);
            if (tv == null) continue;
            col.add(tv);
        }
        return col;
    }

    public Collection getTVViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator it = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView tableView = (TableView)it.next();
            TopViewCollection tvCollection = tableView.getViewsForDPV(this);
            for (TopView tv : tvCollection) {
                if (tv == null) continue;
                col.add(tv);
            }
        }
        return col;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart desPart) {
        return new DPVRelational(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public boolean canCreateDisplays() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TopView createTopViewFor(DesignObject object) {
        void var2_13;
        Object var2_2 = null;
        if (object instanceof Table) {
            TVTable tVTable = new TVTable(this.getApplicationView(), this);
        } else if (object instanceof TableView) {
            TVView tVView = new TVView(this.getApplicationView(), this);
        } else if (object instanceof FKIndexAssociation) {
            if (((FKIndexAssociation)object).getRemoteTable() == null) return null;
            TVFKRelation tVFKRelation = new TVFKRelation(this.getApplicationView(), this);
        } else if (object instanceof TypeSubstitution) {
            TVTypeSubstitution tVTypeSubstitution = new TVTypeSubstitution(this.getApplicationView(), this);
        } else if (object instanceof Note) {
            TVNote tVNote = new TVNote(this.getApplicationView(), this);
        } else if (object instanceof ImageObject) {
            TVImage tVImage = new TVImage(this.getApplicationView(), this);
        } else if (object instanceof Legend) {
            TVLegend tVLegend = new TVLegend(this.getApplicationView(), this);
        } else if (object instanceof DiagramView) {
            TVDiagramView tVDiagramView = new TVDiagramView(this.getApplicationView(), this);
        } else if (object instanceof Label) {
            TVLabel tVLabel = new TVLabel(this.getApplicationView(), this);
        } else {
            if (!(object instanceof FKArc)) return null;
            TVFKArc tva = new TVFKArc(this.getApplicationView(), this);
            tva.setModel(object);
            TVFKArc tVFKArc = tva;
        }
        var2_13.setModel(object);
        var2_13.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel((TopView)var2_13);
        this.setDirty(true);
        return var2_13;
    }

    protected void showPropertiesDialog() {
        if (!this.isMasterDPV()) {
            if (!this.getPlaceHolder().isDialogVisible()) {
                ModelPropertiesDialogEx dialog = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
                dialog.initProperties(this.getPlaceHolder());
                dialog.show();
            }
        } else {
            this.getDesignPart().showPropertyDialog();
        }
    }

    protected void showDesignRulesDialog() {
        ArrayList<DesignObject> allObjects = new ArrayList<DesignObject>();
        Iterator it = this.getTVTablesAndTVViews().iterator();
        while (it.hasNext()) {
            DesignObject obj = ((ContainerView)it.next()).getModel();
            allObjects.add(obj);
        }
        this.getApplicationView().setDesignRuleViewVisible(true, this.getPlaceHolder().getDesignPart(), allObjects);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            this.miPaste = this.menu.add(new AbstractAction(MI_PASTE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DPVRelational.this.getController().paste(DPVRelational.this.pt);
                }
            });
            this.miPaste.setIcon(this.getConfiguration().getIcon("PASTE_ICON", 16));
            this.menu.addSeparator();
            this.addSubViewAndDisplayMenus(this.menu);
            this.menu.addSeparator();
            if (!this.isMainDiagram()) {
                this.menu.add(this.getObjectsSubMenu());
                this.menu.addSeparator();
            }
            this.menu.add(this.getLayoutSubMenu());
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
            this.menu.add(this.getShowMenu());
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getTablesSubMenu());
        this.menu.addSeparator();
        this.menu.add(this.getViewsSubMenu());
        this.menu.addSeparator();
        this.menu.add(this.getPrintDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getSyncMenu());
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(DESIGN_RULES){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.showDesignRulesDialog();
            }
        });
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        JMenuItem miProperties = this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.showPropertiesDialog();
            }
        });
        miProperties.setIcon(this.getConfiguration().getIcon("PROPERTIES_ICON", 16));
        if (this.isEditable()) {
            this.miGridEnabled.setSelected(this.isGridEnabled());
            this.miPaste.setEnabled(this.canPaste());
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miAutoLayout.setEnabled(true);
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miSchemaName.setSelected(this.showSchemaName());
            this.miComments.setSelected(this.showComments());
            this.miClassificationTypes.setSelected(this.isShowClassificationTypes());
            this.miHideDetails.setSelected(this.isHideDetaisOnZoomOut());
            this.miDynamicProperties.setSelected(this.isShowDynamicProperties());
            this.miExpandComplexTypes.setSelected(this.isExpandComplexTypes());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miElements.setSelected(this.showElements());
            this.miKeyElements.setSelected(this.showKeyElements());
            this.miDatatype.setSelected(this.showDatatype());
            this.miFKeys.setSelected(this.showFKeys());
            this.miKeys.setSelected(this.showKeys());
            this.miIndexes.setSelected(this.showIndexes());
            this.miKeyAndIndexColumns.setSelected(this.showKeyAndIndexColumns());
            this.miKeyAndIndexColumns.setVisible(this.showFKeys() || this.showKeys() || this.showIndexes());
        }
        return this.menu;
    }

    private JMenu getAutoLayout() {
        this.miAutoLayout = new JMenu(MI_AUTO_LAYOUT);
        this.miAutoLayout.add(new AbstractAction(LAYOUT_1){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.rearrangeDiagram2(1, true, LAYOUT_1);
            }
        });
        this.miAutoLayout.add(new AbstractAction(LAYOUT_2){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.rearrangeDiagram2(1, false, LAYOUT_2);
            }
        });
        this.miAutoLayout.add(new AbstractAction(LAYOUT_3){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.rearrangeDiagram2(3, true, LAYOUT_3);
            }
        });
        this.miAutoLayout.add(new AbstractAction(LAYOUT_4){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.rearrangeDiagram2(3, false, LAYOUT_4);
            }
        });
        if (this.miUseSynonyms == null) {
            this.miUseSynonyms = new JCheckBoxMenuItem(USE_SYNONYMS);
            this.miUseSynonyms.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DPVRelational.this.useSynonyms = !DPVRelational.this.useSynonyms;
                }
            });
        }
        this.miAutoLayout.addSeparator();
        this.miAutoLayout.add(this.miUseSynonyms);
        this.miUseSynonyms.setSelected(this.useSynonyms);
        return this.miAutoLayout;
    }

    @Override
    public JMenu getDetailsMenu() {
        JMenu detailsMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        detailsMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miHideDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_HIDE_DETAILS));
        this.miHideDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_HIDE_DETAILS));
        this.miSchemaName = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_SCHEMA_NAME));
        this.miSchemaName.setMnemonic(MenuUtils.getMnemonicKey(MI_SCHEMA_NAME));
        this.miComments = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_COMMENTS));
        this.miComments.setMnemonic(MenuUtils.getMnemonicKey(MI_COMMENTS));
        this.miClassificationTypes = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr("Classification Types"));
        this.miDynamicProperties = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr("Dynamic Properties"));
        this.miExpandComplexTypes = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr("Expand Complex Types"));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_COLUMNS));
        this.miElements.setMnemonic(MenuUtils.getMnemonicKey(MI_COLUMNS));
        this.miKeyElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_KEY_ELEMENTS));
        this.miKeyElements.setMnemonic(MenuUtils.getMnemonicKey(MI_KEY_ELEMENTS));
        this.miDatatype = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_DATATYPE));
        this.miDatatype.setMnemonic(MenuUtils.getMnemonicKey(MI_DATATYPE));
        this.miFKeys = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_FOREIGN_KEYS));
        this.miFKeys.setMnemonic(MenuUtils.getMnemonicKey(MI_FOREIGN_KEYS));
        this.miKeys = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_KEYS));
        this.miKeys.setMnemonic(MenuUtils.getMnemonicKey(MI_KEYS));
        this.miIndexes = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_INDEXES));
        this.miIndexes.setMnemonic(MenuUtils.getMnemonicKey(MI_INDEXES));
        this.miKeyAndIndexColumns = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_KEY_AND_INDEX_COLUMNS));
        this.miKeyAndIndexColumns.setMnemonic(MenuUtils.getMnemonicKey(MI_KEY_AND_INDEX_COLUMNS));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowAllDetails(true);
                DPVRelational.this.setShowNamesOnly(false);
                DPVRelational.this.setShowElements(false);
                DPVRelational.this.setShowKeyElements(false);
                DPVRelational.this.setShowDatatype(false);
                DPVRelational.this.setShowFKeys(false);
                DPVRelational.this.setShowKeys(false);
                DPVRelational.this.setShowIndexes(false);
                DPVRelational.this.setShowKeyAndIndexColumns(false);
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        this.miHideDetails.setSelected(this.isHideDetaisOnZoomOut());
        this.miHideDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setHideDetaisOnZoomOut(!DPVRelational.this.isHideDetaisOnZoomOut());
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miAllDetails);
        detailsMenu.add(this.miHideDetails);
        detailsMenu.addSeparator();
        this.miSchemaName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowSchemaName(!DPVRelational.this.showSchemaName());
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miSchemaName);
        this.miClassificationTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowClassificationTypes(!DPVRelational.this.isShowClassificationTypes());
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miClassificationTypes);
        this.miDynamicProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowDynamicProperties(!DPVRelational.this.isShowDynamicProperties());
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miDynamicProperties);
        this.miExpandComplexTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setExpandComplexTypes(!DPVRelational.this.isExpandComplexTypes());
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miExpandComplexTypes);
        this.miComments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowComments(!DPVRelational.this.showComments());
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miComments);
        detailsMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowAllDetails(false);
                DPVRelational.this.setShowNamesOnly(true);
                DPVRelational.this.setShowElements(false);
                DPVRelational.this.setShowKeyElements(false);
                DPVRelational.this.setShowDatatype(false);
                DPVRelational.this.setShowFKeys(false);
                DPVRelational.this.setShowKeys(false);
                DPVRelational.this.setShowIndexes(false);
                DPVRelational.this.setShowKeyAndIndexColumns(false);
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miNameOnly);
        this.miElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowElements(!DPVRelational.this.showElements());
                if (!DPVRelational.this.showElements() && !DPVRelational.this.showKeyElements()) {
                    DPVRelational.this.setShowDatatype(false);
                    if (!DPVRelational.this.showKeys() && !DPVRelational.this.showIndexes()) {
                        DPVRelational.this.setShowAllDetails(true);
                    }
                } else {
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                    DPVRelational.this.setShowKeyAndIndexColumns(false);
                    if (DPVRelational.this.showElements()) {
                        DPVRelational.this.setShowKeyElements(false);
                    }
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miElements);
        this.miKeyElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowKeyElements(!DPVRelational.this.showKeyElements());
                if (!DPVRelational.this.showElements() && !DPVRelational.this.showKeyElements()) {
                    DPVRelational.this.setShowDatatype(false);
                    if (!DPVRelational.this.showKeys()) {
                        DPVRelational.this.setShowAllDetails(true);
                    }
                } else {
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                    DPVRelational.this.setShowKeyAndIndexColumns(false);
                    if (DPVRelational.this.showKeyElements()) {
                        DPVRelational.this.setShowElements(false);
                    }
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miKeyElements);
        this.miDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowDatatype(!DPVRelational.this.showDatatype());
                if (DPVRelational.this.showDatatype()) {
                    if (!DPVRelational.this.showKeyElements()) {
                        DPVRelational.this.setShowElements(true);
                    }
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miDatatype);
        this.miKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowKeys(!DPVRelational.this.showKeys());
                if (DPVRelational.this.showKeys()) {
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                } else if (!(DPVRelational.this.showElements() || DPVRelational.this.showFKeys() || DPVRelational.this.showIndexes() || DPVRelational.this.showKeyElements())) {
                    DPVRelational.this.setShowAllDetails(true);
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        this.miFKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowFKeys(!DPVRelational.this.showFKeys());
                if (DPVRelational.this.showFKeys()) {
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                } else if (!(DPVRelational.this.showElements() || DPVRelational.this.showKeys() || DPVRelational.this.showIndexes() || DPVRelational.this.showKeyElements())) {
                    DPVRelational.this.setShowAllDetails(true);
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        this.miIndexes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowIndexes(!DPVRelational.this.showIndexes());
                if (DPVRelational.this.showIndexes()) {
                    DPVRelational.this.setShowAllDetails(false);
                    DPVRelational.this.setShowNamesOnly(false);
                } else if (!(DPVRelational.this.showElements() || DPVRelational.this.showKeys() || DPVRelational.this.showKeyElements())) {
                    DPVRelational.this.setShowAllDetails(true);
                }
                DPVRelational.this.getWorkSpace().invalidate();
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        this.miKeyAndIndexColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowKeyAndIndexColumns(!DPVRelational.this.showKeyAndIndexColumns());
                DPVRelational.this.getWorkSpace().repaint();
                DPVRelational.this.setDirty(true);
            }
        });
        detailsMenu.add(this.miKeys);
        detailsMenu.add(this.miFKeys);
        detailsMenu.add(this.miIndexes);
        detailsMenu.add(this.miKeyAndIndexColumns);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miSchemaName.setSelected(this.showSchemaName());
        this.miComments.setSelected(this.showComments());
        this.miClassificationTypes.setSelected(this.isShowClassificationTypes());
        this.miHideDetails.setSelected(this.isHideDetaisOnZoomOut());
        this.miDynamicProperties.setSelected(this.isShowDynamicProperties());
        this.miExpandComplexTypes.setSelected(this.isExpandComplexTypes());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        this.miElements.setSelected(this.showElements());
        this.miKeyElements.setSelected(this.showKeyElements());
        this.miDatatype.setSelected(this.showDatatype());
        this.miFKeys.setSelected(this.showFKeys());
        this.miKeys.setSelected(this.showKeys());
        this.miIndexes.setSelected(this.showIndexes());
        this.miKeyAndIndexColumns.setSelected(this.showKeyAndIndexColumns());
        this.miKeyAndIndexColumns.setVisible(this.showFKeys() || this.showKeys() || this.showIndexes());
        return detailsMenu;
    }

    public JMenu getShowMenu() {
        JMenu showMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        showMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowGrid(!DPVRelational.this.showGrid());
            }
        });
        showMenu.add(this.miShowGrid);
        this.miShowPageGrid = new JCheckBoxMenuItem(MI_SHOW_PAGE_GRID);
        this.miShowPageGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowPageGrid(!DPVRelational.this.showPageGrid());
            }
        });
        showMenu.add(this.miShowPageGrid);
        showMenu.addSeparator();
        this.miShowLabels = new JCheckBoxMenuItem(MI_SHOW_LABELS);
        this.miShowLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowLabels(!DPVRelational.this.showLabels());
            }
        });
        showMenu.add(this.miShowLabels);
        showMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setShowLegend(!DPVRelational.this.showLegend());
            }
        });
        showMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowPageGrid.setSelected(this.showPageGrid());
        this.miShowLabels.setSelected(this.showLabels());
        this.miShowLegend.setSelected(this.showLegend());
        return showMenu;
    }

    public void rearrangeDiagram() {
        if (this.autoLayout == 0) {
            this.layOutchanging = true;
            this.layOutchanging = false;
            return;
        }
        if (this.autoLayout == 1) {
            // empty if block
        }
        this.layOutchanging = true;
        this.startAutoLayoutEdit("AutoLayout " + this.lvers + "_" + this.bulToInt(this.mixLeftRight));
        this.initialLeft = 20;
        this.initialTop = 20;
        this.rearrangeT(this.lvers, false);
        this.rearrangeViews();
        this.stopAutoLayoutEdit();
        if (this.lvers == 3 && !this.mixLeftRight) {
            this.layOutchanging = false;
            this.lvers = 1;
            this.mixLeftRight = true;
        } else if (!this.mixLeftRight) {
            ++this.lvers;
            this.mixLeftRight = true;
        } else {
            this.mixLeftRight = false;
        }
    }

    public void rearrangeDiagram2(int version, boolean mix_l_r, String name) {
        Point2D pp = null;
        if (this.pt != null) {
            pp = this.getWorkSpace().fromScreen(new Point2D.Double(this.pt.x, this.pt.y));
        }
        this.lvers = version;
        this.mixLeftRight = mix_l_r;
        this.startAutoLayoutEdit(name);
        List<ContainerView> list = this.getSelectedContainerViews();
        if (list.size() > 0) {
            if (pp != null) {
                this.initialLeft = (int)pp.getX();
                this.initialTop = (int)pp.getY();
            }
            this.rearrangeT(this.lvers, false, list);
        } else {
            this.initialLeft = 20;
            this.initialTop = 20;
            this.rearrangeT(this.lvers, false);
        }
        this.stopAutoLayoutEdit();
    }

    public void rearrangeNewDiagram() {
        this.initialLeft = 20;
        this.initialTop = 20;
        this.lvers = 3;
        this.mixLeftRight = false;
        this.rearrangeT(this.lvers, true);
        this.lvers = 1;
        this.mixLeftRight = true;
    }

    private int bulToInt(boolean bool) {
        if (bool) {
            return 0;
        }
        return 1;
    }

    public Collection getTVTables() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVTable)) continue;
            col.add(tv);
        }
        return col;
    }

    public Collection getTVTablesAndTVViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVTable) && !(tv instanceof TVView)) continue;
            col.add(tv);
        }
        return col;
    }

    public void rearrangeT(int version, boolean resize) {
        this.rearrangeT(version, resize, null);
    }

    public void rearrangeT(int version, boolean resize, List containerViews) {
        this.left = this.initialLeft;
        this.top = this.initialTop;
        this.dy = 60;
        this.dx = 80;
        this.gcount = 0;
        this.refCount = 10;
        List tables = containerViews != null && containerViews.size() > 0 ? containerViews : (List)this.getTVTablesAndTVViews();
        this.maxWidth = 1000;
        this.createdTV.clear();
        this.fkList.clear();
        ArrayList<TH> norefs = new ArrayList<TH>();
        ArrayList<TH> withrefs = new ArrayList<TH>();
        this.roots = new ArrayList();
        ArrayList<TH> realRoots = new ArrayList<TH>();
        List all = this.buildTH_Map(tables, resize);
        ArrayList stars = new ArrayList();
        for (TH th : all) {
            if (th.refer_count == 0 && th.referredBy_count == 0) {
                norefs.add(th);
                continue;
            }
            withrefs.add(th);
            if (th.refer.size() > 0) {
                if (version == 1) {
                    Collections.sort(th.refer, this.referredByComparatorAsc1);
                } else if (version == 2) {
                    Collections.sort(th.refer, this.referredByComparatorAsc2);
                } else {
                    Collections.sort(th.refer, this.referredByComparatorDesc);
                }
            }
            if (th.referredBy_count == 0 && !th.usedInStar) {
                this.roots.add(th);
            }
            if (th.referredBy.size() <= 0) continue;
            Collections.sort(th.referredBy, this.referComparatorDesc);
        }
        if (this.useSynonyms) {
            stars.addAll(this.makeSynonyms(withrefs));
        }
        if (withrefs.size() > 0) {
            if (this.roots.size() == 0) {
                this.findRoots(withrefs, this.roots);
            }
            this.roots.addAll(stars);
            Collections.sort(this.roots, this.referComparatorDesc);
            int x = this.startx;
            int y = this.starty;
            for (int i = 0; i < this.roots.size(); ++i) {
                Rectangle rect;
                TH th = (TH)this.roots.get(i);
                if (th.arranged || th.usedInStar) continue;
                realRoots.add(th);
                this.levelled = 0;
                this.arranged = 0;
                if (th.star) {
                    rect = this.arrangeStar(th, x, y);
                } else {
                    this.setLevel2(th, 0);
                    rect = this.arrange(th, x, y, null, null, null);
                }
                y = y + rect.height + 2 * this.dy;
            }
            Collections.sort(realRoots, this.heightComparatorDesc);
            this.translateArrangeRoots(realRoots);
            withrefs.addAll(this.createdTV);
            this.applyArrange(withrefs);
        }
        this.rearrangeNoneRefTables(norefs);
        this.applyArrange(norefs);
        if (!this.isAutoRoute()) {
            this.straightenLines(this.fkList);
        }
        if (this.showLabels()) {
            this.refreshLabels(this.fkList);
        }
        this.createdTV.clear();
        this.roots.clear();
        this.thMap.clear();
        this.fkList.clear();
    }

    public void straightenLines(List list) {
        for (FKIndexAssociation fk : list) {
            TopView tv = fk.getViewFor(this);
            if (tv == null || tv.getCellView() == null) continue;
            DefaultEdge edge = (DefaultEdge)tv.getCellView().getCell();
            edge.straightLine(false);
        }
    }

    private void refreshLabels(List list) {
        for (FKIndexAssociation fk : list) {
            TopView tv = fk.getViewFor(this);
            if (tv.getCellView() == null || !(tv.getCellView() instanceof EdgeView)) continue;
            DefaultEdge edge = (DefaultEdge)tv.getCellView().getCell();
            ((EdgeView)edge.getTopView().getCellView()).refreshLabels();
        }
    }

    private Rectangle arrangeStar(TH th, int x, int y) {
        TH tht;
        int i;
        Rectangle rect = new Rectangle(x, y, 1, 1);
        th.nodes.add(th);
        ArrayList<TH> list = new ArrayList<TH>();
        for (TH tht2 : th.referredBy) {
            if (list.contains(tht2)) continue;
            list.add(tht2);
        }
        for (TH tht2 : th.refer) {
            if (list.contains(tht2)) continue;
            list.add(tht2);
        }
        Collections.sort(list, this.heightComparatorAsc);
        int w = 0;
        for (TH tht3 : list) {
            w = w + tht3.init_dim.width + this.dx;
        }
        int tx = x;
        int ty = y;
        int xr = x + w / 2;
        int ind = 0;
        int ddy = 0;
        int ddx = x;
        for (i = list.size() - 1; i >= 0 && tx < xr; --i) {
            ind = i;
            tht = (TH)list.get(i);
            ddy = Math.max(ddy, tht.init_dim.height);
            ddx = tx + tht.init_dim.width;
            th.nodes.add(tht);
            tht.nodes.add(tht);
            tht.location = new Point(tx, ty);
            tht.rect = new Rectangle(tht.location, tht.init_dim);
            tx = tx + this.dx + tht.init_dim.width;
            rect = rect.union(tht.rect);
            tht.arranged = true;
        }
        ty = ty + ddy + 2 * this.dy;
        tx = x + (ddx - x) / 2;
        th.location = new Point(tx, ty);
        th.rect = new Rectangle(th.location, th.init_dim);
        rect = rect.union(th.rect);
        th.arranged = true;
        ty = ty + th.init_dim.height + 2 * this.dy;
        tx = x;
        for (i = ind - 1; i >= 0; --i) {
            tht = (TH)list.get(i);
            th.nodes.add(tht);
            tht.nodes.add(tht);
            tht.location = new Point(tx, ty);
            tht.rect = new Rectangle(tht.location, tht.init_dim);
            tx = tx + this.dx + tht.init_dim.width;
            rect = rect.union(tht.rect);
            tht.arranged = true;
        }
        th.rect = rect;
        return rect;
    }

    private void translateArrangeRoots(List listTH) {
        this.left = this.initialLeft;
        this.top = this.initialTop;
        int h = 0;
        int max = this.getRootsMaxWidth(listTH) + this.left + 5;
        for (TH th : listTH) {
            Rectangle r = th.rect;
            if (this.left + r.width > max) {
                this.left = this.initialLeft;
                this.top = this.top + h + 2 * this.dy;
                h = 0;
            }
            h = Math.max(r.height, h);
            int tx = this.left - r.x;
            int ty = this.top - r.y;
            for (TH tht : th.nodes) {
                tht.location.x = tx + tht.location.x;
                tht.location.y = ty + tht.location.y;
            }
            this.left = this.left + r.width + 2 * this.dx;
        }
        this.top = this.top + h + 3 * this.dy;
        this.left = this.initialLeft;
    }

    private int getRootsMaxWidth(List listTH) {
        int max = this.maxWidth;
        for (TH th : listTH) {
            if (max >= th.rect.width) continue;
            max = th.rect.width;
        }
        return max;
    }

    private Rectangle orderLeft(TH upnode, List list, int x, int y, List bookedleft, List upNodes, Rectangle left) {
        int lx = x - this.dx;
        int ly = y;
        Rectangle rect = new Rectangle(x, y, 1, 1);
        for (int i = list.size() - 1; i >= 0; --i) {
            TH th = (TH)list.get(i);
            if (th.arranged || th.isConnectedToBetterLevel(upnode, upnode.level) || th.booked && !bookedleft.contains(th)) continue;
            int tx = lx - th.init_dim.width;
            Rectangle r = this.arrange(th, tx, ly, null, left, upNodes);
            lx = Math.min(lx, r.x) - this.dx;
            rect = rect.union(r);
        }
        return rect;
    }

    private Rectangle orderLeftCenter(TH upnode, List list, int x, int y, List bookedleft, List upNodes, Rectangle left) {
        int i;
        int lx = x - this.dx;
        int ly = y;
        ArrayList<TH> tlist = new ArrayList<TH>();
        Rectangle rect = new Rectangle(x, y, 1, 1);
        for (i = list.size() - 1; i >= 0; --i) {
            TH th = (TH)list.get(i);
            if (th.arranged || th.isConnectedToBetterLevel(upnode, upnode.level) || th.booked && !bookedleft.contains(th)) continue;
            tlist.add(0, th);
        }
        if (tlist.size() > 1) {
            int w = 0;
            for (int i2 = 0; i2 < tlist.size() - 1; ++i2) {
                TH th = (TH)tlist.get(i2);
                w = w + this.dx + th.init_dim.width;
            }
            lx = x + w / 2 - this.dx;
        }
        for (i = tlist.size() - 1; i >= 0; --i) {
            TH th = (TH)tlist.get(i);
            if (th.arranged || th.isConnectedToBetterLevel(upnode, upnode.level) || th.booked && !bookedleft.contains(th)) continue;
            int tx = lx - th.init_dim.width;
            Rectangle r = this.arrange(th, tx, ly, null, left, upNodes);
            lx = Math.min(lx, r.x) - this.dx;
            rect = rect.union(r);
        }
        return rect;
    }

    private Rectangle orderDown(TH upnode, List list, int x, int y, List bookedleft, List upNodes, Rectangle left) {
        int xx;
        List singles;
        ArrayList<TH> booked = new ArrayList<TH>();
        for (TH th : list) {
            if (th.arranged || th.booked || bookedleft.contains(th) || th.isConnectedToBetterLevel(upnode, upnode.level)) continue;
            th.booked = true;
            booked.add(th);
        }
        int lx = x;
        int ly = y;
        Rectangle rect = new Rectangle(x, y, 1, 1);
        Rectangle rl = left == null ? null : new Rectangle(left);
        ArrayList<TH> temp = new ArrayList<TH>();
        int size = booked.size();
        if (size > 1 && (singles = this.getReferOnly(booked, upnode)).size() > 0) {
            int up;
            if (singles.size() > 1) {
                Collections.sort(singles, this.heightComparatorAsc);
            }
            int ty = upnode.location.y;
            int dy3 = this.dy / 3;
            int downy = ty + upnode.init_dim.height + dy3;
            for (int i = 0; i < singles.size(); ++i) {
                TH th = (TH)singles.get(i);
                int dwy = ty + th.init_dim.height;
                if (dwy > downy) break;
                temp.add(th);
                booked.remove(th);
                ty = dwy + dy3;
            }
            if ((up = size / 2) > 1) {
                up = 1;
            }
            while (booked.size() < up) {
                booked.add((TH)temp.get(temp.size() - 1));
                temp.remove(temp.size() - 1);
            }
        }
        size = booked.size();
        for (int i = 0; i < size; ++i) {
            TH th = (TH)booked.get(i);
            if (size > 1 && i == size - 1 && temp.size() == 0) {
                if (temp.size() == 0 && th.referOnlyAndArranged(upnode)) {
                    xx = upnode.location.x + this.dx + upnode.init_dim.width;
                    Rectangle r = this.arrange(th, xx, upnode.location.y, null, rl, upNodes);
                    rect = rect.union(r);
                } else {
                    xx = Math.max(upnode.location.x + this.dx + upnode.init_dim.width, rect.x + rect.width + this.dx);
                    Rectangle r = this.arrange(th, xx, upnode.location.y, null, rl, upNodes);
                    rect = rect.union(r);
                }
            }
            int tx = lx;
            Rectangle r = this.arrange(th, tx, ly, null, rl, upNodes);
            rl = rl == null ? new Rectangle(r) : rl.union(r);
            lx = Math.max(lx, r.x + r.width) + this.dx;
            rect = rect.union(r);
        }
        int ty = upnode.location.y;
        int dy3 = this.dy / 3;
        xx = upnode.location.x + this.dx + upnode.init_dim.width;
        for (int i = 0; i < temp.size(); ++i) {
            TH th = (TH)temp.get(i);
            th.nodes.add(th);
            if (upNodes != null) {
                upNodes.add(th);
            }
            th.location = new Point(xx, ty);
            th.arranged = true;
            th.booked = false;
            th.rect = new Rectangle(th.location, th.init_dim);
            rect = rect.union(th.rect);
            ty = ty + th.init_dim.height + dy3;
        }
        return rect;
    }

    private List getReferOnly(List listTH, TH th) {
        Iterator it = listTH.iterator();
        ArrayList<TH> list = new ArrayList<TH>();
        while (it.hasNext()) {
            TH tht = (TH)it.next();
            if (!tht.referOnly(th)) continue;
            list.add(tht);
        }
        return list;
    }

    private List getNotArranged(List list) {
        ArrayList<TH> res = new ArrayList<TH>();
        for (TH th : list) {
            if (th.arranged) continue;
            res.add(th);
        }
        return res;
    }

    private Rectangle arrange(TH th, int x, int y, Rectangle rect, Rectangle left, List allNodes) {
        if (!th.arranged) {
            Rectangle r;
            boolean canGoleft;
            Rectangle res = rect;
            th.location = new Point(x, y);
            th.nodes.add(th);
            res = res == null ? new Rectangle(th.location, th.init_dim) : res.union(new Rectangle(th.location, th.init_dim));
            th.arranged = true;
            ++this.arranged;
            ++this.gcount;
            List refer = this.getNotArranged(th.refer);
            List referredBy = this.getNotArranged(th.referredBy);
            ArrayList<TH> bookleft = new ArrayList<TH>();
            if (!this.mixLeftRight && this.canGoLeft(left, x, y + th.init_dim.height + this.dy, referredBy)) {
                for (TH thl : referredBy) {
                    if (thl.arranged || thl.booked || thl.isConnectedToBetterLevel(th, th.level)) continue;
                    thl.booked = true;
                    bookleft.add(thl);
                }
            }
            if (!(canGoleft = this.canGoLeft(left, x, y + th.init_dim.height + this.dy, referredBy))) {
                for (TH th1 : bookleft) {
                    th1.booked = false;
                }
                bookleft.clear();
            }
            if (refer.size() > 0) {
                if (this.mixLeftRight || !canGoleft) {
                    referredBy.addAll(refer);
                    r = this.orderDown(th, referredBy, x, y + th.init_dim.height + this.dy, new ArrayList(), th.nodes, left);
                    res = res.union(r);
                } else if (referredBy.size() > 0) {
                    r = this.orderLeft(th, referredBy, x, y + th.init_dim.height + this.dy, bookleft, th.nodes, left);
                    left = left == null ? new Rectangle(r) : left.union(r);
                    res = res.union(r);
                    r = this.orderDown(th, refer, Math.max(x, r.x + r.width), y + th.init_dim.height + this.dy, bookleft, th.nodes, left);
                    res = res.union(r);
                } else {
                    r = this.orderDown(th, refer, x, y + th.init_dim.height + this.dy, bookleft, th.nodes, left);
                    res = res.union(r);
                }
            } else if (referredBy.size() > 0) {
                if (this.mixLeftRight || !this.canGoLeft(left, x, y + th.init_dim.height + this.dy, referredBy)) {
                    referredBy.addAll(refer);
                    r = this.orderDown(th, referredBy, x, y + th.init_dim.height + this.dy, new ArrayList(), th.nodes, left);
                    res = res.union(r);
                } else {
                    TH tht = (TH)referredBy.get(referredBy.size() - 1);
                    r = this.orderLeftCenter(th, referredBy, x + tht.init_dim.width + this.dx, y + th.init_dim.height + this.dy, bookleft, th.nodes, left);
                    res = res.union(r);
                }
            }
            th.rect = new Rectangle(res);
            if (allNodes != null) {
                for (TH tht : th.nodes) {
                    if (allNodes.contains(tht)) continue;
                    allNodes.add(tht);
                }
            }
            return res;
        }
        return th.rect;
    }

    private boolean canGoLeft(Rectangle left, int x, int y, List list) {
        if (left == null || list.size() == 0) {
            return true;
        }
        Iterator it = list.iterator();
        int width = 0;
        while (it.hasNext()) {
            TH th = (TH)it.next();
            width = width + this.dx + th.init_dim.width;
        }
        return y > left.y + left.height || x - width > left.x + width;
    }

    private void findRoots(List refs, List roots) {
        Collections.sort(refs, this.referredByComparatorAsc1);
        int refval = -1;
        if (refs.size() > 0) {
            do {
                ++refval;
                for (TH th : refs) {
                    if (th.referredBy_count != refval) continue;
                    roots.add(th);
                }
            } while (roots.size() == 0);
        }
    }

    private void applyArrange(List list) {
        for (TH th : list) {
            if (!th.arranged) continue;
            if (th.tv.getCellView() != null) {
                th.tv.getCellView().setNewBounds(new Rectangle(new Point(th.location.x, th.location.y), th.init_dim));
                continue;
            }
            th.tv.setBounds(new Rectangle(new Point(th.location), th.init_dim));
        }
    }

    private void setLevel2(TH th, int level) {
        block8: {
            if (level > th.level || th.scanned) break block8;
            ArrayList<TH> list1 = new ArrayList<TH>();
            ArrayList<TH> list2 = new ArrayList<TH>();
            th.level = level;
            th.scanned = true;
            ++this.levelled;
            for (TH tht : th.refer) {
                if (tht.level <= level + 1 || tht.scanned || tht.isScanConnectedToBetterLevel(th, th.level)) continue;
                tht.level = level + 1;
                list1.add(tht);
            }
            for (TH tht : th.referredBy) {
                if (tht.level <= level + 1 || tht.scanned || tht.isScanConnectedToBetterLevel(th, th.level)) continue;
                tht.level = level + 1;
                list2.add(tht);
            }
            if (this.mixLeftRight) {
                for (TH tht : list1) {
                    this.setLevel2(tht, level + 1);
                }
                for (TH tht : list2) {
                    this.setLevel2(tht, level + 1);
                }
            } else {
                TH tht;
                int i;
                for (i = list1.size() - 1; i >= 0; --i) {
                    tht = (TH)list1.get(i);
                    this.setLevel2(tht, level + 1);
                }
                for (i = list2.size() - 1; i >= 0; --i) {
                    tht = (TH)list2.get(i);
                    this.setLevel2(tht, level + 1);
                }
            }
        }
    }

    private List buildTH_Map(List list, boolean resize) {
        this.thMap.clear();
        ArrayList<TH> res = new ArrayList<TH>();
        for (TopView tv : list) {
            DesignObject dob = tv.getModel();
            TH th = (TH)this.thMap.get(tv.getViewID());
            if (th != null) continue;
            th = new TH();
            this.thMap.put(tv.getViewID(), th);
            th.tv = tv;
            th.table = (FKContainer)dob;
            if (resize) {
                th.init_dim = th.table instanceof Table ? this.getTableSize(tv, (Table)th.table) : this.getTableViewSize(tv, (TableView)th.table);
            } else {
                Rectangle rect;
                AbstractCellView cv = tv.getCellView();
                if (cv != null) {
                    rect = cv.getBounds().getBounds();
                    th.init_dim = new Dimension(rect.width, rect.height);
                } else {
                    rect = tv.getBounds();
                    th.init_dim = new Dimension(rect.width, rect.height);
                }
            }
            res.add(th);
        }
        Iterator it = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            FKContainer table = fk.getTable();
            FKContainer remote = fk.getRemoteTable();
            TopView tvt = fk.getTargetTopView(this);
            TopView tvs = fk.getSourceTopView(this);
            if (tvt == null || tvs == null) continue;
            this.fkList.add(fk);
            TH remth = (TH)this.thMap.get(tvs.getViewID());
            TH tabth = (TH)this.thMap.get(tvt.getViewID());
            if (table == remote || remth == null || tabth == null) continue;
            if (!remth.referredByFK.contains(fk)) {
                remth.referredBy.add(tabth);
                remth.referredByFK.add(fk);
                remth.referredByMap.put(fk.getObjectID(), tabth);
                ++remth.referredBy_count;
            }
            if (tabth.referFK.contains(fk)) continue;
            tabth.refer.add(remth);
            tabth.referFK.add(fk);
            tabth.referMap.put(fk.getObjectID(), remth);
            ++tabth.refer_count;
        }
        return res;
    }

    private List makeSynonyms(List listTH) {
        ArrayList<TH> nlist = new ArrayList<TH>();
        ArrayList<TH> list = new ArrayList<TH>();
        for (TH th : listTH) {
            if (th.referredBy_count < this.refCount) continue;
            nlist.add(th);
        }
        Collections.sort(nlist, this.referredByComparatorDesc);
        for (TH th : nlist) {
            if (th.referredBy_count < this.refCount) continue;
            list.add(th);
            th.star = true;
            if (th.refer.size() == 0 || th.referNodesWithNorefs()) {
                this.makeSynonyms(th);
                continue;
            }
            TH nth = this.createSynonmTH(th, false, false);
            this.roots.add(nth);
            Object[] fks = th.referFK.toArray();
            for (int i = fks.length - 1; i >= 0; --i) {
                TH tth;
                FKIndexAssociation fk = (FKIndexAssociation)fks[i];
                TH tht = (TH)th.referMap.get(fk.getObjectID());
                if (!tht.referredByFK.remove(fk) || (tth = (TH)tht.referredByMap.get(fk.getObjectID())) != th) continue;
                tht.referredBy.remove(th);
                tht.referredByMap.remove(fk.getObjectID());
                tht.referredBy.add(nth);
                tht.referredByFK.add(fk);
                tht.referredByMap.put(fk.getObjectID(), nth);
                FK_TV_Edit edit = new FK_TV_Edit(fk, nth.tv, false);
                this.getDesignPart().postUndoableEdit(edit);
                edit.applyUpdates();
                nth.refer.add(tht);
                nth.referFK.add(fk);
                nth.referMap.put(fk.getObjectID(), tht);
                ++nth.refer_count;
                th.refer.remove(tht);
                th.referFK.remove(fk);
                th.referMap.remove(fk.getObjectID());
                --th.refer_count;
            }
            this.makeSynonyms(th);
        }
        return list;
    }

    private void makeSynonyms(TH th) {
        Object[] fks = th.referredByFK.toArray();
        for (int i = fks.length - 1; i >= 0; --i) {
            FKIndexAssociation fk = (FKIndexAssociation)fks[i];
            TH tht = (TH)th.referredByMap.get(fk.getObjectID());
            if (tht.refer.size() + tht.referredBy.size() > 1 && !tht.referOnly(th)) {
                TH nth = (TH)th.synonymsMap.get(tht.tv.getViewID());
                if (nth == null) {
                    nth = this.createSynonmTH(tht, false, false);
                    th.synonymsMap.put(tht.tv.getViewID(), nth);
                }
                nth.usedInStar = true;
                TH tth = (TH)tht.referMap.get(fk.getObjectID());
                if (tth != th) continue;
                tht.referFK.remove(fk);
                tht.refer.remove(th);
                tht.referMap.remove(fk.getObjectID());
                --tht.refer_count;
                nth.refer.add(th);
                nth.referFK.add(fk);
                nth.referMap.put(fk.getObjectID(), th);
                ++nth.refer_count;
                th.referredBy.remove(tht);
                th.referredByMap.remove(fk.getObjectID());
                th.referredBy.add(nth);
                th.referredByMap.put(fk.getObjectID(), nth);
                FK_TV_Edit edit = new FK_TV_Edit(fk, nth.tv, false);
                this.getDesignPart().postUndoableEdit(edit);
                edit.applyUpdates();
                continue;
            }
            tht.usedInStar = true;
        }
    }

    private TH createSynonmTH(TH source, boolean cref, boolean crefBy) {
        TH th = new TH();
        this.createdTV.add(th);
        th.init_dim = new Dimension(source.init_dim);
        if (cref) {
            th.refer.addAll(source.refer);
            th.refer_count = source.refer_count;
            th.referFK.addAll(source.referFK);
        }
        if (crefBy) {
            th.referredBy.addAll(source.refer);
            th.referredBy_count = source.refer_count;
            th.referredByFK.addAll(source.referFK);
        }
        th.table = source.table;
        th.tv = source.tv.createViewSynonim(this);
        return th;
    }

    public void rearrangeNoneRefTables(List nonRefs) {
        this.left = this.initialLeft;
        this.width = 35;
        this.height = 50;
        this.count = 0;
        float square = (float)Math.sqrt(nonRefs.size());
        long maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++maxTablePerRow;
        }
        ++maxTablePerRow;
        for (TH th : nonRefs) {
            ++this.count;
            Dimension dim = th.init_dim;
            this.width = dim.width;
            this.height = Math.max(dim.height, this.height);
            th.location = new Point(this.left, this.top);
            th.arranged = true;
            this.left = this.left + this.width + 50;
            if ((long)this.count != maxTablePerRow) continue;
            this.count = 0;
            this.left = this.initialLeft;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    public void resetLabelsSize() {
        List fks = (List)this.getTVFKRelations();
        for (TopView topView : fks) {
            Label label;
            if (topView == null || (label = ((TVConnector)topView).getCenterLabel()) == null) continue;
            ((LabelView)label.getTopView().getCellView()).resetLabelSize(false);
        }
    }

    public void resizeTable(TopView topView) {
        Dimension dim = this.getTableSize(topView, (Table)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    public void resizeTables() {
        List tables = (List)this.getTVTables();
        for (TopView topView : tables) {
            if (topView == null) continue;
            this.resizeTable(topView);
        }
    }

    public void resizeView(TopView topView) {
        Dimension dim = this.getTableViewSize(topView, (TableView)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    public void resizeViews() {
        List views = (List)this.getTVViews();
        for (TopView topView : views) {
            if (topView == null) continue;
            this.resizeView(topView);
        }
    }

    @Override
    public void resizeSelectedObjects() {
        if (this.getWorkSpace().getSelectionCount() > 0) {
            Object[] cells = this.getWorkSpace().getSelectionCells();
            for (int i = 0; i < cells.length; ++i) {
                TopView topView;
                Object cell = cells[i];
                if (!(cell instanceof DefaultDiagramCell) || (topView = ((DefaultDiagramCell)cell).getTopView()) == null) continue;
                if (topView instanceof TVTable) {
                    this.resizeTable(topView);
                    continue;
                }
                if (!(topView instanceof TVView)) continue;
                this.resizeView(topView);
            }
        }
    }

    public int getMaxTopPoint() {
        int maxTop = 20;
        List tables = (List)this.getTVTables();
        for (TopView topView : tables) {
            if (topView == null) continue;
            Rectangle rec = topView.getBounds();
            int y = rec.y + rec.height;
            maxTop = Math.max(maxTop, y);
        }
        List views = (List)this.getTVViews();
        for (TopView topView : views) {
            if (topView == null) continue;
            Rectangle rec = topView.getBounds();
            int y = rec.y + rec.height;
            maxTop = Math.max(maxTop, y);
        }
        return maxTop += 50;
    }

    public void rearrangeNewTables(List topViews, int maxTop) {
        this.top = maxTop;
        this.left = 20;
        this.width = 35;
        this.height = 50;
        this.count = 0;
        Collections.sort(topViews, new TableComparator());
        float square = (float)Math.sqrt(topViews.size());
        long maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++maxTablePerRow;
        }
        ++maxTablePerRow;
        for (TopView topView : topViews) {
            if (topView == null) continue;
            ++this.count;
            Dimension dim = this.getTableSize(topView, (Table)topView.getModel());
            this.width = dim.width;
            this.height = Math.max(dim.height, this.height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
            } else {
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
            }
            this.left = this.left + this.width + 50;
            if ((long)this.count != maxTablePerRow) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    public void rearrangeTables() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 50;
        this.count = 0;
        List tables = (List)this.getTVTables();
        Collections.sort(tables, new TableComparator());
        float square = (float)Math.sqrt(tables.size());
        long maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++maxTablePerRow;
        }
        ++maxTablePerRow;
        for (TopView topView : tables) {
            if (topView == null) continue;
            ++this.count;
            Dimension dim = this.getTableSize(topView, (Table)topView.getModel());
            this.width = dim.width;
            this.height = Math.max(dim.height, this.height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
            } else {
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
            }
            this.left = this.left + this.width + 50;
            if ((long)this.count != maxTablePerRow) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    private Dimension getTableSize(TopView tv, Table table) {
        String dtName;
        String lname;
        int colTextHeight;
        int w = 35;
        int h = 21;
        int colCount = 0;
        int dtLength = 1;
        int cLength = 1;
        String title = table.getName();
        StructuredType st = null;
        List<DesignPartView.Prop> props = Collections.EMPTY_LIST;
        if (this.isShowDynamicProperties()) {
            props = DPVRelational.getVisibleProperties(table);
        }
        if (table.isBST() && table.getBasedOnStructuredType() != null) {
            title = title + " (" + table.getBasedOnStructuredType().getName() + ")";
        }
        if (table.getSchemaObject() != null) {
            title = table.getSchemaObject().getName() + "." + title;
        }
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        h = h + 2 + 6;
        String comments = table.getCommentInRDBMS().trim();
        if (this.isShowNamesOnly()) {
            if (this.showComments() && !"".equalsIgnoreCase(comments)) {
                h = h + 3 + 1;
                String[] wrappedComments = ContainerRenderer.wrapText(comments, ContainerRenderer.getMaxChars(comments, fm, w * 2 + titleLength - fm.stringWidth("WWW")));
                for (int t = 0; t < wrappedComments.length; ++t) {
                    h += colTextHeight;
                }
            }
            return new Dimension(w * 2 + titleLength, h);
        }
        h = h + 3 + 1;
        if (this.isShowClassificationTypes()) {
            h += colTextHeight;
            h = h + 3 + 1;
        }
        ArrayList<ContainedObjectWithDomain> visibleColumns = new ArrayList<ContainedObjectWithDomain>();
        Font colFont = tv.getFontObject(EditableFonts.FO_COLUMN).getFont();
        if (this.showAllDetails() || this.showElements() || this.showKeyElements()) {
            ContainedObject[] columns;
            if (table.isBST() && table.getTypeSubstitution() != null) {
                st = table.getBasedOnStructuredType();
                if (st != null) {
                    colCount = st.getElements().length;
                }
            } else if (this.showKeyElements()) {
                columns = table.getElements();
                int count = 0;
                for (int i = 0; i < columns.length; ++i) {
                    ContainedObjectWithDomain column = (ContainedObjectWithDomain)columns[i];
                    if (!column.isPKElement() && !column.isFKElement() && !column.isUnique() || tv.getHiddenElements().contains(column)) continue;
                    visibleColumns.add(column);
                    ++count;
                }
                colCount = count;
            } else {
                visibleColumns.addAll(table.getElementsCollection());
                colCount = table.getElements().length;
                for (Object obj : tv.getHiddenElements()) {
                    if (!(obj instanceof ContainedObject)) continue;
                    --colCount;
                }
                if (colCount < 0) {
                    colCount = 0;
                }
            }
            if (this.isExpandComplexTypes()) {
                for (ContainedObject co : columns = table.getElements()) {
                    if (tv.getHiddenElements().contains(co)) continue;
                    colCount += this.getAddtionalRows(co);
                }
            }
            fm = this.getFontMetrics(colFont);
            colTextHeight = fm.getHeight();
            h += (colCount += props.size()) * colTextHeight;
            if (props.size() > 0) {
                h += 6;
            }
        }
        Font keyFont = tv.getFontObject(EditableFonts.FO_KEY).getFont();
        fm = this.getFontMetrics(keyFont);
        int keyWidth = 0;
        boolean hasFK = false;
        boolean hasUK = false;
        boolean hasInd = false;
        if (this.showAllDetails() || this.showFKeys() || this.showKeys() || this.showIndexes()) {
            int keyCount = 0;
            if (table.getKeys().length > 0) {
                for (int i = 0; i < table.getKeys().length; ++i) {
                    KeyObject key = table.getKeys()[i];
                    if (tv.getHiddenElements().contains(key)) continue;
                    if (key.isPK() || key.isUnique()) {
                        hasUK = true;
                    } else if (key.isFK()) {
                        hasFK = true;
                    } else {
                        hasInd = true;
                    }
                    if (!this.showAllDetails()) {
                        boolean mustContinue = true;
                        if ((key.isPK() || key.isUnique()) && this.showKeys()) {
                            mustContinue = false;
                        }
                        if (!key.isPK() && !key.isUnique() && !key.isFK() && this.showIndexes()) {
                            mustContinue = false;
                        }
                        if (key.isFK() && this.showFKeys()) {
                            mustContinue = false;
                        }
                        if (mustContinue) continue;
                    }
                    ++keyCount;
                    int cl = fm.stringWidth(table.getKeys()[i].getName());
                    if (this.showAllDetails() || this.showKeyAndIndexColumns()) {
                        Index ind;
                        String colNames = " (";
                        String expr = null;
                        if (key instanceof Index && "".equals(expr = (ind = (Index)key).getIndexExpression())) {
                            expr = null;
                        }
                        if (expr == null) {
                            ContainedObject[] columns = table.getKeys()[i].getElements();
                            for (int j = 0; j < columns.length; ++j) {
                                ContainedObject column = columns[j];
                                String colName = column.getName();
                                if (j > 0) {
                                    colNames = colNames + ", ";
                                }
                                colNames = colNames + colName;
                            }
                        } else {
                            colNames = colNames + expr;
                        }
                        colNames = colNames + ")";
                        cl += fm.stringWidth(colNames);
                    }
                    keyWidth = Math.max(cl, keyWidth);
                }
            }
            if (keyCount > 0) {
                h += keyCount * fm.getHeight();
                if (hasFK && (this.showAllDetails() || this.showFKeys())) {
                    h += 6;
                }
                if (hasUK && (this.showAllDetails() || this.showKeys())) {
                    h += 6;
                }
                if (hasInd && (this.showAllDetails() || this.showIndexes())) {
                    h += 6;
                }
            }
        }
        int colLength = 1;
        fm = this.getFontMetrics(colFont);
        int cc = 0;
        String prop_text = DPVRelational.getLongestPropertyText(props);
        int propLength = fm.stringWidth(prop_text);
        if (st != null) {
            cc = st.getAttributesCount();
            lname = ContainerRenderer.getLongestTypeName(st.getElements(), this.isExpandComplexTypes());
            colLength = fm.stringWidth(lname);
            if (this.showAllDetails() || this.showDatatype()) {
                dtName = ContainerRenderer.getLongestDTNameInStrType(st, this.isExpandComplexTypes(), table.getSelectedRDBMSType().toString());
                dtLength = fm.stringWidth(dtName);
            }
        } else {
            cc = table.getElementsCollection().size();
            lname = ContainerRenderer.getLongestName(table.getElements(), this.isExpandComplexTypes());
            colLength = fm.stringWidth(lname);
            if (this.showAllDetails() || this.showDatatype()) {
                dtName = ContainerRenderer.getLongestDTName(table.getElements(), table, this.isExpandComplexTypes());
                dtLength = fm.stringWidth(dtName);
            }
        }
        for (int i = 0; i < cc; ++i) {
            if (st != null) {
                if (this.showAllDetails() || !this.showDatatype()) continue;
                continue;
            }
            try {
                ContainedObjectWithDomain element = (ContainedObjectWithDomain)table.getElement(i);
                if (this.showAllDetails() || this.showDatatype()) {
                    // empty if block
                }
                if (!this.showComments() || !visibleColumns.contains(element)) continue;
                int coml = fm.stringWidth(element.getCommentInRDBMS().trim()) + fm.stringWidth("KW");
                cLength = Math.max(coml, cLength);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (colLength == 1) {
            colLength = fm.stringWidth(table.getName());
        }
        colLength += fm.stringWidth("KWN");
        colLength = Math.max(keyWidth, colLength + dtLength + cLength);
        colLength = Math.max(titleLength, colLength);
        colLength = Math.max(propLength, colLength);
        if (this.showComments() && !"".equalsIgnoreCase(comments)) {
            h = h + 3 + 1;
            fm = this.getFontMetrics(titleFont);
            String[] wrappedComments = ContainerRenderer.wrapText(comments, ContainerRenderer.getMaxChars(comments, fm, w + colLength - fm.stringWidth("WW")));
            for (int t = 0; t < wrappedComments.length; ++t) {
                h += fm.getHeight();
            }
        }
        return new Dimension(w + colLength, h);
    }

    public int getAddtionalRows(ContainerObject co) {
        int res = 0;
        for (Object obj : co.getElementsCollection()) {
            TypeElement te;
            CollectionType ct;
            if (!(obj instanceof ContainedObjectWithDomain)) continue;
            ContainedObjectWithDomain cob = (ContainedObjectWithDomain)obj;
            if (3 == cob.getUse() && !cob.isReference()) {
                StructuredType st = cob.getStructuredType();
                if (st == null) continue;
                res = this.getExpandedRows(st);
                continue;
            }
            if (4 != cob.getUse() || (ct = cob.getCollectionType()) == null || (te = ct.getElementType()) == null || te.isReference() || !(te.getType() instanceof StructuredType)) continue;
            StructuredType st = (StructuredType)te.getType();
            res = this.getExpandedRows(st);
        }
        return res;
    }

    public int getAddtionalRows(ContainedObject co) {
        int res = 0;
        if (co instanceof ContainedObjectWithDomain) {
            TypeElement te;
            CollectionType ct;
            ContainedObjectWithDomain cob = (ContainedObjectWithDomain)co;
            if (3 == cob.getUse() && !cob.isReference()) {
                StructuredType st = cob.getStructuredType();
                if (st != null) {
                    res = this.getExpandedRows(st);
                }
            } else if (4 == cob.getUse() && (ct = cob.getCollectionType()) != null && (te = ct.getElementType()).getType() instanceof StructuredType && !te.isReference()) {
                res = this.getExpandedRows((StructuredType)te.getType());
            }
        }
        return res;
    }

    public int getExpandedRows(StructuredType st) {
        TypeElement[] tels;
        int res = 0;
        for (TypeElement te : tels = st.getElements()) {
            TypeElement te2;
            CollectionType ct;
            if (te.getType() instanceof StructuredType && !te.isReference()) {
                StructuredType st2 = (StructuredType)te.getType();
                res += this.getExpandedRows(st2);
            } else if (te.getType() instanceof CollectionType && (ct = (CollectionType)te.getType()) != null && !(te2 = ct.getElementType()).isReference() && te2.getType() instanceof StructuredType) {
                StructuredType st2 = (StructuredType)te2.getType();
                res += this.getExpandedRows(st2);
            }
            ++res;
        }
        return res;
    }

    public void rearrangeNewViews(List topViews) {
        if (this.left > 20) {
            this.left = 20;
            this.top = this.top + this.height + 50;
        }
        this.count = 0;
        this.width = 35;
        this.height = 25;
        Collections.sort(topViews, new ContainerObjectComparator());
        float square = (float)Math.sqrt(topViews.size());
        long maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++maxTablePerRow;
        }
        for (TopView topView : topViews) {
            if (topView == null) continue;
            ++this.count;
            Dimension dim = this.getTableViewSize(topView, (TableView)topView.getModel());
            this.width = dim.width;
            this.height = Math.max(dim.height, this.height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
            } else {
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
            }
            this.left = this.left + this.width + 50;
            if ((long)this.count != maxTablePerRow) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    public void rearrangeViews() {
        if (this.left > 20) {
            this.left = 20;
            this.top = this.top + this.height + 50;
        }
        this.count = 0;
        this.width = 35;
        this.height = 25;
        List views = (List)this.getTVViews();
        Collections.sort(views, new ContainerObjectComparator());
        float square = (float)Math.sqrt(views.size());
        long maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++maxTablePerRow;
        }
        for (TopView topView : views) {
            if (topView == null) continue;
            ++this.count;
            Dimension dim = this.getTableViewSize(topView, (TableView)topView.getModel());
            this.width = dim.width;
            this.height = Math.max(dim.height, this.height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
            } else {
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
            }
            this.left = this.left + this.width + 50;
            if ((long)this.count != maxTablePerRow) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    private Dimension getTableViewSize(TopView tv, TableView view) {
        String lname;
        int colTextHeight;
        int w = 35;
        int h = 21;
        int colCount = 0;
        int dtLength = 1;
        int cLength = 1;
        String title = view.getName();
        StructuredType st = null;
        if (view.isBST() && view.getBasedOnStructuredType() != null) {
            title = title + " (" + view.getBasedOnStructuredType().getName() + ")";
        }
        if (view.getSchemaObject() != null) {
            title = view.getSchemaObject().getName() + "." + title;
        }
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        h = h + 2 + 6;
        String comments = view.getCommentInRDBMS().trim();
        if (this.isShowNamesOnly()) {
            if (this.showComments() && !"".equalsIgnoreCase(comments)) {
                h = h + 3 + 1;
                String[] wrappedComments = ContainerRenderer.wrapText(comments, ContainerRenderer.getMaxChars(comments, fm, w * 2 + titleLength - fm.stringWidth("WWW")));
                for (int t = 0; t < wrappedComments.length; ++t) {
                    h += colTextHeight;
                }
            }
            return new Dimension(w * 2 + titleLength, h);
        }
        ArrayList<ContainedObjectWithDomain> visibleColumns = new ArrayList<ContainedObjectWithDomain>();
        if (this.showAllDetails() || this.showElements() || this.showKeyElements()) {
            Font colFont = tv.getFontObject(EditableFonts.FO_COLUMN).getFont();
            if (view.isBST() && view.getTypeSubstitution() != null) {
                st = view.getBasedOnStructuredType();
                if (st != null) {
                    colCount = st.getElements().length;
                }
            } else if (this.showKeyElements()) {
                ContainedObject[] columns = view.getElements();
                int count = 0;
                for (int i = 0; i < columns.length; ++i) {
                    ContainedObjectWithDomain column = (ContainedObjectWithDomain)columns[i];
                    if (!column.isPKElement() && !column.isFKElement() && !column.isUnique() || tv.getHiddenElements().contains(column)) continue;
                    visibleColumns.add(column);
                    ++count;
                }
                colCount = count;
            } else {
                visibleColumns.addAll(view.getElementsCollection());
                colCount = view.getElements().length;
                for (Object obj : tv.getHiddenElements()) {
                    if (!(obj instanceof ContainedObject)) continue;
                    --colCount;
                }
                if (colCount < 0) {
                    colCount = 0;
                }
            }
            fm = this.getFontMetrics(colFont);
            colTextHeight = fm.getHeight();
            h += colCount * colTextHeight;
            h += 6;
            if (this.showAllDetails()) {
                int containersCount = view.getUsedTablesAndViews().size();
                if (containersCount == 0) {
                    containersCount = view.getUsedContainers().size();
                }
                if (containersCount > 1) {
                    h += containersCount * colTextHeight;
                } else if (containersCount == 1) {
                    h += colTextHeight;
                }
            }
        }
        Font keyFont = tv.getFontObject(EditableFonts.FO_KEY).getFont();
        fm = this.getFontMetrics(keyFont);
        int keyWidth = 0;
        boolean hasFK = false;
        boolean hasUK = false;
        boolean hasInd = false;
        if (this.showAllDetails() || this.showFKeys() || this.showKeys() || this.showIndexes()) {
            int keyCount = 0;
            if (view.getKeys().length > 0) {
                for (int i = 0; i < view.getKeys().length; ++i) {
                    KeyObject key = view.getKeys()[i];
                    if (tv.getHiddenElements().contains(key)) continue;
                    if (key.isPK() || key.isUnique()) {
                        hasUK = true;
                    } else if (key.isFK()) {
                        hasFK = true;
                    } else {
                        hasInd = true;
                    }
                    if (!this.showAllDetails()) {
                        boolean mustContinue = true;
                        if ((key.isPK() || key.isUnique()) && this.showKeys()) {
                            mustContinue = false;
                        }
                        if (!key.isPK() && !key.isUnique() && !key.isFK() && this.showIndexes()) {
                            mustContinue = false;
                        }
                        if (key.isFK() && this.showFKeys()) {
                            mustContinue = false;
                        }
                        if (mustContinue) continue;
                    }
                    ++keyCount;
                    int cl = fm.stringWidth(view.getKeys()[i].getName());
                    if (this.showAllDetails() || this.showKeyAndIndexColumns()) {
                        Index ind;
                        String colNames = " (";
                        String expr = null;
                        if (key instanceof Index && "".equals(expr = (ind = (Index)key).getIndexExpression())) {
                            expr = null;
                        }
                        if (expr == null) {
                            ContainedObject[] columns = view.getKeys()[i].getElements();
                            for (int j = 0; j < columns.length; ++j) {
                                ContainedObject column = columns[j];
                                String colName = column.getName();
                                if (j > 0) {
                                    colNames = colNames + ", ";
                                }
                                colNames = colNames + colName;
                            }
                        } else {
                            colNames = colNames + expr;
                        }
                        colNames = colNames + ")";
                        cl += fm.stringWidth(colNames);
                    }
                    keyWidth = Math.max(cl, keyWidth);
                }
            }
            if (keyCount > 0) {
                h += keyCount * fm.getHeight();
                if (hasFK && (this.showAllDetails() || this.showFKeys())) {
                    h += 6;
                }
                if (hasUK && (this.showAllDetails() || this.showKeys())) {
                    h += 6;
                }
                if (hasInd && (this.showAllDetails() || this.showIndexes())) {
                    h += 6;
                }
            }
        }
        int colLength = 1;
        int cc = 0;
        if (st != null) {
            cc = st.getAttributesCount();
            lname = ContainerRenderer.getLongestTypeName(st.getElements(), this.isExpandComplexTypes());
            colLength = fm.stringWidth(lname);
            if (this.showAllDetails() || this.showDatatype()) {
                String dtName = ContainerRenderer.getLongestDTNameInStrType(st, this.isExpandComplexTypes(), view.getSelectedRDBMSType().toString());
                dtLength = fm.stringWidth(dtName);
            }
        } else {
            cc = view.getElementsCollection().size();
            lname = ContainerRenderer.getLongestName(view.getElements(), this.isExpandComplexTypes());
            colLength = fm.stringWidth(lname);
            if (this.showAllDetails() || this.showDatatype()) {
                String dtName = ContainerRenderer.getLongestDTName(view.getElements(), view, this.isExpandComplexTypes());
                dtLength = fm.stringWidth(dtName);
            }
        }
        ContainedObject[] elements = view.getColumns();
        for (int i = 0; i < cc; ++i) {
            if (st != null) {
                TypeElement element = st.getElements()[i];
                int cl = fm.stringWidth(element.getName());
                colLength = Math.max(cl, colLength);
                if (!this.showAllDetails() && !this.showDatatype()) continue;
                int dtl = fm.stringWidth(element.getDataType() + 40);
                dtLength = Math.max(dtl, dtLength);
                continue;
            }
            if (elements[i] instanceof ColumnView) {
                ColumnView element = (ColumnView)elements[i];
                String name = element.getAlias();
                if ("".equalsIgnoreCase(name)) {
                    name = element.getReferencedName();
                }
                int cl = fm.stringWidth(name);
                colLength = Math.max(cl, colLength);
                if (this.showAllDetails() || this.showDatatype()) {
                    String dtype = element.getDataTypeString();
                    if (dtype == null && (dtype = element.getExpression()) == null) {
                        dtype = "";
                    }
                    int dtl = fm.stringWidth(dtype);
                    dtLength = Math.max(dtl, dtLength);
                }
                if (!this.showComments() || !visibleColumns.contains(element)) continue;
                int coml = fm.stringWidth(element.getCommentInRDBMS().trim() + fm.stringWidth("KW"));
                cLength = Math.max(coml, cLength);
                continue;
            }
            int cl = fm.stringWidth(elements[i].getName());
            colLength = Math.max(cl, colLength);
        }
        if (this.showAllDetails()) {
            if (!view.getUsedTablesAndViews().isEmpty()) {
                for (SQLNameHelper helper : view.getUsedTablesAndViews()) {
                    int cl = fm.stringWidth(helper.getTableName());
                    colLength = Math.max(cl, colLength);
                }
            } else {
                for (AbstractView.ContainerHolder ch : view.getUsedContainers()) {
                    ContainerObject dobj = ch.getContainer();
                    int cl = fm.stringWidth(dobj.getName());
                    colLength = Math.max(cl, colLength);
                }
            }
        }
        colLength += fm.stringWidth("KWN");
        colLength = Math.max(titleLength, colLength + dtLength + cLength);
        colLength = Math.max(keyWidth, colLength);
        if (this.showComments() && !"".equalsIgnoreCase(comments)) {
            h = h + 3 + 1;
            fm = this.getFontMetrics(titleFont);
            String[] wrappedComments = ContainerRenderer.wrapText(comments, ContainerRenderer.getMaxChars(comments, fm, w + colLength - fm.stringWidth("WW")));
            for (int t = 0; t < wrappedComments.length; ++t) {
                h += fm.getHeight();
            }
        }
        return new Dimension(w + colLength, h);
    }

    @Override
    public void setZeroLayout() {
        if (!this.layOutchanging) {
            this.autoLayout = 0;
        }
    }

    @Override
    public void fireSelectionChanged() {
        if (((ControllerRelational)this.getController()).getNewArcAction() != null) {
            ((ControllerRelational)this.getController()).getNewArcAction().setEnabled(true);
        }
        if (((ControllerRelational)this.getController()).getAddToArcAction() != null) {
            ((ControllerRelational)this.getController()).getAddToArcAction().setEnabled(true);
        }
        if (((ControllerRelational)this.getController()).getRemoveFromArcAction() != null) {
            ((ControllerRelational)this.getController()).getRemoveFromArcAction().setEnabled(true);
        }
        if (ApplicationView.isGUIMode()) {
            IdeDMUtils.updateVisibleActions();
        }
    }

    @Override
    public void createSubViewFromSelected() {
        Object[] selectedObjects = this.getSelectedObjects();
        this.createSubViewFromSelected(selectedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSubViewFromSelected(Object[] selectedObjects) {
        if (selectedObjects.length > 0) {
            this.getUndoManager().setLocked(true);
            try {
                DesignPartView subView = this.getApplicationView().createSubview(this);
                if (subView != null) {
                    Object obj;
                    int i;
                    subView.setAutoRoute(false);
                    for (i = 0; i < selectedObjects.length; ++i) {
                        obj = selectedObjects[i];
                        if (!(obj instanceof Table) && !(obj instanceof TableView)) continue;
                        this.addObjectToSubView((ContainerObject)obj, subView);
                    }
                    for (int k = 0; k < selectedObjects.length; ++k) {
                        obj = selectedObjects[k];
                        if (!(obj instanceof FKContainer)) continue;
                        FKContainer table = (FKContainer)obj;
                        FKIndexAssociation[] fks = table.getFKAssociations();
                        for (int n = 0; n < fks.length; ++n) {
                            List t_edgePoints;
                            List s_edgePoints;
                            TVConnector tvc = (TVConnector)fks[n].getViewFor(this);
                            TVConnector tvc_t = (TVConnector)fks[n].getViewFor(subView);
                            if (tvc_t == null || tvc == null) continue;
                            EdgeView ev = null;
                            if (tvc.getEdge() != null) {
                                ev = (EdgeView)tvc.getEdge().getCellView();
                            }
                            if (ev != null) {
                                s_edgePoints = ev.getPoints();
                                t_edgePoints = tvc_t.getEdgePoints();
                                t_edgePoints.clear();
                                for (int i2 = 0; i2 < s_edgePoints.size(); ++i2) {
                                    Object p = s_edgePoints.get(i2);
                                    Point2D point = null;
                                    if (p instanceof Point2D) {
                                        point = (Point2D)p;
                                    } else if (p instanceof PortView) {
                                        point = ((PortView)p).getPoint();
                                    }
                                    if (point == null) continue;
                                    t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                                }
                                if (tvc_t.getEdge() == null || tvc_t.getEdge().getCellView() == null) continue;
                                Hashtable hashtable = new Hashtable();
                                DiagramConstants.setPoints(hashtable, t_edgePoints);
                                tvc_t.getEdge().changeAttributes(hashtable);
                                tvc_t.getEdge().getCellView().update();
                                if (t_edgePoints.size() != 2) continue;
                                tvc_t.getEdge().straightLine(false);
                                continue;
                            }
                            s_edgePoints = tvc.getEdgePoints();
                            t_edgePoints = tvc_t.getEdgePoints();
                            t_edgePoints.clear();
                            for (int j = 0; j < s_edgePoints.size(); ++j) {
                                Point2D point = (Point2D)s_edgePoints.get(j);
                                t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                            }
                        }
                    }
                    for (i = 0; i < selectedObjects.length; ++i) {
                        TVTable tv;
                        obj = selectedObjects[i];
                        if (!(obj instanceof Table) || (tv = (TVTable)subView.getViewFor((DesignObject)obj)) == null) continue;
                        tv.addArcs();
                    }
                    subView.setAutoRoute(this.isAutoRoute());
                    subView.getWorkSpace().updateSettings();
                }
            }
            finally {
                this.getUndoManager().setLocked(false);
            }
        }
    }

    private void addObjectToSubView(ContainerObject object, DesignPartView subView) {
        TopView tv = this.getViewFor(object);
        ContainerView tvt = tv.createViewSynonim(subView);
        if (tvt.getCellView() != null) {
            tvt.getCellView().setNewBounds(tv.getBounds());
        } else {
            tvt.setBounds(tv.getBounds());
        }
        if (tvt instanceof TVTable) {
            ((TVTable)tvt).addTVFKRelations();
            ((TVTable)tvt).addArcs();
        } else if (tvt instanceof TVView) {
            ((TVView)tvt).addTVFKRelations();
        }
        tvt.addTVTypeSubstitutions();
        tvt.setHideElementsInCurrentOnly(tv.isHideElementsInCurrentOnly());
        tvt.getHiddenElements().addAll(tv.getHiddenElements());
        subView.synchronizeSynonymWithDisplays(tvt);
    }

    @Override
    public void createSubViewWithRelatedObjects() {
        Object[] selectedObjects = this.getSelectedObjects();
        this.createSubViewWithRelatedObjects(selectedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSubViewWithRelatedObjects(Object[] selectedObjects) {
        if (selectedObjects.length > 0) {
            this.getUndoManager().setLocked(true);
            try {
                ArrayList<ContainerObject> relatedTables = new ArrayList<ContainerObject>();
                DesignPartView subView = this.getApplicationView().createSubview(this);
                if (subView != null) {
                    subView.setAutoRoute(false);
                    for (int i = 0; i < selectedObjects.length; ++i) {
                        Object object = selectedObjects[i];
                        if (!(object instanceof TableView)) continue;
                        TableView tableView = (TableView)object;
                        this.addObjectToSubView(tableView, subView);
                        List list = tableView.getUsedContainers();
                        for (AbstractView.ContainerHolder ch : list) {
                            ContainerObject container = ch.getContainer();
                            this.addObjectToSubView(container, subView);
                            if (!(container instanceof Table)) continue;
                            relatedTables.add(container);
                        }
                    }
                    for (Object e : relatedTables) {
                        if (!(e instanceof Table)) continue;
                        Table table = (Table)e;
                        FKIndexAssociation[] fks = table.getFKAssociations();
                        for (int n = 0; n < fks.length; ++n) {
                            List t_edgePoints;
                            List s_edgePoints;
                            TVConnector tvc = (TVConnector)fks[n].getViewFor(this);
                            TVConnector tvc_t = (TVConnector)fks[n].getViewFor(subView);
                            if (tvc_t == null || tvc == null) continue;
                            EdgeView ev = null;
                            if (tvc.getEdge() != null) {
                                ev = (EdgeView)tvc.getEdge().getCellView();
                            }
                            if (ev != null) {
                                s_edgePoints = ev.getPoints();
                                t_edgePoints = tvc_t.getEdgePoints();
                                t_edgePoints.clear();
                                for (int i = 0; i < s_edgePoints.size(); ++i) {
                                    Object p = s_edgePoints.get(i);
                                    Point2D point = null;
                                    if (p instanceof Point2D) {
                                        point = (Point2D)p;
                                    } else if (p instanceof PortView) {
                                        point = ((PortView)p).getPoint();
                                    }
                                    if (point == null) continue;
                                    t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                                }
                                if (tvc_t.getEdge() == null || tvc_t.getEdge().getCellView() == null) continue;
                                Hashtable hashtable = new Hashtable();
                                DiagramConstants.setPoints(hashtable, t_edgePoints);
                                tvc_t.getEdge().changeAttributes(hashtable);
                                tvc_t.getEdge().getCellView().update();
                                if (t_edgePoints.size() != 2) continue;
                                tvc_t.getEdge().straightLine(false);
                                continue;
                            }
                            s_edgePoints = tvc.getEdgePoints();
                            t_edgePoints = tvc_t.getEdgePoints();
                            t_edgePoints.clear();
                            for (int j = 0; j < s_edgePoints.size(); ++j) {
                                Point2D point = (Point2D)s_edgePoints.get(j);
                                t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                            }
                        }
                    }
                    for (Object e : relatedTables) {
                        TVTable tv;
                        if (!(e instanceof Table) || (tv = (TVTable)subView.getViewFor((DesignObject)e)) == null) continue;
                        tv.addArcs();
                    }
                    subView.setAutoRoute(this.isAutoRoute());
                    subView.getWorkSpace().updateSettings();
                }
            }
            finally {
                this.getUndoManager().setLocked(false);
            }
        }
    }

    @Override
    public void selectNeighbors(ContainerObject container) {
        SelectNeighborsDialog dialog = new SelectNeighborsDialog(this.getApplicationView(), true);
        dialog.showDialog();
        int zones = dialog.getZones();
        int type = dialog.getType();
        if (zones > -1) {
            ArrayList<ContainerObject> list = new ArrayList<ContainerObject>();
            Table table = (Table)container;
            list.add(container);
            RelationalDesign.collectNeighbors(table, list, zones, zones == 0, type);
            this.getWorkSpace().setSelectionCells(this.getCellsFromObjects(list).toArray());
        }
    }

    @Override
    public DP_UndoManager getUndoManager() {
        return this.getDesignPart().getUndoManager();
    }

    public void validateTables(boolean validateAllTables) {
        this.validateQueryObjects(validateAllTables, true);
    }

    @Override
    public void validateViews(boolean validateAllViews) {
        this.validateQueryObjects(validateAllViews, false);
    }

    private void validateQueryObjects(final boolean validateAll, final boolean validateTables) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long l = System.currentTimeMillis();
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ProgressDialog monitor = new ProgressDialog(ApplicationView.getInstance(), "", 0, 0);
                    try {
                        String messageText = validateTables ? Messages.getString("DPVRelational.ValidatingTable") : Messages.getString("DPVRelational.ValidatiingView");
                        QueryBuilder queryBuilder = null;
                        if (validateAll) {
                            Collection tvViews = validateTables ? DPVRelational.this.getTVTables() : DPVRelational.this.getTVViews();
                            monitor.setMaximum(tvViews.size() + 1);
                            int count = 0;
                            Iterator it = tvViews.iterator();
                            while (it.hasNext()) {
                                ++count;
                                TVFKContainer tv = (TVFKContainer)it.next();
                                FKContainer tableOrView = (FKContainer)tv.getModel();
                                if (tableOrView.isRemoteObject() || tableOrView.getUserDefinedSQL().isEmpty() || tableOrView.isParsed() && tableOrView.isValidSQL() && !tableOrView.isIncorrectSQL()) continue;
                                monitor.setNote(messageText + tableOrView.getName());
                                monitor.setProgress(count);
                                if (tableOrView.getSQLNames().isEmpty()) {
                                    if (queryBuilder == null) {
                                        queryBuilder = new QueryBuilder(true);
                                        QBUtils.initMetadata(DPVRelational.this.getDesignPart(), queryBuilder, null, false);
                                    }
                                    if (tableOrView instanceof TableView) {
                                        ((TableView)tableOrView).parseOlderStyleView(queryBuilder, null);
                                        continue;
                                    }
                                    ((Table)tableOrView).parseSQL(queryBuilder);
                                    continue;
                                }
                                if (tableOrView instanceof TableView) {
                                    ((TableView)tableOrView).validateSQL();
                                    continue;
                                }
                                ((Table)tableOrView).validateSQL();
                            }
                        } else {
                            Object[] cells = DPVRelational.this.getWorkSpace().getSelectionCells();
                            monitor.setMaximum(cells.length + 1);
                            for (int i = 0; i < cells.length; ++i) {
                                FKContainer tableOrView;
                                TopView topView;
                                Object cell = cells[i];
                                if ((validateTables || !(cell instanceof TableViewDiagramCell)) && (!validateTables || !(cell instanceof TableDiagramCell)) || (topView = ((FKDiagramCell)cell).getTopView()) == null || (tableOrView = (FKContainer)topView.getModel()).isRemoteObject() || tableOrView.getUserDefinedSQL().isEmpty() || tableOrView.isParsed() && tableOrView.isValidSQL() && !tableOrView.isIncorrectSQL()) continue;
                                monitor.setNote(messageText + tableOrView.getName());
                                monitor.setProgress(i + 1);
                                if (tableOrView.getSQLNames().isEmpty()) {
                                    if (queryBuilder == null) {
                                        queryBuilder = new QueryBuilder(true);
                                        QBUtils.initMetadata(DPVRelational.this.getDesignPart(), queryBuilder, null, false);
                                    }
                                    if (tableOrView instanceof TableView) {
                                        ((TableView)tableOrView).parseOlderStyleView(queryBuilder, null);
                                        continue;
                                    }
                                    ((Table)tableOrView).parseSQL(queryBuilder);
                                    continue;
                                }
                                if (tableOrView instanceof TableView) {
                                    ((TableView)tableOrView).validateSQL();
                                    continue;
                                }
                                ((Table)tableOrView).validateSQL();
                            }
                        }
                    }
                    finally {
                        monitor.close();
                        DPVRelational.this.getWorkSpace().repaint();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error Validating Views: ", e);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
                System.out.println("validateViews Time: " + (System.currentTimeMillis() - l));
                System.gc();
            }
        });
        thread.start();
    }

    @Override
    public void parseOlderStyleViews(boolean parseAllViews) {
        this.parseQueryObjects(parseAllViews, false);
    }

    public void parseQueryObjects(final boolean parseAllViews, final boolean parseAllTables) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long l = System.currentTimeMillis();
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    QueryBuilder queryBuilder = null;
                    ProgressDialog monitor = new ProgressDialog(ApplicationView.getInstance(), "", 0, 0);
                    try {
                        int mb = 0x100000;
                        Runtime runtime = Runtime.getRuntime();
                        System.out.println("memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  free  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
                        if (parseAllViews || parseAllTables) {
                            int count = 0;
                            String messageText = parseAllViews ? Messages.getString("DPVRelational.ParsingView") : Messages.getString("DPVRelational.ParsingTable");
                            Collection tvViews = parseAllViews ? DPVRelational.this.getTVViews() : DPVRelational.this.getTVTables();
                            monitor.setMaximum(tvViews.size() + 1);
                            Iterator it = tvViews.iterator();
                            while (it.hasNext()) {
                                ++count;
                                TVFKContainer tv = (TVFKContainer)it.next();
                                FKContainer tableOrView = (FKContainer)tv.getModel();
                                if (tableOrView.isParsed() || tableOrView.isRemoteObject() || tableOrView.getUserDefinedSQL().isEmpty()) continue;
                                monitor.setNote(messageText + tableOrView.getName());
                                monitor.setProgress(count);
                                if (queryBuilder == null) {
                                    queryBuilder = new QueryBuilder(true);
                                    QBUtils.initMetadata(DPVRelational.this.getDesignPart(), queryBuilder, null, false);
                                }
                                if (tableOrView instanceof TableView) {
                                    ((TableView)tableOrView).parseOlderStyleView(queryBuilder, null);
                                } else {
                                    ((Table)tableOrView).parseSQL(queryBuilder);
                                }
                                System.out.println("view " + count + " " + tableOrView.getName() + " memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  free  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
                            }
                        } else {
                            Object[] cells = DPVRelational.this.getWorkSpace().getSelectionCells();
                            monitor.setMaximum(cells.length + 1);
                            for (int i = 0; i < cells.length; ++i) {
                                FKContainer tableOrView;
                                TopView topView;
                                Object cell = cells[i];
                                if (!(cell instanceof FKDiagramCell) || (topView = ((FKDiagramCell)cell).getTopView()) == null || (tableOrView = (FKContainer)topView.getModel()).isParsed() || tableOrView.isRemoteObject() || tableOrView.getUserDefinedSQL().isEmpty()) continue;
                                String messageID = tableOrView instanceof TableView ? "DPVRelational.ParsingView" : "DPVRelational.ParsingTable";
                                monitor.setNote(Messages.getString(messageID) + tableOrView.getName());
                                monitor.setProgress(i + 1);
                                if (queryBuilder == null) {
                                    queryBuilder = new QueryBuilder(true);
                                    QBUtils.initMetadata(DPVRelational.this.getDesignPart(), queryBuilder, null, false);
                                }
                                if (tableOrView instanceof TableView) {
                                    ((TableView)tableOrView).parseOlderStyleView(queryBuilder, null);
                                } else {
                                    ((Table)tableOrView).parseSQL(queryBuilder);
                                }
                                System.out.println("view " + i + " " + tableOrView.getName() + " memory  total  " + runtime.totalMemory() / (long)mb + "  /memory  free  " + runtime.freeMemory() / (long)mb + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
                            }
                        }
                    }
                    finally {
                        monitor.close();
                        DPVRelational.this.getWorkSpace().repaint();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error Parsing Older Style Views: ", e);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
                System.out.println("parseOlderStyleViews Time: " + (System.currentTimeMillis() - l));
                System.gc();
            }
        });
        thread.start();
    }

    public List getTables() {
        Map map = this.getTablesMap();
        if (map.size() > 0) {
            return Arrays.asList(map.values().toArray());
        }
        return Collections.EMPTY_LIST;
    }

    private Map getTablesMap() {
        HashMap<DesignObject, DesignObject> map = new HashMap<DesignObject, DesignObject>();
        for (TopView tv : this.getTVShapes()) {
            DesignObject dobj = tv.getModel();
            if (dobj == null || !(dobj instanceof Table)) continue;
            map.put(dobj, dobj);
        }
        return map;
    }

    @Override
    public List getPossibleConnectors() {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        Map map = this.getTablesMap();
        Iterator it = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            DesignObject source = fk.getSourceObject();
            DesignObject target = fk.getTargetObject();
            if (source == null || target == null || map.get(target) == null || map.get(source) == null) continue;
            list.add(fk);
        }
        return list;
    }

    @Override
    protected String getShowHideActionName() {
        return SHOW_HIDE_LINES;
    }

    @Override
    public boolean isSupportLineHiding() {
        return true;
    }

    @Override
    protected String getShowHideSourceName() {
        return SHOW_HIDE_SOURCE_NAME;
    }

    @Override
    protected String getShowHideTargetName() {
        return SHOW_HIDE_TARGET_NAME;
    }

    @Override
    public String getToolbarName() {
        return TOOLBAR_NAME;
    }

    public void clearSourceStamp(Object[] selected) {
        for (int i = 0; i < selected.length; ++i) {
            this.clearSourceStamp(selected[i]);
        }
    }

    public void clearSourceStamp(Object selected) {
        DesignObject desObj;
        if (selected instanceof DesignObject && !"".equals((desObj = (DesignObject)selected).getSourceConnName())) {
            if (desObj instanceof Table) {
                Table tab = (Table)desObj;
                ContainedObject[] cols = tab.getElements();
                for (int i = 0; i < cols.length; ++i) {
                    cols[i].clearSourceDBInfo();
                }
                KeyObject[] keys = tab.getKeys();
                for (int i = 0; i < keys.length; ++i) {
                    keys[i].clearSourceDBInfo();
                    if (!keys[i].isFK()) continue;
                    keys[i].getFKAssociation().clearSourceDBInfo();
                }
                tab.clearSourceDBInfo();
            } else if (desObj instanceof TableView) {
                TableView vie = (TableView)desObj;
                vie.clearSourceDBInfo();
            }
        }
    }

    private JMenu getObjectsSubMenu() {
        JMenu miObjects = new JMenu(Messages.getString("DPVRelational.Objects"));
        miObjects.add(new AbstractAction(ADD_REMOVE_OBJECTS){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin soa = new SubViewObjectsAdmin(DPVRelational.this.getApplicationView(), DPVRelational.this);
                soa.showDialog();
            }
        });
        miObjects.addSeparator();
        if (this.isSupportLineHiding()) {
            final ShowHideConnectors shc = new ShowHideConnectors(this, this.getShowHideActionName());
            JMenuItem shConnectors = miObjects.add(new AbstractAction(this.getShowHideActionName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    shc.showDialog();
                }
            });
            shConnectors.setIcon(this.getConfiguration().getIcon("FK_ICON", 16));
        }
        return miObjects;
    }

    private JMenu getLayoutSubMenu() {
        this.miLayout = new JMenu(Messages.getString("DPVRelational.Layout"));
        this.miGridEnabled = new JCheckBoxMenuItem(MI_SNAP_TO_GRID);
        this.miGridEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setGridEnabled(!DPVRelational.this.isGridEnabled());
            }
        });
        this.miLayout.add(this.miGridEnabled);
        this.miLayout.addSeparator();
        this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
        this.miAutoRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVRelational.this.setAutoRoute(!DPVRelational.this.isAutoRoute());
                DPVRelational.this.getWorkSpace().updateSettings();
            }
        });
        this.miLayout.add(this.miAutoRoute);
        this.miLayout.add(this.getAutoLayout());
        this.miLayout.addSeparator();
        this.miLayout.add(this.getStraightenLinesItem());
        JMenuItem miResizeToVisible = this.miLayout.add(new AbstractAction(MI_RESIZE_OBJECTS_TO_VISIBLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.startAutoLayoutEdit(DesignPartView.MI_RESIZE_OBJECTS_TO_VISIBLE + " of " + DPVRelational.this.getName());
                try {
                    DPVRelational.this.resizeTables();
                    DPVRelational.this.resizeViews();
                    if (!DPVRelational.this.isAutoRoute()) {
                        DPVRelational.this.straightenLines(false);
                    }
                }
                finally {
                    DPVRelational.this.stopAutoLayoutEdit();
                }
            }
        });
        miResizeToVisible.setIcon(this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", 16));
        this.miLayout.addSeparator();
        this.miLayout.add(new AbstractAction(RESET_LABELS_SIZE){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.startAutoLayoutEdit(DesignPartView.RESET_LABELS_SIZE + " of " + DPVRelational.this.getName());
                try {
                    DPVRelational.this.resetLabelsSize();
                }
                finally {
                    DPVRelational.this.stopAutoLayoutEdit();
                }
            }
        });
        return this.miLayout;
    }

    public JMenu getSyncMenu() {
        this.miSync = new JMenu(Messages.getString("DPVRelational.Sync"));
        this.miSync.add(new AbstractAction(MI_SYNCHRONIZE_REMOTE_OBJECTS){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.getDesignPart().getDesign().synchronizeRemoteDomains();
                ((RelationalDesign)DPVRelational.this.getDesignPart()).synchronizeRemoteObjects();
            }
        });
        if (!this.isMainDiagram()) {
            this.miSync.addSeparator();
            JMenuItem mi = new JMenuItem(new AbstractAction(MI_SYNC_SUBVIEW_WITH_DATA_DICTIONARY){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DPVRelational.this.sync(false);
                }
            });
            mi.setIcon(this.getConfiguration().getIcon("SYNC_MODEL_WITH_DICT", 16));
            this.miSync.add(mi);
            JMenuItem mi1 = new JMenuItem(new AbstractAction(MI_SYNC_DATA_DICTIONARY_WITH_SUBVIEW){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DPVRelational.this.sync(true);
                }
            });
            mi1.setIcon(this.getConfiguration().getIcon("SYNC_DICT_WITH_MODEL", 16));
            this.miSync.add(mi1);
        }
        return this.miSync;
    }

    private void sync(boolean syncMode) {
        HashMap<String, String> selectedIDs = new HashMap<String, String>();
        for (TopView tv : this.getTopviewsList()) {
            DesignObject desObj = tv.getModel();
            if (!(desObj instanceof Table) && !(desObj instanceof TableView)) continue;
            selectedIDs.put(desObj.getObjectID(), desObj.getObjectID());
        }
        if (selectedIDs.size() > 0) {
            SyncUtils.syncDataDictionary((RelationalDesign)this.getDesignPart(), syncMode, selectedIDs);
        }
    }

    public JMenu getTablesSubMenu() {
        JMenu miTables = new JMenu(Messages.getString("DPVRelationalSubView.Tables"));
        miTables.setIcon(this.getConfiguration().getIcon("TABLE_ICON", 16));
        JMenuItem miValidate = miTables.add(new AbstractAction(MI_VALIDATE_ALL_TABLE_QUERIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.validateTables(true);
            }
        });
        miValidate.setIcon(this.getConfiguration().getIcon("CHECKOUT_ICON", 16));
        miTables.add(new AbstractAction(MI_PARSE_SQL){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.parseQueryObjects(false, true);
            }
        });
        return miTables;
    }

    public JMenu getViewsSubMenu() {
        this.miViews = new JMenu(Messages.getString("DPVRelational.Views"));
        this.miViews.setIcon(this.getConfiguration().getIcon("VIEW_ICON", 16));
        JMenuItem miValidate = this.miViews.add(new AbstractAction(MI_VALIDATE_ALL_VIEWS){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.validateViews(true);
            }
        });
        miValidate.setIcon(this.getConfiguration().getIcon("CHECKOUT_ICON", 16));
        this.miViews.add(new AbstractAction(MI_PARSE_SQL){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVRelational.this.parseOlderStyleViews(true);
            }
        });
        return this.miViews;
    }

    static /* synthetic */ int access$300(DPVRelational x0) {
        return x0.maxLevel;
    }

    public class FK_TV_Edit
    extends UpdateDO_Edit {
        FKIndexAssociation fk;
        TopView oldtv;
        TopView newtv;
        boolean source;
        DesignPartView dpv;
        private DesignObjectEdit.ConnectorStore cs;

        public FK_TV_Edit(FKIndexAssociation fk, TopView tv, boolean source) {
            super(fk);
            this.source = false;
            this.fk = fk;
            this.dpv = tv.getDesignPartView();
            this.source = source;
            this.newtv = tv;
            this.oldtv = source ? fk.getSourceTV(this.dpv) : fk.getTargetTV(this.dpv);
            TVConnector tvc = (TVConnector)fk.getFirstViewForDPV(this.dpv);
            if (tvc != null) {
                this.cs = this.backupTVConnector(tvc);
            }
        }

        @Override
        public void applyUpdates() {
            MultiShapedDesignObject obj = (MultiShapedDesignObject)this.newtv.getModel();
            int num = obj.getViewNumber(this.newtv);
            if (num < 0) {
                obj.addTopView(this.newtv);
            }
            if (this.source) {
                this.fk.setSourceTopView(this.newtv);
            } else {
                this.fk.setTargetTopView(this.newtv);
            }
        }

        @Override
        protected void restoreObject() {
            MultiShapedDesignObject obj = (MultiShapedDesignObject)this.newtv.getModel();
            int num = obj.getViewNumber(this.newtv);
            if (num >= 0) {
                obj.removeViewSynonim(this.newtv);
            }
            if (this.source) {
                this.fk.setSourceTopView(this.oldtv);
            } else {
                this.fk.setTargetTopView(this.oldtv);
            }
            if (this.cs != null) {
                this.restoreConnectorTopView(this.fk, this.cs);
            }
        }
    }

    class THReferredByComparatorAsc2
    implements Comparator {
        THReferredByComparatorAsc2() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.referredBy_count > th2.referredBy_count) {
                return 1;
            }
            if (th1.referredBy_count < th2.referredBy_count) {
                return -1;
            }
            if (th1.refer_count > th2.refer_count) {
                return 1;
            }
            if (th1.refer_count < th2.refer_count) {
                return -1;
            }
            return 0;
        }
    }

    class THReferredByComparatorAsc1
    implements Comparator {
        THReferredByComparatorAsc1() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.referredBy_count > th2.referredBy_count) {
                return 1;
            }
            if (th1.referredBy_count < th2.referredBy_count) {
                return -1;
            }
            if (th1.refer_count < th2.refer_count) {
                return 1;
            }
            if (th1.refer_count > th2.refer_count) {
                return -1;
            }
            return 0;
        }
    }

    class THReferredByComparatorDesc
    implements Comparator {
        THReferredByComparatorDesc() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.referredBy_count < th2.referredBy_count) {
                return 1;
            }
            if (th1.referredBy_count > th2.referredBy_count) {
                return -1;
            }
            if (th1.refer_count < th2.refer_count) {
                return 1;
            }
            if (th1.refer_count > th2.refer_count) {
                return -1;
            }
            return 0;
        }
    }

    class THReferComparatorDesc
    implements Comparator {
        THReferComparatorDesc() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.refer_count < th2.refer_count) {
                return 1;
            }
            if (th1.refer_count > th2.refer_count) {
                return -1;
            }
            if (th1.referredBy_count < th2.referredBy_count) {
                return 1;
            }
            if (th1.referredBy_count > th2.referredBy_count) {
                return -1;
            }
            if (th1.init_dim != null && th2.init_dim != null) {
                if (th1.init_dim.height < th2.init_dim.height) {
                    return 1;
                }
                if (th1.init_dim.height > th2.init_dim.height) {
                    return -1;
                }
            }
            return 0;
        }
    }

    class THHeightComparatorAsc
    implements Comparator {
        THHeightComparatorAsc() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.init_dim.height > th2.init_dim.height) {
                return 1;
            }
            if (th1.init_dim.height < th2.init_dim.height) {
                return -1;
            }
            return 0;
        }
    }

    class THHeightComparatorDesc
    implements Comparator {
        THHeightComparatorDesc() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.rect.height < th2.rect.height) {
                return 1;
            }
            if (th1.rect.height > th2.rect.height) {
                return -1;
            }
            return 0;
        }
    }

    public static class ContainerObjectComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int col2;
            ContainerObject view1 = (ContainerObject)((TopView)o1).getModel();
            ContainerObject view2 = (ContainerObject)((TopView)o2).getModel();
            int col1 = view1.getElementsCollection().size();
            if (col1 < (col2 = view2.getElementsCollection().size())) {
                return 1;
            }
            if (col2 < col1) {
                return -1;
            }
            return 0;
        }
    }

    class TableComparator
    implements Comparator {
        TableComparator() {
        }

        public int compare(Object o1, Object o2) {
            int ind2;
            int col2;
            int ass2;
            int fk2;
            Table tab1 = (Table)((TopView)o1).getModel();
            Table tab2 = (Table)((TopView)o2).getModel();
            int fk1 = tab1.getFKAssociationsCount();
            if (fk1 < (fk2 = tab2.getFKAssociationsCount())) {
                return 1;
            }
            if (fk1 > fk2) {
                return -1;
            }
            int ass1 = ((RelationalDesign)tab1.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(tab1).size();
            if (ass1 < (ass2 = ((RelationalDesign)tab1.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(tab2).size())) {
                return 1;
            }
            if (ass1 > ass2) {
                return -1;
            }
            int col1 = tab1.getElementsCollection().size();
            if (col1 < (col2 = tab2.getElementsCollection().size())) {
                return 1;
            }
            if (col1 > col2) {
                return -1;
            }
            int ind1 = tab1.getKeySet().size();
            if (ind1 < (ind2 = tab2.getKeySet().size())) {
                return 1;
            }
            if (ind1 > ind2) {
                return -1;
            }
            return 0;
        }
    }

    class TH {
        TopView tv;
        FKContainer table;
        List refer = new ArrayList();
        List referFK = new ArrayList();
        int refer_count = 0;
        List referredBy = new ArrayList();
        List referredByFK = new ArrayList();
        int referredBy_count = 0;
        Dimension init_dim;
        Dimension dim;
        Point location;
        int level = DPVRelational.access$300(DPVRelational.this);
        boolean arranged = false;
        boolean booked = false;
        boolean scanned = false;
        boolean star = false;
        boolean usedInStar = false;
        Rectangle rect;
        List nodes = new ArrayList();
        Map referMap = new TreeMap();
        Map referredByMap = new TreeMap();
        Map synonymsMap = new TreeMap();

        TH() {
        }

        public String toString() {
            if (this.table != null) {
                return this.table.getName();
            }
            return "nunnn";
        }

        public boolean isScanConnectedToBetterLevel(TH node, int level) {
            for (TH tht : this.referredBy) {
                if (tht == node || tht.level >= level || tht.scanned) continue;
                return true;
            }
            for (TH tht : this.refer) {
                if (tht == node || tht.level >= level || tht.scanned) continue;
                return true;
            }
            return false;
        }

        public boolean isConnectedToBetterLevel(TH node, int level) {
            for (TH tht : this.referredBy) {
                if (tht == node || tht.level >= level || tht.arranged) continue;
                return true;
            }
            for (TH tht : this.refer) {
                if (tht == node || tht.level >= level || tht.arranged) continue;
                return true;
            }
            return false;
        }

        private boolean referNodesWithNorefs() {
            for (TH th : this.refer) {
                if (th.refer.size() <= 0 && th.referredBy.size() <= 1) continue;
                return false;
            }
            return true;
        }

        private boolean referOnly(TH tht) {
            for (TH th : this.refer) {
                if (th == tht) continue;
                return false;
            }
            for (TH th : this.referredBy) {
                if (th == tht) continue;
                return false;
            }
            return true;
        }

        private boolean referOnlyAndArranged(TH tht) {
            for (TH th : this.refer) {
                if (th == tht || th.arranged) continue;
                return false;
            }
            for (TH th : this.referredBy) {
                if (th == tht || th.arranged) continue;
                return false;
            }
            return true;
        }
    }
}

