/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.swingui.search.SearchProfile;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SearchProfilesPersistence {
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(SearchProfilesPersistence.class);

    public SearchProfilesPersistence(ApplicationView appView) {
        this.appView = appView;
    }

    public boolean save(SearchProfile sp, boolean showMessage) {
        try {
            StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            buffer.append("\n");
            buffer.append("\t").append("<").append("search_profile").append('>');
            buffer.append("\n");
            buffer.append("\t\t").append("<").append("name").append('>');
            buffer.append(StringUtilities.encodeAttributeValue(sp.getFileName()));
            buffer.append("</").append("name").append('>');
            buffer.append("\n");
            buffer.append("\t\t").append("<").append("description").append('>');
            buffer.append("<![CDATA[").append(sp.getDescription() != null ? sp.getDescription() : "").append("]]>");
            buffer.append("</").append("description").append('>');
            buffer.append("\n");
            buffer.append("\t\t").append("<").append("active").append('>');
            buffer.append(sp.isActive());
            buffer.append("</").append("active").append('>');
            buffer.append("\n");
            buffer.append("\t\t").append("<").append("objects").append('>');
            for (Map.Entry<SearchSet, List<SearchProfile.Property>> pairs : sp.getObjects().entrySet()) {
                String clazz = pairs.getKey().getClazz().getName();
                buffer.append("\n");
                buffer.append("\t\t\t").append("<").append("class").append(' ');
                buffer.append("name=\"").append(clazz).append("\"").append(">");
                buffer.append("\n");
                buffer.append("\t\t\t\t").append("<").append("propertiesInUse").append('>');
                for (SearchProfile.Property p : pairs.getValue()) {
                    if (!p.isUsed()) continue;
                    buffer.append("\n");
                    buffer.append("\t\t\t\t\t").append("<").append("property").append('>');
                    buffer.append(p.getPd().name);
                    buffer.append("</").append("property").append('>');
                }
                buffer.append("\n");
                buffer.append("\t\t\t\t").append("</").append("propertiesInUse").append('>');
                buffer.append("\n");
                buffer.append("\t\t\t").append("</").append("class").append('>');
            }
            buffer.append("\n");
            buffer.append("\t\t").append("</").append("objects").append('>');
            buffer.append("\n");
            buffer.append("\t").append("</").append("search_profile").append(">");
            return this.writeToFile(buffer, sp, showMessage);
        }
        catch (Exception e) {
            LOGGER.error("Unable to save search profile: ", e);
            return false;
        }
    }

    private boolean writeToFile(StringBuffer buffer, SearchProfile sp, boolean showMessage) {
        File file = null;
        try {
            file = new File(sp.getFilePath(), sp.getFileName() + ".sposdm");
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(buffer.toString());
            osw.close();
            if (showMessage) {
                JOptionPane.showMessageDialog(this.appView.getFrame(), MessageFormat.format(Messages.getString("SearchProfilePropertiesDialog.FileSaved"), file.getAbsolutePath()), Messages.getString("SearchProfilePropertiesDialog.Save"), 1);
            }
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.appView.getFrame(), MessageFormat.format(Messages.getString("SearchProfilePropertiesDialog.FileNotSaved"), file.getAbsolutePath() + ".sposdm"), Messages.getString("SearchProfilePropertiesDialog.Save"), 0);
            LOGGER.error("Unable to save search profile (writeToFile) : ", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ApplicationView appView, String path) {
        ArrayList searchProfilesList = new ArrayList();
        try {
            File dir = new File(path);
            if (dir.exists()) {
                File[] files = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File arg0, String name) {
                        return name.endsWith(".sposdm");
                    }
                });
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                InputStreamReader isr = null;
                for (File file : files) {
                    try {
                        if (file.isDirectory()) continue;
                        isr = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                        InputSource inputSource = new InputSource(isr);
                        Document doc = builder.parse(inputSource);
                        this.loadData(doc, file, searchProfilesList);
                    }
                    catch (XMLParseException xpe) {
                    }
                    catch (Exception ad) {
                        LOGGER.error("Unable to load report profile: ", ad);
                    }
                    finally {
                        if (isr != null) {
                            isr.close();
                        }
                    }
                }
                boolean found = false;
                ArrayList<SearchProfile> existingSPList = appView.getSearchProfiles();
                for (SearchProfile sp1 : searchProfilesList) {
                    found = false;
                    for (SearchProfile sp : existingSPList) {
                        if (!sp.getFileName().equals(sp1.getFileName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    existingSPList.add(sp1);
                }
            }
            ReportUtils.reloadSearchProfilesMap(appView);
        }
        catch (Exception e) {
            LOGGER.error("Unable to load report profile: ", e);
        }
    }

    private void loadData(Document doc, File file, List searchProfilesList) {
        String name = "";
        String description = "";
        boolean isActive = false;
        HashMap objectsMap = new HashMap();
        try {
            NodeList nodes = doc.getElementsByTagName("search_profile");
            int nodesLength0 = nodes.getLength();
            for (int i = 0; i < nodesLength0; ++i) {
                NodeList classesNL;
                NodeList activeNL;
                NodeList descrNL;
                Element elm = (Element)nodes.item(i);
                NodeList nameNL = elm.getElementsByTagName("name");
                if (nameNL != null && nameNL.getLength() > 0) {
                    name = StringUtilities.decodeAttributeValue(nameNL.item(0).getTextContent());
                }
                if ((descrNL = elm.getElementsByTagName("description")) != null && descrNL.getLength() > 0) {
                    description = descrNL.item(0).getTextContent();
                }
                if ((activeNL = elm.getElementsByTagName("active")) != null && activeNL.getLength() > 0) {
                    isActive = Boolean.valueOf(activeNL.item(0).getTextContent());
                }
                if ((classesNL = elm.getElementsByTagName("class")) != null && descrNL.getLength() > 0) {
                    int classesNLNodesL = classesNL.getLength();
                    for (int j = 0; j < classesNLNodesL; ++j) {
                        NodeList propertyNL;
                        Element classElemeent = (Element)classesNL.item(j);
                        String clazz = classElemeent.getAttribute("name");
                        ArrayList<String> usedProperties = new ArrayList<String>();
                        NodeList propertiesNL = classElemeent.getElementsByTagName("propertiesInUse");
                        if (propertiesNL != null && propertiesNL.getLength() > 0 && (propertyNL = ((Element)propertiesNL.item(0)).getElementsByTagName("property")) != null && propertyNL.getLength() > 0) {
                            int propertyNLL = propertyNL.getLength();
                            for (int s = 0; s < propertyNLL; ++s) {
                                Element propertyElement = (Element)propertyNL.item(s);
                                usedProperties.add(propertyElement.getTextContent());
                            }
                        }
                        objectsMap.put(clazz, usedProperties);
                    }
                }
                SearchProfile sp = new SearchProfile(this.appView, name, file.getParent(), description, isActive);
                sp.setUsedProperties(objectsMap);
                searchProfilesList.add(sp);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load search profile from file " + file.getAbsolutePath() + ": ", e);
        }
    }
}

