/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.util.LinkedList;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;

public class ReportSection {
    public static final String COLLECTION = "collection";
    public static final String RO_PROPERY = "roPropertiesList";
    private Object element;
    private String propertyName;
    private String customName;
    private int level;
    private LinkedList<ReportColumn> reportColumns;
    private String type;

    public ReportSection(Object element, int level, String type) {
        this.element = element;
        this.level = level;
        this.type = type;
        String name = "";
        if (element instanceof ClassDescription) {
            name = ((ClassDescription)element).getXmlName();
        } else if (element instanceof ClassDescription.CollectionDescription) {
            name = ((ClassDescription.CollectionDescription)element).name;
        } else if (element instanceof ClassDescription.PropertyDescription) {
            name = ((ClassDescription.PropertyDescription)element).name;
        }
        this.setCustomName(ReportUtils.getDisplayName(name));
    }

    public ReportSection(Object element, String propertyName, String customName, int level, String type) {
        this.propertyName = propertyName;
        this.customName = customName;
        this.level = level;
        this.type = type;
        this.element = element;
    }

    public Object getElement() {
        return this.element;
    }

    public String getPropertyName() {
        if (this.element instanceof ClassDescription) {
            this.propertyName = ((ClassDescription)this.element).getXmlName();
        } else if (this.element instanceof ClassDescription.CollectionDescription) {
            this.propertyName = ((ClassDescription.CollectionDescription)this.element).name;
        } else if (this.element instanceof ClassDescription.PropertyDescription) {
            this.propertyName = ((ClassDescription.PropertyDescription)this.element).name;
        }
        return this.propertyName;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getElementClassName() {
        String className = "";
        if (this.element instanceof ClassDescription) {
            className = ((ClassDescription)this.element).getClassName();
        } else if (this.element instanceof ClassDescription.CollectionDescription) {
            className = ((ClassDescription.CollectionDescription)this.element).itemClassName;
        } else if (this.element instanceof ClassDescription.PropertyDescription) {
            className = ((ClassDescription.PropertyDescription)this.element).itemClassName;
        }
        return className;
    }

    public Class getElementClass() {
        Class<?> clazz = null;
        try {
            if (!this.getElementClassName().equals("")) {
                clazz = Class.forName(this.getElementClassName());
            }
            return clazz;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getLevel() {
        return this.level;
    }

    public LinkedList getReportColumns() {
        if (this.reportColumns == null) {
            this.reportColumns = new LinkedList();
        }
        return this.reportColumns;
    }

    public String getType() {
        return this.type;
    }

    public ReportSection copy() {
        ReportSection rs = new ReportSection(this.getElement(), this.getPropertyName(), this.getCustomName(), this.getLevel(), this.getType());
        for (ReportColumn rc : this.getReportColumns()) {
            rs.getReportColumns().add(rc.copy());
        }
        return rs;
    }
}

