/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.Ide;

public class BirtReports_DDLMaker {
    RelationalDesign pdes;
    String tab = "  ";
    String tab2 = "    ";
    int cols_in_row = 3;

    public void generate(File textFile, RelationalDesign pdes) {
        int result;
        this.pdes = pdes;
        if (textFile.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("BirtReports_DDLMaker.FileExists"), textFile.getAbsolutePath()), Messages.getString("BirtReports_DDLMaker.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return;
        }
        StringBuffer content = this.generateContent();
        textFile.getParentFile().mkdirs();
        try {
            textFile.createNewFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(textFile)));
        }
        catch (FileNotFoundException e) {
            out = null;
        }
        if (out != null) {
            out.print(content.toString());
            out.flush();
            out.close();
        }
    }

    private StringBuffer generateContent() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.pdes.getTableSet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Table table = (Table)it.next();
            String tableName = table.getName().trim();
            if (first) {
                first = false;
            } else {
                sb.append("\n\n");
            }
            sb.append("-- ").append(tableName).append("\n");
            sb.append("\n-- plain select\n");
            this.appendPlainSelect(table, sb);
            sb.append("\n\n-- parameter select\n");
            sb.append("if (params[\"DatabaseType\"].equals(\"CSV\")){");
            sb.append("\n");
            this.appendQuotedSelect(table, sb, true);
            sb.append(";\n}else{\n");
            this.appendQuotedSelect(table, sb, false);
            sb.append(";\n}\n");
        }
        return sb;
    }

    private void appendPlainSelect(Table table, StringBuffer sb) {
        sb.append(this.tab).append("select \n").append(this.tab2);
        boolean first = true;
        int ind = 0;
        Iterator it = table.getElementsCollection().iterator();
        while (it.hasNext()) {
            ++ind;
            Column column = (Column)it.next();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (ind > this.cols_in_row) {
                sb.append("\n").append(this.tab2);
                ind = 1;
            }
            sb.append(column.getName().trim().toUpperCase());
        }
        sb.append("\n").append(this.tab).append("from ").append(table.getName());
    }

    private void appendQuotedSelect(Table table, StringBuffer sb, boolean csv) {
        sb.append(this.tab).append("\"select \" + \n").append(this.tab2);
        boolean first = true;
        int ind = 0;
        Iterator it = table.getElementsCollection().iterator();
        while (it.hasNext()) {
            ++ind;
            Column column = (Column)it.next();
            if (first) {
                first = false;
                sb.append("\"");
            } else {
                sb.append(", ");
            }
            if (ind > this.cols_in_row) {
                sb.append("\" + \n").append(this.tab2).append("\"");
                ind = 1;
            }
            sb.append(column.getName().trim().toUpperCase());
        }
        String name = table.getName().trim();
        if (csv) {
            name = name + ".csv";
        }
        sb.append(" \" + \n").append(this.tab).append("\"from ").append(name).append("\"");
    }

    private GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }
}

