/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;

public class Loader {
    private Loader() {
    }

    public static URL getResource(String resource, Class clazz) throws MissingResourceException {
        URL url = null;
        if (resource == null) {
            return null;
        }
        for (int i = 0; i < 2; ++i) {
            ClassLoader loader;
            if (clazz != null && (loader = clazz.getClassLoader()) != null && (url = loader.getResource(resource)) != null) {
                return url;
            }
            url = ClassLoader.getSystemResource(resource);
            if (url != null) {
                return url;
            }
            if (resource.startsWith("/")) {
                if (resource.length() <= 1) break;
                resource = resource.substring(1);
                continue;
            }
            resource = "/" + resource;
        }
        throw new MissingResourceException("Resource " + resource + " not found in the classpath.", resource, "");
    }

    public static InputStream getResourceAsStream(String resource, Class clazz) throws MissingResourceException, IOException {
        URL url = Loader.getResource(resource, clazz);
        return url.openStream();
    }

    public static String getResourceAsString(String resource, Class clazz) throws MissingResourceException, IOException {
        InputStream is = Loader.getResourceAsStream(resource, clazz);
        BufferedInputStream bis = new BufferedInputStream(is);
        DataInputStream dis = new DataInputStream(bis);
        int len = dis.available();
        byte[] buf = new byte[len];
        dis.readFully(buf);
        dis.close();
        bis.close();
        is.close();
        return new String(buf);
    }
}

