/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.print;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.prefs.Preferences;
import javax.print.attribute.PrintRequestAttributeSet;
import oracle.dbtools.crest.util.print.Area;
import oracle.dbtools.crest.util.print.PageSetupDialog;

public final class Config {
    private static final Config INSTANCE = new Config();
    private static final float INCH_TO_PT = 72.0f;
    private static final String PAPER_ORIENTATION = "print.paper.orientation";
    private static final String PAPER_MEDIA = "print.paper.media";
    private static final String AREA_X = "print.page.x";
    private static final String AREA_Y = "print.page.y";
    private static final String AREA_WIDTH = "print.page.width";
    private static final String AREA_HEIGHT = "print.page.height";
    private Area myArea;
    private Preferences myPreferences = Preferences.userNodeForPackage(Config.class);

    public static Config getConfig() {
        return INSTANCE;
    }

    private Config() {
        this.myArea = new Area(null, this.get(PAPER_ORIENTATION, -1), this.get(AREA_X, -1.0f), this.get(AREA_Y, -1.0f), this.get(AREA_WIDTH, -1.0f), this.get(AREA_HEIGHT, -1.0f), null);
    }

    public boolean openPageSetup() {
        if (!PageSetupDialog.pageSetup(this.getAttributes())) {
            return false;
        }
        this.set(PAPER_ORIENTATION, this.myArea.getOrientation());
        this.set(PAPER_MEDIA, this.myArea.getPaperMedia());
        this.set(AREA_X, this.myArea.getX());
        this.set(AREA_Y, this.myArea.getY());
        this.set(AREA_WIDTH, this.myArea.getWidth());
        this.set(AREA_HEIGHT, this.myArea.getHeight());
        return true;
    }

    public PageFormat getPageFormat() {
        PageFormat pf = new PageFormat();
        pf.setOrientation(this.myArea.getOrientation());
        Paper paper = new Paper();
        paper.setSize(this.getPaperWidth(), this.getPaperHeight());
        paper.setImageableArea(this.getPageX(), this.getPageY(), this.getPageWidth(), this.getPageHeight());
        pf.setPaper(paper);
        return pf;
    }

    private PrintRequestAttributeSet getAttributes() {
        return this.myArea.getAttributes();
    }

    private int getPaperWidth() {
        return Config.round(this.myArea.getPaperWidth() * 72.0f);
    }

    private int getPaperHeight() {
        return Config.round(this.myArea.getPaperHeight() * 72.0f);
    }

    private int getPageX() {
        return Config.round(this.myArea.getX() * 72.0f);
    }

    private int getPageY() {
        int y = Config.round(this.myArea.getY() * 72.0f);
        return y;
    }

    private int getPageWidth() {
        return Config.round(this.myArea.getWidth() * 72.0f);
    }

    private int getPageHeight() {
        int height = Config.round(this.myArea.getHeight() * 72.0f);
        return height;
    }

    private int get(String name, int defaultValue) {
        return this.myPreferences.getInt(name, defaultValue);
    }

    private float get(String name, float defaultValue) {
        return this.myPreferences.getFloat(name, defaultValue);
    }

    private void set(String name, float value) {
        this.myPreferences.putFloat(name, value);
    }

    private void set(String name, int value) {
        this.myPreferences.putInt(name, value);
    }

    private static int round(double value) {
        return (int)Math.round(value);
    }

    public String getPrinterName() {
        return this.myArea.getPrinterName();
    }

    public String getPaperMediaName() {
        return this.myArea.getPaperMediaName();
    }

    public void init(PageFormat pf, String printerName, String paperMediaName) {
        this.set(PAPER_ORIENTATION, pf.getOrientation() + 3);
        this.set(AREA_X, (float)pf.getPaper().getImageableX() / 72.0f);
        this.set(AREA_Y, (float)pf.getPaper().getImageableY() / 72.0f);
        this.set(AREA_WIDTH, (float)pf.getPaper().getImageableWidth() / 72.0f);
        this.set(AREA_HEIGHT, (float)pf.getPaper().getImageableHeight() / 72.0f);
        this.myArea = new Area(paperMediaName, this.get(PAPER_ORIENTATION, -1), this.get(AREA_X, -1.0f), this.get(AREA_Y, -1.0f), this.get(AREA_WIDTH, -1.0f), this.get(AREA_HEIGHT, -1.0f), printerName);
    }
}

