/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.common;

import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.plugin.common.InvalidDatabaseException;
import oracle.dbtools.migration.workbench.plugin.common.LinkTableDescriptor;
import oracle.dbtools.migration.workbench.plugin.common.MsAccessRegistry;
import oracle.dbtools.migration.workbench.plugin.common.NotOfficialJetDataTypeException;
import oracle.dbtools.migration.workbench.plugin.common.PHKey;
import oracle.dbtools.migration.workbench.plugin.common.ReplicaDatabaseException;
import oracle.dbtools.migration.workbench.plugin.common.SecuredDatabaseException;
import oracle.dbtools.migration.workbench.plugin.common.UnableToModifyAccessDatabaseException;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoDatabase;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoException;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoField;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoQueryDef;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoTableDef;
import oracle.dbtools.migration.workbench.plugin.jdao.JDaoWorkspace;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public final class MSAccessUtils {
    private static final float ERROR = -999.0f;
    private static final int REPLICATION_ID = 15;
    public static final int NO_DELETE_LOCAL = 1;
    public static final int RELATIONS_ALREADY_DELETED = 2;
    public static final int REL_DELETED_N_DONT_DELETE_LOCAL = 3;
    private static final String QUERY_LOAD_CONV_TABLES = "SELECT DERIVED_TYPE, DERIVED_ID, SRC_ID FROM MD_DERIVATIVES WHERE (DERIVED_TYPE = 'MD_TABLES' OR DERIVED_TYPE = 'MD_COLUMNS') AND DERIVED_TYPE = SRC_TYPE AND DERIVED_CONNECTION_ID_FK = ?";

    private MSAccessUtils() {
    }

    public static boolean confirmDaoVersion(String string) {
        float f = MSAccessUtils.getVersion(string);
        if ((double)f >= 4.0) {
            try {
                return MSAccessUtils.isDao36installed();
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Cannot determine if DAO 3.6 is installed for database " + string), (String)"Error retrieving DAO version", (String)"f1_accessDAOerror_html");
                return false;
            }
        }
        try {
            return MSAccessUtils.isDao36installed();
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Cannot determine if DAO 3.6 is installed for database " + string), (String)"Error retrieving DAO version", (String)"f1_accessDAOerror_html");
            return false;
        }
    }

    private static float getVersion(String string) {
        Connections connections = Connections.getInstance();
        Connection connection = null;
        DatabaseMetaData databaseMetaData = null;
        if (connections.isOracle(string)) {
            return -999.0f;
        }
        Properties properties = connections.getConnectionInfo(string);
        String string2 = properties.getProperty("ConnectionType");
        if (!string2.equalsIgnoreCase("ACCESS")) {
            return -999.0f;
        }
        try {
            connection = connections.getConnection(string);
        }
        catch (DBException dBException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Cannot get a connection to the Access Database " + string), (String)"Error Connecting to Access", (String)"f1_accessconnectionerror_html");
            return -999.0f;
        }
        try {
            databaseMetaData = connection.getMetaData();
            String string3 = databaseMetaData.getDatabaseProductVersion();
            float f = Float.parseFloat(string3);
            return f;
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Cannot get the version of the Access Database " + string), (String)"Error retrieving version", (String)"f1_accessversionerror_html");
            return -999.0f;
        }
    }

    public static boolean isDao35installed() throws Exception {
        boolean bl = false;
        String string = "CLSID\\{00000010-0000-0010-8000-00AA006D2EA4}";
        bl = MSAccessUtils.isDaoVersionInstalled(string);
        return bl;
    }

    public static boolean isDao36installed() throws Exception {
        boolean bl = false;
        String string = "CLSID\\{00000100-0000-0010-8000-00AA006D2EA4}";
        bl = MSAccessUtils.isDaoVersionInstalled(string);
        return bl;
    }

    private static boolean isDaoVersionInstalled(String string) throws Exception {
        boolean bl = false;
        MsAccessRegistry msAccessRegistry = new MsAccessRegistry();
        PHKey pHKey = new PHKey();
        long l = msAccessRegistry.regOpenKeyEx(Integer.MIN_VALUE, string, 0L, 131097, pHKey);
        bl = l == 0L;
        l = msAccessRegistry.regCloseKey(pHKey);
        return bl;
    }

    public static JDaoWorkspace getDAOWorkspace(String string) throws JDaoException {
        float f = MSAccessUtils.getVersion(string);
        if ((double)f < 4.0) {
            return new JDaoWorkspace(false);
        }
        return new JDaoWorkspace(true);
    }

    public static String getOdbcFromConnection(String string) {
        String string2 = "";
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            String string3 = connection.getMetaData().getURL();
            connection.close();
            string2 = string3.substring(10);
        }
        catch (DBException dBException) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureValidDatabase(String string, boolean bl, boolean bl2) throws InvalidDatabaseException, UnsupportedEncodingException {
        JDaoDatabase jDaoDatabase = null;
        try {
            jDaoDatabase = new JDaoDatabase();
            jDaoDatabase.open(string, true, bl);
            int n = jDaoDatabase.getTableCount();
            JDaoTableDef jDaoTableDef = null;
            for (int i = 0; i < n; ++i) {
                byte[] byArray = jDaoDatabase.getTableName(i).getBytes("UTF-8");
                String string2 = new String(byArray, "UTF-8");
                jDaoTableDef = new JDaoTableDef(jDaoDatabase);
                jDaoTableDef.open(string2);
                String string3 = jDaoTableDef.getTableTypeStr();
                if (string3.equals("User Table")) {
                    try {
                        jDaoTableDef.getIndexCount();
                    }
                    catch (JDaoException jDaoException) {
                        jDaoTableDef.close();
                        jDaoTableDef.deinit();
                        jDaoTableDef = null;
                        throw new SecuredDatabaseException(jDaoException.getMessage() + "\n" + string + " is a secured database");
                    }
                    int n2 = jDaoTableDef.getFieldCount();
                    for (int j = 0; j < n2; ++j) {
                        String string4 = jDaoTableDef.getFieldName(j);
                        short s = jDaoTableDef.getFieldType(j);
                        String string5 = JDaoField.strFieldType(s);
                        if (!JDaoField.isOfficialJetDataType(s)) {
                            throw new NotOfficialJetDataTypeException("Unoffical Datatype" + string5 + "\n\nTable: " + string2 + ", Field: " + string4);
                        }
                        if (!string4.equalsIgnoreCase("s_GUID") && !string4.equalsIgnoreCase("s_Lineage") && !string4.equalsIgnoreCase("s_Generation") && s != 15) continue;
                        jDaoTableDef.close();
                        jDaoTableDef.deinit();
                        jDaoTableDef = null;
                        throw new ReplicaDatabaseException(string + "is a replicated database.\n\nTable: " + string2 + ", Field: " + string4);
                    }
                }
                jDaoTableDef.close();
                jDaoTableDef.deinit();
                jDaoTableDef = null;
            }
        }
        catch (JDaoException jDaoException) {
            if (!bl2) {
                throw new InvalidDatabaseException(jDaoException.getMessage());
            }
            throw new InvalidDatabaseException("Attached Database: " + jDaoException.getMessage());
        }
        catch (NotOfficialJetDataTypeException notOfficialJetDataTypeException) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, notOfficialJetDataTypeException.getStackTrace()[0].toString(), notOfficialJetDataTypeException);
            boolean bl3 = false;
            return bl3;
        }
        catch (ReplicaDatabaseException replicaDatabaseException) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, replicaDatabaseException.getStackTrace()[0].toString(), replicaDatabaseException);
            boolean bl4 = false;
            return bl4;
        }
        catch (SecuredDatabaseException securedDatabaseException) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, securedDatabaseException.getStackTrace()[0].toString(), securedDatabaseException);
            boolean bl5 = false;
            return bl5;
        }
        finally {
            try {
                jDaoDatabase.close();
                jDaoDatabase.deinit();
                jDaoDatabase = null;
            }
            catch (JDaoException jDaoException) {
                Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, jDaoException.getStackTrace()[0].toString(), jDaoException);
                return false;
            }
        }
        return true;
    }

    public static int createTableAttachment(JDaoDatabase jDaoDatabase, String string, LinkTableDescriptor linkTableDescriptor, String string2, boolean bl, boolean bl2) throws UnableToModifyAccessDatabaseException {
        boolean bl3 = bl2;
        boolean bl4 = bl;
        int n = 0;
        try {
            String string3 = linkTableDescriptor.getSourceTable().getObjectName();
            String string4 = linkTableDescriptor.getTargetTableName();
            String string5 = string3 + "_L";
            String string6 = string3 + "_R";
            JDaoTableDef jDaoTableDef = new JDaoTableDef(jDaoDatabase);
            jDaoTableDef.create(string6);
            String string7 = MSAccessUtils.getUserFromConnection(string2);
            String string8 = string7 + "." + string4;
            jDaoTableDef.setSourceTableName(string8.toUpperCase());
            jDaoTableDef.setConnect(string);
            jDaoTableDef.append();
            jDaoTableDef.close();
            jDaoTableDef.deinit();
            jDaoTableDef = null;
            if (bl) {
                if (!bl2) {
                    if (!MSAccessUtils.deleteAllRelations(jDaoDatabase)) {
                        bl4 = false;
                    }
                    bl3 = true;
                }
                MSAccessUtils.deleteLocalTable(jDaoDatabase, string3);
            } else {
                JDaoTableDef jDaoTableDef2 = new JDaoTableDef(jDaoDatabase);
                jDaoTableDef2.open(string3);
                boolean bl5 = MSAccessUtils.renameLocalTable(jDaoTableDef2, string5);
                jDaoTableDef2.close();
                jDaoTableDef2.deinit();
                jDaoTableDef2 = null;
                if (!bl4) {
                    ++n;
                }
                if (bl3) {
                    n += 2;
                }
            }
        }
        catch (JDaoException jDaoException) {
            throw new UnableToModifyAccessDatabaseException(jDaoException.getMessage());
        }
        return n;
    }

    private static String getUserFromConnection(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        return properties.getProperty("USERNAME");
    }

    private static boolean deleteAllRelations(JDaoDatabase jDaoDatabase) {
        try {
            int n = jDaoDatabase.getRelationCount();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(jDaoDatabase.getRelationName(i));
            }
            for (String string : arrayList) {
                jDaoDatabase.deleteRelation(string);
            }
            return true;
        }
        catch (JDaoException jDaoException) {
            return false;
        }
    }

    private static boolean deleteLocalTable(JDaoDatabase jDaoDatabase, String string) {
        try {
            jDaoDatabase.deleteTable(string);
            return true;
        }
        catch (JDaoException jDaoException) {
            return false;
        }
    }

    private static boolean renameLocalTable(JDaoTableDef jDaoTableDef, String string) {
        try {
            jDaoTableDef.setName(string);
            return true;
        }
        catch (JDaoException jDaoException) {
            Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, jDaoException.getStackTrace()[0].toString(), jDaoException);
            return false;
        }
    }

    public static void createMappingQuery(JDaoDatabase jDaoDatabase, LinkTableDescriptor linkTableDescriptor) throws UnableToModifyAccessDatabaseException {
        try {
            String string = linkTableDescriptor.getSourceTableName();
            JDaoQueryDef jDaoQueryDef = new JDaoQueryDef(jDaoDatabase);
            jDaoQueryDef.create(string);
            String string2 = string + "_R";
            LinkedHashMap<MdColumn, MdColumn> linkedHashMap = linkTableDescriptor.getColumns();
            MdColumn[] mdColumnArray = linkedHashMap.keySet().toArray(new MdColumn[linkedHashMap.size()]);
            MdColumn[] mdColumnArray2 = linkedHashMap.values().toArray(new MdColumn[linkedHashMap.size()]);
            String string3 = " SELECT ";
            int n = 0;
            int n2 = linkedHashMap.size();
            for (int i = 0; i < linkedHashMap.size(); ++i) {
                String string4 = mdColumnArray2[i].getColumnName();
                String string5 = mdColumnArray[i].getColumnName();
                string3 = ++n < n2 - 1 ? string3 + "[" + string2 + "].[" + string5 + "] AS [" + string4 + "]," : string3 + "[" + string2 + "].[" + string5 + "] AS [" + string4 + "] FROM [" + string2 + "]";
            }
            jDaoQueryDef.setSQL(string3);
            jDaoQueryDef.append();
            jDaoQueryDef.close();
            jDaoQueryDef.deinit();
            jDaoQueryDef = null;
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").info("Link table for " + string + "created");
        }
        catch (JDaoException jDaoException) {
            throw new UnableToModifyAccessDatabaseException(jDaoException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<LinkTableDescriptor> getTablesInfo(DBObjectId dBObjectId) {
        ArrayList<LinkTableDescriptor> arrayList = new ArrayList<LinkTableDescriptor>();
        MdSchema mdSchema = null;
        MdSchema mdSchema2 = null;
        MdTable mdTable = null;
        MdTable mdTable2 = null;
        LinkTableDescriptor linkTableDescriptor = null;
        try (CloseableResultSet closeableResultSet = null;){
            PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(QUERY_LOAD_CONV_TABLES);
            preparedStatement.setLong(1, dBObjectId.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            LinkedHashMap<MdColumn, MdColumn> linkedHashMap = null;
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                Long l = resultSet.getLong(2);
                Long l2 = resultSet.getLong(3);
                if (string.equals("MD_TABLES")) {
                    if (linkTableDescriptor != null) {
                        if (linkedHashMap == null || linkedHashMap.size() == 0) {
                            throw new IllegalStateException("derived records not found");
                        }
                        linkTableDescriptor.setColumnMap(linkedHashMap);
                        arrayList.add(linkTableDescriptor);
                    }
                    linkTableDescriptor = new LinkTableDescriptor();
                    linkedHashMap = new LinkedHashMap<MdColumn, MdColumn>();
                    try {
                        mdTable = MdTable.retrieveExistingInstance((PersistenceManager)persistenceManager, (DBObjectId)new DBObjectId(l2.longValue()));
                        mdSchema = MdSchema.retrieveExistingInstance((PersistenceManager)persistenceManager, (DBObjectId)mdTable.getSchemaId());
                        mdTable2 = MdTable.retrieveExistingInstance((PersistenceManager)persistenceManager, (DBObjectId)new DBObjectId(l.longValue()));
                        mdSchema2 = MdSchema.retrieveExistingInstance((PersistenceManager)persistenceManager, (DBObjectId)mdTable2.getSchemaId());
                        if (mdTable == null || mdSchema == null || mdTable2 == null || mdTable2 == null) {
                            throw new IllegalStateException("derived records not found");
                        }
                        linkTableDescriptor = new LinkTableDescriptor(mdSchema, mdTable, mdSchema2, mdTable2);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, noSuchObjectException.getLocalizedMessage());
                    }
                    catch (PersistenceException persistenceException) {
                        Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
                    }
                    continue;
                }
                if (!string.equals("MD_COLUMNS")) continue;
                try {
                    linkedHashMap.put(MdColumn.retrieveExistingInstance((PersistenceManager)persistenceManager, (DBObjectId)new DBObjectId(l.longValue())), MdColumn.retrieveExistingInstance((PersistenceManager)persistenceManager, (DBObjectId)new DBObjectId(l2.longValue())));
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, noSuchObjectException.getLocalizedMessage());
                }
                catch (PersistenceException persistenceException) {
                    Logger.getLogger(MSAccessUtils.class.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
                }
            }
        }
        if (linkTableDescriptor != null) {
            arrayList.add(linkTableDescriptor);
        }
        return arrayList;
    }

    public static String getPathAndFileName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken().substring(4);
        return string2;
    }
}

