/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.analyzer;

import javax.swing.Icon;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;

public class Severity
implements Comparable,
TypeSafeEnumeration {
    public static final Severity ERROR = new Severity("error", "error.png", oracle.javatools.status.Severity.ERROR);
    public static final Severity WARNING = new Severity("warning", "warning.png", oracle.javatools.status.Severity.WARNING);
    public static final Severity INCOMPLETE = new Severity("incomplete", "incompletestatus.png", oracle.javatools.status.Severity.INCOMPLETE);
    public static final Severity ADVISORY = new Severity("advisory", "info.png", oracle.javatools.status.Severity.ADVISORY);
    public static final Severity ASSIST = new Severity("assist", "assist.png", oracle.javatools.status.Severity.OK);
    public static final Severity VIOLATION = ADVISORY;
    public static final Severity CONVENTION = ADVISORY;
    public static final Severity SUGGESTION = ADVISORY;
    private static int next;
    private int severity = next++;
    private String name;
    private oracle.javatools.status.Severity issueSeverity;
    private String iconName;
    private Icon icon;

    private Severity(String name, String iconName, oracle.javatools.status.Severity issueSeverity) {
        this.name = name;
        this.iconName = iconName;
        this.issueSeverity = issueSeverity;
    }

    public int hashCode() {
        return this.severity;
    }

    public boolean equals(Object object) {
        return object instanceof Severity && this.severity == ((Severity)object).severity;
    }

    public int compareTo(Object object) {
        return this.severity - ((Severity)object).severity;
    }

    public boolean isWorseThan(Severity severity) {
        return severity == null || this.compareTo(severity) < 0;
    }

    public oracle.javatools.status.Severity getIssueSeverity() {
        return this.issueSeverity;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = OracleIcons.getIcon((String)this.iconName);
        }
        return this.icon;
    }

    public String toString() {
        return this.name;
    }

    public static Severity valueOf(String string) {
        if (Severity.ERROR.name.equals(string)) {
            return ERROR;
        }
        if (Severity.WARNING.name.equals(string)) {
            return WARNING;
        }
        if (Severity.ADVISORY.name.equals(string)) {
            return ADVISORY;
        }
        if (Severity.INCOMPLETE.name.equals(string)) {
            return INCOMPLETE;
        }
        if (Severity.ASSIST.name.equals(string)) {
            return ASSIST;
        }
        return null;
    }

    static {
        TypeSafeEnumerationFactory.addSubstitution(Severity.class, "violation", "advisory");
        TypeSafeEnumerationFactory.addSubstitution(Severity.class, "convention", "advisory");
        TypeSafeEnumerationFactory.addSubstitution(Severity.class, "suggestion", "advisory");
        next = 0;
    }
}

